

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSummPageGetMediaInLibrary.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSummPageGetMediaInLibrary.sp,v $ $Id: MMSummPageGetMediaInLibrary.sp,v 1.3.198.2 2020/09/28 10:58:11 prasanthm Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetMediaInLibrary"	|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMSummPageGetMediaInLibrary')
BEGIN
	print '>>> Drop Stored Procedure: MMSummPageGetMediaInLibrary <<<'
	drop procedure MMSummPageGetMediaInLibrary
END
IF EXISTS (select * from GxQscripts where name='MMSummPageGetMediaInLibrary')
	delete from GxQscripts where name = 'MMSummPageGetMediaInLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetMediaInLibrary')
	delete from GXDBVersions where aliasname = 'MMSummPageGetMediaInLibrary'
GO
print '... Creating Procedure: MMSummPageGetMediaInLibrary'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSummPageGetMediaInLibrary
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_libraryId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @mediaTbl		TABLE (t_id int, t_sparegroupId int, t_spareGroupType int, t_status1 int, t_status2 int, isInMediaGroup int, isAged int)
-- Get media inside library
INSERT INTO @mediaTbl
SELECT DISTINCT MediaId, (case isInMediaGroup when 1 then 0 else sparegroupId end), 0, 0, 0, isInMediaGroup, isAged
FROM 	MMMedia WITH(NOLOCK)
WHERE 	LibraryId = @i_LibraryId AND MediaId > 0 AND mediaTypeId <> 10001 AND MediaLocation <> 3
-- Update media status
UPDATE @mediaTbl
SET	t_spareGroupType = spareGroupType
FROM	MMSpareGroup WITH(NOLOCK)
WHERE	t_sparegroupId = spareGroupId AND t_sparegroupId > 0
DECLARE @mediaStatusTable TABLE(MediaId int, status1 int, status2 int)
INSERT INTO @mediaStatusTable
SELECT MV.MediaId, min(MV.VolumeFlags), max(MV.VolumeFlags)
FROM @mediaTbl TMP inner join MMVolume MV WITH(NOLOCK)
ON TMP.t_id = MV.MediaId and t_sparegroupId = 0
group by MV.MediaID
UPDATE TMP
SET TMP.t_status1 = TMP1.status1,
TMP.t_Status2 = TMP1.status2
FROM @mediaTbl TMP inner join @mediaStatusTable TMP1 ON TMP.t_id = TMP1.MediaId
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
SELECT  TAG							= 1,
	Parent							= null,
        [EVGui_SummPageGetMediaInLibrary!1!numOfMedia]		= (select count(DISTINCT t_id) from @mediaTbl /*where isInMediaGroup <> 1*/),
      	[EVGui_SummPageGetMediaInLibrary!1!numOfActiveMedia]	= (select count(DISTINCT t_id) from @mediaTbl where t_status1 = 1 OR t_status2 = 1),
	[EVGui_SummPageGetMediaInLibrary!1!numOfAppendableMedia]= (select count(DISTINCT t_id) from @mediaTbl where t_status1 = 7 OR t_status2 = 7),
	[EVGui_SummPageGetMediaInLibrary!1!numOfSpareMedia]	= (select count(DISTINCT t_id) from @mediaTbl where t_spareGroupType in( 1, 2) AND isInMediaGroup <> 1 AND isAged = 0),
	[EVGui_SummPageGetMediaInLibrary!1!numOfAgedMedia]	= (select count(DISTINCT t_id) from @mediaTbl where isAged = 1),
	[EVGui_SummPageGetMediaInLibrary!1!numOfCleaningMedia]	= (select count(DISTINCT t_id) from @mediaTbl where t_spareGroupType = 32),
	[EVGui_SummPageGetMediaInLibrary!1!numOfBadMedia]	= (select count(DISTINCT t_id) from @mediaTbl where t_spareGroupType = 8), --t_status1 = 4 OR t_status2 = 4 ),
	[EVGui_SummPageGetMediaInLibrary!1!numOfForeignMedia]	= (select count(DISTINCT t_id) from @mediaTbl where t_spareGroupType = 16)
FOR XML EXPLICIT
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSummPageGetMediaInLibrary')
	delete from GxQscripts where name = 'MMSummPageGetMediaInLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetMediaInLibrary')
	delete from GXDBVersions where aliasname = 'MMSummPageGetMediaInLibrary'
GO

insert into GXDBVersions values(2, 'MMSummPageGetMediaInLibrary',  '00010003019800020000', 'MMSummPageGetMediaInLibrary', '00010003019800020000')
GO

