

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSummPageGetMediaGroupsByLib.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSummPageGetMediaGroupsByLib.sp,v $ $Id: MMSummPageGetMediaGroupsByLib.sp,v 1.3.198.3 2020/09/28 10:58:08 prasanthm Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetMediaGroupsByLib"	|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMSummPageGetMediaGroupsByLib')
BEGIN
	print '>>> Drop Stored Procedure: MMSummPageGetMediaGroupsByLib <<<'
	drop procedure MMSummPageGetMediaGroupsByLib
END
IF EXISTS (select * from GxQscripts where name='MMSummPageGetMediaGroupsByLib')
	delete from GxQscripts where name = 'MMSummPageGetMediaGroupsByLib'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetMediaGroupsByLib')
	delete from GXDBVersions where aliasname = 'MMSummPageGetMediaGroupsByLib'
GO
print '... Creating Procedure: MMSummPageGetMediaGroupsByLib'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSummPageGetMediaGroupsByLib
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_libId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @mediaTbl		TABLE (t_id int, t_sparegroupId int, t_isExported int, t_spareGroupType int, t_status1 int, t_status2 int,  t_isInMediaGroup int, t_isAged int)
--------
-- Get media by group ID
INSERT INTO @mediaTbl
SELECT DISTINCT MediaId, (case isInMediaGroup when 1 then 0 else sparegroupId end), (case MediaLocation when 3 then 1 else 0 end), 0, 0, 0, IsInMediaGroup, IsAged
FROM 	MMMedia WITH(NOLOCK)
WHERE 	LibraryId = @i_libId AND BarCode <> ('StdAln_' + CAST(MediaId as varchar(64))) --#define MMS2_STANDALONE_DUMMY_BARCODE     "StdAln"
-- Update media status
UPDATE @mediaTbl
SET	t_spareGroupType = spareGroupType
FROM	MMSpareGroup WITH(NOLOCK)
WHERE	t_sparegroupId = spareGroupId AND t_sparegroupId > 0
DECLARE @mediaStatusTable TABLE(MediaId int, status1 int, status2 int)
INSERT INTO @mediaStatusTable
SELECT MV.MediaId, min(MV.VolumeFlags), max(MV.VolumeFlags)
FROM @mediaTbl TMP inner join MMVolume MV WITH(NOLOCK)
ON TMP.t_id = MV.MediaId and t_sparegroupId = 0
group by MV.MediaID
UPDATE TMP
SET TMP.t_status1 = TMP1.status1,
TMP.t_Status2 = TMP1.status2
FROM @mediaTbl TMP inner join @mediaStatusTable TMP1 ON TMP.t_id = TMP1.MediaId
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
SELECT  TAG										= 1,
	Parent										= null,
        [EVGui_SummPageGetMediaGroupByLibId!1!numOfMediaInside]				= (select count(DISTINCT t_id) from @mediaTbl where t_isExported = 0),
        [EVGui_SummPageGetMediaGroupByLibId!1!numOfMediaOutside]			= (select count(DISTINCT t_id) from @mediaTbl where t_isExported = 1),
      	[EVGui_SummPageGetMediaGroupByLibId!1!numOfActiveMediaInside]			= (select count(DISTINCT t_id) from @mediaTbl where (t_status1 = 1 OR t_status2 = 1) AND t_isExported = 0),
      	[EVGui_SummPageGetMediaGroupByLibId!1!numOfActiveMediaOutside]			= (select count(DISTINCT t_id) from @mediaTbl where (t_status1 = 1 OR t_status2 = 1) AND t_isExported = 1),
	[EVGui_SummPageGetMediaGroupByLibId!1!numOfAppendableMediaInside]		= (select count(DISTINCT t_id) from @mediaTbl where (t_status1 = 7 OR t_status2 = 7) AND t_isExported = 0),
	[EVGui_SummPageGetMediaGroupByLibId!1!numOfAppendableMediaOutside]		= (select count(DISTINCT t_id) from @mediaTbl where (t_status1 = 7 OR t_status2 = 7) AND t_isExported = 1),
	[EVGui_SummPageGetMediaGroupByLibId!1!numOfSpareMediaInside]			= (select count(DISTINCT t_id) from @mediaTbl where t_spareGroupType in (1, 2) AND t_isInMediaGroup = 0 AND  t_isExported = 0), -- should show aged media as spare media because aged media is present in scratch pool, so spare media count in summary page should equals to number of medias present in scratch pool.
	[EVGui_SummPageGetMediaGroupByLibId!1!numOfSpareMediaOutside]			= (select count(DISTINCT t_id) from @mediaTbl where t_spareGroupType in (1, 2) AND t_isInMediaGroup = 0 AND  t_isExported = 1),
	[EVGui_SummPageGetMediaGroupByLibId!1!numOfCleaningMediaInside]			= (select count(DISTINCT t_id) from @mediaTbl where t_spareGroupType = 32 AND t_isExported = 0),
	[EVGui_SummPageGetMediaGroupByLibId!1!numOfCleaningMediaOutside]		= (select count(DISTINCT t_id) from @mediaTbl where t_spareGroupType = 32 AND t_isExported = 1),
	[EVGui_SummPageGetMediaGroupByLibId!1!numOfBadMediaInside]			= (select count(DISTINCT t_id) from @mediaTbl where /*t_status1 = 4 OR t_status2 = 4*/t_spareGroupType = 8 AND t_isExported = 0), --in GUI bad media count is used for retired media.
	[EVGui_SummPageGetMediaGroupByLibId!1!numOfBadMediaOutside]			= (select count(DISTINCT t_id) from @mediaTbl where /*t_status1 = 4 OR t_status2 = 4*/t_spareGroupType = 8 AND t_isExported = 1),
	[EVGui_SummPageGetMediaGroupByLibId!1!numOfForeignMediaInside]			= (select count(DISTINCT t_id) from @mediaTbl where t_spareGroupType = 16 AND t_isExported = 0),
	[EVGui_SummPageGetMediaGroupByLibId!1!numOfForeignMediaOutside]			= (select count(DISTINCT t_id) from @mediaTbl where t_spareGroupType = 16 AND t_isExported = 1),
	[EVGui_SummPageGetMediaGroupByLibId!1!numOfOverwriteProtectedMediaInside]	= (select count(DISTINCT t_id) from @mediaTbl where t_spareGroupType = 64 AND t_isExported = 0),
	[EVGui_SummPageGetMediaGroupByLibId!1!numOfOverwriteProtectedMediaOutside]	= (select count(DISTINCT t_id) from @mediaTbl where t_spareGroupType = 64 AND t_isExported = 1)
FOR XML EXPLICIT
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSummPageGetMediaGroupsByLib')
	delete from GxQscripts where name = 'MMSummPageGetMediaGroupsByLib'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetMediaGroupsByLib')
	delete from GXDBVersions where aliasname = 'MMSummPageGetMediaGroupsByLib'
GO

insert into GXDBVersions values(2, 'MMSummPageGetMediaGroupsByLib',  '00010003019800030000', 'MMSummPageGetMediaGroupsByLib', '00010003019800030000')
GO

