

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSummPageGetMediaByGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSummPageGetMediaByGroup.sp,v $ $Id: MMSummPageGetMediaByGroup.sp,v 1.5.88.1 2018/03/19 23:58:53 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetTapeLibrary"		|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSummPageGetMediaByGroup <<<'

IF EXISTS (select * from sysobjects where name='MMSummPageGetMediaByGroup')
	drop procedure MMSummPageGetMediaByGroup
IF EXISTS (select * from GxQscripts where name='MMSummPageGetMediaByGroup')
	delete from GxQscripts where name = 'MMSummPageGetMediaByGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetMediaByGroup')
	delete from GXDBVersions where aliasname = 'MMSummPageGetMediaByGroup'
GO
print '... Creating Procedure: MMSummPageGetMediaByGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSummPageGetMediaByGroup
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_groupId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@mediaTypeId	INT
DECLARE	@lowWaterMark	INT
DECLARE	@libId		INT
DECLARE	@isShelf 	INT
DECLARE @mediaType      varchar(256)
DECLARE @mediaTbl	TABLE (t_id int, t_isExported int)
--------
-- Get media by group ID
INSERT INTO @mediaTbl
SELECT DISTINCT MediaId, (case MediaLocation when 3 then 1 else 0 end)
FROM 	MMMedia
WHERE 	IsInMediaGroup = 0 AND SpareGroupId = @i_groupId
	AND BarCode <> ('StdAln_' + CAST(MediaId as varchar(64))) --#define MMS2_STANDALONE_DUMMY_BARCODE     "StdAln"
SELECT	@mediaTypeId = mediatypeId, @lowWaterMark = lowWaterMark, @libId = LibraryId
FROM	MMSpareGroup
WHERE	SpareGroupId = @i_groupId
SELECT	@mediaType = mediaTypeName
FROM	MMMediaType where MediaTypeId = @mediaTypeId
SELECT	@isShelf = (case libraryTypeId when 8 then 1 else 0 end)
FROM	MMLibrary
WHERE	LibraryId = @libId
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
SELECT  TAG								= 1,
	Parent								= null,
        [EVGui_SummPageGetMediaByGroup!1!mediaType]		= @mediaType,
        [EVGui_SummPageGetMediaByGroup!1!numOfMedia]			= (select count(DISTINCT t_id) from @mediaTbl),
        [EVGui_SummPageGetMediaByGroup!1!numOfMediaInsideLibrary]	= case when @isShelf > 0 then null else
										(select count(DISTINCT t_id) from @mediaTbl where t_isExported = 0) end,
        [EVGui_SummPageGetMediaByGroup!1!numOfMediaOutsideLibrary]	= case when @isShelf > 0 then null else
										(select count(DISTINCT t_id) from @mediaTbl where t_isExported = 1) end,
        [EVGui_SummPageGetMediaByGroup!1!lowWaterMark]			= case when @lowWaterMark < 0 then null else @lowWaterMark end
FOR XML EXPLICIT
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSummPageGetMediaByGroup')
	delete from GxQscripts where name = 'MMSummPageGetMediaByGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetMediaByGroup')
	delete from GXDBVersions where aliasname = 'MMSummPageGetMediaByGroup'
GO

insert into GXDBVersions values(2, 'MMSummPageGetMediaByGroup',  '00010005008800010000', 'MMSummPageGetMediaByGroup', '00010005008800010000')
GO

