

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSummPageGetMagLibrary.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSummPageGetMagLibrary.sp,v $ $Id: MMSummPageGetMagLibrary.sp,v 1.26.40.11 2018/08/08 15:23:41 pveeravalli Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetMagLibrary"		|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSummPageGetMagLibrary <<<'

IF EXISTS (select * from sysobjects where name='MMSummPageGetMagLibrary')
	drop procedure MMSummPageGetMagLibrary
IF EXISTS (select * from GxQscripts where name='MMSummPageGetMagLibrary')
	delete from GxQscripts where name = 'MMSummPageGetMagLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetMagLibrary')
	delete from GXDBVersions where aliasname = 'MMSummPageGetMagLibrary'
GO
print '... Creating Procedure: MMSummPageGetMagLibrary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMSummPageGetMagLibrary
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_libraryId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @status			INT
DECLARE @lastBkpTime		INT
DECLARE @lastRstTime		INT
DECLARE @totalFreeSpace		DECIMAL(38)
DECLARE @totalCapacity		DECIMAL(38)
DECLARE @dataSizeInLast1H	BIGINT
DECLARE @durationInLast1H	BIGINT
DECLARE @dataSizeInLast24H	BIGINT
DECLARE @durationInLast24H	BIGINT
DECLARE @driveTbl		TABLE (t_id int)
DECLARE @mountPathTbl		TABLE (t_id int, t_capacity BIGINT, t_freeSpace BIGINT, t_lastRstTime int, t_lastBkpTime int, t_isOnline int)
DECLARE	@yesterdaysTime		DATETIME
DECLARE @hourAgoTime		DATETIME
DECLARE @mountPathUsage		INT
DECLARE @extendedAttributes	INT
DECLARE @AUXCOPY                INT
DECLARE @DASHCOPY               INT
DECLARE @totalAvailableSpace	DECIMAL(38)
SET @AUXCOPY                        = 13
SET @DASHCOPY                       = 104
INSERT INTO @mountPathTbl
SELECT	S.MediaSideId,
(CASE WHEN MP.MountPathTypeId = 7 AND S.totalSpaceMB = 1048576 THEN -1 ELSE S.totalSpaceMB END),/*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
(CASE WHEN MP.MountPathTypeId = 7 AND S.FreeBytesMB = 1048576 THEN -1 ELSE S.FreeBytesMB END),/*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
	L.LastRestoreTime,
	L.lastBackupTime,
	0
FROM	MMMedia L WITH (NOLOCK)
	JOIN MMMediaSide S WITH (NOLOCK) ON L.MediaId=S.MediaId
	JOIN MMMountPath MP WITH (NOLOCK) ON MP.MediaSideId=S.MediaSideId
WHERE	L.LibraryId = @i_libraryId AND L.MediaTypeId = 10001
AND MP.MountPathName != 'CVDiskFolder'
INSERT INTO @driveTbl
SELECT	driveId
FROM	MMDrive D WITH (NOLOCK) JOIN MMMasterPool P WITH (NOLOCK) ON D.masterPoolId = P.masterPoolId
WHERE	LibraryId = @i_libraryId
SET @yesterdaysTime	= dateadd(HH,-24,getUTCDate())
SET @hourAgoTime = dateadd(HH,-1,getUTCDate())
SELECT	@dataSizeInLast1H = sum(dataWritten)*1024*1024, @durationInLast1H = sum(cast(dataWriteDurationSec as bigint))
FROM	MMDrivehistory WITH (NOLOCK) JOIN @driveTbl ON driveId = t_id
WHERE	timeStart > @hourAgoTime AND dataWritten > 0 AND historytype=2
SELECT  @dataSizeInLast24H = sum(dataWritten)*1024*1024, @durationInLast24H = sum(cast(dataWriteDurationSec as bigint))
FROM	MMDrivehistory WITH (NOLOCK)  JOIN @driveTbl ON driveId = t_id
WHERE   timeStart > @yesterdaysTime AND dataWritten > 0 AND historytype=2
SET @status = (560 | (CAST(POWER(2, 24) AS BIGINT) * 61))
--Add check based on device and mountpath enabled for get Library Online and Offline status
IF EXISTS( 	SELECT	TOP 1 ML.LibraryId
		FROM 	MMLibrary ML WITH (NOLOCK)
			INNER JOIN MMMountPath MP WITH (NOLOCK) ON MP.LibraryId = ML.LibraryId
			INNER JOIN MMMountPathToStorageDevice MP2SD WITH (NOLOCK) ON MP.MountPathId = MP2SD.MountPathId
			INNER JOIN MMDevice MD WITH (NOLOCK) ON MP2SD.DeviceId = MD.DeviceId
			INNER JOIN MMDeviceController DC WITH (NOLOCK) ON MD.DeviceId = DC.DeviceId
		WHERE 	ML.LibraryId = @i_libraryId
			AND (ML.LibrarySoftState>0 AND ML.LibraryEnabled > 0 AND ML.LibraryBroken = 0)
			AND (MD.DeviceEnabled > 0 AND MD.DeviceBroken = 0 AND DC.DeviceControllerEnabled > 0)
AND (MP.IsEnabled > 0 AND MP.IsOffline = 0 AND MP.MountPathName != 'CVDiskFolder')
		)
BEGIN
SET @status = (559 | (CAST(POWER(2, 24) AS BIGINT) * 61))
END
SELECT	@totalFreeSpace = sum(CAST(t_freeSpace AS DECIMAL(38))) * 1024 * 1024 FROM @mountPathTbl
SELECT	@totalCapacity	= sum(CAST(t_capacity AS DECIMAL(38))) * 1024 * 1024 FROM @mountPathTbl
SELECT	@lastBkpTime = ISNULL(max(t_lastBkpTime), 0) from @mountPathTbl
IF(@lastBkpTime IS NOT NULL AND @lastBkpTime <> 0)
SELECT	@lastBkpTime =  dbo.GetUnixTime(dbo.UTCToLocalTime(  dbo.GetDateTime( max(t_lastBkpTime)), dbo.GetClientTimeZone(2))) from @mountPathTbl
SELECT	@lastRstTime = ISNULL(max(t_lastRstTime), 0) from @mountPathTbl
IF(@lastRstTime IS NOT NULL AND @lastRstTime <> 0)
SELECT	@lastRstTime =  dbo.GetUnixTime(dbo.UTCToLocalTime(  dbo.GetDateTime( max(t_lastRstTime)), dbo.GetClientTimeZone(2))) from @mountPathTbl
SELECT @mountPathUsage = (CASE
WHEN ExtendedAttributes & 1 = 1 THEN (1625 | (CAST(POWER(2, 24) AS BIGINT) * 61))
ELSE (1626 | (CAST(POWER(2, 24) AS BIGINT) * 61))
			END)
FROM	MMLibrary WITH (NOLOCK)
WHERE	LibraryId = @i_libraryId
UPDATE	@mountPathTbl
SET	t_isOnline = (CASE
			WHEN EXISTS(	SELECT	1
					FROM	MMMountPath MP WITH (NOLOCK)
						INNER JOIN MMMountPathToStorageDevice MMPSD WITH (NOLOCK) ON MMPSD.MountPathId = MP.MountPathId
						INNER JOIN MMDeviceController MDC WITH (NOLOCK) ON MDC.DeviceId = MMPSD.DeviceId
						INNER JOIN MMDevice MD WITH (NOLOCK) ON MD.DeviceId = MMPSD.DeviceId
					WHERE	MP.MediaSideId = t_Id AND MP.IsEnabled = 1 AND MP.IsOffline = 0
						AND MDC.DeviceControllerEnabled = 1 AND MDC.DeviceAccessible = 1
						AND MD.DeviceEnabled = 1 AND MD.DeviceBroken = 0
					) THEN 1
			ELSE 0
			END)
-- If Reserved space selected and Do not consume morethan option is not selected available Space = (free space - reserve space)
-- If Do not consume morethan option selected, if total data written morethan setvalue then available space is 0.
--	if set value is morethan datawritten then check with free space, if free space is more then available space is (setvalue - datawritten)
--  if free space is less than setvalue then the available space = free space
SELECT @totalAvailableSpace = SUM(CAST(availableSpace AS DECIMAL(38))) * 1024 * 1024 FROM
(
	SELECT
		CASE
		WHEN MS.t_freeSpace <= 0 THEN 0
		WHEN MP.MaxDataToWriteMB = -1 AND (MS.t_freeSpace - MP.MagneticSpaceRsrvInMB) < 0 THEN 0
		WHEN MP.MaxDataToWriteMB = -1 AND (MS.t_freeSpace - MP.MagneticSpaceRsrvInMB) >= 0 THEN (MS.t_freeSpace - MP.MagneticSpaceRsrvInMB)
		WHEN MP.MaxDataToWriteMB <> -1 AND (MP.MaxDataToWriteMB - (SELECT ISNULL(SUM(PhysicalBytesMB),0) FROM MMVolume MV WITH (NOLOCK) WHERE MV.MediaSideId = MP.MediaSideId)) <= 0 THEN 0
		WHEN MP.MaxDataToWriteMB <> -1 AND (MP.MaxDataToWriteMB - (SELECT ISNULL(SUM(PhysicalBytesMB),0) FROM MMVolume MV WITH (NOLOCK) WHERE MV.MediaSideId = MP.MediaSideId)) > 0
			AND (MS.t_freeSpace - (MP.MaxDataToWriteMB - (SELECT ISNULL(SUM(PhysicalBytesMB),0) FROM MMVolume MV WITH (NOLOCK) WHERE MV.MediaSideId = MP.MediaSideId))) > 0
			THEN  (MP.MaxDataToWriteMB - (SELECT ISNULL(SUM(PhysicalBytesMB),0) FROM MMVolume MV WITH (NOLOCK) WHERE MV.MediaSideId = MP.MediaSideId))
		ELSE MS.t_freeSpace
		END
	AS availableSpace
	FROM MMMountPath MP, @mountPathTbl MS
	WHERE MP.MediaSideId = MS.t_id
) AS TempTable
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
SELECT  TAG							= 1,
	Parent							= null,
	[EVGui_SummPageGetMagLibraries!1!numOfMountPath]	= (select count(*) from @mountPathTbl),
[EVGui_SummPageGetMagLibraries!1!totalFreeSpace]	= CASE WHEN @totalFreeSpace >= 0 THEN DBO.GetSizeString(@totalFreeSpace) ELSE DBO.fn_EvFormatEventMsgText(0, @i_localeId, (369 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) END,
[EVGui_SummPageGetMagLibraries!1!totalCapacity]		= CASE WHEN @totalCapacity >= 0 THEN DBO.GetSizeString(@totalCapacity) ELSE DBO.fn_EvFormatEventMsgText(0, @i_localeId, (369 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) END,
	[EVGui_SummPageGetMagLibraries!1!isOnline]		= DBO.fn_EvFormatEventMsgText(0, @i_localeId, @status, 0,2),
--	[EVGui_SummPageGetMagLibraries!1!offlineReason]		= (select LibraryStatusReason from MMLibrary where libraryId=@i_libraryId),
	[EVGui_SummPageGetMagLibraries!1!bytesBackedupInLast1H]	= DBO.GetSizeString(@dataSizeInLast1H),
	[EVGui_SummPageGetMagLibraries!1!bytesBackedupInLast24H]= DBO.GetSizeString(@dataSizeInLast24H),
[EVGui_SummPageGetMagLibraries!1!lastBackupTime]	= (case @lastBkpTime when 0 then DBO.fn_EvFormatEventMsgText(0, @i_localeId, (369 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) else DBO.getDateTime2(@lastBkpTime, null, 0) end),
[EVGui_SummPageGetMagLibraries!1!lastRestoreTime]	= (case @lastRstTime when 0 then DBO.fn_EvFormatEventMsgText(0, @i_localeId, (369 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) else DBO.getDateTime2(@lastRstTime, null, 0) end),
	[EVGui_SummPageGetMagLibraries!1!lastHourThroughput]	= DBO.GetThroughputString(@dataSizeInLast1H, @durationInLast1H, 1),
	[EVGui_SummPageGetMagLibraries!1!lastDayThroughput]	= DBO.GetThroughputString(@dataSizeInLast24H, @durationInLast24H, 1),
	[EVGui_SummPageGetMagLibraries!1!mountPathUsage]	= DBO.fn_EvFormatEventMsgText(0, @i_localeId, @mountPathUsage, 0,2),
	[EVGui_SummPageGetMagLibraries!1!onlineMountPaths]	= (SELECT CAST(ISNULL(SUM(t_isOnline), 0) AS VARCHAR(10))
+ ' ' + DBO.fn_EvFormatEventMsgText(0, @i_localeId, (3194 | (CAST(POWER(2, 24) AS BIGINT) * 61)) , 0,2) + ' '
									+ CAST(COUNT(*) AS VARCHAR(10))
								   FROM @mountPathTbl),
	[EVGui_SummPageGetMagLibraries!1!totalNumberOfWriteReservations] = (SELECT COUNT(*) FROM MMRESOURCE WITH (NOLOCK) WHERE ReservationType = 2 AND LibraryId =@i_libraryId AND HasJobInterrupted=0 and IntrJobId_L=0),
	[EVGui_SummPageGetMagLibraries!1!backupReservations] = (SELECT COUNT(*) FROM MMRESOURCE WITH (NOLOCK) WHERE ReservationType = 2 AND LibraryId = @i_libraryId AND HasJobInterrupted = 0
															AND IntrJobId_l = 0 AND EXISTS(SELECT 1 FROM MMRESOURCETOJOB WITH (NOLOCK) WHERE ReservationId = MMRESOURCE.ReservationId AND DBO.GETJOBTYPEFORJOBID(JobId_l) IN (4, 11, 14,18,30,43,59,60,70,98,101))),
	[EVGui_SummPageGetMagLibraries!1!auxiliaryCopyWriteReservations] = (SELECT COUNT(*) FROM MMRESOURCE  WITH (NOLOCK) WHERE ReservationType = 2 AND LibraryId = @i_libraryId AND HasJobInterrupted = 0
															AND IntrJobId_l = 0 AND EXISTS(SELECT 1 FROM MMRESOURCETOJOB WITH (NOLOCK) WHERE ReservationId = MMRESOURCE.ReservationId AND DBO.GETJOBTYPEFORJOBID(JobId_l) IN (@AUXCOPY,@DASHCOPY))),
    [EVGui_SummPageGetMagLibraries!1!associatedMediaAgents] = ISNULL ( (select stuff((select ','+ displayName from app_client WITH (NOLOCK)  INNER JOIN mmlibrarycontroller AS m WITH (NOLOCK)  ON id = ClientId AND m.Libraryid = @i_libraryId
															    FOR XML PATH(''), TYPE).value('.', 'varchar(max)'),1,1,' ')),''),
[EVGui_SummPageGetMagLibraries!1!totalAvailableSpace]	= (CASE WHEN @totalAvailableSpace >= 0 THEN DBO.GetSizeString(@totalAvailableSpace) ELSE DBO.fn_EvFormatEventMsgText(0, @i_localeId, (369 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) END)
FOR XML EXPLICIT
--DROP TABLE #MMDrivehistoryTemp
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSummPageGetMagLibrary')
	delete from GxQscripts where name = 'MMSummPageGetMagLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetMagLibrary')
	delete from GXDBVersions where aliasname = 'MMSummPageGetMagLibrary'
GO

insert into GXDBVersions values(2, 'MMSummPageGetMagLibrary',  '00010026004000110000', 'MMSummPageGetMagLibrary', '00010026004000110000')
GO

