

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSummPageGetMADetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSummPageGetMADetails.sp,v $ $Id: MMSummPageGetMADetails.sp,v 1.23.2.9 2020/05/06 16:15:46 xsui Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetMADetails"		|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMSummPageGetMADetails')
BEGIN
	print '>>> Drop Stored Procedure: MMSummPageGetMADetails <<<'
	drop procedure MMSummPageGetMADetails
END
IF EXISTS (select * from GxQscripts where name='MMSummPageGetMADetails')
	delete from GxQscripts where name = 'MMSummPageGetMADetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetMADetails')
	delete from GXDBVersions where aliasname = 'MMSummPageGetMADetails'
GO
print '... Creating Procedure: MMSummPageGetMADetails'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSummPageGetMADetails
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_clientId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @idxCacheStatus		INT
DECLARE @secInLast24H		INT
DECLARE @secInLast1H		INT
DECLARE @jobsIn24Hours		INT
DECLARE @jobsRunning		INT
DECLARE @updateStatus		INT
DECLARE @numOfTapeLib		INT
DECLARE @status			INT
DECLARE @dataSizeInLast1H	BIGINT
DECLARE @durationInLast1H	BIGINT
DECLARE @dataSizeInLast24H	BIGINT
DECLARE @durationInLast24H	BIGINT
DECLARE @buildId		VARCHAR(256)
DECLARE @installDate		DATETIME
DECLARE @libTbl			TABLE (t_id int, t_isMag int)
DECLARE @driveTbl		TABLE (t_id int, t_isOnline int)
DECLARE @DASHCOPY                INT
DECLARE @AUXCOPY                INT
DECLARE @maxReservations 	BIGINT
DECLARE @maxReservationsOnMA 	INT
DECLARE @pruningStatus		NVARCHAR(256)
--Get TimeZone
DECLARE @timeZone  NVARCHAR(2048)
DECLARE @formattedTimeZone  NVARCHAR(2048)
--DECLARE @FirstColon INTEGER
--DECLARE @SecondColon INTEGER
--DECLARE @MinusSign INTEGER
--DECLARE @Minutes INTEGER
--SELECT  @timeZone=attrVal FROM APP_ClientProp WHERE attrName = 'timezone' AND componentNameId = @i_clientId
--SET @MinusSign = CHARINDEX('-', @timeZone, 1)
--SET @FirstColon = CHARINDEX(':', @timeZone, 1)
--SET @SecondColon = CHARINDEX(':', @timeZone, @FirstColon+1)
--SET @Minutes = CAST (SUBSTRING(@timeZone, @FirstColon+1, @SecondColon - @FirstColon -1) AS INTEGER)
--IF @MinusSign = 0  SET @formattedTimeZone = 'GMT+' ELSE SET @formattedTimeZone = 'GMT-'
--IF ((@Minutes/60) < 10)  SET @formattedTimeZone= @formattedTimeZone + '0'
--SET @formattedTimeZone = @formattedTimeZone + CAST (@Minutes/60 AS VARCHAR(10)) + ':'
--IF ((@Minutes%60) < 10)  SET @formattedTimeZone= @formattedTimeZone + '0'
--SET @formattedTimeZone = @formattedTimeZone + CAST (@Minutes%60 AS VARCHAR(10)) + ':00:' + SUBSTRING(@timeZone, @SecondColon+1, LEN(@timeZone) - @SecondColon)
SET @AUXCOPY                        = 13
SET @DASHCOPY			    = 104
SELECT  @formattedTimeZone=
TimeZoneName from SchedTimeZone where TimeZoneID=
(SELECT attrVal FROM APP_ClientProp WHERE attrName = 'timezone id' AND componentNameId = @i_clientId AND modified = 0)
SELECT @secInLast24H	= dbo.getUnixTime(getUTCdate()) - 24*60*60
SELECT @secInLast1H	= dbo.getUnixTime(getUTCdate()) - 60*60
SELECT @idxCacheStatus	= count(*)
FROM	idxAccessPath A, idxCache C
WHERE	A.clientId = @i_clientId AND A.idxCacheId = C.idxCacheId AND C.idxCacheType > 0 AND C.idxCacheType <> 2 AND
	A.enabled * A.softState > 0 AND C.enabled * C.softState > 0
--SELECT @jobsIn24Hours	= count(distinct R.jobId)
--FROM	JMJobResourceHistory R WITH (READUNCOMMITTED)
--WHERE	R.clientId = @i_clientId AND R.releaseTime > @secInLast24H
SELECT	@jobsRunning	= count(distinct J.jobId)
FROM	JMBkpJobInfo J, APP_client A
WHERE	A.id = @i_clientId AND A.net_hostName = CAST(J.mediaAgentName AS nvarchar(255))
INSERT INTO @libTbl
SELECT	DISTINCT L.libraryId, (case L.LibraryTypeId when 3 then 1 else 0 end)
FROM	MMLibrary L JOIN MMLibraryController C ON C.LibraryId = L.LibraryId
WHERE	C.clientId = @i_clientId AND C.LibraryControllerId > 0
----------------------
-- VISIBILITY CHECK --
----------------------
IF @i_userId > 0
BEGIN
	IF object_id('tempdb.dbo.#MMSummUserObjects') IS NOT null DROP TABLE #MMSummUserObjects
create table  #MMSummUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 0, 0, '#MMSummUserObjects'
	DELETE #MMSummUserObjects
	WHERE clientGroupId <> 0 OR clientId <> 0 OR mediaAgentId <> 0 OR archGroupID <> 0 OR vtContainerId <> 0 OR VtShelfId <> 0 OR vtPolicyId <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0
	DELETE @libTbl
	WHERE NOT EXISTS (select * from #MMSummUserObjects where libraryID in (0, t_id))
	DROP TABLE #MMSummUserObjects
END
---------------------
INSERT INTO @driveTbl
SELECT	D.driveId, (case when D.DriveSoftState > 0 and D.DriveEnabled > 0 and D.DriveBroken = 0 then 1 else 0 end)
FROM	MMDrive D, MMMasterPool MP
WHERE	D.MasterPoolId = MP.MasterPoolId and MP.LibraryId in (select t_id from @libTbl where t_isMag = 0)
IF object_id('tempdb.dbo.#MMDrivehistoryTemp') IS NOT null DROP TABLE #MMDrivehistoryTemp
SELECT * INTO #MMDrivehistoryTemp
FROM	MMDrivehistory
WHERE	clientId = @i_clientId AND datediff(hh, timeStart, getUTCDate()) < 24 AND dataWritten > 0 AND historytype=2
SELECT	@dataSizeInLast1H = sum(dataWritten)*1024*1024, @durationInLast1H	= sum(cast(dataWriteDurationSec as bigint))
FROM	#MMDrivehistoryTemp
WHERE	datediff(hh, timeStart, getUTCDate()) < 1
SELECT	@dataSizeInLast24H = sum(dataWritten)*1024*1024, @durationInLast24H = sum(cast(dataWriteDurationSec as bigint))
FROM	#MMDrivehistoryTemp
SELECT	@buildId = build, @installDate = opTimeUTC
FROM	LicUsage
WHERE	CId = @i_clientId and appType = 1002 AND OpType='Install'
SET	@updateStatus	= ISNULL((select dbo.simGetBaseline(sum(distinct P.Baseline)) from simInstalledPackages P where P.clientId = @i_clientId ), 8)
SET	@updateStatus	= (case	when (@updateStatus & 8) > 0 then (369 | (CAST(POWER(2, 24) AS BIGINT) * 61))
when (@updateStatus & 16) > 0 then (1709 | (CAST(POWER(2, 24) AS BIGINT) * 61))
when (@updateStatus & 2) > 0 then (1639 | (CAST(POWER(2, 24) AS BIGINT) * 61))
when EXISTS (select * from simInstalledPackages where clientId=@i_clientId and Baseline=0) then (371 | (CAST(POWER(2, 24) AS BIGINT) * 61))
when (@updateStatus & 4) > 0 then (1640 | (CAST(POWER(2, 24) AS BIGINT) * 61))
when (@updateStatus & 1) > 0 then (1638 | (CAST(POWER(2, 24) AS BIGINT) * 61))
				else 0 end	)
IF object_id('tempdb.dbo.#tempMADetails') IS NOT null DROP TABLE #tempMADetails
SELECT	C.id, C.displayName, C.net_hostname, P.install_dir, OSID = O.id, OSName = O.name, HWID = 0, HWName = dbo.GetClientHardwareName(C.id, NULL), --H.id, HWName = H.name,
	isOnline	= (case when M.mmHostSoftState > 0 and M.MmHostEnabled > 0 then 1 else 0 end), M.offlineReason,
	isVirtual	= ISNULL((select attrVal from APP_ClientProp where componentNameId=C.id and attrName='Virtual client' and modified =0), 0),
	release		= (select release from simAllGalaxyRel R where R.id = C.releaseId)
INTO	#tempMADetails
FROM	APP_Client C	LEFT JOIN 	APP_Platform P	ON C.id = P.clientId and P.platformType = 4
--			LEFT JOIN	simSystemOS S	ON C.simSystemOSId = S.id
--			LEFT JOIN	simOS O		ON S.simOSId = O.id
			LEFT JOIN	simOperatingSystem O		ON C.simOperatingSystemId = O.id
			LEFT JOIN	MMHost M	ON M.ClientId = C.id
WHERE	C.id = @i_clientId
SELECT @numOfTapeLib = count(*) FROM @libTbl WHERE t_isMag = 0
SELECT @status = (case isOnline when 0 then (560 | (CAST(POWER(2, 24) AS BIGINT) * 61)) else (559 | (CAST(POWER(2, 24) AS BIGINT) * 61)) end) FROM #tempMADetails
SELECT @maxReservations =  ((SELECT SUM(MaxConcurrentWriters) FROM MMMountPath M WITH (NOLOCK) INNER JOIN MMMountPathToStorageDevice MS WITH (NOLOCK) ON M.MountPathId = MS.MountPathId INNER JOIN MMDeviceController MD
     ON MS.DeviceId = MD.DeviceId  AND ClientId = @i_clientId )+( SELECT COUNT(*) FROM mmdrive MMD WITH (NOLOCK) INNER JOIN MMDriveController MD WITH (NOLOCK) ON  MMD.DriveId = MD.DriveId AND MD.ClientId = @i_clientId))
SELECT @maxReservationsOnMA = (SELECT maxreservations FROM MMHost WITH (NOLOCK) WHERE ClientId = @i_clientId)
-- Pruning Status
-- #define OPERATION_DATA_PRUNING              (1<<17)  (value - 131072)
-- #define MMS2_MA_MARKED_FOR_MAINTENANCE	   16
SET @pruningStatus = 'Enabled'
SELECT @pruningStatus =
	CASE
WHEN @status = (560 | (CAST(POWER(2, 24) AS BIGINT) * 61)) THEN 'Disabled [MediaAgent offline]'
		WHEN (H.Attribute & 16) = 16 THEN 'Disabled [MediaAgent is in maintenance mode]'
		WHEN dbo.IsOperationAllowed(131072,2,@i_clientId,0,0,0,0) = 0 THEN 'Disabled [Data pruning operation window is set]'
		ELSE 'Enabled'
	END
FROM MMHost H WHERE H.ClientId = @i_clientId
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
SELECT  TAG							= 1,
	Parent							= null,
	[EVGui_SummPageGetMADetails!1!name]			= (select displayName from #tempMADetails),
	[EVGui_SummPageGetMADetails!1!hostName]			= (select net_hostname from #tempMADetails),
        [EVGui_SummPageGetMADetails!1!OS]			= (select OSName from #tempMADetails),
        [EVGui_SummPageGetMADetails!1!platform]			= (select HWName from #tempMADetails),
        [EVGui_SummPageGetMADetails!1!version]			= ( ISNULL( (select attrVal from APP_ClientProp where   componentNameId = @i_clientId and  attrName = 'SP Version Info'), 'N/A' )), --(select release + '.' + @buildId from #tempMADetails),
        [EVGui_SummPageGetMADetails!1!isPhysical]		= (select (case isVirtual when 0 then 1 else 0 end) from #tempMADetails),
        [EVGui_SummPageGetMADetails!1!installDir]		= (select install_dir from #tempMADetails),
      	[EVGui_SummPageGetMADetails!1!installDate]		= DBO.GetDateTime2(0, @installDate, 1),
	[EVGui_SummPageGetMADetails!1!updateStatus]		= DBO.fn_EvFormatEventMsgText(0, @i_localeId, @updateStatus, 0,2),
	[EVGui_SummPageGetMADetails!1!timezone]			= @formattedTimeZone,
	[EVGui_SummPageGetMADetails!1!isOnline]			= DBO.fn_EvFormatEventMsgText(0, @i_localeId, @status, 0,2),
--	[EVGui_SummPageGetMADetails!1!offlineReason]		= (select offlineReason from #tempMADetails),
	[EVGui_SummPageGetMADetails!1!isIndexCacheOnline]	= (case @idxCacheStatus when 0 then 0 else 1 end),
	[EVGui_SummPageGetMADetails!1!numOfTotalLib]		= (select count(*) from @libTbl),
	[EVGui_SummPageGetMADetails!1!numOfMagLib]		= (select count(*) from @libTbl where t_isMag > 0),
	[EVGui_SummPageGetMADetails!1!numOfTapeLib]		= @numOfTapeLib,
	[EVGui_SummPageGetMADetails!1!numOfDrivesOffline]	= (case @numOfTapeLib when 0 then null else (select count(*) from @driveTbl where t_isOnline = 0) end),
--	[EVGui_SummPageGetMADetails!1!numOf24HourBkpJobs]	= @jobsIn24Hours,
	[EVGui_SummPageGetMADetails!1!numOfActiveBkpJobs]	= @jobsRunning,
	[EVGui_SummPageGetMADetails!1!lastHourThroughput]	= DBO.GetThroughputString(@dataSizeInLast1H, @durationInLast1H, 1),
	[EVGui_SummPageGetMADetails!1!lastDayThroughput]	= DBO.GetThroughputString(@dataSizeInLast24H, @durationInLast24H, 1),
	[EVGui_SummPageGetMADetails!1!totalNumberOfWriteReservations] = (SELECT CASE  WHEN @maxReservations < @maxReservationsOnMA THEN @maxReservations ELSE @maxReservationsOnMA END) ,
	[EVGui_SummPageGetMADetails!1!backupReservations] = (SELECT COUNT(*) FROM MMRESOURCE WITH (NOLOCK) WHERE ReservationType = 2 AND ClientId = @i_clientId AND HasJobInterrupted = 0
															AND IntrJobId_l = 0 AND EXISTS(SELECT 1 FROM MMRESOURCETOJOB WHERE ReservationId = MMRESOURCE.ReservationId AND DBO.GETJOBTYPEFORJOBID(JobId_l) IN (4, 11, 14,18,30,43,59,60,70,98,101))),
	[EVGui_SummPageGetMADetails!1!auxiliaryCopyWriteReservations] = (SELECT COUNT(*) FROM MMRESOURCE  WITH (NOLOCK) WHERE ReservationType = 2 AND ClientId = @i_clientId AND HasJobInterrupted = 0
															AND IntrJobId_l = 0 AND EXISTS(SELECT 1 FROM MMRESOURCETOJOB WHERE ReservationId = MMRESOURCE.ReservationId AND DBO.GETJOBTYPEFORJOBID(JobId_l) IN (@AUXCOPY,@DASHCOPY))),
--	[EVGui_SummPageGetMADetails!1!pruningEnabled] = dbo.IsOperationAllowed(131072,2,@i_clientId,0,0,0,0)
	[EVGui_SummPageGetMADetails!1!pruningStatus] = @pruningStatus
FOR XML EXPLICIT
DROP TABLE #tempMADetails
DROP TABLE #MMDrivehistoryTemp
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSummPageGetMADetails')
	delete from GxQscripts where name = 'MMSummPageGetMADetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetMADetails')
	delete from GXDBVersions where aliasname = 'MMSummPageGetMADetails'
GO

insert into GXDBVersions values(2, 'MMSummPageGetMADetails',  '00010023000200090000', 'MMSummPageGetMADetails', '00010023000200090000')
GO

