

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSummPageGetMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSummPageGetMA.sp,v $ $Id: MMSummPageGetMA.sp,v 1.10.190.2 2018/03/20 00:09:06 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetMA"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSummPageGetMA <<<'

IF EXISTS (select * from sysobjects where name='MMSummPageGetMA')
	drop procedure MMSummPageGetMA
IF EXISTS (select * from GxQscripts where name='MMSummPageGetMA')
	delete from GxQscripts where name = 'MMSummPageGetMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetMA')
	delete from GXDBVersions where aliasname = 'MMSummPageGetMA'
GO
print '... Creating Procedure: MMSummPageGetMA'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSummPageGetMA
  @i_userId INTEGER,
  @i_localeId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @MATbl	TABLE (t_id int, t_online int, t_OS int)
INSERT INTO @MATbl
SELECT	clientId,
	MmHostSoftState * MmHostEnabled,
--	(select S.simOSId from APP_client C, simSystemOS S where C.id=clientId and C.simSystemOSId=S.id)
	(select C.simOperatingSystemId from APP_client C where C.id=clientId)
FROM	MMHost
WHERE	clientId > 1 AND MmHostType >= 0
UPDATE @MATbl
SET	t_OS = (case type	when 'Windows' then 1
when 'netware' then 2
else 3 end	)
FROM	simOperatingSystem
WHERE	id = t_OS
----------------------
-- VISIBILITY CHECK --
----------------------
IF @i_userId > 0
BEGIN
	IF object_id('tempdb.dbo.#MMSummUserObjects') IS NOT null DROP TABLE #MMSummUserObjects
create table  #MMSummUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 0, 0, '#MMSummUserObjects'
	DELETE #MMSummUserObjects
	WHERE clientGroupId <> 0 OR clientId <> 0 OR libraryID <> 0 OR archGroupID <> 0 OR vtContainerId <> 0 OR VtShelfId <> 0 OR vtPolicyId <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0 OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
	OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
	OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
	OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
	DELETE @MATbl
	WHERE NOT EXISTS (select * from #MMSummUserObjects where mediaAgentId in (0, t_id))
	DROP TABLE #MMSummUserObjects
END
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
SELECT  TAG						= 1,
	Parent						= null,
	[EVGui_SummPageGetMAs!1!numOfMAs]		= (select count(*) from @MATbl),
[EVGui_SummPageGetMAs!1!numOfUnixMAs]		= (select count(*) from @MATbl where t_OS = 3),
[EVGui_SummPageGetMAs!1!numOfWinMAs]		= (select count(*) from @MATbl where t_OS = 1),
[EVGui_SummPageGetMAs!1!numOfNetwareMAs]	= (select count(*) from @MATbl where t_OS = 2),
        [EVGui_SummPageGetMAs!1!numOfMAsOffline]		= (select count(*) from @MATbl where t_online = 0),
[EVGui_SummPageGetMAs!1!numOfUnixMAsOffline]	= (select count(*) from @MATbl where t_online = 0 and t_OS = 3),
[EVGui_SummPageGetMAs!1!numOfWinMAsOffline]	= (select count(*) from @MATbl where t_online = 0 and t_OS = 1),
[EVGui_SummPageGetMAs!1!numOfNetwareMAsOffline]	= (select count(*) from @MATbl where t_online = 0 and t_OS = 2)
FOR XML EXPLICIT
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSummPageGetMA')
	delete from GxQscripts where name = 'MMSummPageGetMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetMA')
	delete from GXDBVersions where aliasname = 'MMSummPageGetMA'
GO

insert into GXDBVersions values(2, 'MMSummPageGetMA',  '00010010019000020000', 'MMSummPageGetMA', '00010010019000020000')
GO

