

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSummPageGetLibraries.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSummPageGetLibraries.sp,v $ $Id: MMSummPageGetLibraries.sp,v 1.6.190.8 2018/03/26 16:52:30 aselvanayagam Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetLibraries"		|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSummPageGetLibraries <<<'

IF EXISTS (select * from sysobjects where name='MMSummPageGetLibraries')
	drop procedure MMSummPageGetLibraries
IF EXISTS (select * from GxQscripts where name='MMSummPageGetLibraries')
	delete from GxQscripts where name = 'MMSummPageGetLibraries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetLibraries')
	delete from GXDBVersions where aliasname = 'MMSummPageGetLibraries'
GO
print '... Creating Procedure: MMSummPageGetLibraries'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSummPageGetLibraries
  @i_userId INTEGER,
  @i_localeId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
DECLARE @totalFreeSpace		DECIMAL(38)
DECLARE @totalCapacity		DECIMAL(38)
DECLARE @showHiddenLibConfig INTEGER = 0
-------------------------------------------------
-- Get 'MMCONFIG_SHOW_HIDDEN_LIBRARIES' value from MMConfigs
-------------------------------------------------
SELECT @showHiddenLibConfig = value
FROM    MMConfigs WITH (NOLOCK)
WHERE NAME = 'MMCONFIG_SHOW_HIDDEN_LIBRARIES'
DECLARE @libTbl			TABLE (t_id int, t_isMag int, t_isOnline int, t_isLCPOnline int, t_isCloud int)
SET @totalFreeSpace = 0
SET @totalCapacity = 0
INSERT INTO @libTbl
SELECT	DISTINCT libraryId,
(case LibraryTypeId when 3 then 1 else 0 end),
	(case when LibrarySoftState > 0 and LibraryEnabled > 0 and LibraryBroken = 0 then 1 else 0 end),
	ISNULL((select count(*) from MMLibraryController where libraryId=MMLibrary.libraryId and librarycontrolleractive=1 and LibraryControllerEnabled=1), 0),
(case when LibraryTypeId = 3 AND PrivateData like '|6|%' then 1 else 0 end)
FROM	MMLibrary
WHERE	LibraryId > 0 AND libraryTypeId <> 8 AND
( (@showHiddenLibConfig = 1) OR (ExtendedAttributes & 33554432 = 0) )
AND LibraryTypeId <> 10
----------------------
-- VISIBILITY CHECK --
----------------------
IF @i_userId > 0
BEGIN
	IF object_id('tempdb.dbo.#MMSummUserObjects') IS NOT null DROP TABLE #MMSummUserObjects
create table  #MMSummUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 0, 0, '#MMSummUserObjects'
	DELETE #MMSummUserObjects
	WHERE clientGroupId <> 0 OR clientId <> 0 OR mediaAgentId <> 0 OR archGroupID <> 0 OR vtContainerId <> 0 OR VtShelfId <> 0 OR vtPolicyId <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0 OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
	OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
	OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
	OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
	DELETE @libTbl
	WHERE NOT EXISTS (select * from #MMSummUserObjects where libraryID in (0, t_id))
	DROP TABLE #MMSummUserObjects
END
---------------------
SELECT	 @totalCapacity = sum(CAST(m.TotalSpaceMB AS DECIMAL(38))) * 1024 * 1024, @totalFreeSpace = sum(CAST(m.FreeBytesMB AS DECIMAL(38))) * 1024 * 1024
FROM  MMMountPath mp  WITH (NOLOCK)  INNER JOIN @libTbl l ON l.t_id = mp.LibraryId AND l.t_isMag = 1
        INNER JOIN MMMediaSide m WITH (NOLOCK) ON mp.MediaSideId = m.MediaSideId AND m.MediaSideId>0
AND (mp.MountPathTypeId !=7 OR (mp.MountPathTypeId =7 AND m.TotalSpaceMB != 1048576 AND m.FreeBytesMB != 1048576))
SELECT  TAG						= 1,
	Parent						= null,
	[EVGui_SummPageGetLibraries!1!totalLib]		= (select count(*) from @libTbl),
    [EVGui_SummPageGetLibraries!1!totalTapeLib]	= (select count(*) from @libTbl where t_isMag = 0),
	[EVGui_SummPageGetLibraries!1!totalmagLib]	= (select count(*) from @libTbl where t_isMag > 0 and t_isCloud = 0),
    [EVGui_SummPageGetLibraries!1!totalOfflineLib]	= (select count(*) from @libTbl where t_isOnline = 0 OR t_isLCPOnline = 0),
[EVGui_SummPageGetLibraries!1!totalFreeSpace]	= (CASE WHEN @totalFreeSpace >= 0 THEN DBO.GetSizeString(@totalFreeSpace) ELSE DBO.fn_EvFormatEventMsgText(0, @i_localeId, (369 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) END),
[EVGui_SummPageGetLibraries!1!totalCapacity]		= (CASE WHEN @totalCapacity >= 0 THEN DBO.GetSizeString(@totalCapacity) ELSE DBO.fn_EvFormatEventMsgText(0, @i_localeId, (369 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) END),
	[EVGui_SummPageGetLibraries!1!totalCloudLib]	= (SELECT COUNT(*) FROM @libTbl WHERE t_isMag > 0 AND t_isCloud > 0)
FOR XML EXPLICIT
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSummPageGetLibraries')
	delete from GxQscripts where name = 'MMSummPageGetLibraries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetLibraries')
	delete from GXDBVersions where aliasname = 'MMSummPageGetLibraries'
GO

insert into GXDBVersions values(2, 'MMSummPageGetLibraries',  '00010006019000080000', 'MMSummPageGetLibraries', '00010006019000080000')
GO

