

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSummPageGetExportedMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSummPageGetExportedMedia.sp,v $ $Id: MMSummPageGetExportedMedia.sp,v 1.3.198.6 2020/09/24 14:32:29 lviswambharan Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetExportedMedia"		|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMSummPageGetExportedMedia')
BEGIN
	print '>>> Drop Stored Procedure: MMSummPageGetExportedMedia <<<'
	drop procedure MMSummPageGetExportedMedia
END
IF EXISTS (select * from GxQscripts where name='MMSummPageGetExportedMedia')
	delete from GxQscripts where name = 'MMSummPageGetExportedMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetExportedMedia')
	delete from GXDBVersions where aliasname = 'MMSummPageGetExportedMedia'
GO
print '... Creating Procedure: MMSummPageGetExportedMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSummPageGetExportedMedia
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_libraryId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @mediaTbl		TABLE (t_id int, t_sparegroupId int, t_spareGroupType int, t_status1 int, t_status2 int,  isInMediaGroup int, isAged int)
DECLARE	@exportSGId		TABLE (sgId int, libId int)
DECLARE	@exportMGId		TABLE (medId int, libId int)
-- Get media outside library
INSERT INTO @exportSGId
SELECT	SpareGroupId, LibraryId
FROM	MMSpareGroup
WHERE	LibraryId = @i_LibraryId
INSERT INTO @exportMGId
SELECT	V.MediaId, T.libId
FROM	MMMediaGroup G, MMVolume V, @exportSGId T
WHERE	G.SpareGroupId = T.sgId AND G.MediaGroupId = V.MediaGroupId and V.MediaGroupId > 0
IF @i_LibraryId = 0  -- Orphan media
 BEGIN
  INSERT INTO @mediaTbl
  SELECT DISTINCT MediaId, (case isInMediaGroup when 1 then 0 else sparegroupId end), 0, 0, 0, isInMediaGroup, isAged
  FROM    MMMedia
  WHERE   MediaId > 0 AND mediaTypeId <> 10001 AND libraryId=0
 END
ELSE
 BEGIN
	INSERT INTO @mediaTbl
	SELECT DISTINCT MediaId, (case isInMediaGroup when 1 then 0 else sparegroupId end), 0, 0, 0, isInMediaGroup, isAged
	FROM	MMMedia
	WHERE	LastWriteLibraryId = @i_LibraryId AND MediaId > 0 AND mediaTypeId <> 10001 AND MediaLocation = 3
	UNION
	SELECT DISTINCT MediaId, (case isInMediaGroup when 1 then 0 else sparegroupId end), 0, 0, 0, isInMediaGroup, isAged
	FROM	MMMedia, @exportSGId SG
	WHERE	LastWriteLibraryId <> @i_LibraryId AND MediaId > 0 AND mediaTypeId <> 10001 AND MediaLocation = 3 AND
	IsInMediaGroup = 0 AND SpareGroupId = SG.sgId
	UNION
	SELECT DISTINCT MediaId, (case isInMediaGroup when 1 then 0 else sparegroupId end), 0, 0, 0, isInMediaGroup, isAged
	FROM	MMMedia, @exportMGId MG
	WHERE	LastWriteLibraryId <> @i_LibraryId AND MediaId > 0 AND mediaTypeId <> 10001 AND MediaLocation = 3 AND
	IsInMediaGroup > 0 AND MediaId = MG.medId AND LastWriteLibraryId <> 0
	UNION
	SELECT DISTINCT MediaId, (case isInMediaGroup when 1 then 0 else sparegroupId end), 0, 0, 0, isInMediaGroup, isAged
	FROM	MMMedia
	WHERE	LastWriteLibraryId <> @i_LibraryId AND MediaId > 0 AND mediaTypeId <> 10001 AND MediaLocation = 3 AND
	IsInMediaGroup > 0 AND LibraryId = @i_LibraryId
 END
delete A from @mediaTbl A  inner join   MMMedia as  B on a.t_id = B.mediaid
where B.barcode = (select ('StdAln_' + CAST(B.MediaId as varchar(64))))  --Dummy Media for stand alone library not to be shown MR 9121
-- Update media status
UPDATE @mediaTbl
SET	t_spareGroupType = spareGroupType
FROM	MMSpareGroup
WHERE	t_sparegroupId = spareGroupId AND t_sparegroupId > 0
UPDATE @mediaTbl
SET	t_status1 = (	select min(V.VolumeFlags) from MMVolume V, MMMediaSide S
			where V.MediaSideId = S.MediaSideId AND S.MediaId = t_id AND t_sparegroupId = 0),
	t_status2 = (	select max(V.VolumeFlags) from MMVolume V, MMMediaSide S
			where V.MediaSideId = S.MediaSideId AND S.MediaId = t_id AND t_sparegroupId = 0)
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
SELECT  TAG							= 1,
	Parent							= null,
        [EVGui_SummPageGetExportedMedia!1!numOfMedia]		= (select count(DISTINCT t_id) from @mediaTbl),
      	[EVGui_SummPageGetExportedMedia!1!numOfActiveMedia]	= (select count(DISTINCT t_id) from @mediaTbl where t_status1 = 1 OR t_status2 = 1),
	[EVGui_SummPageGetExportedMedia!1!numOfAppendableMedia]= (select count(DISTINCT t_id) from @mediaTbl where t_status1 = 7 OR t_status2 = 7),
	[EVGui_SummPageGetExportedMedia!1!numOfSpareMedia]	= (select count(DISTINCT t_id) from @mediaTbl MT inner join MMMedia M WITH(READUNCOMMITTED) on MT.t_id = M.MediaId INNER JOIN MMMediaType MTYP WITH(READUNCOMMITTED) ON MTYP.MediaTypeId = M.MediaTypeId  where (t_spareGroupType in( 1, 2) OR (M.isInMediaGroup = 0 AND MT.t_sparegroupId = 0)) AND MT.isAged = 0 AND M.MediaFlags = 1 AND MTYP.IsCleaningMedia <> 1),
	[EVGui_SummPageGetExportedMedia!1!numOfAgedMedia]	= (select count(DISTINCT t_id) from @mediaTbl where isAged = 1),
	[EVGui_SummPageGetExportedMedia!1!numOfCleaningMedia]	= (select count(DISTINCT t_id) from @mediaTbl MT inner join MMMedia M WITH(READUNCOMMITTED) on MT.t_id = M.MediaId INNER JOIN MMMediaType MTYP WITH(READUNCOMMITTED) ON MTYP.MediaTypeId = M.MediaTypeId where (t_spareGroupType = 32) OR (MTYP.IsCleaningMedia = 1 AND t_status1 = 5 AND t_status2 = 5)),
	[EVGui_SummPageGetExportedMedia!1!numOfBadMedia]	= (select count(DISTINCT t_id) from @mediaTbl where t_status1 = 4 OR t_status2 = 4),
	[EVGui_SummPageGetExportedMedia!1!numOfForeignMedia]	= (select count(DISTINCT t_id) from @mediaTbl where t_spareGroupType = 16)
FOR XML EXPLICIT
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSummPageGetExportedMedia')
	delete from GxQscripts where name = 'MMSummPageGetExportedMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetExportedMedia')
	delete from GXDBVersions where aliasname = 'MMSummPageGetExportedMedia'
GO

insert into GXDBVersions values(2, 'MMSummPageGetExportedMedia',  '00010003019800060000', 'MMSummPageGetExportedMedia', '00010003019800060000')
GO

