

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSummPageGetDrivePool.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSummPageGetDrivePool.sp,v $ $Id: MMSummPageGetDrivePool.sp,v 1.7.194.2 2018/03/20 00:03:55 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetDrivePool"		|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSummPageGetDrivePool <<<'

IF EXISTS (select * from sysobjects where name='MMSummPageGetDrivePool')
	drop procedure MMSummPageGetDrivePool
IF EXISTS (select * from GxQscripts where name='MMSummPageGetDrivePool')
	delete from GxQscripts where name = 'MMSummPageGetDrivePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetDrivePool')
	delete from GXDBVersions where aliasname = 'MMSummPageGetDrivePool'
GO
print '... Creating Procedure: MMSummPageGetDrivePool'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSummPageGetDrivePool
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_drivePoolId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @currentTime	INT
DECLARE @clientId	INT
DECLARE @jobsLast24H	INT
DECLARE @runningJobs	INT
DECLARE @drivePoolName	nvarchar(max)
DECLARE @driveTbl	TABLE (t_id int, t_isOnline int)
SET @currentTime = DBO.GetUnixTime(getUTCDate())
-------------
-- Client
SELECT @clientId = Clientid, @drivePoolName = drivePoolName
FROM	MMDrivePool
WHERE	drivepoolId = @i_drivePoolId
-------------
-- Drive
INSERT INTO @driveTbl
SELECT	DISTINCT D.driveId, (case when D.DriveSoftState > 0 and D.DriveEnabled > 0 and D.DriveBroken = 0 then 1 else 0 end)
FROM	MMDrive D, MMDriveController C
WHERE	C.drivepoolId = @i_drivePoolId AND C.ClientId = @clientId AND C.DriveId = D.DriveId
-------------
-- Drive Pool
IF object_id('tempdb.dbo.#tempDrivePoolTbl') is not null DROP TABLE #tempDrivePoolTbl
SELECT	drivepoolId, isOnline=(case when drivepoolsoftstate > 0 and drivepoolenabled > 0 then 1 else 0 end), drivePoolType, maxdrivestoswitch
INTO	#tempDrivePoolTbl
FROM	MMDrivePool
WHERE	drivepoolid = @i_drivePoolId
-------------
-- Jobs
SELECT	@jobsLast24H = count(distinct jobID)
FROM	JMJobResourceHistory
WHERE	drivePoolId = @i_drivePoolId AND clientId = @clientId AND @currentTime - reservationTime < 24*60*60
--SELECT	@runningJobs = count(distinct jobID)
--FROM	JMBkpAttemptInfo
--WHERE	drivePoolname like @drivePoolName
SET @runningJobs=  ISNULL((SELECT COUNT(DISTINCT JobId_l) FROM MMResourceToJob where
JobId_h=0 and
ReservationId in(SELECT ReservationId FROM MMResource WHERE DrivePoolId = @i_drivePoolId)),0)
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
DECLARE @drivePoolTypestring NVARCHAR(100)
SET @drivePoolTypestring = (CASE (select drivePoolType from #tempDrivePoolTbl)
WHEN 0 THEN DBO.fn_EvFormatEventMsgText(0, @i_localeId, (3213 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
WHEN 1 THEN DBO.fn_EvFormatEventMsgText(0, @i_localeId, (3214 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
WHEN 2  THEN DBO.fn_EvFormatEventMsgText(0, @i_localeId, (3215 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
WHEN 2  THEN DBO.fn_EvFormatEventMsgText(0, @i_localeId, (3216 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
WHEN 10001   THEN DBO.fn_EvFormatEventMsgText(0, @i_localeId, (3217 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
							END)
SELECT  TAG								= 1,
	Parent								= null,
	[EVGui_SummPageGetDrivePool!1!isOnline]				= (select isOnline from #tempDrivePoolTbl),
--	[EVGui_SummPageGetDrivePool!1!offlineReason]			= 0,
	[EVGui_SummPageGetDrivePool!1!drivePooType]			= (@drivePoolTypestring),
	[EVGui_SummPageGetDrivePool!1!driveAllocation]			= case(select maxdrivestoswitch from #tempDrivePoolTbl) when -1 then (select count(*) from @driveTbl) else (select maxdrivestoswitch from #tempDrivePoolTbl) end ,
	[EVGui_SummPageGetDrivePool!1!numberOfDrives]			= (select count(*) from @driveTbl),
	[EVGui_SummPageGetDrivePool!1!numberOfDrivesOnine]		= (select count(*) from @driveTbl where t_isOnline > 0),
	[EVGui_SummPageGetDrivePool!1!numberOfBackupsInLast24Hours]	= @jobsLast24H,
	[EVGui_SummPageGetDrivePool!1!numberOfRunningJobs]		= @runningJobs
FOR XML EXPLICIT
DROP TABLE #tempDrivePoolTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSummPageGetDrivePool')
	delete from GxQscripts where name = 'MMSummPageGetDrivePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetDrivePool')
	delete from GXDBVersions where aliasname = 'MMSummPageGetDrivePool'
GO

insert into GXDBVersions values(2, 'MMSummPageGetDrivePool',  '00010007019400020000', 'MMSummPageGetDrivePool', '00010007019400020000')
GO

