

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSummPageGetDrive.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSummPageGetDrive.sp,v $ $Id: MMSummPageGetDrive.sp,v 1.13.2.7 2019/02/15 23:35:02 pveeravalli Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetDrive"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMSummPageGetDrive')
BEGIN
	print '>>> Drop Stored Procedure: MMSummPageGetDrive <<<'
	drop procedure MMSummPageGetDrive
END
IF EXISTS (select * from GxQscripts where name='MMSummPageGetDrive')
	delete from GxQscripts where name = 'MMSummPageGetDrive'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetDrive')
	delete from GXDBVersions where aliasname = 'MMSummPageGetDrive'
GO
print '... Creating Procedure: MMSummPageGetDrive'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSummPageGetDrive
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_driveId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @clientId		INT
DECLARE	@status			INT
DECLARE	@driveStatusEventId	INT
DECLARE @mountErrorsSinceClean	INT
DECLARE @dataSizeInLast1H	BIGINT
DECLARE @durationInLast1H	BIGINT
DECLARE @dataSizeInLast24H	BIGINT
DECLARE @durationInLast24H	BIGINT
--------
-- Drive
IF object_id('tempdb.dbo.#tempDriveTbl') is not null DROP TABLE #tempDriveTbl
SELECT	libId = (select M.LibraryId from MMMasterPool M where M.masterPoolId = MMDrive.masterPoolId),
	isOnline = (case when DriveSoftState > 0 and DriveEnabled > 0 and DriveBroken = 0 then 1 else 0 end), OfflineReason,
	DriveVendor, DriveModel, firmwareRevision, lastUseTime, LastCleanTime,
	hoursUsedSinceLastClean = MinutesUsedSinceClean/60,
	errorsSinceLastClean = NumSoftErrsSinceClean + NumHardErrsSinceClean
INTO	#tempDriveTbl
FROM	MMDrive
WHERE	driveId = @i_driveId
SELECT	@clientId = MAX(clientId)
FROM	MMDriveController
WHERE	driveId = @i_driveId AND driveControllerId > 0
GROUP BY driveId
SELECT	@mountErrorsSinceClean = count(*)
FROM	MMErrorTracker
WHERE	driveId = @i_driveId AND errorCode > 0 AND dbo.GetUnixTime(errorTime) > (select LastCleanTime from #tempDriveTbl)
--------
-- jobs
SELECT	@dataSizeInLast1H = sum(dataWritten)*1024*1024, @durationInLast1H	= sum(cast(dataWriteDurationSec as bigint))
FROM	MMDrivehistory
WHERE	driveId = @i_driveId AND datediff(hh, timeStart, getUTCDate()) < 1 AND dataWritten > 0 AND historytype=2
SELECT	@dataSizeInLast24H = sum(dataWritten)*1024*1024, @durationInLast24H = sum(cast(dataWriteDurationSec as bigint))
FROM	MMDrivehistory
WHERE	driveId = @i_driveId AND datediff(hh, timeStart, getUTCDate()) < 24 AND dataWritten > 0 AND historytype=2
SELECT	@status = (case isOnline when 0 then (560 | (CAST(POWER(2, 24) AS BIGINT) * 61)) else (559 | (CAST(POWER(2, 24) AS BIGINT) * 61)) end) FROM #tempDriveTbl
SELECT	@driveStatusEventId=DriveOfflineReasonEventId
FROM	MMDrive WITH (NOLOCK)
WHERE	driveId = @i_driveId
DECLARE @runningJobs INT
SET @runningJobs=  ISNULL((SELECT COUNT(DISTINCT JobId_l) FROM MMResourceToJob where
JobId_h=0 and
ReservationId in(SELECT ReservationId FROM MMResource WHERE DriveId = @i_driveId)),0)
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
DECLARE @lastUseTime		INT
SELECT	@lastUseTime =  lastUseTime from #tempDriveTbl
IF(@lastUseTime IS NOT NULL AND @lastUseTime <> 0)
SELECT	@lastUseTime =  dbo.GetUnixTime(dbo.UTCToLocalTime(  dbo.GetDateTime( @lastUseTime), dbo.GetClientTimeZone(2)))
SELECT  TAG								= 1,
	Parent								= null,
	[EVGui_SummPageGetDrive!1!isOnline]				= DBO.fn_EvFormatEventMsgText(0, @i_localeId, @status, 0,2),
[EVGui_SummPageGetDrive!1!offlineReason]			= (select DBO.fn_EvFormatEventMsgText(0, @i_localeId, CASE isOnline WHEN 1 THEN (369 | (CAST(POWER(2, 24) AS BIGINT) * 61)) ELSE @driveStatusEventId END, 0,2) from #tempDriveTbl),
	[EVGui_SummPageGetDrive!1!vendor]				= (select DriveVendor from #tempDriveTbl),
	[EVGui_SummPageGetDrive!1!model]				= (select DriveModel from #tempDriveTbl),
	[EVGui_SummPageGetDrive!1!firmwareRevision]			= (select firmwareRevision from #tempDriveTbl),
	[EVGui_SummPageGetDrive!1!bytesBackedupInLast1Hour]		= DBO.GetSizeString(@dataSizeInLast1H),
	[EVGui_SummPageGetDrive!1!bytesBackedupInLast24Hour]		= DBO.GetSizeString(@dataSizeInLast24H),
	[EVGui_SummPageGetDrive!1!controller]				= (select displayName from APP_client WITH(READUNCOMMITTED) where id = @clientId),
	[EVGui_SummPageGetDrive!1!numberOfRunningJobs]			= @runningJobs,
	[EVGui_SummPageGetDrive!1!library]				= (select aliasName from MMLibrary, #tempDriveTbl where libraryId=libId),
[EVGui_SummPageGetDrive!1!lastUseTime]				= (case @lastUseTime when 0 then DBO.fn_EvFormatEventMsgText(0, @i_localeId, (369 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0, 2) else DBO.getDateTime2(@lastUseTime, null, 0) end),
	[EVGui_SummPageGetDrive!1!hoursUsedSinceLastClean]		= (select hoursUsedSinceLastClean from #tempDriveTbl),
	[EVGui_SummPageGetDrive!1!mountUnmountErrosSinceLastClean]	= (select errorsSinceLastClean from #tempDriveTbl),
	[EVGui_SummPageGetDrive!1!readWriteErrosSinceLastClean]		= @mountErrorsSinceClean,
	[EVGui_SummPageGetDrive!1!lastHourThroughput]			= DBO.GetThroughputString(@dataSizeInLast1H, @durationInLast1H, 1),
	[EVGui_SummPageGetDrive!1!lastDayThroughput]			= DBO.GetThroughputString(@dataSizeInLast24H, @durationInLast24H, 1),
	[EVGui_SummPageGetDrive!1!driveName]				= (select AliasName from MMDrive where DriveId = @i_driveId),
	[EVGui_SummPageGetDrive!1!serialNumber]				= (select SerialNumber from MMDrive where DriveId = @i_driveId),
	[EVGui_SummPageGetDrive!1!isEnabled]				= (select DriveEnabled from MMDrive where DriveId = @i_driveId),
	[EVGui_SummPageGetDrive!1!status]				= (select isOnline from #tempDriveTbl),
	[EVGui_SummPageGetDrive!1!attribute]				= (select Attributes from MMDrive where DriveId = @i_driveId)
FOR XML EXPLICIT
DROP TABLE #tempDriveTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSummPageGetDrive')
	delete from GxQscripts where name = 'MMSummPageGetDrive'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetDrive')
	delete from GXDBVersions where aliasname = 'MMSummPageGetDrive'
GO

insert into GXDBVersions values(2, 'MMSummPageGetDrive',  '00010013000200070000', 'MMSummPageGetDrive', '00010013000200070000')
GO

