

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSummPageGetContainer.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSummPageGetContainer.sp,v $ $Id: MMSummPageGetContainer.sp,v 1.5.190.2 2018/03/20 00:07:11 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetContainer"		|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSummPageGetContainer <<<'

IF EXISTS (select * from sysobjects where name='MMSummPageGetContainer')
	drop procedure MMSummPageGetContainer
IF EXISTS (select * from GxQscripts where name='MMSummPageGetContainer')
	delete from GxQscripts where name = 'MMSummPageGetContainer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetContainer')
	delete from GXDBVersions where aliasname = 'MMSummPageGetContainer'
GO
print '... Creating Procedure: MMSummPageGetContainer'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSummPageGetContainer
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_commcellId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @containerTbl		TABLE (t_containerId int, t_mediaId int, t_isExported int)
INSERT INTO @containerTbl
SELECT	C.containerId, M.MediaId, (case M.MediaLocation when 3 then 1 else 0 end)
FROM	MMContainer C	LEFT OUTER JOIN MMMedia M ON M.ContainerId = C.ContainerId
WHERE	C.containerId > 0
----------------------
-- VISIBILITY CHECK --
----------------------
IF @i_userId > 0
BEGIN
	IF object_id('tempdb.dbo.#MMSummUserObjects') IS NOT null DROP TABLE #MMSummUserObjects
create table  #MMSummUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 0, 0, '#MMSummUserObjects'
	DELETE #MMSummUserObjects
	WHERE clientGroupId <> 0 OR clientId <> 0 OR mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0 OR vtPolicyId <> 0 OR VtShelfId <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0 OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
	OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
	OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
	OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
	DELETE @containerTbl
	WHERE NOT EXISTS (select * from #MMSummUserObjects where vtContainerId in (0, t_containerId))
	DROP TABLE #MMSummUserObjects
END
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
SELECT  TAG									= 1,
	Parent									= null,
	[EVGui_SummPageGetContainers!1!totalContainers]				= (select count(DISTINCT t_containerId) from @containerTbl),
	[EVGui_SummPageGetContainers!1!totalMediaAssignToContainers]		= (select count(DISTINCT t_mediaId) from @containerTbl),
	[EVGui_SummPageGetContainers!1!totalMediaAssignToContainersInsideLib]	= (select count(DISTINCT t_mediaId) from @containerTbl where t_isExported = 0)
FOR XML EXPLICIT
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSummPageGetContainer')
	delete from GxQscripts where name = 'MMSummPageGetContainer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetContainer')
	delete from GXDBVersions where aliasname = 'MMSummPageGetContainer'
GO

insert into GXDBVersions values(2, 'MMSummPageGetContainer',  '00010005019000020000', 'MMSummPageGetContainer', '00010005019000020000')
GO

