

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSummPageGetAssignedMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSummPageGetAssignedMedia.sp,v $ $Id: MMSummPageGetAssignedMedia.sp,v 1.2.196.1 2018/03/20 00:16:02 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetAssignedMedia"		|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSummPageGetAssignedMedia <<<'

IF EXISTS (select * from sysobjects where name='MMSummPageGetAssignedMedia')
	drop procedure MMSummPageGetAssignedMedia
IF EXISTS (select * from GxQscripts where name='MMSummPageGetAssignedMedia')
	delete from GxQscripts where name = 'MMSummPageGetAssignedMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetAssignedMedia')
	delete from GXDBVersions where aliasname = 'MMSummPageGetAssignedMedia'
GO
print '... Creating Procedure: MMSummPageGetAssignedMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSummPageGetAssignedMedia
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_libraryId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@isShelf	INT
DECLARE @mediaTbl	TABLE (t_id int, t_isExported int)
--------
-- Get media by group ID
INSERT INTO @mediaTbl
SELECT DISTINCT MediaId, (case MediaLocation when 3 then 1 else 0 end)
FROM 	MMMedia
WHERE 	IsInMediaGroup = 1 AND libraryId = @i_libraryId
delete A from @mediaTbl A  inner join   MMMedia as  B on a.t_id = B.mediaid
where B.barcode = (select ('StdAln_' + CAST(B.MediaId as varchar(64))))  --Dummy Media for stand alone library not to be shown MR 9121
SELECT	@isShelf = (case libraryTypeId when 8 then 1 else 0 end)
FROM	MMLibrary
WHERE	LibraryId = @i_libraryId
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
SELECT  TAG								= 1,
	Parent								= null,
        [EVGui_SummPageGetMediaByGroup!1!mediaType]			= null,
        [EVGui_SummPageGetMediaByGroup!1!numOfMedia]			= (select count(DISTINCT t_id) from @mediaTbl),
	[EVGui_SummPageGetMediaByGroup!1!numOfMediaInsideLibrary]	= case when @isShelf > 0 then null else
										(select count(DISTINCT t_id) from @mediaTbl where t_isExported = 0) end,
	[EVGui_SummPageGetMediaByGroup!1!numOfMediaOutsideLibrary]	= case when @isShelf > 0 then null else
										(select count(DISTINCT t_id) from @mediaTbl where t_isExported = 1) end,
	[EVGui_SummPageGetMediaByGroup!1!lowWaterMark]			= null
FOR XML EXPLICIT
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSummPageGetAssignedMedia')
	delete from GxQscripts where name = 'MMSummPageGetAssignedMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetAssignedMedia')
	delete from GXDBVersions where aliasname = 'MMSummPageGetAssignedMedia'
GO

insert into GXDBVersions values(2, 'MMSummPageGetAssignedMedia',  '00010002019600010000', 'MMSummPageGetAssignedMedia', '00010002019600010000')
GO

