

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSetPrunerMAForCloudMountPath.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSetPrunerMAForCloudMountPath.sp,v $ $Id: MMSetPrunerMAForCloudMountPath.sp,v 1.1.2.5 2018/03/22 03:10:32 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSetPrunerMAForCloudMountPath <<<'

IF EXISTS (select * from sysobjects where name='MMSetPrunerMAForCloudMountPath')
	drop procedure MMSetPrunerMAForCloudMountPath
IF EXISTS (select * from GxQscripts where name='MMSetPrunerMAForCloudMountPath')
	delete from GxQscripts where name = 'MMSetPrunerMAForCloudMountPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSetPrunerMAForCloudMountPath')
	delete from GXDBVersions where aliasname = 'MMSetPrunerMAForCloudMountPath'
GO
print '... Creating Procedure: MMSetPrunerMAForCloudMountPath'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSetPrunerMAForCloudMountPath
  @i_MountPathId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_retCode integer			
SET @o_retCode = 0
IF ISNULL((SELECT MountPathTypeId FROM MMMountPath WITH(NOLOCK) WHERE MountPathId = @i_MountPathId), 0) <> 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
	GOTO ERR_EXIT
/*Get all MAs that has access to this mount path*/
DECLARE @tbl_MAsWithAccess table(ClientId int)
INSERT @tbl_MAsWithAccess
SELECT 	DISTINCT H.ClientId
	FROM 		MMHost H (READUNCOMMITTED) INNER JOIN MMDeviceController DEVC (READUNCOMMITTED)
				ON  H.MmHostEnabled = 1 AND H.MmHostSoftState = 1 AND H.ClientId = DEVC.ClientId
AND DEVC.DeviceControllerEnabled = 1 AND DEVC.DeviceAccessible = 1 AND (DEVC.DeviceAccessType & 2) = 2
AND DEVC.DeviceAccessType & 16 = 0
AND DEVC.DeviceAccessType & 32 = 0
AND DEVC.DeviceAccessType & 128 = 0
			INNER JOIN MMDevice DEV (READUNCOMMITTED)
				ON DEV.DeviceId = DEVC.DeviceId AND DEV.DeviceEnabled = 1 AND DEV.DeviceBroken = 0
			INNER JOIN MMMountPathToStorageDevice MPTODEV (READUNCOMMITTED)
				ON MPTODEV.DeviceId = DEV.DeviceId
			WHERE MPTODEV.MountPathId = @i_MountPathId
SET @o_retCode = @@ERROR
IF(@o_retCode <> 0)
	GOTO ERR_EXIT
DECLARE @l_MasterPoolId int
SELECT @l_MasterPoolId = MasterPoolId FROM MMMountPath MP WITH(NOLOCK) WHERE MP.MountPathId = @i_MountPathId
/*
DECLARE @l_DrivePoolId int
SELECT @l_DrivePoolId = DrivePoolId FROM MMDrivePool DPOOL WITH(NOLOCK) INNER JOIN MMMountPath MP WITH(NOLOCK) ON DPOOL.MasterPoolId = MP.MasterPoolId
WHERE MP.MountPathId = @i_MountPathId
*/
SET @o_retCode = @@ERROR
IF(@o_retCode <> 0)
	GOTO ERR_EXIT
DECLARE @tbl_AllCopies table(CopyId int)
/*All copies that have this mount path in their datapath*/
INSERT @tbl_AllCopies
SELECT DISTINCT DP.CopyId
FROM MMDataPath DP WITH(NOLOCK) INNER JOIN ArchGroupCopy AGC WITH(NOLOCK) ON DP.CopyId = AGC.id
INNER JOIN MMDrivePool DPOOL ON DP.DrivePoolId = DPOOL.DrivePoolId AND DPOOL.MasterPoolId = @l_MasterPoolId
WHERE (AGC.dedupeflags & 134217728 = 0)
SET @o_retCode = @@ERROR
IF(@o_retCode <> 0)
	GOTO ERR_EXIT
--Remove those copies that have the flag set
/*
DELETE @tbl_AllCopies
FROM @tbl_AllCopies Copy INNER JOIN MMDataPath DP WITH(NOLOCK) ON Copy.CopyId = DP.CopyId AND DP.DrivePoolId = @l_DrivePoolId
WHERE DP.flag & 64 > 0
*/
DELETE @tbl_AllCopies
FROM @tbl_AllCopies Copy INNER JOIN MMDataPath DP WITH(NOLOCK) ON Copy.CopyId = DP.CopyId
INNER JOIN MMDrivePool DPOOL ON DP.DrivePoolId = DPOOL.DrivePoolId AND DPOOL.MasterPoolId = @l_MasterPoolId
WHERE DP.flag & 64 > 0
SET @o_retCode = @@ERROR
IF(@o_retCode <> 0)
	GOTO ERR_EXIT
IF EXISTS(SELECT 1 FROM @tbl_AllCopies)
BEGIN
	/*
	Set cloud pruner datapath flag on datapaths that have this mount path in the order of preference
	1->Those with an MA with access to mount path
	2->Enabled data path
	3->Default datapath
	4->Random
	*/
	;WITH DPPicker (DataPathId, rank)
	AS
	(
	SELECT DP.DataPathId, row_number() OVER (
	partition by DP.copyId
order by (CASE WHEN MA.ClientId IS NOT NULL THEN 1 ELSE 0 END) desc, (DP.flag & 4) desc, (DP.flag & 1) desc, NEWID()) as rank
		FROM MMDataPath DP WITH(NOLOCK) INNER JOIN @tbl_AllCopies Copy ON DP.CopyId = Copy.CopyId
		LEFT OUTER JOIN @tbl_MAsWithAccess MA ON DP.HostClientId = MA.ClientId
		WHERE DP.DrivePoolId IN (SELECT DrivePoolId FROM MMDrivePool WITH(NOLOCK) WHERE MasterPoolId = @l_MasterPoolId)
	)
	UPDATE DP
SET DP.flag = DP.flag | 64
	FROM MMDataPath DP WITH(NOLOCK) INNER JOIN DPPicker T ON DP.DataPathId = T.DataPathId AND T.rank = 1
	SET @o_retCode = @@ERROR
	IF(@o_retCode <> 0)
		GOTO ERR_EXIT
END
ERR_EXIT:
	SELECT @o_retCode
GO

IF EXISTS (select * from GxQscripts where name = 'MMSetPrunerMAForCloudMountPath')
	delete from GxQscripts where name = 'MMSetPrunerMAForCloudMountPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSetPrunerMAForCloudMountPath')
	delete from GXDBVersions where aliasname = 'MMSetPrunerMAForCloudMountPath'
GO

insert into GXDBVersions values(2, 'MMSetPrunerMAForCloudMountPath',  '00010001000200050000', 'MMSetPrunerMAForCloudMountPath', '00010001000200050000')
GO

