

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSetPreferredAccessForDevice.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSetPreferredAccessForDevice.sp,v $ $Id: MMSetPreferredAccessForDevice.sp,v 1.4.2.4 2018/08/23 14:38:04 aselvanayagam Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSetPreferredAccessForDevice <<<'

IF EXISTS (select * from sysobjects where name='MMSetPreferredAccessForDevice')
	drop procedure MMSetPreferredAccessForDevice
IF EXISTS (select * from GxQscripts where name='MMSetPreferredAccessForDevice')
	delete from GxQscripts where name = 'MMSetPreferredAccessForDevice'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSetPreferredAccessForDevice')
	delete from GXDBVersions where aliasname = 'MMSetPreferredAccessForDevice'
GO
print '... Creating Procedure: MMSetPreferredAccessForDevice'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSetPreferredAccessForDevice
  @i_DeviceId INTEGER,
  @i_DeviceControllerId INTEGER,
  @i_reserveInt INTEGER
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_DeviceControllerId INTEGER
  DECLARE @o_ReserveInt INTEGER
  DECLARE @o_ReserveStr VARCHAR(1024)
SET NOCOUNT ON
DECLARE @deviceControllerId INT = 0
-- When adding a controller to the device, we'll get only the deviceId.
IF @i_DeviceId > 0
BEGIN
IF NOT EXISTS (SELECT * FROM MMDeviceController WITH (NOLOCK) WHERE DeviceId = @i_DeviceId AND (DeviceAccessType & 8) > 0)
	BEGIN
		SET @deviceControllerId = ISNULL((SELECT TOP 1 DeviceControllerId
						FROM MMDeviceController
						WHERE DeviceId = @i_DeviceId
						AND (UserName = '' AND CredentialAssocId = 0)
AND (DeviceAccessType & (8 | 16 | 32 | 128)) = 0
ORDER BY (CASE WHEN DeviceAccessType = 6 THEN 1 ELSE 2 END),  DeviceControllerEnabled DESC, DeviceControllerId ASC )
						, 0)
		UPDATE MMDeviceController
SET DeviceAccessType = DeviceAccessType | 8
		WHERE DeviceControllerId = @deviceControllerId
		AND @deviceControllerId > 0
	END
END
-- When updating the prefrerred bit for a controller, we'll get the controller Id also.
ELSE IF @i_DeviceControllerId > 0
BEGIN
	SET @deviceControllerId = @i_DeviceControllerId
/*	Reverting the behaviour to unset the preferred bit on other MAs. User may choose any number of MAs as preferred. MR: 130228
	--Reset all the controllers for preferred bit first.
	DECLARE @deviceId INT = 0
	SELECT @deviceId = DeviceId
	FROM MMDeviceController WITH (NOLOCK)
	WHERE DeviceControllerId = @deviceControllerId
	UPDATE MMDeviceController
SET DeviceAccessType = DeviceAccessType & ~(8)
	WHERE DeviceId = @deviceId
*/
	-- Now set only the one which has been selected.
	UPDATE MMDeviceController
SET DeviceAccessType = DeviceAccessType | 8
	WHERE DeviceControllerId = @deviceControllerId
END
SELECT @deviceControllerId, 0, ''
GO

IF EXISTS (select * from GxQscripts where name = 'MMSetPreferredAccessForDevice')
	delete from GxQscripts where name = 'MMSetPreferredAccessForDevice'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSetPreferredAccessForDevice')
	delete from GXDBVersions where aliasname = 'MMSetPreferredAccessForDevice'
GO

insert into GXDBVersions values(2, 'MMSetPreferredAccessForDevice',  '00010004000200040000', 'MMSetPreferredAccessForDevice', '00010004000200040000')
GO

