

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSetNFSCacheInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSetNFSCacheInfo.sp,v $ $Id: MMSetNFSCacheInfo.sp,v 1.1.2.6 2018/03/27 09:13:55 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  MMSetNFSCacheInfo
--  |
--  | Description: sets currency preference.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSetNFSCacheInfo <<<'

IF EXISTS (select * from sysobjects where name='MMSetNFSCacheInfo')
	drop procedure MMSetNFSCacheInfo
IF EXISTS (select * from GxQscripts where name='MMSetNFSCacheInfo')
	delete from GxQscripts where name = 'MMSetNFSCacheInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSetNFSCacheInfo')
	delete from GXDBVersions where aliasname = 'MMSetNFSCacheInfo'
GO
print '... Creating Procedure: MMSetNFSCacheInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMSetNFSCacheInfo
  @i_MediaAgentId INT,
  @i_enableNFSCache INT,
  @i_cacheDirectory VARCHAR(1024),
  @i_pruneHighWaterMark INT,
  @i_cacheFlags INT
AS
  DECLARE @o_CacheDirectoryChanged INT 
SET NOCOUNT ON
DECLARE @localTran INT = 0
DECLARE @idxCacheId INT = 0
DECLARE @oldCacheDirectory VARCHAR(1024) = ''
DECLARE @oldWaterMark INT = 0
DECLARE @cacheOfflineReason INT = 0
DECLARE @cacheMigrationOfflineReason INT = 4 --IDXCACHE_NFSCACHE_MIGRATION_IN_PROGRESS (ncvs this define)
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION localTran
		SET @localTran = 1
	END
	SET @o_CacheDirectoryChanged = 0
	IF @i_MediaAgentId <= 0
	BEGIN
		RAISERROR('Valid MediaAgent not specified', 15, 1)
		RETURN
	END
	IF NOT EXISTS (SELECT 1 FROM IdxAccessPath AP, IdxCache C
WHERE C.IdxCacheId = AP.IdxCacheId AND AP.ClientId = @i_MediaAgentId AND C.IdxCacheType = 3)
	BEGIN
		DECLARE	@namePrefix NVARCHAR(510) = ''
		SELECT @namePrefix = 'NFSCache_' + name from APP_Client where id = @i_MediaAgentId
		DECLARE @poolId INT
		-----------------IDXPOOL------------------
		INSERT INTO IdxPool ([Description],[Enabled],[IsShared],[AgeingNoOfDays])
					VALUES  (@namePrefix + '_Pool',1,0,50)
		SET @poolId = SCOPE_IDENTITY()
		UPDATE IdxPool
		SET Description = Description + convert(varchar, @poolId)
		WHERE IdxPoolId = @poolId
		-----------------IDXCACHE------------------
		INSERT INTO IdxCache
               ([IdxPoolId],[Description],[Enabled],[Creationtime]
               ,[SoftState],[OfflineReason],[AgeingPercentDiskspace],[FillUpOrder]
               ,[FreeDiskSpaceMB],[LastUpdateTime],[LastUpdateAPId],[DiskUsageMB]
               ,[DiskUsageLastChecked],[DiskFreeThresholdMB],[DiskFreeWarningThreshholdMB],[IdxCacheType]
               ,[DiskReadSpeed],[DiskWriteSpeed],[CatalogServerClientId],[flags]
               ,[TotalCapacityMB])
         VALUES
               (@poolId, @namePrefix + '_Cache', 1, datediff(second, '01/01/1970', GetUTCdate())
               ,1,0,@i_pruneHighWaterMark,1
               ,-1,0,-1,-1
,0,-1,-1,3
               ,0,0,0,0
               ,-1)
		DECLARE @cacheId INT
		SET @cacheId = SCOPE_IDENTITY()
	    UPDATE IdxCache
		SET Description = Description + convert(varchar, @cacheId)
		WHERE IdxCacheId = @cacheId
		-----------------IDXACCESSPATH------------------
		INSERT INTO IdxAccessPath
               ([IdxCacheId],[ClientId],[Path],[Username],[Password]
               ,[Enabled],[SoftState],[OfflineReason]
               ,[Priority],[LocalIndexTimeStamp],[ActualDaysIndexRetain],[Flags]
               ,[AgeingNoOfDays],[AgeingPercentDiskspace],[DiskFreeThresholdMB],[DiskFreeWarningThreshholdMB]
               ,[TotalCapacityMB],[FreeDiskSpaceMB],[DiskUsageMB],[DiskUsageLastChecked]
               ,[StagingCachePath], [VolumeGUID])
         VALUES
               (@cacheId, @i_MediaAgentId, @i_cacheDirectory,'',''
               ,1,1,0
               ,1,0,0,0
               ,0,0,-1,-1
               ,0,0,0,0
               ,'', '')
		--This is important so that we can start a work queue
		--However currently setting it zero, so no work queue is triggered.
		--Change this to 1 when we support active migration.
		--and the new cache location gets created
		SET @o_CacheDirectoryChanged = 0
		IF (@localTran = 1)
		BEGIN
			COMMIT TRANSACTION localTran
			SET @localTran = 0
		END
	END
	ELSE
	BEGIN
		SELECT @oldCacheDirectory = path, @cacheOfflineReason = C.OfflineReason, @oldWaterMark = C.AgeingPercentDiskspace FROM IdxAccessPath AP, IdxCache C
WHERE C.IdxCacheId = AP.IdxCacheId AND AP.ClientId = @i_MediaAgentId AND C.IdxCacheType = 3
		IF @oldWaterMark <> @i_pruneHighWaterMark
		BEGIN
			IF @cacheOfflineReason = @cacheMigrationOfflineReason
			BEGIN
				RAISERROR('Cache migration is in progress', 15, 1)
				RETURN
			END
			ELSE
			BEGIN
				--Currently setting it 1, only for HWM change.
				SET @o_CacheDirectoryChanged = 1
			END
		END
		UPDATE IdxAccessPath
		SET path = @i_cacheDirectory, @idxCacheId = AP.IdxCacheId
		FROM IdxAccessPath AP, IdxCache C
WHERE C.IdxCacheId = AP.IdxCacheId AND AP.ClientId = @i_MediaAgentId AND C.IdxCacheType = 3
		UPDATE IdxCache
		SET Enabled = @i_enableNFSCache, AgeingPercentDiskspace = @i_pruneHighWaterMark, flags = @i_cacheFlags
		FROM IdxAccessPath AP, IdxCache C
WHERE C.IdxCacheId = AP.IdxCacheId AND AP.ClientId = @i_MediaAgentId AND C.IdxCacheType = 3 AND C.IdxCacheId = @idxCacheId
		IF (@localTran = 1)
		BEGIN
			COMMIT TRANSACTION localTran
			SET @localTran = 0
		END
	END
END TRY
BEGIN CATCH
DECLARE @l_error INT = ERROR_NUMBER()
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
RAISERROR(@l_error, 15, 1)
IF (XACT_STATE() <> 0 AND @localTran = 1)
BEGIN
    ROLLBACK TRANSACTION localTran
    SET @localTran = 0
END
END CATCH
SELECT @o_CacheDirectoryChanged
GO

IF EXISTS (select * from GxQscripts where name = 'MMSetNFSCacheInfo')
	delete from GxQscripts where name = 'MMSetNFSCacheInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSetNFSCacheInfo')
	delete from GXDBVersions where aliasname = 'MMSetNFSCacheInfo'
GO

insert into GXDBVersions values(2, 'MMSetNFSCacheInfo',  '00010001000200060000', 'MMSetNFSCacheInfo', '00010001000200060000')
GO

