

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSetErrorCodeForPruningFailures.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSetErrorCodeForPruningFailures.sp,v $ $Id: MMSetErrorCodeForPruningFailures.sp,v 1.13.2.11 2020/09/23 03:29:20 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMSetErrorCodeForPruningFailures')
BEGIN
	print '>>> Drop Stored Procedure: MMSetErrorCodeForPruningFailures <<<'
	drop procedure MMSetErrorCodeForPruningFailures
END
IF EXISTS (select * from GxQscripts where name='MMSetErrorCodeForPruningFailures')
	delete from GxQscripts where name = 'MMSetErrorCodeForPruningFailures'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSetErrorCodeForPruningFailures')
	delete from GXDBVersions where aliasname = 'MMSetErrorCodeForPruningFailures'
GO
print '... Creating Procedure: MMSetErrorCodeForPruningFailures'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSetErrorCodeForPruningFailures
  @i_MountPathId INTEGER,
  @i_flags INTEGER,
  @i_reserveStr VARCHAR(1024)
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_ReserveInt INTEGER
  DECLARE @o_ReserveStr VARCHAR(1024)
	SET NOCOUNT ON
	IF object_id('tempdb.dbo.#tmpMPSetErrorCode') IS NULL
		CREATE TABLE #tmpMPSetErrorCode
		(
			MountPathId			INT,
			MediaSideId			INT,
			errorCode			INT
			PRIMARY KEY (MountPathId)
		)
	--ELSE
		--Caller has created the table, just set error code if any
	/*This is for error codes for a mount path specific to a copy's data if mount path is set to use copy's datapath media agents*/
	IF object_id('tempdb.dbo.#tmpMPCopySetErrorCode') IS NULL
		CREATE TABLE #tmpMPCopySetErrorCode
		(
			MountPathId			INT,
			MediaSideId			INT,
			copyId				INT,
			errorCode			INT
			PRIMARY KEY (MountPathId, copyId)
		)
	--ELSE
		--Caller has created the table, just set error code if any
	IF object_id('tempdb.dbo.#tmpVolume') IS NOT NULL DROP TABLE #tmpVolume
	CREATE TABLE #tmpVolume
	(
		VolumeId	INT,
		MediaSideId	INT,
		errorCode	INT,
		isDedupe	BIT,
		copyId		INT
		PRIMARY KEY (VolumeId)
	)
	IF object_id('tempdb.dbo.#tmpDeletedAF') IS NOT NULL DROP TABLE #tmpDeletedAF
	CREATE TABLE #tmpDeletedAF
	(
		SIDBStoreId	INT,
		MountPathId	INT,
		VolumeId	INT,
		archChunkId	INT,
		archFileId	INT,
		errorCode	INT
	)
	CREATE CLUSTERED INDEX tmpDeletedAF_SIDBStoreId_MountPathId_VolumeId_archChunkId_archFileId_Idx ON #tmpDeletedAF (SIDBStoreId, MountPathId, VolumeId, archChunkId, archFileId);
	IF object_id('tempdb.dbo.#tmpStore') IS NOT NULL DROP TABLE #tmpStore
	CREATE TABLE #tmpStore
	(
		SIDBStoreId	INT,
		errorCode	INT
		PRIMARY KEY (SIDBStoreId)
	)
	IF OBJECT_ID('tempdb..#MMMountPathPrunerView') IS NOT NULL DROP TABLE #MMMountPathPrunerView
	SELECT * INTO #MMMountPathPrunerView
	FROM MMMountPathPrunerView
	IF NOT EXISTS(SELECT 1 FROM #tmpMPSetErrorCode) --If caller already has list of mount paths to process do not populate here
	BEGIN
		IF @i_MountPathId > 0
		BEGIN
			INSERT INTO #tmpMPSetErrorCode
			SELECT	@i_MountPathId, MediaSideId, 0
			FROM	MMMountPath WITH (READUNCOMMITTED)
			WHERE	MountPathId = @i_MountPathId
			INSERT INTO #tmpVolume
			SELECT 	MV.VolumeId, MV.MediaSideId, FailureErrorCode, (CASE WHEN SIDBStoreId > 0 THEN 1 ELSE 0 END), ISNULL(AST.archGroupCopyId, 0)
			FROM	MMVolume MV WITH (READUNCOMMITTED)
					INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MP.MediaSideId = MV.MediaSideId
					LEFT OUTER JOIN ArchStream AST WITH (READUNCOMMITTED) ON MV.mediaGroupId = AST.mediaGroupId
			WHERE	MP.MountPathId = @i_MountPathId AND MV.VolumeFlags = 6
		END
		ELSE
		BEGIN
			INSERT INTO #tmpVolume
			SELECT	MV.VolumeId, MV.MediaSideId, FailureErrorCode, (CASE WHEN SIDBStoreId > 0 THEN 1 ELSE 0 END), ISNULL(AST.archGroupCopyId, 0)
			FROM	MMVolume MV WITH (READUNCOMMITTED)
			LEFT OUTER JOIN ArchStream AST WITH (READUNCOMMITTED) ON MV.mediaGroupId = AST.mediaGroupId
			WHERE	MV.VolumeFlags = 6
			INSERT INTO #tmpMPSetErrorCode
			SELECT	MP.MountPathId, MP.MediaSideId, 0
			FROM	( 	SELECT DISTINCT MountPathId
						FROM 	MMDeletedAF WITH (READUNCOMMITTED)
					) AF
					INNER JOIN	MMMountPath MP WITH (READUNCOMMITTED) ON MP.MountPathId = AF.MountPathId
			WHERE	MP.MountPathId > 0
			UNION
			SELECT	MP.MountPathId, MP.MediaSideId, 0
			FROM	( 	SELECT DISTINCT MediaSideId
						FROM 	#tmpVolume
					) TV
					INNER JOIN	MMMountPath MP WITH (READUNCOMMITTED) ON MP.MediaSideId = TV.MediaSideId
			WHERE	MP.MountPathId > 0
		END
		/*Get copy mapping with mount path, only for the mount paths enabled to use datapath MAs for pruning*/
IF EXISTS(SELECT 1 FROM MMMountPath WITH (READUNCOMMITTED) WHERE Attribute & 256 > 0)
		BEGIN
			INSERT INTO #tmpMPCopySetErrorCode
			SELECT DISTINCT T.MountPathId, T.MediaSideId, V.copyId, 0
			FROM #tmpMPSetErrorCode T INNER JOIN MMMountPath MP WITH (READUNCOMMITTED)
			ON T.MountPathId = MP.MountPathId
			INNER JOIN #tmpVolume V ON T.mediaSideId = V.mediaSideId
WHERE MP.Attribute & 256 > 0 AND V.copyId > 0
			INSERT INTO #tmpMPCopySetErrorCode
			SELECT DISTINCT T.MountPathId, T.MediaSideId, DAF.copyId, 0
			FROM #tmpMPSetErrorCode T INNER JOIN MMMountPath MP WITH (READUNCOMMITTED)
			ON T.MountPathId = MP.MountPathId
			INNER JOIN MMDeletedAF DAF WITH (READUNCOMMITTED) ON T.mountPathId = DAF.mountPathId
WHERE MP.Attribute & 256 > 0 AND DAF.copyId > 0
			AND NOT EXISTS (SELECT 1 FROM #tmpMPCopySetErrorCode T1 WHERE T1.mountPathId = T.mountPathId AND T1.copyId = DAF.copyId)
			/*If the copy doesn't exist any more, datapath MA requirement for pruning won't apply, so process these for errors only if the copy is still valid*/
			DELETE #tmpMPCopySetErrorCode
			WHERE NOT EXISTS(SELECT 1 FROM ArchGroupCopy WITH(NOLOCK) WHERE id = #tmpMPCopySetErrorCode.copyId)
		END
	END
	/*Consider mount path level errors and problems first*/
	UPDATE	#tmpMPSetErrorCode
	SET		errorCode = CASE
WHEN MP.MPEnabled = 0 THEN 65105
							WHEN MP.MPOffline = 1 THEN 	CASE
WHEN MP.MPOfflineReason = 1 /*MOUNTPATH_NOT_ACCESIBLE*/ THEN 65107
WHEN MP.MPOfflineReason = 3 /**MOUNTPATH_DIRTY*/ THEN 65108
ELSE 65109
														END
WHEN MP.PruningEnabled = 0 THEN 65123
WHEN (MP.MountPathTypeId = 7 AND CloudDDBPruningEnabled = 0) THEN 65125
							ELSE errorCode
						END
	FROM	#MMMountPathPrunerView MP
	WHERE	#tmpMPSetErrorCode.MountPathId = MP.MountPathId
	/*
	If there is no problem at mount path level then set the error codes below for
	1) MA Pruning Opwindow restriction
	2) No controllers with required accesstype
	3) No online controllers
	Following 3 queries are written in such a way to overwrite error codes one after the other.
	*/
	/*Check all the conditions including online check, access type check and pruning op check here*/
	UPDATE #tmpMPSetErrorCode
SET errorCode = 65128
	WHERE NOT EXISTS (SELECT 1 FROM #MMMountPathPrunerView MPV WHERE MPV.mountPathId = #tmpMPSetErrorCode.mountPathId
	AND HostOnline = 1 AND DeviceControllerEnabled = 1 AND DeviceAccessible = 1 AND HasPruneAccessType = 1 AND PruningOpAllowed = 1)
AND errorCode NOT IN (65107, 65108, 65109,
65105, 65123)
	/*Remove PruningOpAllowed = 1 check in below query so that we overwrite error code as access problem*/
	UPDATE #tmpMPSetErrorCode
SET errorCode = 65126
	WHERE NOT EXISTS (SELECT 1 FROM #MMMountPathPrunerView MPV WHERE MPV.mountPathId = #tmpMPSetErrorCode.mountPathId
	AND HostOnline = 1 AND DeviceControllerEnabled = 1 AND DeviceAccessible = 1 AND HasPruneAccessType = 1)
AND errorCode NOT IN (65107, 65108, 65109,
65105, 65123)
	/*Remove HasPruneAccessType = 1 check in below query so that we overwrite error code as device controller offline*/
	UPDATE #tmpMPSetErrorCode
SET errorCode = 65106
	WHERE NOT EXISTS (SELECT 1 FROM #MMMountPathPrunerView MPV WHERE MPV.mountPathId = #tmpMPSetErrorCode.mountPathId
	AND HostOnline = 1 AND DeviceControllerEnabled = 1 AND DeviceAccessible = 1)
AND errorCode NOT IN (65107, 65108, 65109,
65105, 65123)
	/*
	If the device controllers that can prune this mount path are not in datapath, set copy specific error code.
	Do this only if we don't have mount path level error code set already -
	meaning we set this error code only if mount path is online and has at least one device controller that can prune data.
	*/
	UPDATE #tmpMPCopySetErrorCode
SET errorCode = 65132
	WHERE NOT EXISTS (SELECT 1 FROM MMDataPath DP WITH(READUNCOMMITTED) INNER JOIN MMDrivePool DPOOL WITH(NOLOCK) ON DP.drivePoolId = DPOOL.drivePoolId
	INNER JOIN #MMMountPathPrunerView MPV ON DPOOL.masterPoolId = MPV.masterPoolId AND DPOOL.clientId = MPV.HostClientId
WHERE MPV.mountPathId = #tmpMPCopySetErrorCode.mountPathId AND DP.CopyId = #tmpMPCopySetErrorCode.copyId AND DP.flag & 4 = 4
	AND MPV.HostOnline = 1 AND MPV.DeviceControllerEnabled = 1 AND MPV.DeviceAccessible = 1 AND MPV.HasPruneAccessType = 1 AND MPV.PruningOpAllowed = 1)
	AND NOT EXISTS (SELECT 1 FROM #tmpMPSetErrorCode T WHERE T.mountPathId = #tmpMPCopySetErrorCode.mountPathId AND T.errorCode > 0)
	AND errorCode = 0
	/*
	Set error code if cloud mount path has ddb pruning enabled but there is no dedicated cloud pruner device controller set
	*/
UPDATE #tmpMPSetErrorCode SET errorCode =  65127
	WHERE EXISTS (SELECT 1 FROM #MMMountPathPrunerView MPV WHERE MPV.mountPathId = #tmpMPSetErrorCode.mountPathId
	AND MPV.mountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/ AND MPV.CloudDDBPruningEnabled = 1 AND MPV.UseDatapathMAForPruning = 0)
AND NOT EXISTS (SELECT 1 FROM #MMMountPathPrunerView MPV WHERE MPV.mountPathId = #tmpMPSetErrorCode.mountPathId AND DeviceControllerFlags & 1 > 0)
	AND errorCode = 0
	/*
	Set error code if cloud mount path has ddb pruning enabled, dedicated cloud pruner set but the pruner controller has no access or not online
	*/
UPDATE #tmpMPSetErrorCode SET errorCode =  65134
	WHERE EXISTS (SELECT 1 FROM #MMMountPathPrunerView MPV WHERE MPV.mountPathId = #tmpMPSetErrorCode.mountPathId
	AND MPV.mountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/ AND MPV.CloudDDBPruningEnabled = 1 AND MPV.UseDatapathMAForPruning = 0)
AND NOT EXISTS (SELECT 1 FROM #MMMountPathPrunerView MPV WHERE MPV.mountPathId = #tmpMPSetErrorCode.mountPathId AND DeviceControllerFlags & 1 > 0
	AND HostOnline = 1 AND DeviceControllerEnabled = 1 AND DeviceAccessible = 1 AND HasPruneAccessType = 1 AND PruningOpAllowed = 1)
	AND errorCode = 0
	/*Set error code if cloud mount path has ddb pruning enabled and option to use datapath MA for pruning enabled but there is no dedicated pruner flag set on datapath.
	Do this only if we don't have mount path level error code set already -
	meaning we set this error code only if mount path is online and has at least one device controller that can prune data.
	*/
	UPDATE #tmpMPCopySetErrorCode
SET errorCode = 65133
	WHERE EXISTS (SELECT 1 FROM #MMMountPathPrunerView MPV WHERE MPV.mountPathId = #tmpMPCopySetErrorCode.mountPathId
	AND MPV.mountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/ AND MPV.CloudDDBPruningEnabled = 1 AND MPV.UseDatapathMAForPruning = 1)
	AND NOT EXISTS (SELECT 1 FROM MMDataPath DP WITH(READUNCOMMITTED) INNER JOIN MMDrivePool DPOOL WITH(NOLOCK) ON DP.drivePoolId = DPOOL.drivePoolId
	INNER JOIN #MMMountPathPrunerView MPV ON DPOOL.masterPoolId = MPV.masterPoolId
WHERE MPV.mountPathId = #tmpMPCopySetErrorCode.mountPathId AND DP.CopyId = #tmpMPCopySetErrorCode.copyId AND DP.flag & 64 = 64)
	AND NOT EXISTS (SELECT 1 FROM #tmpMPSetErrorCode T WHERE T.mountPathId = #tmpMPCopySetErrorCode.mountPathId AND T.errorCode > 0)
	AND errorCode = 0
	/*
	Set error code if cloud mount path has ddb pruning enabled and option to use datapath MA for pruning enabled,
	there is a dedicated pruner flag set on datapath but this datapath is disabled or does not have access to the mount path.
	Do this only if we don't have mount path level error code set already -
	meaning we set this error code only if mount path is online and has at least one device controller that can prune data.
	*/
	UPDATE #tmpMPCopySetErrorCode
SET errorCode = 65134
	WHERE EXISTS (SELECT 1 FROM #MMMountPathPrunerView MPV WHERE MPV.mountPathId = #tmpMPCopySetErrorCode.mountPathId
	AND MPV.mountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/ AND MPV.CloudDDBPruningEnabled = 1 AND MPV.UseDatapathMAForPruning = 1)
	AND NOT EXISTS (SELECT 1 FROM MMDataPath DP WITH(READUNCOMMITTED) INNER JOIN MMDrivePool DPOOL WITH(NOLOCK) ON DP.drivePoolId = DPOOL.drivePoolId
	INNER JOIN #MMMountPathPrunerView MPV ON DPOOL.masterPoolId = MPV.masterPoolId  AND DPOOL.clientId = MPV.HostClientId
WHERE MPV.mountPathId = #tmpMPCopySetErrorCode.mountPathId AND DP.CopyId = #tmpMPCopySetErrorCode.copyId AND DP.flag & (4 | 64) = (4 | 64)
	AND MPV.HostOnline = 1 AND MPV.DeviceControllerEnabled = 1 AND MPV.DeviceAccessible = 1 AND MPV.HasPruneAccessType = 1 AND MPV.PruningOpAllowed = 1)
	AND NOT EXISTS (SELECT 1 FROM #tmpMPSetErrorCode T WHERE T.mountPathId = #tmpMPCopySetErrorCode.mountPathId AND T.errorCode > 0)
	AND errorCode = 0
IF(@i_flags & 1 > 0)
		GOTO PROC_EXIT
	-- Hybrid cloud library has cache mountpath
	UPDATE 	TV
SET 	TV.errorCode = 65130
	FROM 	#tmpVolume TV
			INNER JOIN MMMountPathOnlineStatus MPO WITH (READUNCOMMITTED) ON MPO.MediaSideId = TV.MediaSideId
AND (MPO.MPAttribute & 2048) > 0
																			AND MPO.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
			INNER JOIN MMCloudVolCacheMountPath MPC WITH (READUNCOMMITTED) ON MPC.volumeId = TV.VolumeId
			LEFT OUTER JOIN MMMountPathOnlineStatus MPO1 WITH (READUNCOMMITTED) ON MPO1.MountPathId = MPC.cacheMountPathId
	WHERE 	MPO1.MountPathId IS NULL
	-- Recycleable non-deduep volumes will be removed from MMDeletedAF table.
	-- clear Failure error code for dedupe volumes in MMvolume table
	-- Set MP disabled failure error code for dedupe volumes in MMvolume table
	UPDATE 	TV
	SET		TV.errorCode = TE.errorCode
	FROM	#tmpVolume TV
			INNER JOIN #tmpMPSetErrorCode TE ON TV.MediaSideId = TE.MediaSideId
	WHERE	TV.errorCode <> TE.errorCode
			AND (	TE.errorCode <> 0
					OR 	TV.isDedupe = 1
					OR 	(TV.errorCode BETWEEN 65105 AND 65134))
	--If we have a copy specific error code if mountpath is configured to use dapath MA for pruning, set it.
	IF EXISTS(SELECT 1 FROM #tmpMPCopySetErrorCode WHERE errorCode > 0)
		UPDATE 	TV
		SET		TV.errorCode = TE.errorCode
		FROM	#tmpVolume TV
				INNER JOIN #tmpMPCopySetErrorCode TE ON TV.MediaSideId = TE.MediaSideId AND TV.copyId = TE.copyId
		WHERE	TV.errorCode <> TE.errorCode AND TE.errorCode <> 0
	DECLARE @rowCount INT = 1
	DECLARE @batchSize INT = 500000
	DECLARE @batchNum INT = 0
	WHILE @rowCount > 0
	BEGIN
		UPDATE 	MV
		SET		MV.FailureErrorCode = TV.errorCode
		FROM 	MMVolume MV
				INNER JOIN (	SELECT	VolumeId, errorCode
								FROM	#tmpVolume
								ORDER BY VolumeId
								OFFSET (@batchSize * @batchNum) ROWS
								FETCH NEXT (@batchSize) ROWS ONLY
							)TV ON TV.VolumeId = MV.VolumeId
		SET @rowCount = @@ROWCOUNT
		SET @batchNum +=1
	END
	IF OBJECT_ID('tempdb..#tmpVolume') IS NOT NULL DROP TABLE #tmpVolume
	INSERT INTO #tmpDeletedAF
SELECT 	AF.SIDBStoreId, AF.MountPathId, AF.VolumeId, AF.archChunkId, AF.archFileId, 65129
	FROM 	MMDeletedAF AF WITH (READUNCOMMITTED)
			INNER JOIN IdxSIDBSubStore SUBSTORE WITH (READUNCOMMITTED) ON AF.SIDBStoreId = SUBSTORE.SIDBStoreId
			INNER JOIN APP_Client DDBMA WITH (READUNCOMMITTED) ON SUBSTORE.ClientId = DDBMA.id
			INNER JOIN APP_Client DATAMA WITH (READUNCOMMITTED) ON AF.reserveInt = DATAMA.id
WHERE 	(	(DDBMA.releaseId = 14 AND DATAMA.releaseId >=16)
OR (DATAMA.releaseId = 14 AND DDBMA.releaseId >= 16))
			AND FailureErrorCode IN (-1, -7)
	SET @batchSize = 500000
	SET @rowCount = 1
	SET @batchNum = 0
	WHILE @rowCount > 0
	BEGIN
		UPDATE 	AF
		SET		AF.FailureErrorCode = TF.errorCode
		FROM 	MMDeletedAF AF
				INNER JOIN (	SELECT	SIDBStoreId, MountPathId, VolumeId, archChunkId, archFileId, errorCode
								FROM	#tmpDeletedAF
								ORDER BY SIDBStoreId, MountPathId, VolumeId, archChunkId, archFileId
								OFFSET (@batchSize * @batchNum) ROWS
								FETCH NEXT (@batchSize) ROWS ONLY
							)TF ON AF.SIDBStoreId = TF.SIDBStoreId AND AF.MountPathId = TF.MountPathId AND AF.VolumeId = TF.VolumeId AND AF.ArchChunkId = TF.archChunkId AND AF.archFileId = TF.archFileId
		SET @rowCount = @@ROWCOUNT
		SET @batchNum +=1
	END
	TRUNCATE TABLE #tmpDeletedAF
	INSERT INTO #tmpStore
	VALUES (0, 0)
	INSERT INTO #tmpStore
	SELECT 	STORE.SIDBStoreId,
			CASE
				WHEN STORE.CommCellId <> 2
THEN 65110
				WHEN STORE.Status = 1
THEN 65112
WHEN STORE.flags & 2097152 > 0 AND STORE.flags & 128 = 0
THEN 65120
WHEN STORE.flags & 536870912 = 0
THEN 65124
				ELSE 0
			END
	FROM 	IdxSIDBStore STORE WITH (READUNCOMMITTED)
	WHERE 	STORE.SIDBStoreId > 0
	UPDATE 	TS
	SET 	TS.errorCode = 	CASE
WHEN (SUBSTORE.Status = 1) THEN 65121
ELSE 65122
							END
	FROM 	#tmpStore TS
			INNER JOIN IdxSIDBSubStore SUBSTORE WITH (READUNCOMMITTED) ON TS.SIDBStoreId = SUBSTORE.SIDBStoreId
			INNER JOIN MMHost HOST WITH (READUNCOMMITTED) ON SUBSTORE.ClientId = HOST.clientId
	WHERE 	TS.errorCode = 0 AND TS.SIDBStoreId <> 0
			AND (SUBSTORE.Status = 1 OR HOST.MmHostSoftState = 0 OR HOST.MmHostEnabled = 0)
	INSERT INTO #tmpDeletedAF
	SELECT 	AF.SIDBStoreId, AF.MountPathId, AF.VolumeId, AF.archChunkId, AF.archFileId, (CASE WHEN TS.errorCode > 0 THEN TS.errorCode WHEN (TCE.errorCode IS NOT NULL AND TCE.errorCode > 0) THEN TCE.errorCode ELSE TE.errorCode END)
	FROM 	MMDeletedAF AF WITH (READUNCOMMITTED)
			INNER JOIN #tmpMPSetErrorCode TE ON AF.MountPathId = TE.MountPathId
			INNER JOIN #tmpStore TS ON TS.SIDBStoreId = AF.SIDBStoreId
			LEFT OUTER JOIN #tmpMPCopySetErrorCode TCE ON AF.mountPathId = TCE.mountPathId AND AF.copyId = TCE.copyId AND TCE.errorCode > 0
	WHERE	TE.errorCode <> 0  OR TS.errorCode <> 0 OR (TCE.errorCode IS NOT NULL AND TCE.errorCode > 0)
OR ((FailureErrorCode BETWEEN 65105 AND 65134) AND FailureErrorCode <> 65129)
	IF OBJECT_ID('tempdb..#tmpMPSetErrorCode') IS NOT NULL DROP TABLE #tmpMPSetErrorCode
	IF OBJECT_ID('tempdb..#tmpMPCopySetErrorCode') IS NOT NULL DROP TABLE #tmpMPCopySetErrorCode
	IF OBJECT_ID('tempdb..#tmpStore') IS NOT NULL DROP TABLE #tmpStore
	SET @rowCount = 1
	SET @batchNum = 0
	WHILE @rowCount > 0
	BEGIN
		UPDATE 	AF
		SET		AF.FailureErrorCode = TF.errorCode
		FROM 	MMDeletedAF AF
				INNER JOIN (	SELECT	SIDBStoreId, MountPathId, VolumeId, archChunkId, archFileId, errorCode
								FROM	#tmpDeletedAF
								ORDER BY SIDBStoreId, MountPathId, VolumeId, archChunkId, archFileId
								OFFSET (@batchSize * @batchNum) ROWS
								FETCH NEXT (@batchSize) ROWS ONLY
							)TF ON AF.SIDBStoreId = TF.SIDBStoreId AND AF.MountPathId = TF.MountPathId AND AF.VolumeId = TF.VolumeId AND AF.ArchChunkId = TF.archChunkId AND AF.archFileId = TF.archFileId
		SET @rowCount = @@ROWCOUNT
		SET @batchNum +=1
	END
	TRUNCATE TABLE #tmpDeletedAF
	INSERT INTO #tmpDeletedAF
SELECT 	AF.SIDBStoreId, AF.MountPathId, AF.VolumeId, AF.archChunkId, AF.archFileId, 65130
	FROM 	MMDeletedAF AF WITH (READUNCOMMITTED)
			INNER JOIN MMMountPathOnlineStatus MPO WITH (READUNCOMMITTED) ON MPO.MountPathId = AF.MountPathId
AND (MPO.MPAttribute & 2048) > 0
																			AND MPO.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
			INNER JOIN MMCloudVolCacheMountPath MPC WITH (READUNCOMMITTED) ON MPC.volumeId = AF.VolumeId AND AF.volumeId > 0
			LEFT OUTER JOIN MMMountPathOnlineStatus MPO1 WITH (READUNCOMMITTED) ON MPO1.MountPathId = MPC.cacheMountPathId
	WHERE 	MPO1.MountPathId IS NULL
	SET @rowCount = 1
	SET @batchNum = 0
	WHILE @rowCount > 0
	BEGIN
		UPDATE 	AF
		SET		AF.FailureErrorCode = TF.errorCode
		FROM 	MMDeletedAF AF
				INNER JOIN (	SELECT	SIDBStoreId, MountPathId, VolumeId, archChunkId, archFileId, errorCode
								FROM	#tmpDeletedAF
								ORDER BY SIDBStoreId, MountPathId, VolumeId, archChunkId, archFileId
								OFFSET (@batchSize * @batchNum) ROWS
								FETCH NEXT (@batchSize) ROWS ONLY
							)TF ON AF.SIDBStoreId = TF.SIDBStoreId AND AF.MountPathId = TF.MountPathId AND AF.VolumeId = TF.VolumeId AND AF.ArchChunkId = TF.archChunkId AND AF.archFileId = TF.archFileId
		SET @rowCount = @@ROWCOUNT
		SET @batchNum +=1
	END
PROC_EXIT:
	/*
	DO NOT drop #tmpMPSetErrorCode and #tmpMPCopySetErrorCode here. There is a caller stored proc that wants results from this.
	For the case when there is no caller stored proc there are drop table statements above to drop those tables.
	*/
	IF OBJECT_ID('tempdb..#tmpVolume') IS NOT NULL DROP TABLE #tmpVolume
	IF OBJECT_ID('tempdb..#tmpDeletedAF') IS NOT NULL DROP TABLE #tmpDeletedAF
	IF OBJECT_ID('tempdb..#tmpStore') IS NOT NULL DROP TABLE #tmpStore
	IF OBJECT_ID('tempdb..#MMMountPathPrunerView') IS NOT NULL DROP TABLE #MMMountPathPrunerView
	IF OBJECT_ID('tempdb..#tblOutMMSetErrorCodeForPruningFailures') IS NOT NULL
		INSERT INTO #tblOutMMSetErrorCodeForPruningFailures
		SELECT 0, ''
	ELSE
		SELECT 0, ''
GO

IF EXISTS (select * from GxQscripts where name = 'MMSetErrorCodeForPruningFailures')
	delete from GxQscripts where name = 'MMSetErrorCodeForPruningFailures'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSetErrorCodeForPruningFailures')
	delete from GXDBVersions where aliasname = 'MMSetErrorCodeForPruningFailures'
GO

insert into GXDBVersions values(2, 'MMSetErrorCodeForPruningFailures',  '00010013000200110000', 'MMSetErrorCodeForPruningFailures', '00010013000200110000')
GO

