

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSetEntityAction.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSetEntityAction.sp,v $ $Id: MMSetEntityAction.sp,v 1.1.2.6 2018/06/21 03:46:16 rsivadas Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSetEntityAction <<<'

IF EXISTS (select * from sysobjects where name='MMSetEntityAction')
	drop procedure MMSetEntityAction
IF EXISTS (select * from GxQscripts where name='MMSetEntityAction')
	delete from GxQscripts where name = 'MMSetEntityAction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSetEntityAction')
	delete from GXDBVersions where aliasname = 'MMSetEntityAction'
GO
print '... Creating Procedure: MMSetEntityAction'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSetEntityAction
  @EntityId INT,
  @EntityType INT,
  @OperationType INT,
  @EnableTimeZone INT,
  @UNCEnableTime INT
AS
  DECLARE @o_oldTime VARCHAR(255)	= ''
  DECLARE @o_oldTimeZone varchar(255)	= ''
  DECLARE @o_newTime VARCHAR(255)	= ''
  DECLARE @o_newTimeZone varchar(255)	= ''
  DECLARE @o_errorCode INT				= 0
  DECLARE @o_errorMsg VARCHAR(2048)	= ''
SET NOCOUNT ON
BEGIN TRANSACTION;
DECLARE @OldEnableTimeZone 	INT = 0
DECLARE @OldEnableTime	 	INT = 0
DECLARE	@EnableTime		INT = 0
DECLARE @InsertValue		INT = 0
BEGIN TRY
	SELECT @OldEnableTime = EnableTime, @OldEnableTimeZone = EnableTimeZone
	FROM MMEntityAction WITH(READUNCOMMITTED)
	WHERE EntityId = @EntityId
	AND EntityType = @EntityType
	AND OperationType = @OperationType
	SET @InsertValue = @@ROWCOUNT
	IF NOT (@OldEnableTime = 0 OR @OldEnableTimeZone = 0)
	BEGIN
		SET @o_oldTime = CONVERT(VARCHAR,  dbo.getdatetime(@OldEnableTime), 0)
		SELECT @o_oldTimeZone = TimeZoneStdName FROM SchedTimeZone WITH(READUNCOMMITTED) WHERE TimeZoneID = @OldEnableTimeZone
	END
	IF @EnableTimeZone = 0 OR @UNCEnableTime = 0
	BEGIN
		DELETE FROM MMEntityAction
		WHERE EntityId = @EntityId
		AND EntityType = @EntityType
		AND OperationType = @OperationType
	END
	ELSE
	BEGIN
		SELECT @o_newTimeZone = TimeZoneStdName FROM SchedTimeZone WITH(READUNCOMMITTED) WHERE TimeZoneID = @EnableTimeZone
		SET @EnableTime = dbo.getunixtime(dbo.UTCToLocalTime(dbo.getdatetime(@UNCEnableTime), @o_newTimeZone))
		SET @o_newTime = CONVERT(VARCHAR,  dbo.getdatetime(@EnableTime), 0)
		IF @InsertValue = 0
		BEGIN
			INSERT INTO MMEntityAction(EntityId, EntityType, OperationType, EnableTimeZone, EnableTime, UNCEnableTime)
			VALUES (@EntityId, @EntityType, @OperationType, @EnableTimeZone, @EnableTime, @UNCEnableTime)
		END
		ELSE IF @OldEnableTime <> @EnableTime OR @OldEnableTimeZone <> @EnableTimeZone
		BEGIN
			UPDATE MMEntityAction
			SET EnableTimeZone = @EnableTimeZone, EnableTime = @EnableTime, UNCEnableTime = @UNCEnableTime
			WHERE EntityId = @EntityId
			AND EntityType = @EntityType
			AND OperationType = @OperationType
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @o_errorCode	= ERROR_NUMBER()
    SET @o_errorMsg		= ERROR_MESSAGE()
END CATCH
PROC_EXIT:
IF @o_errorCode <> 0
BEGIN
    ROLLBACK TRANSACTION
END
ELSE
BEGIN
    COMMIT TRANSACTION
END
SELECT 	@o_oldTime		AS oldTime,
		@o_oldTimeZone	AS oldTimeZone,
		@o_newTime		AS newTime,
		@o_newTimeZone	AS newTimeZone,
		@o_errorCode 	AS errorCode,
		@o_errorMsg 	AS errorString;
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'MMSetEntityAction')
	delete from GxQscripts where name = 'MMSetEntityAction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSetEntityAction')
	delete from GXDBVersions where aliasname = 'MMSetEntityAction'
GO

insert into GXDBVersions values(2, 'MMSetEntityAction',  '00010001000200060000', 'MMSetEntityAction', '00010001000200060000')
GO

