

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSetCGConfigOnMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMSetCGConfigOnMA"               	|
--  |       Author	    :	ksanghvi                            		|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    			|
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSetCGConfigOnMA <<<'

IF EXISTS (select * from sysobjects where name='MMSetCGConfigOnMA')
	drop procedure MMSetCGConfigOnMA
IF EXISTS (select * from GxQscripts where name='MMSetCGConfigOnMA')
	delete from GxQscripts where name = 'MMSetCGConfigOnMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSetCGConfigOnMA')
	delete from GXDBVersions where aliasname = 'MMSetCGConfigOnMA'
GO
print '... Creating Procedure: MMSetCGConfigOnMA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMSetCGConfigOnMA
  @i_mediaAgentID INT
AS
  DECLARE @o_errorCode INT
  DECLARE @o_errorMessage NVARCHAR(MAX)
DECLARE @vClientID 		    INT = 0
DECLARE @enablePowerMgmt 	INT = 0
DECLARE @repClientGroupId   INT = 0
DECLARE @errorMessage		NVARCHAR(MAX) = N''
DECLARE @errorCode          INT = 0
SELECT @vClientID = ControllerNode FROM MMPowerMgmtHost WITH (NOLOCK) WHERE HostId = @i_mediaAgentID
-- Check if the MediaAgent is not part of any ClientGroup
IF NOT EXISTS(SELECT 1 FROM APP_ClientGroupAssoc WITH (NOLOCK)
                WHERE clientId = @i_mediaAgentID)
    BEGIN
        SET @enablePowerMgmt = 0
        SET @vClientID = 0
        GOTO RECONFIGURE_MEDIA_AGENT
    END
-- Check if MediaAgent has a common CloudController with any other ClientGroup on which power mgmt is enabled
SELECT TOP 1 @repClientGroupId = ACGA.clientGroupId FROM APP_ClientGroupAssoc AS ACGA WITH (NOLOCK)
INNER JOIN MMPowerMgmtHost AS MPH WITH (NOLOCK) ON ACGA.clientId = MPH.HostId
INNER JOIN APP_ComponentProp AS ACPR WITH (NOLOCK) ON ACGA.clientGroupId = ACPR.componentId AND CAST(ACPR.longVal AS INTEGER) = @vClientID AND ACPR.componentType = 8 AND ACPR.modified = 0 AND ACPR.propertyTypeId = 3502
INNER JOIN APP_ComponentProp AS ACPS WITH (NOLOCK) ON ACPS.componentId = ACPR.componentId AND ACPS.componentType = 8 AND ACPS.modified = 0 AND ACPS.propertyTypeId = 3501 AND ACPS.longVal = 1
WHERE ACGA.clientId = @i_mediaAgentID
IF (@@ERROR <> 0)
    BEGIN
        SET @errorCode 		= @@ERROR
        SET @errorMessage	= 'Query Failed'
        GOTO QUIT_WITH_ROLLBACK
    END
IF @repClientGroupId <> 0
BEGIN
    SET @enablePowerMgmt = 1
    GOTO RECONFIGURE_MEDIA_AGENT
END
SET @vClientID = 0
-- Select random client group which does not have same cloud controller as current media agent but power management is enabled on it
SELECT TOP 1 @vClientID = ACPR.longVal, @repClientGroupId = ACPR.componentId FROM APP_ClientGroupAssoc AS ACGA WITH (NOLOCK)
INNER JOIN APP_ComponentProp AS ACPR WITH (NOLOCK) ON ACPR.componentId = ACGA.clientGroupId AND ACPR.componentType = 8 AND ACPR.modified = 0 AND ACPR.propertyTypeId = 3502
INNER JOIN APP_ComponentProp AS ACPS WITH (NOLOCK) ON ACPS.componentId = ACPR.componentId AND ACPS.componentType = 8 AND ACPS.modified = 0 AND ACPS.propertyTypeId = 3501 AND ACPS.longVal = 1
WHERE ACGA.clientId = @i_mediaAgentID
IF @vClientID <> 0
BEGIN
    SET @enablePowerMgmt = 1
END
RECONFIGURE_MEDIA_AGENT:
BEGIN TRANSACTION
UPDATE MMHost SET Attribute =	CASE
                                    WHEN (@enablePowerMgmt = 1)
THEN (Attribute | 32768)
ELSE (Attribute & ~32768)
                                END
WHERE ClientId = @i_mediaAgentID
IF (@@ERROR <> 0)
    BEGIN
        SET @errorCode 		= @@ERROR
        SET @errorMessage	= 'Failed to update MMHost table'
        GOTO QUIT_WITH_ROLLBACK
    END
IF EXISTS(SELECT 1 FROM MMPowerMgmtHost WITH (NOLOCK) WHERE HostId = @i_mediaAgentID)
BEGIN
UPDATE MMPowerMgmtHost SET isEnabled = @enablePowerMgmt, ControllerNode = @vClientID, Flags = Flags & ~1024, ClientGroupId = @repClientGroupId
	WHERE HostId = @i_mediaAgentID
END
ELSE
BEGIN
	DECLARE @HostSoftState INTEGER = 0
	DECLARE @PowerStatus INTEGER = 0
	SELECT @HostSoftState = MmHostSoftState FROM MMHost WITH (NOLOCK) WHERE ClientId = @i_mediaAgentID
	IF @HostSoftState = 0
SET @PowerStatus = 5
	ELSE
SET @PowerStatus = 3
	INSERT INTO MMPowerMgmtHost (HostId, isEnabled, LastPowerMgmtUpdateTime, ControllerNode, PowerStatus, Flags, NoPowerOff, LastAccessTime, UseCountForIndexServer, FailedPowerOperation, FailureReason, ClientGroupId, PowerStateTransitTime)
	SELECT @i_mediaAgentID, @enablePowerMgmt, dbo.GetUnixTime(GETUTCDATE()), @vClientID, @PowerStatus, 0, 0, dbo.GetUnixTime(GETUTCDATE()), 0, 0, NULL, @repClientGroupId, 0
END
IF (@@ERROR <> 0)
    BEGIN
        SET @errorCode 		= @@ERROR
        SET @errorMessage	= 'Failed to update MMPowerMgmtHost table'
        GOTO QUIT_WITH_ROLLBACK
    END
COMMIT TRANSACTION
GOTO ERROR_EXIT
QUIT_WITH_ROLLBACK:
	IF ( @@TRANCOUNT > 0 ) ROLLBACK TRANSACTION
    GOTO ERROR_EXIT
ERROR_EXIT:
    SELECT @errorCode,@errorMessage
GO

IF EXISTS (select * from GxQscripts where name = 'MMSetCGConfigOnMA')
	delete from GxQscripts where name = 'MMSetCGConfigOnMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSetCGConfigOnMA')
	delete from GXDBVersions where aliasname = 'MMSetCGConfigOnMA'
GO

insert into GXDBVersions values(2, 'MMSetCGConfigOnMA',  '00000000000000000000', 'MMSetCGConfigOnMA', '00000000000000000000')
GO

