

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSendPowerONReqForScheduleJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSendPowerONReqForScheduleJobs.sp,v $ $Id: MMSendPowerONReqForScheduleJobs.sp,v 1.1.2.6 2018/03/20 00:05:31 jiechen Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMSendPowerONReqForScheduleJobs"         |
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
/*
	This will return the list of VMs need to be power on.
	Request status should be in WAITING_TO_VM_POWER_ON or if VM_POWERING_ON and still not powered on more than 5 mins
	If reach max retry count then should not send power on request
*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSendPowerONReqForScheduleJobs <<<'

IF EXISTS (select * from sysobjects where name='MMSendPowerONReqForScheduleJobs')
	drop procedure MMSendPowerONReqForScheduleJobs
IF EXISTS (select * from GxQscripts where name='MMSendPowerONReqForScheduleJobs')
	delete from GxQscripts where name = 'MMSendPowerONReqForScheduleJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSendPowerONReqForScheduleJobs')
	delete from GXDBVersions where aliasname = 'MMSendPowerONReqForScheduleJobs'
GO
print '... Creating Procedure: MMSendPowerONReqForScheduleJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSendPowerONReqForScheduleJobs
AS
  DECLARE @o_errorCode INTEGER
DECLARE @ScheduleHostList TABLE (HostId INTEGER)
INSERT INTO @ScheduleHostList
EXEC dbo.MMGetCloudVMsTOPowerONForScheduleJobs 1
-- Don't send power on request if already sent by schedule job or VM already powered on by some other job or gui
DELETE SCH
FROM @ScheduleHostList SCH
INNER JOIN APP_ClientProp PROP WITH (NOLOCK) ON PROP.componentNameId = SCH.HostId
INNER JOIN MMVMPowerMgmtReq VM WITH (NOLOCK) ON VM.HostId = SCH.HostId
WHERE VM.RequestStatus IN (1,2) AND PROP.attrName = 'Cloud VM Managment Power Status'
AND (VM.FailureReason <> 2 AND CAST(PROP.attrVal AS INTEGER) <> 5)
/*
-- Use existing request to power on by schedule job if the exist request already processed and the VM is down
UPDATE VM
SET RequestStatus = 1, FailureReason = 0, ReqStartTime =  dbo.GetUnixTime(GetUTCDate()), RetryCount = 0, LastUpdateTime = dbo.GetUnixTime(GetUTCDate())
FROM MMVMPowerMGmtReq VM
INNER JOIN @ScheduleHostList SCH ON SCH.HostId = VM.HostId
INNER JOIN APP_ClientProp PROP WITH (NOLOCK) ON PROP.componentNameId = SCH.HostId
WHERE (VM.Flags & 8) = 8
AND ( VM.RequestStatus = 3 OR (VM.RequestStatus IN (1,2) AND VM.FailureReason = 2))
AND PROP.attrName = 'Cloud VM Managment Power Status' AND CAST(PROP.attrVal AS INTEGER) = 5
*/
-- Insert new request if the VM is not powered on and no existing request by schedule job
INSERT INTO MMVMPowerMgmtReq
SELECT -1,SCH.HostId, -1,2,1,1,0,8,dbo.GetUnixTime(GetUTCDate()),0,0,dbo.GetUnixTime(GetUTCDate())
FROM  @ScheduleHostList SCH
LEFT JOIN MMVMPowerMgmtReq VM ON VM.HostId = SCH.HostId AND VM.RequestStatus IN (1, 2)
WHERE VM.HostId IS NULL
SELECT @@ERROR
GO

IF EXISTS (select * from GxQscripts where name = 'MMSendPowerONReqForScheduleJobs')
	delete from GxQscripts where name = 'MMSendPowerONReqForScheduleJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSendPowerONReqForScheduleJobs')
	delete from GXDBVersions where aliasname = 'MMSendPowerONReqForScheduleJobs'
GO

insert into GXDBVersions values(2, 'MMSendPowerONReqForScheduleJobs',  '00010001000200060000', 'MMSendPowerONReqForScheduleJobs', '00010001000200060000')
GO

