

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSIDBReplayPrunedDeletedAF.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSIDBReplayPrunedDeletedAF.sp,v $ $Id: MMSIDBReplayPrunedDeletedAF.sp,v 1.33.50.4 2018/09/08 03:32:37 aselvanayagam Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSIDBReplayPrunedDeletedAF <<<'

IF EXISTS (select * from sysobjects where name='MMSIDBReplayPrunedDeletedAF')
	drop procedure MMSIDBReplayPrunedDeletedAF
IF EXISTS (select * from GxQscripts where name='MMSIDBReplayPrunedDeletedAF')
	delete from GxQscripts where name = 'MMSIDBReplayPrunedDeletedAF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSIDBReplayPrunedDeletedAF')
	delete from GXDBVersions where aliasname = 'MMSIDBReplayPrunedDeletedAF'
GO
print '... Creating Procedure: MMSIDBReplayPrunedDeletedAF'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMSIDBReplayPrunedDeletedAF
  @i_adminJobId integer,
  @i_sidbStoreId integer,
  @i_mode integer,
  @i_reserveParam1 integer,
  @i_reserveParam2 integer
AS
  DECLARE @o_ArchFileId INTEGER
  DECLARE @o_VolumeId INTEGER
  DECLARE @o_Status INTEGER
  DECLARE @o_Retry INTEGER
  DECLARE @o_CopyId INTEGER
  DECLARE @o_CClip VARCHAR(255)
  DECLARE @o_ArchChunkId BIGINT
  DECLARE @o_MountPathId INTEGER
  DECLARE @o_SIDBStoreId INTEGER
  DECLARE @o_CommCellId INTEGER
  DECLARE @o_DeletedTime INTEGER
  DECLARE @o_HostId INTEGER
  DECLARE @o_MountPathName NVARCHAR(1024)
  DECLARE @o_MountPathTypeId INTEGER
  DECLARE @o_UserName VARCHAR(255)
  DECLARE @o_Password VARCHAR(2048)
  DECLARE @o_Folder VARCHAR(255)
  DECLARE @o_subStoreBitField INTEGER
  DECLARE @o_sidbPruningFlag INTEGER
  DECLARE @o_reserveParam1 INTEGER
  DECLARE @o_reserveParam2 INTEGER
  DECLARE @o_strReserveParam VARCHAR(255)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
	CREATE	TABLE #tempDeletedAFList(
		archFileId			INT,
		volumeId 			INT,
		status				INT,
		retry				INT,
		copyId				INT,
cclip				VARCHAR(255),
		archChunkId			BIGINT,
		mountPathId			INT,
		sidbStoreId			INT,
		commCellId			INT,
		deletedTime			INT,
		hostId				INT,
mountPathName		NVARCHAR(1024),
		mountPathTypeId		INT,
userName			VARCHAR(255),
password			VARCHAR(2048),
folder				VARCHAR(255),
		subStoreBitField	INT,
		sidbPruningFlag		INT,
		credentialAssocId	INT
	)
	-- MMTempDeletedAF.PruneStatus
	--		0 - MM_SIDB_TEMPDELETEDAF_PS_NONE - Pruned from MMDeletedAF
	--		1 - MM_SIDB_TEMPDELETEDAF_PS_REPLAYING - To be replayed
	--		2 - MM_SIDB_TEMPDELETEDAF_PS_REPLAY_SUCCEEDED - Replay succeeded
	--		3 - MM_SIDB_TEMPDELETEDAF_PS_REPLAY_FAILED - Replay failed
	DECLARE @l_pruneStatus	INTEGER
	DECLARE	@l_lastSnapTime	INTEGER
	DECLARE	@l_currentTime	INTEGER = dbo.GetUnixTime(GetUTCDate())
    DECLARE	@l_batchCount	INTEGER = 0
	DECLARE	@l_reconJobStartTime INTEGER
	DECLARE @pruningBatchCount INT = ISNULL((SELECT value from MMConfigs WHERE name = 'MMS2_CONFIG_DEDUP_PRUNE_BATCH_SIZE'), 0)
	IF NOT EXISTS (SELECT SubStoreId FROM IdxSIDBSubStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = @i_sidbStoreId)
		SELECT @l_lastSnapTime = LastSnapTime FROM IdxSIDBStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = @i_sidbStoreId
	ELSE
		SELECT @l_lastSnapTime = MIN(LastSnapTime) FROM IdxSIDBSubStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = @i_sidbStoreId
	SELECT	@l_reconJobStartTime = jobStartTime FROM JMJobInfo WITH (NOLOCK) WHERE jobId = @i_adminJobId
SELECT	@l_batchCount = ISNULL(value, 1000) FROM MMConfigs WITH (NOLOCK) WHERE name = N'MMS2_CONFIG_SIDB_RECONSTRUCT_REPLAY_BATCH_COUNT'
    IF @l_batchCount <= 0
SET	@l_batchCount = 1000
	/* Now we rely on auto pruning so no need to move entries from MMDAF to MMTDAF.
	INSERT	INTO MMTempDeletedAF
SELECT	distinct DAF.archFileId, DAF.VolumeId, DAF.Status, DAF.Retry, DAF.copyId, DAF.cclip, DAF.capacityfreedbytes, DAF.archChunkId, DAF.mountPathId, DAF.sidbStoreId, DAF.commCellId, DAF.deletedTime, @i_adminJobId, 0, @l_currentTime, 0, DAF.sidbPruningFlag, DAF.appSizeFreedBytes, 0, DAF.chunkCommCellId
	FROM	MMDeletedAF DAF WITH (READUNCOMMITTED) LEFT OUTER JOIN MMTempDeletedAF TDAF WITH (READUNCOMMITTED)
			ON DAF.VolumeId = TDAF.VolumeId AND DAF.archFileId = TDAF.archFileId AND DAF.ArchChunkId = TDAF.ArchChunkId
			INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MP.mountPathId = DAF.mountPathId
	WHERE	DAF.SIDBStoreId = @i_sidbStoreId
			AND DAF.DeletedTime < @l_reconJobStartTime
			--AND DAF.DeletedTime >= @l_lastSnapTime -- MR: 84055 this condition is not required. We need to copy all entries from MMDeletedAF to MMTempDeletedAF for reconstruction.
			AND TDAF.VolumeId IS NULL
			AND TDAF.archFileId IS NULL
			AND TDAF.ArchChunkId IS NULL
			-- Enable granular pruning on cloud targets. Reconstruction should support this.
			--AND MP.mountPathTypeId <> 7 -- MOUNT_PATH_EXTERNAL_REMOTE_HOST
			-- pick only those rows which are already marked picked for pruning.
AND (((DAF.Status & 2) > 0) OR (@pruningBatchCount = 0))
	*/
/*
	-- For Parallel dedup, we should keep entries in mmdeletedaf until pruned from all substores.
	DELETE FROM MMDeletedAF
	WHERE SIDBStoreId = @i_sidbStoreId
*/
	DELETE	FROM MMTempDeletedAF
	WHERE	SIDBStoreId = @i_sidbStoreId
			-- Remove only entries that have BOTH archfileid and archchunkid = 0 - before it used to be OR here which will not replay AfID > 0 entries.  Change made after finding this from Sunguard TR 130805-264.
			AND (archFileId = 0 AND archChunkId = 0)
SET		@l_pruneStatus = 1
	-- Also Reset the substoreBitField before starting pruning
IF @i_mode = 1
	BEGIN
		UPDATE	MMTempDeletedAF
		SET		AdminJobId = @i_adminJobId, PruneStatus = @l_pruneStatus, subStoreBitField = 0
		WHERE	SIDBStoreId = @i_sidbStoreId
	END
	-- From now, for retry attempts, only the entries with PruneStatus as PENDING are taken for resubmission
	-- Otherwise, all the records are submitted again and again overloading SIDB
	/*
ELSE IF @i_mode = 2
	BEGIN
		UPDATE	MMTempDeletedAF
SET		PruneStatus = 1
WHERE	SIDBStoreId = @i_sidbStoreId AND PruneStatus NOT IN (2)
	END
ELSE IF @i_mode = 3
	BEGIN
		UPDATE	MMTempDeletedAF
SET		PruneStatus = 1
WHERE	SIDBStoreId = @i_sidbStoreId AND PruneStatus IN (3)
	END
ELSE IF @i_mode = 4
	BEGIN
		UPDATE	MMTempDeletedAF
SET		PruneStatus = 1
WHERE	SIDBStoreId = @i_sidbStoreId AND PruneStatus IN (4)
	END
	*/
	ELSE
	BEGIN
		UPDATE	MMTempDeletedAF
		SET		AdminJobId = @i_adminJobId, PruneStatus = @l_pruneStatus
		WHERE	SIDBStoreId = @i_sidbStoreId
AND PruneStatus NOT IN (2, 3)
	END
	INSERT	INTO #tempDeletedAFList
	SELECT	distinct archFileId, VolumeId, Status, Retry, copyId, cclip, archChunkId, mountPathId, sidbStoreId, commCellId, deletedTime, 0, '', 0, '', '', '', subStoreBitField, sidbPruningFlag, 0
	FROM	MMTempDeletedAF WITH (READUNCOMMITTED)
	WHERE	SIDBStoreId = @i_sidbStoreId AND PruneStatus = @l_pruneStatus
		-- Only process those rows that have atleast archfileId or archChunkId > 0 - both 0 anyway will be skipped in cpp code.
		AND (archFileId > 0 OR archChunkId > 0)
/*	INSERT	INTO #tempDeletedAFList
	SELECT	distinct archFileId, VolumeId, Status, Retry, copyId, cclip, archChunkId, mountPathId, sidbStoreId, commCellId, deletedTime, 0, '', 0, '', '', ''
	FROM	MMDeletedAF WITH (READUNCOMMITTED)
	WHERE	SIDBStoreId = @i_sidbStoreId
*/
/*Added by lpulickal , 10/15/13 : Pruning request is sent to DDB MA directly if it has access to any of the data paths*/
	DECLARE @DDBMA INT = -1
	DECLARE	@SIDBSubStoresUnderRecon TABLE (
		subStoreId			INT,
		clientID 			INT
	)
	INSERT INTO @SIDBSubStoresUnderRecon
            SELECT  T.t_substoreId , I.ClientId
            FROM IdxSIDBSubStore I WITH (NOLOCK),
            (
                    SELECT sb.value('@val', 'INT') AS t_substoreId
                    FROM
                    (
                            SELECT CAST(value AS XML) AS xmlstr
                            FROM dbo.GetAllJobOptions(@i_adminJobId)
                            WHERE optionId = 34449693 -- DEDUPDBSYNCOPTION__SUB_STORE_ID_LIST
					) AS O
                    CROSS APPLY O.xmlstr.nodes ('SubStoreIdList') R(sb)
            ) T
            WHERE I.Status = 1
            AND T.t_substoreId = I.SubStoreId
			AND I.SIDBStoreId = @i_sidbStoreId
	SELECT top 1  @DDBMA = SR.clientID -- if ddb MA has access to any data path , @DDBMA will have a non negative value
	FROM #tempDeletedAFList T
	INNER JOIN MMMountPathToStorageDevice MPTODEV WITH (READUNCOMMITTED) ON T.mountPathId = MPTODEV.MountPathId
	INNER JOIN MMDeviceController DEVC WITH (READUNCOMMITTED) ON DEVC.DeviceId = MPTODEV.DeviceId
	INNER JOIN MMDevice DEV WITH (READUNCOMMITTED) ON DEV.DeviceId = MPTODEV.DeviceId
	INNER JOIN @SIDBSubStoresUnderRecon SR ON SR.clientID = DEVC.ClientId
	INNER JOIN MMHost H WITH (READUNCOMMITTED) ON SR.ClientID = H.ClientId
	WHERE	DEV.DeviceEnabled  = 1
			AND DEV.DeviceBroken = 0
			AND DEVC.DeviceControllerEnabled = 1
			AND DEVC.DeviceAccessible = 1
			AND DEVC.DeviceAccessType & 2 = 2
			AND H.MmHostSoftState = 1
			AND H.MmHostEnabled = 1
	UPDATE	#tempDeletedAFList
	SET		hostId = LC.ClientId, mountPathName = MP.MountPathName, mountPathTypeId = MP.MountPathTypeId, userName = MP.UserName, password = MP.UserPassword
	FROM	#tempDeletedAFList AS T INNER JOIN MMMountPath AS MP WITH (READUNCOMMITTED) ON T.mountPathId = MP.MountPathId
			INNER JOIN MMLibraryController AS LC WITH (READUNCOMMITTED) ON MP.LibraryId = LC.LibraryId
			INNER JOIN MMHost H WITH (READUNCOMMITTED) ON LC.ClientId = H.ClientId
	WHERE	MP.IsEnabled = 1
			AND MP.IsOffline = 0
			AND H.MmHostSoftState = 1
			AND H.MmHostEnabled = 1
	UPDATE	#tempDeletedAFList
	SET		hostId = (CASE WHEN @DDBMA = -1 THEN DEVC.ClientId
						   ELSE @DDBMA
					  END), userName = DEVC.UserName, password = DEVC.UserPassword, folder = DEVC.Folder, credentialAssocId = DEVC.CredentialAssocId
	FROM	#tempDeletedAFList AS T INNER JOIN MMMountPathToStorageDevice MPTODEV WITH (READUNCOMMITTED) ON T.mountPathId = MPTODEV.MountPathId
			INNER JOIN MMDevice AS DEV WITH (READUNCOMMITTED) ON MPTODEV.DeviceId = DEV.DeviceId
			INNER JOIN MMDeviceController AS DEVC WITH (READUNCOMMITTED) ON MPTODEV.DeviceId = DEVC.DeviceId
			INNER JOIN MMHost H WITH (READUNCOMMITTED) ON DEVC.ClientId = H.ClientId
			-- MOUNT_PATH_SHARED_STATIC, MOUNT_PATH_SHARED_REPLICA, MOUNT_PATH_EXTERNAL_REMOTE_HOST
	WHERE	T.MountPathTypeId IN (4, 5, 7)
			AND	DEV.DeviceEnabled= 1
			AND	DEV.DeviceBroken = 0
			AND	DEVC.DeviceControllerEnabled = 1
			AND	DEVC.DeviceAccessible = 1
AND	DEVC.DeviceAccessType & 2 = 2
			AND	H.MmHostEnabled = 1
			AND	H.MmHostSoftState = 1
	-- Update user name and password for entries that use credentials
	EXEC MMS2GetDeviceControllerCredentials '#tempDeletedAFList', 'credentialAssocId', 'userName', 'password'
	SELECT	TOP (@l_batchCount) archFileId,
		volumeId,
		status,
		retry,
		copyId,
		cclip,
		archChunkId,
		mountPathId,
		sidbStoreId,
		commCellId,
		deletedTime,
		hostId,
		mountPathName,
		mountPathTypeId,
		userName,
		password,
		folder,
		subStoreBitField,
		sidbPruningFlag, 0, 0, '' FROM #tempDeletedAFList
	ORDER	BY hostId, mountPathId
	DROP TABLE #tempDeletedAFList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSIDBReplayPrunedDeletedAF')
	delete from GxQscripts where name = 'MMSIDBReplayPrunedDeletedAF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSIDBReplayPrunedDeletedAF')
	delete from GXDBVersions where aliasname = 'MMSIDBReplayPrunedDeletedAF'
GO

insert into GXDBVersions values(2, 'MMSIDBReplayPrunedDeletedAF',  '00010033005000040000', 'MMSIDBReplayPrunedDeletedAF', '00010033005000040000')
GO

