

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2getSpareMediaListForGUI.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2getSpareMediaListForGUI.sp,v $ $Id: MMS2getSpareMediaListForGUI.sp,v 1.13.210.3 2018/03/20 19:50:19 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Cursor: "MMS2getSpareMediaListForGUI"								|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2getSpareMediaListForGUI <<<'

IF EXISTS (select * from sysobjects where name='MMS2getSpareMediaListForGUI')
	drop procedure MMS2getSpareMediaListForGUI
IF EXISTS (select * from GxQscripts where name='MMS2getSpareMediaListForGUI')
	delete from GxQscripts where name = 'MMS2getSpareMediaListForGUI'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2getSpareMediaListForGUI')
	delete from GXDBVersions where aliasname = 'MMS2getSpareMediaListForGUI'
GO
print '... Creating Procedure: MMS2getSpareMediaListForGUI'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2getSpareMediaListForGUI
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @GroupId integer
AS
--	The next two lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @MediaId integer
  DECLARE @BarCode char(255)
  DECLARE @UniqueId char(255)
  DECLARE @MediaLocation integer
  DECLARE @ExportLocation NVARCHAR(255)
  DECLARE @MediaTypeId integer
  DECLARE @MediaFlags integer
  DECLARE @ExternalGUID char(255)
  DECLARE @IsCleaningMedia integer
  DECLARE @MediaSideId integer
  DECLARE @VolumeId integer
  DECLARE @VolumeFlags integer
  DECLARE @MediaStatus integer
  DECLARE @slotId integer
  DECLARE @slotName char(255)
  DECLARE @driveId integer
  DECLARE @driveAliasName NVARCHAR(255)
  DECLARE @containerId integer
  DECLARE @containerName NVARCHAR(255)
  DECLARE @mediaAttributes integer
  DECLARE @guiAttributes integer
  DECLARE @exportLocationId integer
  DECLARE @libraryId integer
  DECLARE @lastWriteLibraryId integer
  DECLARE @usageCounter integer
  DECLARE @numberOfSoftErrors integer
  DECLARE @numberOfHardErrors integer
  DECLARE @isAged integer
  DECLARE @isInMediaGroup integer
  DECLARE @lastWriteTime integer
  DECLARE @physicalBytesMB bigint
  DECLARE @o_extendedAttributes integer
  DECLARE @o_mediaReasonStatus integer
-- NoOfUses = number of REuses for a media that is not a cleaning tape, and number of uses for a cleaning tape
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
	IF object_id('tempdb.dbo.#tmpSpareResult') is not null DROP TABLE #tmpSpareResult
DECLARE @emptyString varchar(255)
	SET			@emptyString = ''
	SELECT DISTINCT M.MediaId,
			M.BarCode,
			M.UniqueId,
			M.MediaLocation,
			ME.ExportLocation,
			M.MediaTypeId,
			M.MediaFlags,
			M.ExternalGUID,
			MT.IsCleaningMedia,
			V.MediaSideId,
			V.VolumeId,
			V.VolumeFlags,
			t_mediaStatus = 0, --(select MediaStatus from MMSlot where MediaId = M.MediaId),
			t_slotid = 0, --(select slotid from MMSlot where mediaid = M.mediaId),
			t_slotname = @emptyString, --(select slotname from MMSlot where mediaid = M.mediaId),
			t_driveid = 0, --(select driveid from MMDrive where mediaid = M.mediaid),
			t_drivename = @emptyString, --(select aliasname from MMDrive where mediaid = M.mediaid),
			mc.ContainerId, mc.ContainerName, M.attributes, dbo.MMS2FUNC_GetGUIMediaAttribute(M.MediaId) AS GuiAttributes, ME.ExportLocationId,
			M.LibraryId, M.LastWriteLibraryId, M.NumberOfReUses,
			MS.NumberOfSoftErrors, MS.NumberOfHardErrors,
			M.IsAged, M.IsInMediaGroup,
			M.LastBackupTime,
			t_physicalBytesMB = 0,
			M.ExtendedAttributes,
			M.MediaStatusReason
	INTO 	#tmpSpareResult
	FROM 	MMMedia as M,
		MMMediaType as MT,
		MMVolume as V, MMExportLocation as ME, MMContainer as mc,
		MMMediaSide as MS, MMSpareGroup as MSG
	WHERE 	M.SpareGroupId = @GroupId AND
		-- For Saved Media Group, also return the active media
( IsInMediaGroup = 0 OR MSG.SpareGroupType = 64 OR MSG.SpareGroupType = 128 ) AND MSG.SpareGroupId = M.SpareGroupId AND
		M.MediaTypeId = MT.MediaTypeId and M.ExportLocationId = ME.ExportLocationId and
		V.MediaId = M.MediaId and
		mc.ContainerId = m.containerId
		and MS.MediaSideId = V.MediaSideId
	-- ORDER BY slotid, driveid
	--Dummy Media for stand alone library not to be shown MR 9121
	delete from #tmpSpareResult
	where BarCode in (select 'StdAln_' + CAST(mediaId as varchar(64)) from #tmpSpareResult)
	-- Update the slot and drive info (eliminate errors because of duplicate barcode)
	UPDATE #tmpSpareResult
	SET		t_mediaStatus = Slot.MediaStatus,	t_slotId = Slot.SlotId,	t_slotName = Slot.SlotName
	FROM	#tmpSpareResult AS tt, MMSlot AS Slot, MMBay AS Bay, MMSpareGroup AS SpareGroup
	WHERE	Slot.BayId = Bay.BayId AND Bay.LibraryId = SpareGroup.LibraryId
	AND		SpareGroup.SpareGroupId = @GroupId AND Slot.MediaId = tt.MediaId
	UPDATE #tmpSpareResult
	SET		t_DriveId = Drive.DriveId, t_DriveName = Drive.AliasName
	FROM	#tmpSpareResult AS tt, MMDrive AS Drive, MMMasterPool AS MasterPool,MMSpareGroup AS SpareGroup
	WHERE	Drive.MasterPoolId = MasterPool.MasterPoolId AND MasterPool.LibraryId = SpareGroup.LibraryId
	AND		SpareGroup.SpareGroupId = @GroupId AND tt.MediaId = Drive.MediaId
	-- for a cleaning media, the number of reusages is actually the number of mounts
	UPDATE #tmpSpareResult
	SET NumberOfReUses = MS.NumberOfMounts
	FROM #tmpSpareResult AS tt, MMMediaSide AS MS
	WHERE tt.IsCleaningMedia = 1 AND MS.MediaId = tt.MediaId
	-- get PhysicalBytes MB from MMMediaSide table
	UPDATE #tmpSpareResult
	set t_physicalBytesMB = (select sum(MS.PhysicalBytesMB)
	from MMMediaSide MS
	where #tmpSpareResult.mediaId = MS.mediaId)
	SELECT * FROM #tmpSpareResult ORDER BY t_slotid, t_driveid
	DROP TABLE #tmpSpareResult
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2getSpareMediaListForGUI')
	delete from GxQscripts where name = 'MMS2getSpareMediaListForGUI'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2getSpareMediaListForGUI')
	delete from GXDBVersions where aliasname = 'MMS2getSpareMediaListForGUI'
GO

insert into GXDBVersions values(2, 'MMS2getSpareMediaListForGUI',  '00010013021000030000', 'MMS2getSpareMediaListForGUI', '00010013021000030000')
GO

