

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2getMountPathListForLibAndMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2getMountPathListForLibAndMA.sp,v $ $Id: MMS2getMountPathListForLibAndMA.sp,v 1.3.190.8 2020/12/04 18:27:24 anarulkar Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2getMountPathListForLibAndMA"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMS2getMountPathListForLibAndMA')
BEGIN
	print '>>> Drop Stored Procedure: MMS2getMountPathListForLibAndMA <<<'
	drop procedure MMS2getMountPathListForLibAndMA
END
IF EXISTS (select * from GxQscripts where name='MMS2getMountPathListForLibAndMA')
	delete from GxQscripts where name = 'MMS2getMountPathListForLibAndMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2getMountPathListForLibAndMA')
	delete from GXDBVersions where aliasname = 'MMS2getMountPathListForLibAndMA'
GO
print '... Creating Procedure: MMS2getMountPathListForLibAndMA'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMS2getMountPathListForLibAndMA
  @in_LibraryId integer, 
  @in_MaClientId integer = 0
AS
  DECLARE @o_mountPathId integer
  DECLARE @o_mountPathName NVARCHAR(1024)
  DECLARE @o_baseFolder NVARCHAR(1024)
  DECLARE @o_isEnabled integer
  DECLARE @o_isOffline integer
  DECLARE @o_offlineReason integer
  DECLARE @o_freeBytesMB bigint
  DECLARE @o_mountPathType integer
  DECLARE @o_mediaId integer
  DECLARE @o_clientId integer
  DECLARE @o_clientName char(255)
  DECLARE @o_net_HostName char(255)
-- resource
  DECLARE @o_InUse integer
  DECLARE @o_jobId bigint 
  DECLARE @o_Priority integer
  DECLARE @o_ReserveBitMask integer
  DECLARE @o_ReleaseTime integer
  DECLARE @o_LogicalRelease integer 
  DECLARE @o_totalSpaceMB bigint
  DECLARE @o_driveId integer
  DECLARE @o_deviceTypeId integer
  DECLARE @o_reseveSpaceInMB integer
  DECLARE @o_maxDataToWriteInMB integer
  DECLARE @o_MPUsedForLogCaching integer
if @in_MaClientId = 0
begin
	exec MMS2getMountPathListForLib @in_LibraryId
	return
end
select 	mp.mountpathid, tmpMP.mountpathname, mp.MountPathName,
		mp.isenabled, mp.isOffline, mp.offlineReason,
CASE WHEN mp.MountPathTypeId = 7 AND  ms.freebytesmb = 1048576  /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
			 THEN	-1
 			 ELSE  ms.freebytesmb END,
		mp.MountPathTypeId, ms.MediaId,
		clientId = 	tmpMP.clientId,
		clientName = case when tmpMP.clientId > 0 then cl.displayName else '' end,
		clientNet_Hostname = case when tmpMP.clientId > 0 then cl.net_hostName else '' end,
		InUse = isnull(MRJ.InUse,0),
		JobId = convert(bigint,isnull(MRJ.JobId_h, 0))*2147483648+convert(bigint,isnull(MRJ.JobId_l, 0)),
		Priority = isnull(MRJ.Priority, 0),
		ReserveBitmask = isnull(MRJ.ReserveBitMask, 0),
		ReleaseTime = isnull(MRJ.ReleaseTime, 0),
		LogicalRelease = isnull(MR.LogicalRelease, 0),
CASE WHEN mp.MountPathTypeId = 7 AND  ms.TotalSpaceMB = 1048576  /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
			 THEN -1
			 ELSE  ms.TotalSpaceMB END,
		md.DriveId,
		tmpMP.deviceTypeId,
		mp.MagneticSpaceRsrvInMB,
		mp.MaxDataToWriteMB,
		CASE WHEN EXISTS(SELECT 1 FROM APP_SubclientToMountpathMapping SCM WITH (READUNCOMMITTED) WHERE SCM.mountPathId = MP.MountPathId) THEN 1 ELSE 0 END
	from MMMountPath as mp WITH(READUNCOMMITTED)
		inner join MMS2getMountPathList as tmpMP WITH(READUNCOMMITTED) on mp.MountPathId = tmpMP.MountPathId
		inner join MMMediaSide as ms  WITH(READUNCOMMITTED)on mp.mediasideid = ms.MediaSideId
		inner join MMDrive as md WITH(READUNCOMMITTED) on md.MediaId = ms.MediaId
		left outer join MMResource as MR WITH(READUNCOMMITTED) on tmpMP.mediaId = MR.mediaId
		left outer join MMResourceToJob as MRJ WITH(READUNCOMMITTED) on MR.reservationId = MRJ.reservationId
		left outer join	APP_Client as Cl WITH(READUNCOMMITTED) on Cl.id = tmpMP.ClientId
	where mp.LibraryId = @in_LibraryId and tmpMP.ClientId = @in_MaClientId
	and mp.MountPathTypeId <> 11 /*MOUNT_PATH_CACHE*/
	order by mp.mountpathid, JobId
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2getMountPathListForLibAndMA')
	delete from GxQscripts where name = 'MMS2getMountPathListForLibAndMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2getMountPathListForLibAndMA')
	delete from GXDBVersions where aliasname = 'MMS2getMountPathListForLibAndMA'
GO

insert into GXDBVersions values(2, 'MMS2getMountPathListForLibAndMA',  '00010003019000080000', 'MMS2getMountPathListForLibAndMA', '00010003019000080000')
GO

