

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2getMountPathListForLib.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2getMountPathListForLib.sp,v $ $Id: MMS2getMountPathListForLib.sp,v 1.12.190.7 2020/07/02 01:13:32 pveeravalli Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2getMountPathListForLib"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2getMountPathListForLib')
BEGIN
	print '>>> Drop Stored Procedure: MMS2getMountPathListForLib <<<'
	drop procedure MMS2getMountPathListForLib
END
IF EXISTS (select * from GxQscripts where name='MMS2getMountPathListForLib')
	delete from GxQscripts where name = 'MMS2getMountPathListForLib'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2getMountPathListForLib')
	delete from GXDBVersions where aliasname = 'MMS2getMountPathListForLib'
GO
print '... Creating Procedure: MMS2getMountPathListForLib'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2getMountPathListForLib
  @in_LibraryId integer
AS
  DECLARE @o_mountPathId integer
  DECLARE @o_mountPathName NVARCHAR(1024)
  DECLARE @o_baseFolder NVARCHAR(1024)
  DECLARE @o_isEnabled integer
  DECLARE @o_isOffline integer
  DECLARE @o_offlineReason integer
  DECLARE @o_freeBytesMB bigint
  DECLARE @o_mountPathType integer
  DECLARE @o_mediaId integer
  DECLARE @o_clientId integer
  DECLARE @o_clientName char(255)
  DECLARE @o_net_HostName char(255)
-- resource
  DECLARE @o_InUse integer
  DECLARE @o_jobId bigint 
  DECLARE @o_Priority integer
  DECLARE @o_ReserveBitMask integer
  DECLARE @o_ReleaseTime integer
  DECLARE @o_LogicalRelease integer 
  DECLARE @o_totalSpaceMB bigint
  DECLARE @o_driveId integer
  DECLARE @o_deviceTypeId integer
  DECLARE @o_reseveSpaceInMB integer
  DECLARE @o_maxDataToWriteInMB integer
  DECLARE @o_MPUsedForLogCaching integer
	declare @tmpmountspaths table (	mountPathId 		integer,
					mediaSideId		integer,
					mediaId			integer,
					deviceId		integer,
					deviceTypeId	integer,
					mountPathName   NVARCHAR(1024))
	-- get list of mountpaths for libray and potential deviceIds
	-- note, below query has become a little obselete almost and could be combined
	-- into the main one, but we may need the deviceId in the future for something..
	-- and it doesn't reduce DB complexity, actually it makes this cursor more readable
	insert into @tmpmountspaths
	select 	mp.mountpathId, mp.mediaSideId, ms.mediaId, isnull(mp2sd.deviceId,0), ISNULL(mmd.DisplayDeviceTypeId, 0), mp.MountPathName
	from 	MMMountPath as mp
			left outer join MMMountPathToStorageDevice as mp2sd
				ON mp2sd.mountPathId = mp.mountPathId
			left outer join MMDevice as mmd
				ON mp2sd.deviceId = mmd.DeviceId,
		MMMediaSide as ms, MMMedia as mm
	where 	mm.libraryId = @in_LibraryId and
		ms.mediaId = mm.mediaId and
		mp.mediaSideId = ms.mediaSideId
select 	mp.mountpathid, mp.mountpathname, tmpMP.mountPathName,
		mp.isenabled, mp.isOffline, mp.offlineReason,
CASE WHEN mp.MountPathTypeId = 7 AND  ms.freebytesmb = 1048576  /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
		 THEN	-1
 		 ELSE  ms.freebytesmb END AS FreeSpace,
		mp.MountPathTypeId, ms.MediaId,
		clientId = 	case
					when (isnull(MH.clientid,0) = 0) then 0
					else isnull(cl.Id, 0)
			   	end,
		clientName = 	case
					when (isnull(MH.clientid,0) > 0) and  (isnull(cl.Id, 0) > 0) then isnull(cl.Name, '')
					else ''
				end,
		clientNet_Hostname = case
					when (isnull(MH.clientid,0) > 0) and  (isnull(cl.Id, 0) > 0) then isnull(cl.net_hostName, '')
					else ''
				end,
		InUse = isnull(MRJ.InUse,0),
		JobId = convert(bigint,isnull(MRJ.JobId_h, 0))*2147483648+convert(bigint,isnull(MRJ.JobId_l, 0)),
		Priority = isnull(MRJ.Priority, 0),
		ReserveBitmask = isnull(MRJ.ReserveBitMask, 0),
		ReleaseTime = isnull(MRJ.ReleaseTime, 0),
		LogicalRelease = isnull(MR.LogicalRelease, 0),
CASE WHEN mp.MountPathTypeId = 7 AND  ms.TotalSpaceMB = 1048576  /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
			 THEN -1
			 ELSE  ms.TotalSpaceMB END AS  TotalSpace,
		md.DriveId,
		tmpMP.deviceTypeId,
		mp.MagneticSpaceRsrvInMB,
		mp.MaxDataToWriteMB,
		CASE WHEN EXISTS(SELECT 1 FROM APP_SubclientToMountpathMapping SCM WITH (READUNCOMMITTED) WHERE SCM.mountPathId = tmpMP.MountPathId) THEN 1 ELSE 0 END
	from 	MMS2getMountPathNameGUIView as mp,
		@tmpmountspaths as tmpMP 	left outer join MMResource as MR WITH (READUNCOMMITTED)
							on tmpMP.mediaId = MR.mediaId
						left outer join MMResourceToJob as MRJ WITH (READUNCOMMITTED)
							on MR.reservationId = MRJ.reservationId
						left outer join MMHost as MH WITH (READUNCOMMITTED)
							on MR.clientid = MH.clientid
						left outer join	APP_Client as Cl WITH (READUNCOMMITTED)
							on Cl.id = MH.ClientId,
		MMMediaSide as ms WITH (READUNCOMMITTED) ,
		MMDrive	as md WITH (READUNCOMMITTED)
	where 	mp.mountPathId = tmpMP.mountPathId and
		ms.mediasideid = mp.mediaSideId and
		ms.mediaId = md.mediaId
	order by mp.mountpathid, JobId
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2getMountPathListForLib')
	delete from GxQscripts where name = 'MMS2getMountPathListForLib'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2getMountPathListForLib')
	delete from GXDBVersions where aliasname = 'MMS2getMountPathListForLib'
GO

insert into GXDBVersions values(2, 'MMS2getMountPathListForLib',  '00010012019000070000', 'MMS2getMountPathListForLib', '00010012019000070000')
GO

