

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2getMasterPoolListForLib.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2getMasterPoolListForLib.sp,v $ $Id: MMS2getMasterPoolListForLib.sp,v 1.2.294.2 2018/03/20 19:45:05 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2getMasterPoolListForLib"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2getMasterPoolListForLib <<<'

IF EXISTS (select * from sysobjects where name='MMS2getMasterPoolListForLib')
	drop procedure MMS2getMasterPoolListForLib
IF EXISTS (select * from GxQscripts where name='MMS2getMasterPoolListForLib')
	delete from GxQscripts where name = 'MMS2getMasterPoolListForLib'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2getMasterPoolListForLib')
	delete from GXDBVersions where aliasname = 'MMS2getMasterPoolListForLib'
GO
print '... Creating Procedure: MMS2getMasterPoolListForLib'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2getMasterPoolListForLib
  @in_mediaAgentId integer,
  @in_libraryId integer
AS
  DECLARE @o_masterPoolId integer
  DECLARE @o_masterPoolName NVARCHAR(255)
  DECLARE @o_masterPoolSoftState integer
  DECLARE @o_masterPoolEnabled integer
  DECLARE @o_numHosts integer
	if(@in_MediaAgentId > 0)
	begin
		select distinct a.masterpoolid, a.masterpoolname, a.masterpoolsoftstate, a.masterpoolenabled,
		NumHosts = (select count(*) from MMDrivePool as t where t.MasterPoolId = a.MasterPoolId)
		from MMMasterPool as a, MMDrivePool  as b
		where b.ClientId = @in_MediaAgentId and b.MasterPoolId = a.MasterPoolId and a.libraryid=@in_libraryId
	end
	else
	begin
		select distinct masterpoolid, masterpoolname, masterpoolsoftstate, masterpoolenabled,
		NumHosts = (select count(*) from MMDrivePool where MasterPoolId = a.MasterPoolId)
		from MMMasterPool as a
		where libraryid=@in_libraryId
	end
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2getMasterPoolListForLib')
	delete from GxQscripts where name = 'MMS2getMasterPoolListForLib'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2getMasterPoolListForLib')
	delete from GXDBVersions where aliasname = 'MMS2getMasterPoolListForLib'
GO

insert into GXDBVersions values(2, 'MMS2getMasterPoolListForLib',  '00010002029400020000', 'MMS2getMasterPoolListForLib', '00010002029400020000')
GO

