

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2getLibList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2getLibList.sp,v $ $Id: MMS2getLibList.sp,v 1.13.2.18 2020/08/24 14:14:29 pnara Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2getLibList"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2getLibList')
BEGIN
	print '>>> Drop Stored Procedure: MMS2getLibList <<<'
	drop procedure MMS2getLibList
END
IF EXISTS (select * from GxQscripts where name='MMS2getLibList')
	delete from GxQscripts where name = 'MMS2getLibList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2getLibList')
	delete from GXDBVersions where aliasname = 'MMS2getLibList'
GO
print '... Creating Procedure: MMS2getLibList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMS2getLibList
  @i_userId integer = 0,
  @i_libraryTypeFlags integer = -1
AS
  DECLARE @LibraryId integer
  DECLARE @AliasName NVARCHAR(255)
  DECLARE @LibraryTypeId integer
  DECLARE @libraryVTLType integer
  DECLARE @librarySoftState integer
  DECLARE @libraryEnabled integer
  DECLARE @libraryBroken integer
  DECLARE @barcodeReaderPresent integer
  DECLARE @libraryVendor char(255)
  DECLARE @libraryModel char(255)
  DECLARE @libraryAttribute integer
  DECLARE @libraryExtendedAttributes integer
  DECLARE @isConvertedToSited integer
  DECLARE @driveCount integer
  DECLARE @emptySlotCount integer
  DECLARE @libraryMediaTypeId integer
  DECLARE @description NVARCHAR(max)
  DECLARE @libHasSiloData integer
  DECLARE @Capabilities bigint
  DECLARE @isOnline integer
  DECLARE @associatedMediaAgents NVARCHAR(max)
  DECLARE @freeSpaceOnLib bigint
  DECLARE @capacity bigint
  DECLARE @privateData CHAR(256)
  DECLARE @libraryVendorId integer
  DECLARE @poolType integer
  DECLARE @associatedMediaAgentsDisplayName NVARCHAR(max)
  DECLARE @isLibraryUsedForLogCaching integer
	IF object_id('tempdb.dbo.#tblLibDetails') IS NOT NULL DROP TABLE #tblLibDetails
	IF object_id('tempdb.dbo.#PoolType') IS NOT NULL DROP TABLE #PoolType
	IF object_id('tempdb.dbo.#tblSecLibrary') IS NOT NULL DROP TABLE #tblSecLibrary
	CREATE TABLE #tblSecLibrary (LibraryId int primary key, capabilities bigint)
	INSERT INTO #tblSecLibrary
		EXEC sec_getLibraryForUser @i_userId
	DECLARE @tblOnlineLibrary table (LibraryId int)
	DECLARE @tblSiloLibrary table (LibraryId int)
	DECLARE @showHiddenLibConfig INTEGER = 0
	CREATE TABLE #tblLibDetails  (
		libraryId int,
		freespace bigint ,
		capacity bigint,
		associatedMediaAgents NVARCHAR(max),
		libraryVendorId int,
		associatedMediaAgentsDisplayName NVARCHAR(max),
		isLibraryUsedForLogCaching int,
		PRIMARY KEY (libraryId)
	)
	-------------------------------------------------
    -- Get 'MMCONFIG_SHOW_HIDDEN_LIBRARIES' value from MMConfigs
    -------------------------------------------------
    SELECT @showHiddenLibConfig = value
    FROM    MMConfigs WITH (NOLOCK)
    WHERE NAME = 'MMCONFIG_SHOW_HIDDEN_LIBRARIES'
	IF @i_libraryTypeFlags < 0
SET @i_libraryTypeFlags = (0x7FFFFFFF & (~POWER(2, 10)))
	DELETE TMP
	FROM #tblSecLibrary TMP
		INNER JOIN MMLibrary ML (READUNCOMMITTED) ON ML.LibraryId = TMP.LibraryId
	WHERE (POWER(2, ML.libraryTypeId) & @i_libraryTypeFlags) = 0
OR (@showHiddenLibConfig = 0 AND (ML.ExtendedAttributes & 33554432) > 0)
OR ML.LibraryTypeId = 8 -- don't show self library at all
	INSERT INTO @tblSiloLibrary
		SELECT DISTINCT ML.LibraryId
		FROM MMLibrary ML WITH (NOLOCK) JOIN #tblSecLibrary SEC ON ML.LibraryId = SEC.LibraryId,
		MMMedia M WITH(NOLOCK), MMVolume V WITH(NOLOCK)
		WHERE ML.LibraryId = M.LibraryId AND M.MediaId = V.MediaId AND V.SiloStatus > 0
	INSERT INTO @tblOnlineLibrary
		SELECT DISTINCT ML.LibraryId
		FROM MMLibrary ML WITH (NOLOCK)
			JOIN MMMountPath AS MP WITH (NOLOCK) ON MP.LibraryId = ML.LibraryId
			JOIN MMMountPathToStorageDevice AS MP2SD WITH (NOLOCK) ON MP.MountPathId = MP2SD.MountPathId
			JOIN MMDevice AS MD WITH (NOLOCK) ON MP2SD.DeviceId = MD.DeviceId
			JOIN MMDeviceController AS DC WITH (NOLOCK) ON MD.DeviceId = DC.DeviceId
			JOIN #tblSecLibrary SEC ON ML.LibraryId = SEC.LibraryId
		WHERE ML.LibrarySoftState > 0 AND ML.LibraryEnabled > 0 AND ML.LibraryBroken = 0
			AND MD.DeviceEnabled > 0 AND MD.DeviceBroken = 0
			AND DC.DeviceControllerEnabled > 0 AND DC.DeviceAccessible > 0
			AND MP.IsEnabled > 0 AND MP.IsOffline = 0
AND ML.LibraryTypeId = 3
	INSERT INTO @tblOnlineLibrary
		SELECT DISTINCT ML.LibraryId
		FROM MMLibrary ML WITH (NOLOCK)
			JOIN MMLibraryController AS MLC WITH (NOLOCK) ON MLC.LibraryId = ML.LibraryId
			JOIN #tblSecLibrary SEC ON ML.LibraryId = SEC.LibraryId
		WHERE ML.LibrarySoftState > 0 AND ML.LibraryEnabled > 0 AND ML.LibraryBroken = 0
			AND MLC.LibraryControllerSoftState > 0 AND MLC.LibraryControllerEnabled > 0
AND	ML.LibraryTypeId <> 3
	INSERT INTO #tblLibDetails
		SELECT  L.LibraryId,
freespace = SUM(CASE WHEN mp.MountPathTypeId = 7 AND S.FreeBytesMB = 1048576  /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
						THEN  -1
						ELSE S.FreeBytesMB  END),
capacity= SUM(CASE WHEN mp.MountPathTypeId = 7 AND S.totalSpaceMB = 1048576  /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
						THEN -1
						ELSE S.totalSpaceMB END) ,'',MAX(d.DisplayDeviceTypeId),'', 0
		FROM    MMMedia L WITH (NOLOCK) INNER JOIN #tblSecLibrary t ON t.LibraryId = L.LibraryId
INNER JOIN MMMediaSide S  WITH (NOLOCK) ON L.MediaId=S.MediaId AND L.MediaTypeId = 10001
			INNER JOIN MMMountPath mp WITH (NOLOCK) ON mp.MediaSideId = S.MediaSideId
			INNER JOIN MMMountPathToStorageDevice msd WITH (NOLOCK) ON mp.MountPathId = msd.MountPathId
			INNER JOIN MMDevice d WITH (NOLOCK) ON msd.DeviceId = d.DeviceId
		GROUP BY L.LibraryId
	INSERT INTO #tblLibDetails
		SELECT S.LibraryId ,-1,-1,'',0,'', 0 FROM #tblSecLibrary AS S
		WHERE S.LibraryId NOT IN (SELECT LibraryId from #tblLibDetails)
	UPDATE TMP
	SET isLibraryUsedForLogCaching = 1
	FROM #tblLibDetails TMP
	WHERE EXISTS(SELECT 1 FROM MMMountpath MP INNER JOIN APP_SubclientToMountpathMapping SCM WITH (NOLOCK) ON SCM.mountPathId = MP.MountPathId AND MP.LibraryId = TMP.libraryId)
	UPDATE #tblLibDetails
	SET associatedMediaAgents = ISNULL ( (select stuff((select ','+ name from app_client WITH (READUNCOMMITTED)  INNER JOIN mmlibrarycontroller AS m WITH (READUNCOMMITTED)  ON id = m.ClientId AND m.Libraryid = t.LibraryId
    FOR XML PATH(''), TYPE).value('.', 'varchar(max)'),1,1,' ')),''),
	associatedMediaAgentsDisplayName = ISNULL ( (select stuff((select ','+ displayName from app_client WITH (READUNCOMMITTED)  INNER JOIN mmlibrarycontroller AS m WITH (READUNCOMMITTED)  ON id = m.ClientId AND m.Libraryid = t.LibraryId
    FOR XML PATH(''), TYPE).value('.', 'varchar(max)'),1,1,' ')),'') FROM  #tblLibDetails as t
	IF object_id('tempdb.dbo.#PoolType') IS NOT NULL DROP TABLE #PoolType
	CREATE TABLE #PoolType(libraryId int primary key, poolType int)
	INSERT INTO #PoolType
		SELECT	ML.LibraryId, -1
		FROM	MMLibrary ML WITH (READUNCOMMITTED)
	UPDATE	PT
	SET		poolType =
				(CASE
WHEN AG.flags & 33554432 = 33554432  --CVA_SP_SCALEOUT_STORAGE_POOL - Scale out storagepool
						THEN 4 --EVGui::TypeOfStoragePool_SCALE_OUT
WHEN AG.flags & 256 = 256  --CVA_SP_GLOBAL_DEDUP_FLAG - GDSP
						THEN 1 --EVGui::TypeOfStoragePool_DEDUPLICATION
WHEN AG.flags & 16384 = 16384 --CVA_SP_GLOBAL_AUXCOPY_POLICY_FLAG - GACP
						THEN 2 --EVGui::TypeOfStoragePool_SECONDARY_COPY
WHEN AG.flags & 8388608 = 8388608 --8388608  - Global Non dedup
						THEN 3--EVGui::TypeOfStoragePool_NON_DEDUPLICATION
					ELSE -1
				END )
	FROM	ArchGroup AG WITH (READUNCOMMITTED)
			INNER JOIN MMDataPath DPath WITH (READUNCOMMITTED) ON AG.defaultCopy = DPath.CopyId
			INNER JOIN MMDrivePool DPool WITH (READUNCOMMITTED) ON DPool.DrivePoolId = DPath.DrivePoolId
			INNER JOIN MMMasterPool MPool WITH (READUNCOMMITTED) ON MPool.MasterPoolId = DPool.MasterPoolId
			INNER JOIN #PoolType PT ON MPool.LibraryId = PT.libraryId
WHERE	(AG.flags & (33554432 | 256 | 16384 | 8388608 ) > 0)
	IF OBJECT_ID('tempdb.dbo.#tmpLibraryList') IS NOT NULL
	BEGIN
	INSERT INTO #tmpLibraryList
		select 	ml.libraryid, ml.aliasname, ml.librarytypeid, ml.VTLType, ml.LibrarySoftState, ml.LibraryEnabled,
			ml.LibraryBroken, ml.BarcodeReaderPresent, ml.LibraryVendor, ml.LibraryModel,
			ml.LibraryAttribute, ml.ExtendedAttributes, ml.IsconvertedToSited, ml.driveCount,
			(	select count(*)
				from MMSlot as MS with (nolock), MMBay as MB with (nolock)
				where ml.LibraryId = MB.LibraryId
				and MB.BayId = MS.BayId and MS.IsOccupied = 0 and MS.SlotType = 1
			),
			case ml.librarytypeid
when 3 then 10001
			else ISNULL(( select sg.MediaTypeId from MMSpareGroup sg with (nolock) where sg.libraryId = ml.libraryId and sg.spareGroupType = 2), 0) end, isnull(ml.descript, N''),
			case when T.LibraryId is null then 0 else 1 end, sl.capabilities,
			case when OL.LibraryId is null then 0 else 1 end ,SUBSTRING(tl.associatedMediaAgents, 0, 4096),
			tl.freespace,
			tl.capacity,
			ml.PrivateData, tl.libraryVendorId, pt.poolType,SUBSTRING(tl.associatedMediaAgentsDisplayName, 0, 4096), tl.isLibraryUsedForLogCaching
		from 	MMLibrary as ml with (nolock) inner join #tblSecLibrary sl on ml.libraryId = sl.libraryId
				inner join #tblLibDetails  tl on ml.LibraryId = tl.libraryId
				inner join #PoolType pt on ml.LibraryId = pt.libraryId
				left outer join @tblSiloLibrary T ON ml.LibraryId = T.LibraryId
				left outer join @tblOnlineLibrary OL ON ml.LibraryId = OL.LibraryId
		ORDER BY ml.aliasname asc
	END
	ELSE
	BEGIN
		select 	ml.libraryid, ml.aliasname, ml.librarytypeid, ml.VTLType, ml.LibrarySoftState, ml.LibraryEnabled,
			ml.LibraryBroken, ml.BarcodeReaderPresent, ml.LibraryVendor, ml.LibraryModel,
			ml.LibraryAttribute, ml.ExtendedAttributes, ml.IsconvertedToSited, ml.driveCount,
			(	select count(*)
				from MMSlot as MS with (nolock), MMBay as MB with (nolock)
				where ml.LibraryId = MB.LibraryId
				and MB.BayId = MS.BayId and MS.IsOccupied = 0 and MS.SlotType = 1
			),
			case ml.librarytypeid
when 3 then 10001
			else ISNULL(( select sg.MediaTypeId from MMSpareGroup sg with (nolock) where sg.libraryId = ml.libraryId and sg.spareGroupType = 2), 0) end, isnull(ml.descript, N''),
			case when T.LibraryId is null then 0 else 1 end, sl.capabilities,
			case when OL.LibraryId is null then 0 else 1 end ,SUBSTRING(tl.associatedMediaAgents, 0, 4096),
			tl.freespace,
			tl.capacity,
			ml.PrivateData, tl.libraryVendorId, pt.poolType,SUBSTRING(tl.associatedMediaAgentsDisplayName, 0, 4096), tl.isLibraryUsedForLogCaching
		from 	MMLibrary as ml with (nolock) inner join #tblSecLibrary sl on ml.libraryId = sl.libraryId
				inner join #tblLibDetails  tl on ml.LibraryId = tl.libraryId
				inner join #PoolType pt on ml.LibraryId = pt.libraryId
				left outer join @tblSiloLibrary T ON ml.LibraryId = T.LibraryId
				left outer join @tblOnlineLibrary OL ON ml.LibraryId = OL.LibraryId
		ORDER BY ml.aliasname asc
	END
	IF object_id('tempdb.dbo.#tblLibDetails') is not null DROP TABLE #tblLibDetails
	IF object_id('tempdb.dbo.#PoolType') is not null DROP TABLE #PoolType
	IF object_id('tempdb.dbo.#tblSecLibrary') is not null DROP TABLE #tblSecLibrary
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2getLibList')
	delete from GxQscripts where name = 'MMS2getLibList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2getLibList')
	delete from GXDBVersions where aliasname = 'MMS2getLibList'
GO

insert into GXDBVersions values(2, 'MMS2getLibList',  '00010013000200180000', 'MMS2getLibList', '00010013000200180000')
GO

