

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2getCopyFailOverConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2getCopyFailOverConfig.sp,v $ $Id: MMS2getCopyFailOverConfig.sp,v 1.30.32.5 2020/08/27 18:13:46 pveeravalli Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Cursor: "MMS2getCopyFailOverConfig"								|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2getCopyFailOverConfig')
BEGIN
	print '>>> Drop Stored Procedure: MMS2getCopyFailOverConfig <<<'
	drop procedure MMS2getCopyFailOverConfig
END
IF EXISTS (select * from GxQscripts where name='MMS2getCopyFailOverConfig')
	delete from GxQscripts where name = 'MMS2getCopyFailOverConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2getCopyFailOverConfig')
	delete from GXDBVersions where aliasname = 'MMS2getCopyFailOverConfig'
GO
print '... Creating Procedure: MMS2getCopyFailOverConfig'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2getCopyFailOverConfig
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @i_ArchGroupId integer,
  @i_CopyId integer,
  @i_getNWInterfaceInfoForClient integer,
  @i_defaultDPOnly integer,
  @i_useSnapCopyForDDR integer
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- list all datapaths for a copy:
-- ---------------------------------------------
--  if a copyId is supplied, ignore the storage policy, and list all datapaths for it
-- if AG, but no copyId is specified, list all datapaths for the default copy
-- get the default copy for the storage policy supplied.
-- the getNWInterfaceInfoForClient gets the interface pairs based on the client in question, if 0,
-- then this information is not gathered.
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_DataPathId integer	
  DECLARE @o_MAId integer
  DECLARE @o_MAName char(255)
  DECLARE @o_MAReleaseId integer
  DECLARE @o_hostName char(255)
  DECLARE @o_libId integer
  DECLARE @o_libName NVARCHAR(255)
  DECLARE @o_libType integer
  DECLARE @o_masterPoolId integer
  DECLARE @o_masterPoolName NVARCHAR(255)
  DECLARE @o_drivePoolId integer
  DECLARE @o_drivePoolTypeId integer
  DECLARE @o_mountPathTypeId integer
  DECLARE @o_drivePoolName NVARCHAR(255)
  DECLARE @o_DataPathFlag integer
  DECLARE @o_spareGroupId integer
  DECLARE @o_spareGroupName NVARCHAR(255)
  DECLARE @o_IdxCacheId integer
  DECLARE @o_IdxCacheName NVARCHAR(255)
  DECLARE @o_FlushBlockSizeKB integer
  DECLARE @o_ChunkSizeMB integer
  DECLARE @o_HWCompression integer
  DECLARE @o_clientInterface char(255)
  DECLARE @o_mediaAgentInterface char(255)
  DECLARE @o_priority integer
  DECLARE @o_NoOfClientSubSelects integer
  DECLARE @o_HWEncryption integer
  DECLARE @o_hasNoData integer
  DECLARE @o_DeviceTypeId integer
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
	DECLARE @l_ArchGroupId integer
	SET @l_ArchGroupId = @i_ArchGroupId
	DECLARE @l_CopyId integer
	SET @l_CopyId = @i_CopyId
	IF (@l_CopyId < 1)
	BEGIN
		IF	@i_useSnapCopyForDDR > 0
			SET @l_CopyId = (select defaultSnapCopy from ArchGroup where id = @l_archGroupId)
		ELSE
			SET @l_CopyId = (select defaultCopy from ArchGroup where id = @l_archGroupId)
	END
	if object_id('tempdb.dbo.#tmpNWIF') is not null DROP TABLE #tmpNWIF
	if object_id('tempdb.dbo.#tmpCopyFailover') is not null DROP TABLE #tmpCopyFailover
	create table #tmpCopyFailover (
					DataPathId			integer,
					HostId				integer,
					clientName			nvarchar(255),
					clientOSId			integer,
					clientReleaseId		integer,
					net_hostName		nvarchar(255),
					copyId 				integer,
					DrivePoolId			integer,
					DrivePoolTypeId		integer,
					DrivePoolName		nvarchar(255),
					LibraryId			integer,
					LibraryTypeId		integer,
					DataPathFlag		integer,
					MasterPoolId		integer,
					MasterPoolname		nvarchar(255),
					SpareGroupId		integer,
					SpareGroupName      nvarchar(255),
					IdxCacheId			integer,
					FlushBlockSizeKB	integer,
					ChunkSizeMB			integer,
					HWCompression		integer,
					priority			integer,
					HWEncryption		integer,
					hasNoData			integer,
					mountPathTypeId     integer
				  )
	create table #tmpNWIF     (
					MAHostId			integer,
					ClientInterface		varchar(255),
					MAInterface			varchar(255)	)
	INSERT into #tmpCopyFailover
	SELECT  mcf.DataPathId, mcf.HostClientId, '', 0, 0, '', mcf.CopyId, mcf.DrivePoolId,
	mdp.DrivePoolType, mdp.DrivePoolName, mmp.LibraryId, ml.LibraryTypeId, mcf.Flag,
	mdp.MasterPoolId, mmp.MasterPoolName, mcf.SpareGroupId,'', iap.idxCacheId,
	mcf.FlushBlockSizeKB, mcf.ChunkSizeMB, mcf.IsHardwareCompressed, mcf.Priority,
	mcf.UseHardwareEncryption, 1,0
	FROM MMDataPath mcf, MMMasterPool as mmp, MMDrivePool as mdp, IdxAccessPath as iap, IdxCache as ic,
	MMLibrary as ml
	WHERE 	mcf.CopyId = @l_CopyId  AND
		(
			@i_defaultDPOnly = 0
		  OR 	(
		  		@i_defaultDPOnly > 0
		  	   AND	(mcf.flag & 1) > 0
			)
		)
	-- now come the joins
	and mcf.DrivePoolId = mdp.DrivePoolId
	-- extra comparison, NDMP client will not return
	-- and mcf.HostClientId = mdp.ClientId
	and mdp.ClientId = iap.ClientId AND MDP.MasterPoolId = MMP.MasterPoolId
	and ml.libraryId = mmp.LibraryId
	and iap.idxCacheId = ic.idxCacheId
and ic.idxCacheType = 1
    update #tmpCopyFailover set mountPathTypeId =
				case
				   WHEN drivePoolTypeId != 10001 then 0
				   ELSE
				     isnull (
								(
		  						select top 1 MP.MountPathTypeId
		  						from MMMedia AS MM, MMMediaSide AS MS, MMMountPath as MP
		  						where MM.libraryid= #tmpCopyFailover.libraryId AND MS.MediaId = MM.MediaId AND MP.MediaSideId = MS.MediaSideId
		  					), 0)
		  	end
	update #tmpCopyFailover set SpareGroupName = tt.SpareGroupName
	from MMSpareGroup tt where  #tmpCopyFailover.SpareGroupId = tt.SpareGroupId
	update #tmpCopyFailover set clientName = cl.name, clientOSId = cl.simOperatingSystemId, clientReleaseId = cl.ReleaseId
	from APP_Client as cl, #tmpCopyFailover as tt
	where cl.id = tt.HostId
			-- Get all the drive pool and its devices
	DECLARE @tblDriveDevice TABLE (DrivePoolId INT, DeviceTypeId INT)
	INSERT INTO @tblDriveDevice
	SELECT DISTINCT DPO.DrivePoolId, DC.DisplayDeviceTypeId
	FROM MMDrivePool DPO INNER JOIN #tmpCopyFailover as tt ON tt.DrivePoolId = DPO.DrivePoolId ,
			MMMasterPool MPO,
			MMDevice DC,
			MMDeviceController as MDC,
			MMMountPathToStorageDevice as MP2SD,
			MMMountPath as MP
		WHERE DPO.MasterPoolId = MPO.MasterPoolId
		AND DPO.ClientId = MDC.ClientId
		AND  MP.LibraryId = MPO.LibraryId
		AND  MDC.DeviceId = DC.DeviceId
		AND  MDC.DeviceId = MP2SD.DeviceId
		AND  MP2SD.MountPathId = MP.MountPathId
	-- DataPath for DDR: 1) same OS type as client; 2) magnetic; 3) CDR is installed on the destination client.
	IF	@i_useSnapCopyForDDR > 0 AND @i_getNWInterfaceInfoForClient > 0
	BEGIN
		DECLARE	@l_clientOSType	VARCHAR(64)
		SELECT	@l_clientOSType = type
		FROM	simOperatingSystem
		WHERE	id = (SELECT simOperatingSystemId FROM APP_Client WHERE id = @i_getNWInterfaceInfoForClient)
		DELETE	#tmpCopyFailover
		FROM	simOperatingSystem OS
		WHERE	OS.id = #tmpCopyFailover.clientOSId AND OS.type <> @l_clientOSType
		DELETE	#tmpCopyFailover
WHERE	LibraryTypeId <> 3
		DELETE	#tmpCopyFailover
		FROM	APP_IDAName
		WHERE	NOT EXISTS (SELECT id FROM APP_IDAName WHERE appTypeId = 84 and clientId = #tmpCopyFailover.HostId)
	END
	-- get NDMP Hostname
	if (exists(select DrivePoolId from #tmpCopyFailover where DrivePoolTypeId = 3))
	begin
		update #tmpCopyFailover set net_hostName = cc.Net_HostName, clientName = cc.name, clientReleaseId = cc.ReleaseId
		from MMNDMPHostInfo as mdnh, MMDrivePool as MD, #tmpCopyFailover as tt, APP_Client as CC
		where tt.DrivePoolId = md.DrivePoolId and md.NDMPHostId = mdnh.NDMPHostId and cc.id = mdnh.ClientId
		and tt.DrivePoolTypeId = 3
	end
	else
	begin
		update #tmpCopyFailover set net_hostName = cl.net_hostName
		from APP_Client as cl, #tmpCopyFailover as tt
		where cl.id = tt.HostId
		and tt.DrivePoolTypeId <> 3
	end
	declare @RowCount	integer
	set 	@RowCount	= (select count(*) from #tmpCopyFailover)
	if(@RowCount > 0)
	begin
		update #tmpCopyFailover
		set HWCompression = -1, HWEncryption = -1
		where LibraryTypeId IN (2,3,5)
		-- Optical, Mag, StdAln Optical
		-- -1 means off and cannot be changed
		IF (@i_getNWInterfaceInfoForClient > 0)
		BEGIN
			-- we need to get the client and MA data interface pairs, if configured.
			insert into #tmpNWIF
			select distinct tt.HostId, '', ''
			from #tmpCopyFailover as tt
			update #tmpNWIF
			set ClientInterface = ap.srcInterface, MAInterface = ap.destInterface
			from #tmpNWIF AS tnw, ArchPipeline as ap
			where 	ap.srcClientId = @i_getNWInterfaceInfoForClient
				AND ap.destClientID = tnw.MAHostId AND ap.isActive >0
			-- if not configured, get default client interface
			declare @tmpClientAttrVal varchar(255)
			set @tmpClientAttrVal =
				(
					select attrVal from APP_ClientProp
					where ComponentNameId = @i_getNWInterfaceInfoForClient and attrName = 'DataPipeInterface'
				)
			-- now set default client and MA interfaces where not configured.
			update #tmpNWIF
			set ClientInterface = @tmpClientAttrVal, MAInterface = cp.attrVal
			from #tmpNWIF AS tnw, APP_ClientProp AS cp
			where 	tnw.MAInterface = ''
				and cp.ComponentNameId = tnw.MAHostId
				and cp.attrName = 'DataPipeInterface'
		END
		-- now actually display the information
        select tt.DataPathId, tt.HostId, tt.ClientName, tt.ClientReleaseId, tt.net_hostName, ml.LibraryId, ml.AliasName, ml.LibraryTypeId,
		tt.MasterPoolId, tt.MasterPoolName, tt.DrivePoolId, tt.drivePoolTypeId,
		tt.mountPathTypeId,
		tt.DrivePoolName,
		tt.DataPathFlag, tt.SpareGroupId,
		tt.SpareGroupName,
		tt.IdxCacheId, IC.description, tt.FlushBlockSizeKB, tt.ChunkSizeMB, tt.HWCompression,
		isnull(tnw.ClientInterface, ''), isnull(tnw.MAInterface, ''),
		tt.priority,
		NoOfClientSubSelects = (
						select count(*) from APP_AppToDataPath where DataPathId = tt.DataPathId
					),
		tt.HWEncryption, tt.hasNoData,
		DeviceTypeId = isnull((select DeviceTypeId from @tblDriveDevice where drivePoolId = tt.DrivePoolId), 0)
		from 	MMLibrary as ml, #tmpCopyFailover as tt left outer join #tmpNWIF AS tnw ON tnw.MAHostId = tt.HostId,
			IdxCache as IC
		where 	ml.LibraryId = tt.LibraryId
			and IC.IdxCacheId = tt.IdxCacheId
		-- For Storage Policy Report shows the default datapath first
		order by (tt.DataPathFlag & 1) desc
	end
	else
	begin
		select -1, 0, 'N/A', 0, 'N/A', 0, 'N/A', 0,
		0, 'N/A', 0, 0, 0, 'N/A', 1, 0, 'N/A', 0, 'N/A', 0, 0, 0, '', '', 0, 0, 0, 0, 0
	end
	drop table #tmpCopyFailover
	drop table #tmpNWIF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2getCopyFailOverConfig')
	delete from GxQscripts where name = 'MMS2getCopyFailOverConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2getCopyFailOverConfig')
	delete from GXDBVersions where aliasname = 'MMS2getCopyFailOverConfig'
GO

insert into GXDBVersions values(2, 'MMS2getCopyFailOverConfig',  '00010030003200050000', 'MMS2getCopyFailOverConfig', '00010030003200050000')
GO

