

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2getArchGrpNCopyListByLibIdEZ.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2getArchGrpNCopyListByLibIdEZ.sp,v $ $Id: MMS2getArchGrpNCopyListByLibIdEZ.sp,v 1.5.210.2 2018/03/20 19:44:59 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2getArchGrpNCopyListByLibIdEZ"					|
--	|																		|
--	|		Get the default copy for EZ storage policy of library			|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2getArchGrpNCopyListByLibIdEZ <<<'

IF EXISTS (select * from sysobjects where name='MMS2getArchGrpNCopyListByLibIdEZ')
	drop procedure MMS2getArchGrpNCopyListByLibIdEZ
IF EXISTS (select * from GxQscripts where name='MMS2getArchGrpNCopyListByLibIdEZ')
	delete from GxQscripts where name = 'MMS2getArchGrpNCopyListByLibIdEZ'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2getArchGrpNCopyListByLibIdEZ')
	delete from GXDBVersions where aliasname = 'MMS2getArchGrpNCopyListByLibIdEZ'
GO
print '... Creating Procedure: MMS2getArchGrpNCopyListByLibIdEZ'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2getArchGrpNCopyListByLibIdEZ
  @i_libId integer,
  @i_ezOnly integer
AS
  DECLARE @o_ArchGroupId integer
  DECLARE @o_ArchGroupName NVARCHAR(255)
  DECLARE @o_NumDedupCopies integer
  DECLARE @o_DefaultCopyId integer
  DECLARE @o_DefaultCopyName NVARCHAR(255)
  DECLARE @o_RetentionDays integer
  DECLARE @o_RetentionCycles integer
  DECLARE @o_DiskCapacity integer
  DECLARE @o_AutoManageDisk integer
	declare @CVA_SP_EZ_STORAGE_FLAG	integer
	declare @CVA_REGULAR_SP integer
	declare @AM_AGING_FLAGS_JUST_IN_TIME integer
	declare @IsMatador integer
	set @CVA_SP_EZ_STORAGE_FLAG = 128
	set @CVA_REGULAR_SP = 1
	set @AM_AGING_FLAGS_JUST_IN_TIME = 8
    if exists (select * from GXGlobalParam where name = 'matador' and value like '1')
        set @IsMatador = 1
    else
        set @IsMatador = 0
	declare @tblCopyForLib table (
		archGroupId int,
		archGroupName nvarchar(256),
		numDedupCopies int,
		defaultCopyId int,
		defaultCopyName nvarchar(256),
		retentionDays int,
		retentionCycles int,
		diskCapacity int,
		autoManageDisk int)
	-- Return storage policy created by EZ wizard and has default copy using the given library
	insert into @tblCopyForLib
	Select distinct ag.id, ag.name, 0, agc.id, agc.name, -1, -1, 0, 0
	from archgroup as ag WITH (NOLOCK),
			archgroupcopy as agc WITH (NOLOCK),
			MMMasterPool as mp WITH (NOLOCK),
			MMDrivePool as MDP WITH (NOLOCK),
			MMDataPath as dpath WITH (NOLOCK)
	where 	mp.LibraryId = @i_libId
	and mp.masterpoolid = MDP.masterpoolid
	and MDP.DrivePoolId = dpath.DrivePoolId
	and agc.id = dpath.CopyId
	and ag.id = agc.archgroupid
	and ag.defaultCopy = agc.id
	and ag.type = @CVA_REGULAR_SP
	and (@i_ezOnly = 0 or ag.flags & @CVA_SP_EZ_STORAGE_FLAG > 0 or @IsMatador = 1)
	update @tblCopyForLib
	set numDedupCopies =
		(SELECT COUNT(*) from archGroupCopy as B WITH (NOLOCK)
		where B.archGroupId = A.archGroupId and (B.dedupeFlags & 262144) > 0)
	from @tblCopyForLib as A
	update @tblCopyForLib
	set retentionDays = B.retentionDays,
	retentionCycles = B.fullCycles,
	autoManageDisk = case B.flags & @AM_AGING_FLAGS_JUST_IN_TIME when @AM_AGING_FLAGS_JUST_IN_TIME then 1 else 0 end
	from @tblCopyForLib as A, ArchAgingRule B WITH (NOLOCK)
	where B.CopyId = A.defaultCopyId
	update @tblCopyForLib
	set diskCapacity = (select ThresholdPercentage from MMLibrary WITH (NOLOCK) where libraryId = @i_libId)
	select * from @tblCopyForLib order by archGroupId desc
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2getArchGrpNCopyListByLibIdEZ')
	delete from GxQscripts where name = 'MMS2getArchGrpNCopyListByLibIdEZ'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2getArchGrpNCopyListByLibIdEZ')
	delete from GXDBVersions where aliasname = 'MMS2getArchGrpNCopyListByLibIdEZ'
GO

insert into GXDBVersions values(2, 'MMS2getArchGrpNCopyListByLibIdEZ',  '00010005021000020000', 'MMS2getArchGrpNCopyListByLibIdEZ', '00010005021000020000')
GO

