

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2WCSP_getFilteredMediaList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2WCSP_getFilteredMediaList.sp,v $ $Id: MMS2WCSP_getFilteredMediaList.sp,v 1.1.2.8 2018/09/29 18:26:44 vikramsingh Exp $";
-- 	+-----------------------------------------------------------------------------------------------+
--	| 	Cursor: "MMS2WCSP_getFilteredMediaList"							|
--	|			This SP fetches media list for admin console reports			|
--	|	Inputs: i_LibraryId  - id of the required Library					|
--	|		i_filterType - result set will be filtered on this parameter			|
--	|			 values  								|
--	|				NOFILTER : 0							|
--	|				ONLY_SPARE_MEDIA : 1						|
--	|				ONLY_CLEANING_MEDIA : 2						|
--	|				ONLY_AGED_MEDIA : 3						|
--	|				ONLY_ASSIGNED_MEDIA: 4						|
--	|				SLOT_VIEW : 5 --will return all slots even the ones without media|
--	|				IE_PORT_VIEW : 6 --returns all ports even the ones without media|
--	|		i_getExported - flag to say whether you want exported media or media in Library |
--	|			 values									|
--	|				FALSE : 0 --fetches media in library 				|
--	|				TRUE  : 1 --fetches exported media 				|
-- 	+-----------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2WCSP_getFilteredMediaList <<<'

IF EXISTS (select * from sysobjects where name='MMS2WCSP_getFilteredMediaList')
	drop procedure MMS2WCSP_getFilteredMediaList
IF EXISTS (select * from GxQscripts where name='MMS2WCSP_getFilteredMediaList')
	delete from GxQscripts where name = 'MMS2WCSP_getFilteredMediaList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2WCSP_getFilteredMediaList')
	delete from GXDBVersions where aliasname = 'MMS2WCSP_getFilteredMediaList'
GO
print '... Creating Procedure: MMS2WCSP_getFilteredMediaList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2WCSP_getFilteredMediaList
  @i_LibraryId int,
  @i_filterType int,
  @i_getExported int,
  @i_localeId int
AS
/*
Will cause error "An INSERT EXEC statement cannot be nested." if returning these
So the caller should create a table named #tempFilteredMediaList with this schema, and values will be inserted in the sp itself
  DECLARE @o_BarCode char(255)
  DECLARE @o_statusString nvarchar(255)
  DECLARE @o_ExportLocation nvarchar(255)
  DECLARE @o_slotName char(255)
  DECLARE @o_driveAliasName nvarchar(255)
  DECLARE @o_containerName nvarchar(255)
  DECLARE @o_archiveGroupName nvarchar(255)
  DECLARE @o_archiveGroupCopyName nvarchar(255)
  DECLARE @o_spareGroupName nvarchar(255)
  DECLARE @o_usageCounter integer
  DECLARE @o_numberOfExtRetentionJobsOnMedia integer
  DECLARE @o_numberOfSoftErrors integer
  DECLARE @o_numberOfHardErrors integer
  DECLARE @o_lastWriteTime nvarchar(255)
  DECLARE @o_physicalBytesMB bigint
  DECLARE @o_retentionExpireTime nvarchar(255)
*/
  DECLARE @o_errorCode integer
SET @o_errorCode = 0
IF (@i_filterType > 4 AND @i_getExported = 1)
BEGIN
	THROW 50001, 'Invalid usage of Stored Proc', 1
END
DECLARE @libraryType INTEGER
SET @libraryType = (SELECT LibraryTypeId FROM MMLibrary WHERE LibraryId = @i_LibraryId)
IF OBJECT_ID('tempdb.dbo.#tempMediaList') IS NOT NULL
	DROP TABLE #tempMediaList
CREATE TABLE #tempMediaList (
					o_MediaId			integer,
o_BarCode			varchar(255),
o_UniqueId			varchar(255),
					o_MediaLocation			integer,
o_ExportLocation		nvarchar(255),
					o_MediaTypeId			integer,
o_MediaTypeName                 nvarchar(255),
					o_MediaFlags			integer,
o_ExternalGUID			varchar(255),
					o_IsCleaningMedia		integer,
					o_MediaSideId			integer,
					o_VolumeId			integer,
					o_VolumeFlags			integer,
					o_MediaStatus			integer,
					o_slotId			integer,
o_slotName			char(255),
					o_slotElementAddress		integer,
					o_slotType			integer,
					o_driveId			integer,
o_driveAliasName		nvarchar(255),
					o_libraryId			integer,
o_libraryAliasName		nvarchar(255),
					o_lastWriteLibraryId		integer,
o_lastWriteLibName		nvarchar(255),
					o_containerId			integer,
o_containerName			nvarchar(255),
					o_mediaAttributes		integer,
					o_guiAttributes			integer,
					o_exportLocationId		integer,
					o_archiveGroupId		integer,
o_archiveGroupName		nvarchar(255),
					o_archiveGroupCopyId		integer,
o_archiveGroupCopyName		nvarchar(255),
					o_spareGroupId			integer,
o_spareGroupName		nvarchar(255),
					o_spareGroupType		integer,
					o_usageCounter			integer,
					o_numberOfExtRetentionJobsOnMedia  integer,
					o_numberOfSoftErrors		integer,
					o_numberOfHardErrors		integer,
					o_isAged			integer,
					o_isInMediaGroup		integer,
					o_isPrimaryCopy			integer,
					o_archStreamNum			integer,
					o_lastWriteTime			integer,
					o_physicalBytesMB		bigint,
					o_extendedAttributes		integer,
					o_retentionExpireTime		bigint,
lastWriteTimeStr		nvarchar(255),
retentionExpireTimeStr		nvarchar(255),
mediaStatusStr			nvarchar(255),
					mediaStatusReason		integer,
					creationTime		integer,
					lastExportTime		integer
				)
IF (@i_getExported <> 1 AND @libraryType <> 9)
BEGIN
	INSERT INTO #tempMediaList(o_MediaId, o_BarCode, o_UniqueId, o_MediaLocation, o_ExportLocation, o_MediaTypeId, o_MediaFlags, o_ExternalGUID, o_IsCleaningMedia,
					o_MediaSideId, o_VolumeId, o_VolumeFlags, o_MediaStatus, o_slotId, o_slotName, o_slotElementAddress, o_slotType, o_driveId, o_driveAliasName,
					o_libraryId, o_libraryAliasName, o_lastWriteLibraryId, o_lastWriteLibName, o_containerId, o_containerName, o_mediaAttributes, o_guiAttributes,
					o_exportLocationId, o_archiveGroupId, o_archiveGroupName, o_archiveGroupCopyId, o_archiveGroupCopyName, o_spareGroupId, o_spareGroupName,
					o_spareGroupType, o_usageCounter, o_numberOfExtRetentionJobsOnMedia, o_numberOfSoftErrors, o_numberOfHardErrors, o_isAged, o_isInMediaGroup,
					o_isPrimaryCopy, o_archStreamNum, o_lastWriteTime, o_physicalBytesMB, o_extendedAttributes, o_retentionExpireTime,mediaStatusReason,creationTime, lastExportTime, o_MediaTypeName)
		EXEC MMS2GUISP_getMediaList @i_LibraryId
END
ELSE IF (@i_getExported <> 1) --Deconfigured Library
BEGIN
	INSERT INTO #tempMediaList(o_MediaId, o_BarCode, o_UniqueId, o_MediaLocation, o_ExportLocation, o_MediaTypeId, o_MediaFlags, o_ExternalGUID, o_IsCleaningMedia,
					o_MediaSideId, o_VolumeId, o_VolumeFlags, o_MediaStatus, o_slotId, o_slotName, o_slotType, o_driveId, o_driveAliasName, o_lastWriteLibraryId,
					o_lastWriteLibName, o_libraryId, o_libraryAliasName, o_containerId, o_containerName, o_mediaAttributes, o_guiAttributes, o_exportLocationId,
					o_archiveGroupId, o_archiveGroupName, o_archiveGroupCopyId, o_archiveGroupCopyName, o_spareGroupId, o_spareGroupName, o_spareGroupType, o_usageCounter,
					o_numberOfExtRetentionJobsOnMedia, o_numberOfSoftErrors, o_numberOfHardErrors, o_isAged, o_isInMediaGroup, o_isPrimaryCopy, o_archStreamNum,
					o_lastWriteTime, o_physicalBytesMB, o_retentionExpireTime,mediaStatusReason,o_MediaTypeName)
		EXEC MMS2GUISP_getAssignedMediaList @i_LibraryId
END
ELSE
BEGIN
	INSERT INTO #tempMediaList(o_MediaId, o_BarCode, o_UniqueId, o_ExportLocation, o_MediaFlags, o_ExternalGUID, o_MediaTypeId, o_MediaTypeName, o_IsCleaningMedia,
					o_VolumeId, o_VolumeFlags, o_libraryId, o_libraryAliasName, o_lastWriteLibraryId, o_lastWriteLibName, o_containerId, o_containerName,
					o_mediaAttributes, o_guiAttributes, o_exportLocationId, o_archiveGroupId, o_archiveGroupName, o_archiveGroupCopyId, o_archiveGroupCopyName,
					o_spareGroupId, o_spareGroupName, o_spareGroupType, o_usageCounter, o_numberOfExtRetentionJobsOnMedia, o_numberOfSoftErrors, o_numberOfHardErrors,
					o_isAged, o_isInMediaGroup, o_isPrimaryCopy, o_archStreamNum, o_lastWriteTime, o_physicalBytesMB, o_retentionExpireTime,mediaStatusReason, creationTime,lastExportTime)
		EXEC MMS2GUISP_getExportedMediaList @i_LibraryId
END
UPDATE	#tempMediaList
SET	o_containerName = ''
WHERE 	o_containerId = 0
UPDATE	#tempMediaList
SET	lastWriteTimeStr = CAST(dbo.UTCToClientLocalTime(dbo.GetDateTime(o_lastWriteTime), 2) AS VARCHAR)
WHERE 	o_lastWriteTime > 0
UPDATE	#tempMediaList
SET	retentionExpireTimeStr = CAST(dbo.UTCToClientLocalTime(dbo.GetDateTime(o_retentionExpireTime), 2) AS VARCHAR)
WHERE 	o_retentionExpireTime > 0
UPDATE	#tempMediaList
SET	retentionExpireTimeStr = DBO.fn_EvFormatEventMsgText(0, @i_localeId, (468 | (CAST(POWER(2, 24) AS BIGINT) * 32)), 0, 2)
WHERE 	o_retentionExpireTime < 0
UPDATE	#tempMediaList
SET	mediaStatusStr = dbo.MMS2FUNC_GetGUIMediaAttributeStringWC(o_guiAttributes, @i_localeId)
IF(@i_filterType < 5)
BEGIN
	INSERT INTO #tempFilteredMediaList(o_BarCode, o_statusString, o_ExportLocation, o_slotName, o_driveAliasName, o_containerName, o_archiveGroupName, o_archiveGroupCopyName, o_spareGroupName, o_usageCounter, o_numberOfExtRetentionJobsOnMedia, o_numberOfSoftErrors, o_numberOfHardErrors, o_lastWriteTime, o_physicalBytesMB, o_retentionExpireTime)
		SELECT	o_BarCode,
			mediaStatusStr,
			o_ExportLocation,
			o_slotName,
			o_driveAliasName,
			o_containerName,
			o_archiveGroupName,
			o_archiveGroupCopyName,
			o_spareGroupName,
			o_usageCounter,
			o_numberOfExtRetentionJobsOnMedia,
			o_numberOfSoftErrors,
			o_numberOfHardErrors,
			lastWriteTimeStr,
			o_physicalBytesMB,
			retentionExpireTimeStr
		FROM	#tempMediaList
		WHERE @i_filterType = 0
OR (@i_filterType = 1 AND o_guiAttributes&( 1 		--MMS2_ASSIGNED_MEDIA
| 512 	--MMS2_CLEANING_MEDIA
| 524288 	--MMS2_NONGALAXY_MEDIA
| 131072 	--MMS2_DUPLICATE_MEDIA
| 1048576 ) = 0) 	--MMS2_INVALID_BARCODE_MEDIA
OR (@i_filterType = 2 AND o_guiAttributes&512 = 512) 	--MMS2_CLEANING_MEDIA
OR (@i_filterType = 3 AND o_guiAttributes&8388608 = 8388608) 		--MMS2_AGED_MEDIA
OR (@i_filterType = 4 AND o_guiAttributes&1 = 1) 	--MMS2_ASSIGNED_MEDIA
END
ELSE IF (@i_filterType = 5) --Slot View
BEGIN
	INSERT INTO #tempFilteredMediaList(o_BarCode, o_statusString, o_ExportLocation, o_slotName, o_driveAliasName, o_containerName, o_archiveGroupName, o_archiveGroupCopyName, o_spareGroupName, o_usageCounter, o_numberOfExtRetentionJobsOnMedia, o_numberOfSoftErrors, o_numberOfHardErrors, o_lastWriteTime, o_physicalBytesMB, o_retentionExpireTime)
		SELECT	o_BarCode,
			mediaStatusStr,
			o_ExportLocation,
			S.SlotName,
			o_driveAliasName,
			o_containerName,
			o_archiveGroupName,
			o_archiveGroupCopyName,
			o_spareGroupName,
			o_usageCounter,
			o_numberOfExtRetentionJobsOnMedia,
			o_numberOfSoftErrors,
			o_numberOfHardErrors,
			lastWriteTimeStr,
			o_physicalBytesMB,
			retentionExpireTimeStr
		FROM 	MMBay B
			INNER JOIN MMSlot S ON B.BayId = S.BayId
			LEFT OUTER JOIN (#tempMediaList M  LEFT OUTER JOIN MMDrive D ON M.o_driveId = D.DriveId)ON M.o_slotId = S.SlotId OR D.SlotElementAddress = S.ElementAddress
		WHERE 	B.LibraryId = @i_LibraryId
			AND S.SlotType = 1 -- =1 for slot view and >1 for IE port view
		ORDER BY S.SlotId
END
ELSE --IE Port View
BEGIN
	INSERT INTO #tempFilteredMediaList(o_BarCode, o_statusString, o_ExportLocation, o_slotName, o_driveAliasName, o_containerName, o_archiveGroupName, o_archiveGroupCopyName, o_spareGroupName, o_usageCounter, o_numberOfExtRetentionJobsOnMedia, o_numberOfSoftErrors, o_numberOfHardErrors, o_lastWriteTime, o_physicalBytesMB, o_retentionExpireTime)
		SELECT	o_BarCode,
			mediaStatusStr,
			o_ExportLocation,
			S.SlotName,
			o_driveAliasName,
			o_containerName,
			o_archiveGroupName,
			o_archiveGroupCopyName,
			o_spareGroupName,
			o_usageCounter,
			o_numberOfExtRetentionJobsOnMedia,
			o_numberOfSoftErrors,
			o_numberOfHardErrors,
			lastWriteTimeStr,
			o_physicalBytesMB,
			retentionExpireTimeStr
		FROM 	MMBay B
			INNER JOIN MMSlot S ON B.BayId = S.BayId
			LEFT OUTER JOIN #tempMediaList M ON M.o_slotId = S.SlotId
		WHERE 	B.LibraryId = @i_LibraryId
			AND S.SlotType > 1 -- =1 for slot view and >1 for IE port view
		ORDER BY S.SlotId
END
IF OBJECT_ID('tempdb.dbo.#tempMediaList') IS NOT NULL
	DROP TABLE #tempMediaList
RETURN @o_errorCode

IF EXISTS (select * from GxQscripts where name = 'MMS2WCSP_getFilteredMediaList')
	delete from GxQscripts where name = 'MMS2WCSP_getFilteredMediaList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2WCSP_getFilteredMediaList')
	delete from GXDBVersions where aliasname = 'MMS2WCSP_getFilteredMediaList'
GO

insert into GXDBVersions values(2, 'MMS2WCSP_getFilteredMediaList',  '00010001000200080000', 'MMS2WCSP_getFilteredMediaList', '00010001000200080000')
GO

