

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2UpdateVaultTrackerPolicyDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +===================================================================+
--  |               MMS2UpdateVaultTrackerPolicyDetails                   |
--  +===================================================================+
/*
<Api_UpdateVaultTrackerPolicyReq>
    <trackingPolicy enable="1" vaultTrackerPolicyType="1">
        <destinationLocation destinationType="2">
            <location locationId="1"/>
        </destinationLocation>
        <sourceLocation>
            <exportCriteria excludeMediaNotCopied="1" mediaState="1" tapeWrittenToLastDay="7">
                <limitMediaCountForExport limitMediaCount="1" value="20"/>
                <mediaGroups all="1"/>
                <mediaStatus activeAssignedMedia="1" appendableAssignedMedia="1" fullAssignedMedia="1"/>
            </exportCriteria>
            <libraryList _type_="9" libraryId="1" libraryName=" "/>
        </sourceLocation>
        <trackingPolicy trackingPolicyId="48" trackingPolicyName="VT"/>
    </trackingPolicy>
    <processinginstructioninfo>
        <locale _type_="66" localeId="0"/>
        <user _type_="13" userId="1" userName="admin"/>
    </processinginstructioninfo>
</Api_UpdateVaultTrackerPolicyReq>
*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2UpdateVaultTrackerPolicyDetails')
BEGIN
	print '>>> Drop Stored Procedure: MMS2UpdateVaultTrackerPolicyDetails <<<'
	drop procedure MMS2UpdateVaultTrackerPolicyDetails
END
IF EXISTS (select * from GxQscripts where name='MMS2UpdateVaultTrackerPolicyDetails')
	delete from GxQscripts where name = 'MMS2UpdateVaultTrackerPolicyDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2UpdateVaultTrackerPolicyDetails')
	delete from GXDBVersions where aliasname = 'MMS2UpdateVaultTrackerPolicyDetails'
GO
print '... Creating Procedure: MMS2UpdateVaultTrackerPolicyDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMS2UpdateVaultTrackerPolicyDetails
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS                         ---
  @ixml XML
-----------------------------------------------------------
AS
  DECLARE @o_errorCode INTEGER
  DECLARE @o_errorString NVARCHAR(MAX)
SET NOCOUNT ON
BEGIN TRY
BEGIN   TRANSACTION
    DECLARE @i_userId int
    DECLARE @i_localeId int = 0
	DECLARE @vtPolicyId int = 0
	DECLARE @description NVARCHAR(MAX)
DECLARE @policyName NVARCHAR(255)
	DECLARE @flag  int=0
	DECLARE @destinationType int=0
	DECLARE @orgDestId  int=0          -- this variable is initialized with existing "DestinationId" from table VTPolicy
	DECLARE @orgTransitId int=0        -- this variable is initialized with existing "InTransitId" from table VTPolicy
	DECLARE @destinationId int=0       -- this variable is initialized with destination "location id/Library id/Container ID" from XML
	DECLARE @destination_Id int=-1     -- this variable is initialized with existing "DestinationId" from table VTLocation Table
	DECLARE @desttype int=0
	DECLARE @destvalue int=0
	DECLARE @transitId int=0            --this variable is initialized with trasit location id from XML
	DECLARE @inTransit int=-1
	DECLARE @existingTransitValue int=0
	DECLARE @vtRule  int= 0
	DECLARE @limitCountSchemaType int=0
	DECLARE @limitCountValue int=0
	DECLARE @excludeMediaNotCopied int=0
	DECLARE @retentionDays int=0
	DECLARE @locationType int=2
	DECLARE @VTRuleToSchemaTemp TABLE
	(
	   schemaId    INT,
	   param	   INT,
	   flag        INT
	)
    SET @i_userId = ISNULL((SELECT  ref.value('@userId', 'int')
    FROM @ixml.nodes('Api_UpdateVaultTrackerPolicyReq/processinginstructioninfo/user') R ( ref )),0)
    SET @i_localeId = ISNULL((SELECT  ref.value('@localeId', 'int')
    FROM @ixml.nodes('Api_UpdateVaultTrackerPolicyReq/processinginstructioninfo/locale') R ( ref )),0)
	SELECT
	@vtPolicyId = ISNULL(Tbl.Col.value('(trackingPolicy/@trackingPolicyId)[1]', 'int'),0),
	@transitId = ISNULL(Tbl.Col.value('(trasitLocation/@locationId)[1]', 'int'),-1) ,
	@destinationType = ISNULL(Tbl.Col.value('(destinationLocation/@destinationType)[1]', 'int'),-1),
	@limitCountSchemaType = CASE ISNULL(Tbl.Col.value('(sourceLocation/exportCriteria/limitMediaCountForExport/@limitMediaCount)[1]', 'int'),-1)
WHEN 1 THEN  (SELECT SchemaId from  VTRuleSchema where type = 16)
WHEN 2 THEN  (SELECT SchemaId from  VTRuleSchema where type = 1024)
WHEN 3 THEN  (SELECT SchemaId from  VTRuleSchema where type = 512)
							 ELSE -1
							 END ,
	@limitCountValue = ISNULL(Tbl.Col.value('(sourceLocation/exportCriteria/limitMediaCountForExport/@value)[1]', 'int'),-1),
	@excludeMediaNotCopied = ISNULL(Tbl.Col.value('(sourceLocation/exportCriteria/@excludeMediaNotCopied)[1]', 'int'),-1),
	@retentionDays = ISNULL(Tbl.Col.value('(sourceLocation/exportCriteria/@tapeWrittenToLastDay)[1]', 'int'),-1) ,
    @policyName = (Tbl.Col.value('(trackingPolicy/@trackingPolicyName)[1]', 'nvarchar(256)')),
	@description = (Tbl.Col.value('(@description)[1]', 'nvarchar(max)'))
	FROM @ixml.nodes('Api_UpdateVaultTrackerPolicyReq/trackingPolicy') as Tbl(Col)
	SELECT	@destinationId =  CASE @destinationType
	                          WHEN 0 THEN 0
							  WHEN 1 THEN ISNULL(Tbl.Col.value('(destinationLocation/library/@libraryId)[1]', 'int'),-1)
							  WHEN 2 THEN ISNULL(Tbl.Col.value('(destinationLocation/location/@locationId)[1]', 'int'),-1)
							  WHEN 3 THEN ISNULL(Tbl.Col.value('(destinationLocation/shelf/@shelfId)[1]', 'int'),-1) END
	FROM @ixml.nodes('Api_UpdateVaultTrackerPolicyReq/trackingPolicy') as Tbl(Col)
   -- Check if policy exists with given VTpolicyId
   IF NOT EXISTS (SELECT 1 FROM VTPolicy WITH(READUNCOMMITTED)
				   WHERE PolicyId = @vtPolicyId)
		BEGIN
			SET @o_ErrorCode = 1
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (3874 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
			GOTO EXIT_HERE
		END
	-- Check if user is trying to update policy name with other existing policy
	IF EXISTS (SELECT 1 FROM VTPolicy WITH(READUNCOMMITTED)
                   WHERE Policyname = @policyName AND PolicyId != @vtPolicyId)
   		BEGIN
			SET @o_ErrorCode = 1
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (435 | (CAST(POWER(2, 24) AS BIGINT) * 62)) AND localeId = @i_localeId)
			GOTO EXIT_HERE
		END
	-- Check if no location exists with @destinationId
	IF @destinationType = 2
		BEGIN
			IF NOT EXISTS (SELECT 1 FROM MMExportLocation WITH (READUNCOMMITTED) WHERE ExportLocationId = @destinationId)
			BEGIN
				 SET @o_ErrorCode = 2
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (3872 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
				 GOTO EXIT_HERE
			END
		END
	-- Check if no library exits with @destinationId
	ELSE IF @destinationType = 1
		BEGIN
			IF NOT EXISTS (SELECT 1 FROM MMLibrary  WITH (READUNCOMMITTED) WHERE LibraryId = @destinationId)
			BEGIN
				 SET @o_ErrorCode = 3
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (3871 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
				 GOTO EXIT_HERE
			END
		END
    -- Check If transit location exists with given transit location
    IF @transitId > 0
		BEGIN
			IF NOT EXISTS (SELECT 1 FROM MMExportLocation WITH (READUNCOMMITTED) WHERE ExportLocationId = @transitId AND Type=2)
			BEGIN
				 SET @o_ErrorCode = 4
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (3873 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
				GOTO EXIT_HERE
			END
		END
	SET @o_ErrorCode = 0
	SET @o_ErrorString =''
	--Set Flags with existing values, later this can be set accordingly
	SELECT @Flag = flag, @orgDestId = DestinationId, @orgTransitId = InTransitId
	FROM VTPolicy  WITH (READUNCOMMITTED) WHERE PolicyId = @vtPolicyId
	SELECT @desttype = type, @destvalue = value
    FROM VTLocation  WITH (READUNCOMMITTED)
    WHERE locationid = @orgDestId
	--Updating destination Location
	IF  (@destinationType = @locationType AND @destinationId > 0) AND (@desttype!=@destinationType OR @destinationId!=@destvalue)
	  BEGIN
		    IF NOT EXISTS (SELECT 1 from VTLocation WITH(READUNCOMMITTED) WHERE value = @destinationId AND type = @locationType)
			   BEGIN
			       INSERT INTO VTLocation
			       VALUES(@locationType,@destinationId)
			   END
			    --Update in both cases (Adding New location or Using existing)
			 SELECT @destination_Id = (SELECT LocationId FROM VTLocation  WITH(READUNCOMMITTED) WHERE type=@locationType AND Value = @destinationId)
	   END
    SELECT  @existingTransitValue = value
    FROM VTLocation WITH(READUNCOMMITTED)
    WHERE locationid = @orgTransitId
	---Updating Transit location
	IF @transitId > -1
	BEGIN
      IF @transitId = 0
        BEGIN
		 SET @inTransit = 0
SET @flag |= ~2
        END
	  ELSE IF @transitId!=@existingTransitValue
	    BEGIN
		     IF NOT EXISTS (SELECT 1 from VTLocation WITH(READUNCOMMITTED) WHERE value = @transitId AND type = @locationType )
			   BEGIN
			       INSERT INTO VTLocation
			       VALUES(@locationType,@transitId)
			   END
			   --Update in both cases (Adding New Transit location or Using existing)
			   SELECT @inTransit = (SELECT LocationId FROM VTLocation  WITH(READUNCOMMITTED) WHERE value = @transitId AND type = @locationType )
SELECT @Flag |= 2
	    END
	END
	SELECT @flag  =   @flag |
		(	CASE  WHEN Tbl.Col.value('(@enable)[1]', 'int') > 0
THEN 1
				ELSE 0 END |
			CASE  WHEN Tbl.Col.value('(@autoAcknowledge)[1]', 'int') > 0
THEN 16
				ELSE 0 END
		)
		& ~
		(
			CASE  WHEN Tbl.Col.value('(@enable)[1]', 'int') = 0
THEN 1
					ELSE 0 END |
			CASE  WHEN Tbl.Col.value('(@autoAcknowledge)[1]', 'int') = 0
THEN 16
					ELSE 0 END
		)
		FROM @ixml.nodes('Api_UpdateVaultTrackerPolicyReq/trackingPolicy') as Tbl(Col)
	/*---------------------------------------------------------------------------------------------------------
						          Updating VTPolicy table
	-------------------------------------------------------------------------------------------------------------*/
	UPDATE VTPolicy
	SET PolicyName = ISNULL(@policyName,PolicyName),
	    flag  = @flag,
		destinationId = (CASE WHEN @destination_Id = -1 THEN destinationId ELSE @destination_Id END),
		inTransitId  = (CASE WHEN @inTransit = -1 THEN inTransitId ELSE @inTransit END),
		Descript = ISNULL(@description,Descript)
	WHERE policyid = @vtPolicyId
	/*---------------------------------------------------------------------------------------------------------
						          Updating VTRuleToSchema table
	-------------------------------------------------------------------------------------------------------------*/
	SELECT @vtRule = ruleId FROM VTPolicyToRule WITH(READUNCOMMITTED) WHERE PolicyId = @vtPolicyId
	INSERT INTO @VTRuleToSchemaTemp
	VALUES(1,ISNULL((SELECT param FROM VTRuleToSchema WHERE SchemaId = 1 AND RuleId =  @vtRule),0),0)
	UPDATE 	@VTRuleToSchemaTemp
	SET param = param |(
			CASE  WHEN Tbl.Col.value('(sourceLocation/exportCriteria/mediaStatus/@activeAssignedMedia)[1]', 'int') > 0
THEN 4
				ELSE 0 END |
			CASE  WHEN Tbl.Col.value('(sourceLocation/exportCriteria/mediaStatus/@appendableAssignedMedia)[1]', 'int') > 0
THEN 2
				ELSE 0 END |
			CASE  WHEN Tbl.Col.value('(sourceLocation/exportCriteria/mediaStatus/@fullAssignedMedia)[1]', 'int') > 0
THEN 1
					ELSE 0 END|
			CASE  WHEN Tbl.Col.value('(sourceLocation/exportCriteria/mediaStatus/@mediaState)[1]', 'int') = 1
THEN 131072 & ~( 1048576 | 524288)
					ELSE 0 END|
			CASE  WHEN Tbl.Col.value('(sourceLocation/exportCriteria/mediaStatus/@mediaState)[1]', 'int') = 2
THEN 1048576 & ~( 131072 | 524288)
					ELSE 0 END|
			CASE  WHEN Tbl.Col.value('(sourceLocation/exportCriteria/mediaStatus/@mediaState)[1]', 'int') = 3
THEN 524288 & ~( 131072 | 1048576)
					ELSE 0 END
		)
		& ~
		(
			CASE  WHEN Tbl.Col.value('(sourceLocation/exportCriteria/mediaStatus/@activeAssignedMedia)[1]', 'int') = 0
THEN 4
					ELSE 0 END |
			CASE  WHEN Tbl.Col.value('(sourceLocation/exportCriteria/mediaStatus/@appendableAssignedMedia)[1]', 'int') = 0
THEN 2
					ELSE 0 END |
			CASE  WHEN Tbl.Col.value('(sourceLocation/exportCriteria/mediaStatus/@fullAssignedMedia)[1]', 'int') = 0
THEN 1
					ELSE 0 END
		) FROM @ixml.nodes('Api_UpdateVaultTrackerPolicyReq/trackingPolicy') as Tbl(Col)
		WHERE schemaId = 1
	----------Updating TM_RULE_SCHEMA_TYPE_PRESERVE_MEDIA_NOT_COPIED ----------
	IF(@limitCountSchemaType>0 AND @limitCountValue>0)
		BEGIN
			INSERT INTO @VTRuleToSchemaTemp
			VALUES(@limitCountSchemaType,@limitCountValue,0)
		 END
    ----------Updating Preserve Media Not Copied ----------
	IF(@excludeMediaNotCopied>-1)
		BEGIN
		    INSERT INTO @VTRuleToSchemaTemp
			VALUES(9,@excludeMediaNotCopied,0)
		 END
	----------------------- Updating Tape written to in last -------------------------
	DECLARE @olderThanDaysSchemaType int  = (SELECT SchemaId from  VTRuleSchema where type = 4)
	IF(@retentionDays>-1)
		BEGIN
		   IF(@retentionDays=0)
		     BEGIN
				INSERT INTO @VTRuleToSchemaTemp
VALUES(@olderThanDaysSchemaType,@retentionDays, ~(2 | 64 | 4))
			 END
		   ELSE
		     BEGIN
	 			INSERT INTO @VTRuleToSchemaTemp
VALUES(@olderThanDaysSchemaType,@retentionDays,2 | 64 | 4)
			 END
		UPDATE @VTRuleToSchemaTemp
		SET flag = flag|ISNULL((SELECT flag FROM VTRuleToSchema WHERE SchemaId = @olderThanDaysSchemaType AND RuleId =  @vtRule),0)
		WHERE schemaId = @olderThanDaysSchemaType
		END
		MERGE   VTRuleToSchema AS VTRule
		USING   (SELECT * FROM @VTRuleToSchemaTemp) AS SRC
		ON      VTRule.SchemaId = SRC.schemaID AND VTRule.RuleId = @vtRule
		WHEN    MATCHED THEN UPDATE SET
					param  = SRC.param,
					flag   = SRC.flag
		WHEN    NOT MATCHED THEN INSERT VALUES
					(@vtRule, SRC.schemaID, SRC.param,SRC.flag);
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   SET @o_ErrorCode = ERROR_NUMBER()
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (18 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
END CATCH
EXIT_HERE:
IF @o_ErrorCode = 0
   COMMIT   TRANSACTION
ELSE
   ROLLBACK TRANSACTION
 				SELECT @o_ErrorCode, @o_ErrorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2UpdateVaultTrackerPolicyDetails')
	delete from GxQscripts where name = 'MMS2UpdateVaultTrackerPolicyDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2UpdateVaultTrackerPolicyDetails')
	delete from GXDBVersions where aliasname = 'MMS2UpdateVaultTrackerPolicyDetails'
GO

insert into GXDBVersions values(2, 'MMS2UpdateVaultTrackerPolicyDetails',  '00000000000000000000', 'MMS2UpdateVaultTrackerPolicyDetails', '00000000000000000000')
GO

