

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2UpdateSlotNBayConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2UpdateSlotNBayConfig.sp,v $ $Id: MMS2UpdateSlotNBayConfig.sp,v 1.44.32.9 2018/03/20 19:59:09 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2UpdateSlotNBayConfig <<<'

IF EXISTS (select * from sysobjects where name='MMS2UpdateSlotNBayConfig')
	drop procedure MMS2UpdateSlotNBayConfig
IF EXISTS (select * from GxQscripts where name='MMS2UpdateSlotNBayConfig')
	delete from GxQscripts where name = 'MMS2UpdateSlotNBayConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2UpdateSlotNBayConfig')
	delete from GXDBVersions where aliasname = 'MMS2UpdateSlotNBayConfig'
GO
print '... Creating Procedure: MMS2UpdateSlotNBayConfig'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2UpdateSlotNBayConfig
  @i_libraryId integer,
  @i_configScope integer,
  @i_isBlind integer
AS
  DECLARE @errorCode integer
  DECLARE @errorString char(255)
  DECLARE @rowcnt INT
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	/* The value of @i_configScope
	enum ConfigScope
	{
		SCOPE_NONE = 0,
		SCOPE_PARTIAL,
		SCOPE_FULL
	};*/
	SET	@errorCode = 0
	SET	@errorString = ''
	DECLARE @LibraryExtendedAttributes	INTEGER
	DECLARE @CurrentTime INTEGER = dbo.GetUnixTime(GETUTCDATE())
	CREATE TABLE #MediaInSlotDrive
	(
		MediaId				integer,
		Barcode 			varchar(256),
		LibraryId			integer,
		MediaLocation		integer,
		MediaFlags			integer,
		MediaStatusReason	integer,
		ExportLocationId	integer,
		Attributes			integer,
		ContainerId			integer,
		IsInMediaGroup		integer,
		RMSpareStatus		integer,
		SlotType			integer,
		InSlot				integer,
		LastExportTime			integer
	)
	CREATE INDEX MediaInSlotDrive_MediaId_idx ON #MediaInSlotDrive(MediaId)
	CREATE INDEX MediaInSlotDrive_Barcode_idx ON #MediaInSlotDrive(Barcode)
	IF object_id('CommServ.dbo.MMTmpDriveConfig') IS NOT null
	BEGIN
		INSERT INTO #MediaInSlotDrive
    	SELECT	M.MediaId, M.Barcode, M.LibraryId, M.MediaLocation, M.MediaFlags, M.MediaStatusReason,
			M.ExportLocationId, M.Attributes, M.ContainerId, M.IsInMediaGroup, M.RMSpareStatus, T.SlotType, T.InSlot, M.LastExportTime
		FROM	MMMedia M WITH (READUNCOMMITTED),
			(SELECT	CartridgePCL, SlotType, 1 AS InSlot
			FROM	MMTmpSlotConfig WITH (READUNCOMMITTED)
			UNION
			SELECT	CartridgePCL, 0, 0
			FROM	MMTmpDriveConfig WITH (READUNCOMMITTED)) T
		WHERE	M.BarCode = T.CartridgePCL
	END
	SET @rowcnt = @@ROWCOUNT
	-- Declare media unknown should be done only in the case of non blind library and the config level is full.
	IF	(@i_isBlind = 0) AND (@i_configScope = 2)
	BEGIN
	  IF  (@rowcnt > 0)
	  BEGIN
	    -- IF rowcnt = 0, then we have to check for media that might have been exported from IE port to shelf. MR 32282.
		-- Reset the ContainerId to zero when the spare media reappears in the library based on the attributes at the library level
		SELECT @LibraryExtendedAttributes = ExtendedAttributes FROM MMLibrary WITH (READUNCOMMITTED) WHERE LibraryId = @i_libraryId
		DECLARE @lt_MediaToUpdate TABLE
		(
			MediaId				integer,
			MediaLocation		integer,
			MediaFlags			integer,
			MediaStatusReason	integer,
			ExportLocationId	integer,
			Attributes			integer,
			ContainerId			integer,
			IsInMediaGroup		integer,
			RMSpareStatus		integer,
			LastExportTime		integer
		)
		-- These are the media that WERE exported and now IN the library and that are spare.
		INSERT INTO @lt_MediaToUpdate
		SELECT	M.MediaId, (case when (M.SlotType = 0 AND M.InSlot = 0) then 2 when (M.InSlot = 1) then 1 else M.MediaLocation end), M.MediaFlags, M.MediaStatusReason, M.ExportLocationId,
				M.Attributes, M.ContainerId, M.IsInMediaGroup, M.RMSpareStatus, M.LastExportTime
		FROM	#MediaInSlotDrive M
				LEFT OUTER JOIN MMMediaExport ME  WITH (READUNCOMMITTED) ON M.MediaId = ME.MediaId
				LEFT OUTER JOIN VTActionMedia VTA WITH (READUNCOMMITTED) ON M.MediaId = VTA.MediaId
		WHERE	ME.MediaId IS NULL AND VTA.MediaId IS NULL
			AND M.LibraryId = @i_libraryId
			AND M.MediaLocation = 3
			AND (M.Attributes & 1) = 0
			AND (M.InSlot = 0 OR M.SlotType IN (1,2)) /* (REGULAR_SLOT, MAIL_SLOT) */
			AND (M.ContainerId <> 0 OR M.ExportLocationId <> 0)
			AND (M.IsInMediaGroup = 0
OR (@LibraryExtendedAttributes & (128 | 256)) > 0)
		UPDATE	@lt_MediaToUpdate
		SET		ContainerId = 0
WHERE	(IsInMediaGroup > 0 AND (@LibraryExtendedAttributes & 128) > 0)
		UPDATE	@lt_MediaToUpdate
		SET		ExportLocationId = 0
WHERE	(IsInMediaGroup > 0 AND (@LibraryExtendedAttributes & 256) > 0)
		-- Declare Media unknown
		INSERT INTO @lt_MediaToUpdate
	    SELECT	M.MediaId, 3, M.MediaFlags, M.MediaStatusReason, M.ExportLocationId,
(M.Attributes & ~1 & ~16777216), M.ContainerId, M.IsInMediaGroup, M.RMSpareStatus, DATEDIFF(second, '01/01/1970', GETUTCDATE())
		FROM	MMMedia M WITH (READUNCOMMITTED)
				LEFT OUTER JOIN #MediaInSlotDrive I ON M.MediaId = I.MediaId
		WHERE	I.MediaId IS NULL
			AND M.LibraryId = @i_libraryId
AND (M.MediaLocation <> 3 OR (M.Attributes & (1 | 16777216)) > 0)
		-- Declare Media known
		INSERT INTO @lt_MediaToUpdate
	    SELECT	M.MediaId, 1, M.MediaFlags, M.MediaStatusReason, M.ExportLocationId,
				M.Attributes, M.ContainerId, M.IsInMediaGroup, M.RMSpareStatus, M.LastExportTime
		FROM	#MediaInSlotDrive M
				LEFT OUTER JOIN @lt_MediaToUpdate U ON M.MediaId = U.MediaId
		WHERE	U.MediaId IS NULL
			AND M.InSlot = 1
			AND (M.LibraryId <> @i_libraryId OR M.MediaLocation <> 1)
		-- Update all the volumes that were in stuck state
		DECLARE @lt_VolumesToUpdate TABLE
		(
			VolumeId		integer,
			VolumeState		integer
		)
		INSERT INTO @lt_VolumesToUpdate
		SELECT	V.VolumeId, 0
		FROM	MMVolume V WITH (READUNCOMMITTED), #MediaInSlotDrive M
		WHERE	V.VolumeState = 2 AND V.MediaId = M.MediaId AND M.InSlot = 1
	  END
	  ELSE
	  BEGIN
 	  -- Declare Media unknown
	  INSERT INTO @lt_MediaToUpdate
	  SELECT	M.MediaId, 3, M.MediaFlags, M.MediaStatusReason, M.ExportLocationId,
(M.Attributes & ~1 & ~16777216), M.ContainerId, M.IsInMediaGroup, M.RMSpareStatus, DATEDIFF(second, '01/01/1970', GETUTCDATE())
	  FROM	MMMedia M WITH (READUNCOMMITTED)
			LEFT OUTER JOIN #MediaInSlotDrive I ON M.MediaId = I.MediaId
	  WHERE	I.MediaId IS NULL
			AND M.LibraryId = @i_libraryId
AND (M.MediaLocation <> 3 OR (M.Attributes & (1 | 16777216)) > 0)
	  END
	END
	-- Get the Bay Config to update or insert here
	DECLARE @lt_BaysToUpdate TABLE
	(
		BayId			integer,
		BayAccessible	integer
	)
	INSERT INTO @lt_BaysToUpdate
	SELECT	B.BayId, TSC.isBayAccessible
	FROM	MMTmpSlotConfig TSC WITH (READUNCOMMITTED), MMBay B WITH (READUNCOMMITTED)
	WHERE	TSC.BayName = B.BayName and B.LibraryId = @i_libraryId
		AND (B.BayAccessible <> TSC.isBayAccessible)
	DECLARE @lt_BaysToInsert TABLE
	(
		LibraryId		integer,
		BayName			varchar(20),
		BayAccessible	integer
	)
	INSERT INTO @lt_BaysToInsert
	SELECT	DISTINCT @i_libraryId, TSC.BayName, TSC.isBayAccessible
	FROM	MMTmpSlotConfig TSC WITH (READUNCOMMITTED)
			LEFT OUTER JOIN MMBay B WITH (READUNCOMMITTED) ON B.LibraryId = @i_libraryId and B.BayName = TSC.BayName
	WHERE	B.LibraryId IS NULL
	-- Now delete, insert and update
	IF EXISTS (SELECT MediaId FROM @lt_MediaToUpdate)
	BEGIN
		UPDATE	MMMedia
		SET		LibraryId = @i_libraryId, MediaLocation = T.MediaLocation, MediaFlags = T.MediaFlags,
				MediaStatusReason = T.MediaStatusReason, ExportLocationId = T.ExportLocationId,
				Attributes = T.Attributes, ContainerId = T.ContainerId,
				IsInMediaGroup = T.IsInMediaGroup, RMSpareStatus = T.RMSpareStatus,
				LastExportTime = T.LastExportTime
		FROM	@lt_MediaToUpdate T
		WHERE	MMMedia.MediaId = T.MediaId
		INSERT 	INTO MMTapeStateHistory(MediaId, BarCode, LibraryId, LibraryName, MediaLocation,
			MarkedForExport, SlotId, SlotName, DriveId, DriveName, ContainerId, ContainerName,
			ExportLocationId, ExportLocation, ExportTime, ImportTime, UpdateTime)
		SELECT	MMMed.MediaId, MMMed.BarCode,
				MML.LibraryId,
				MML.AliasName,
				(CASE WHEN T.MediaLocation = 1 THEN 'In Slot' WHEN T.MediaLocation = 2 THEN 'In Drive' ELSE 'Exported' END),
				(CASE WHEN T.MediaLocation = 3 THEN (CASE WHEN (SELECT COUNT(*) FROM MMMediaExport MME with(READUNCOMMITTED) WHERE MME.MediaId = T.MediaId) > 0 THEN 1 ELSE 0 END)  ELSE 0 END),
				(CASE WHEN T.MediaLocation = 3 THEN MMS.SlotId ELSE MMST.SlotId END),
				(CASE WHEN T.MediaLocation = 3 THEN MMS.SlotName ELSE MMST.SlotName END),
				MMD.DriveId,
				MMD.DriveName,
				MMC.ContainerId,
				CASE WHEN MMC.ContainerId = 0 THEN '' ELSE MMC.ContainerName END,
				MMexp.ExportLocationId,
				MMexp.ExportLocation,
				(CASE T.MediaLocation WHEN 3 THEN T.LastExportTime ELSE NULL END),
				(CASE T.MediaLocation WHEN 3 THEN NULL ELSE @CurrentTime END),
				@CurrentTime
		FROM	@lt_MediaToUpdate T
		JOIN	MMMedia MMMed with(READUNCOMMITTED) ON MMMed.MediaId = T.MediaId
		LEFT JOIN	MMExportLocation MMexp with(READUNCOMMITTED) on T.ExportLocationId = MMexp.ExportLocationId
		LEFT JOIN	MMLibrary MML with(READUNCOMMITTED) on MMMed.LibraryId = MML.LibraryId
		LEFT JOIN	MMSlot MMS with(READUNCOMMITTED) on T.MediaId = MMS.MediaId
		LEFT JOIN	MMDrive MMD with(READUNCOMMITTED) on T.MediaId = MMD.mediaid
		LEFT JOIN	MMTmpSlotConfig MMTSC with(READUNCOMMITTED) on MMTSC.CartridgePCL = MMMed.BarCode AND MMTSC.libraryId = MML.LibraryId
		LEFT JOIN	MMBay MMB with(READUNCOMMITTED) on MMTSC.libraryId = MMB.LibraryId AND MMTSC.BayName = MMB.BayName
		LEFT JOIN	MMSlot MMST with(READUNCOMMITTED) on MMTSC.SlotName = MMST.SlotName AND MMST.BayId = MMB.BayId
		LEFT JOIN	MMContainer MMC with(READUNCOMMITTED) on T.ContainerId = MMC.ContainerId
	END
	IF EXISTS (SELECT VolumeId FROM @lt_VolumesToUpdate)
		UPDATE	MMVolume
		SET		VolumeState = T.VolumeState
		FROM	@lt_VolumesToUpdate T
		WHERE	MMVolume.VolumeId = T.VolumeId
	IF EXISTS (SELECT BayId FROM @lt_BaysToUpdate)
		UPDATE	MMBay
		SET		BayAccessible = T.BayAccessible
		FROM	@lt_BaysToUpdate T
		WHERE	MMBay.BayId = T.BayId
	IF EXISTS (SELECT LibraryId FROM @lt_BaysToInsert)
		INSERT INTO MMBay
		SELECT	LibraryId, BayName, BayAccessible
		FROM	@lt_BaysToInsert
	-- If it is ia blind library, or it is a partial config then don't do the slot Config update here.
	IF ((@i_isBlind = 1) OR (@i_configScope = 1))
		GOTO error_exit
	--DECLARE @lt_SlotToInsert TABLE
	--(
	--	SlotName			varchar(32),
	--	BayId				integer,
	--	IsGalaxyMedia		integer,
	--	BarCode				varchar(256),
	--	MediaId				integer,
	--	IsOccupied			integer,
	--	CartridgeType		varchar(256),
	--	MediaStatus			integer,
	--	ConfidenceLevel		integer,
	--	InventoryTimeStamp	integer,
	--	InventoryStatus		integer,
	--	IsAccessible		integer,
	--	ElementAddress		integer,
	--	SlotType			integer
	--
	CREATE TABLE #lt_SlotToInsert
	(
		SlotName			varchar(32),
		BayId				integer,
		IsGalaxyMedia		integer,
		BarCode				varchar(256),
		MediaId				integer,
		IsOccupied			integer,
		CartridgeType		varchar(256),
		MediaStatus			integer,
		ConfidenceLevel		integer,
		InventoryTimeStamp	integer,
		InventoryStatus		integer,
		IsAccessible		integer,
		ElementAddress		integer,
		SlotType			integer
	)
	INSERT INTO #lt_SlotToInsert
	SELECT	TSC.SlotName, B.BayId, TSC.isOccupied, TSC.CartridgePCL, 0, TSC.isOccupied,
			TSC.CartridgeType, 0, 2, DATEDIFF(second, '01/01/1970', GETUTCDATE()), 0,
			TSC.isAccessible, TSC.ElementAddress, TSC.slotType
	FROM	MMTmpSlotConfig TSC WITH (READUNCOMMITTED), MMBay B WITH (READUNCOMMITTED)
	WHERE	TSC.LibraryId = @i_libraryId and TSC.LibraryId = B.LibraryId
		AND TSC.BayName = B.BayName
	ORDER BY TSC.ElementAddress ASC
	-- Update the slots for non galaxy media
	UPDATE	#lt_SlotToInsert
	SET		MediaStatus = MediaStatus | 2
	WHERE	BarCode = '' AND IsOccupied = 1
	-- ((S.IsAccessible & 6) <> 0)  Here we would like to see if the slots are import or export CAPs,
	-- 2 = MMS2_SLOT_DEFAULT_IMPORT, 4 = MMS2_SLOT_DEFAULT_EXPORT
	UPDATE	#lt_SlotToInsert
	SET		IsAccessible = STI.IsAccessible | (S.IsAccessible & 6)
	FROM	#lt_SlotToInsert STI, MMSlot S WITH (READUNCOMMITTED)
	WHERE	S.slotName = STI.SlotName AND S.SlotType = 3 /* CAP_SLOT */ AND (S.IsAccessible & 6) <> 0
	-- Declare the media known
	UPDATE	#lt_SlotToInsert
	SET		MediaId = M.MediaId, isGalaxyMedia = 1
	FROM	#lt_SlotToInsert S, #MediaInSlotDrive M
	WHERE	M.BarCode = S.BarCode AND M.InSlot = 1
	IF EXISTS (SELECT BayId FROM #lt_SlotToInsert)
	BEGIN
		DELETE	FROM MMSlot
		WHERE	BayId in (SELECT DISTINCT BayId FROM #lt_SlotToInsert)
		INSERT	INTO MMSlot
		SELECT * FROM #lt_SlotToInsert
	END
	-- Update source element address for media that are pending export. MR 71289.
	UPDATE MMMediaExport SET SourceElementAddress = MS.ElementAddress
	FROM MMMediaExport ME INNER JOIN MMSlot MS ON ME.MediaId = MS.MediaId
	WHERE ME.SourceElementAddress != MS.ElementAddress AND MS.SlotType = 1 /* REGULAR_SLOT */ AND ME.DestinationElementAddress = 0
	AND ME.LibraryControllerId IN (SELECT LibraryControllerId FROM MMLibraryController where LibraryId = @i_libraryId)
	-- Detect and declare duplicate media here.
	DECLARE @lt_MediaBarcode TABLE
	(
		MediaId				integer,
BarCode				varchar(255),
		IsInMediaGroup		integer
	)
	INSERT	INTO @lt_MediaBarcode
	SELECT	MediaId, BarCode, IsInMediaGroup
	FROM	MMMedia WITH (READUNCOMMITTED)
	WHERE	BarCode in (SELECT	BarCode FROM MMMedia WITH (READUNCOMMITTED)
						WHERE	BarCode <> '' AND MediaTypeId <> 10001
						GROUP	BY BarCode
						HAVING	COUNT(BarCode) > 1)
	INSERT	INTO @lt_MediaBarcode
	SELECT	MediaId, BarCode, (SELECT IsInMediaGroup FROM MMMedia WITH (READUNCOMMITTED) WHERE MediaId = MMSlot.MediaId)
	FROM	MMSlot WITH (READUNCOMMITTED)
	WHERE	BarCode in (SELECT	BarCode FROM MMSlot WITH (READUNCOMMITTED)
						WHERE	BarCode <> '' AND SlotType = 1
						GROUP	BY BarCode
						HAVING	COUNT(BarCode) > 1)
		AND BarCode NOT in (SELECT BarCode FROM @lt_MediaBarcode)
	--AND SlotType = 1 /* REGULAR_SLOT */
	IF EXISTS (select MediaId from @lt_MediaBarcode)
	BEGIN
		UPDATE	MMSlot
		SET		MediaStatus = (MediaStatus | 1), MediaId = 0
		WHERE	BarCode in (SELECT BarCode FROM @lt_MediaBarcode)
		AND	SlotType = 1 /* REGULAR_SLOT */
		-- Set these duplicate active media as bad, so that the backup jobs wouldn't try to reserve these media
		UPDATE	MMMedia
		SET		MediaFlags = 2, MediaStatusReason = 14
		WHERE	MediaId in (select distinct MediaId from @lt_MediaBarcode where MediaId > 0 AND IsInMediaGroup = 1)
		AND		IsInMediaGroup = 1 AND (MediaFlags <> 2 OR MediaStatusReason <> 14)
		UPDATE	MMVolume
		SET		VolumeFlags = 4
		WHERE	MediaId in (select distinct MediaId from @lt_MediaBarcode where MediaId > 0 AND IsInMediaGroup = 1)
			AND (VolumeFlags <> 4)
	END
error_exit:
	EXEC SQLUtilTruncateTable 'MMTmpSlotConfig'
	DROP TABLE #MediaInSlotDrive
	IF object_id('tempdb.dbo.#lt_SlotToInsert') IS NOT NULL
	BEGIN
		DROP TABLE #lt_SlotToInsert
	END
	select @errorCode, @errorString, @rowcnt
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2UpdateSlotNBayConfig')
	delete from GxQscripts where name = 'MMS2UpdateSlotNBayConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2UpdateSlotNBayConfig')
	delete from GXDBVersions where aliasname = 'MMS2UpdateSlotNBayConfig'
GO

insert into GXDBVersions values(2, 'MMS2UpdateSlotNBayConfig',  '00010044003200090000', 'MMS2UpdateSlotNBayConfig', '00010044003200090000')
GO

