

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2UpdateMediaExtRetFlagFromTrackingTable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2UpdateMediaExtRetFlagFromTrackingTable.sp,v $ $Id: MMS2UpdateMediaExtRetFlagFromTrackingTable.sp,v 1.7.46.10 2019/12/12 19:18:23 pkrishnan Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "MMS2UpdateMediaExtRetFlagFromTrackingTable"					|
--	|																																				|
--	|   This procedure will update the retentionFlags column  |
--	|   in the MMMedia table for all those media whose status changed  		 |
--	|   since the last dataaging operation was run. 												|
--  |																																				|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2UpdateMediaExtRetFlagFromTrackingTable')
BEGIN
	print '>>> Drop Stored Procedure: MMS2UpdateMediaExtRetFlagFromTrackingTable <<<'
	drop procedure MMS2UpdateMediaExtRetFlagFromTrackingTable
END
IF EXISTS (select * from GxQscripts where name='MMS2UpdateMediaExtRetFlagFromTrackingTable')
	delete from GxQscripts where name = 'MMS2UpdateMediaExtRetFlagFromTrackingTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2UpdateMediaExtRetFlagFromTrackingTable')
	delete from GXDBVersions where aliasname = 'MMS2UpdateMediaExtRetFlagFromTrackingTable'
GO
print '... Creating Procedure: MMS2UpdateMediaExtRetFlagFromTrackingTable'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2UpdateMediaExtRetFlagFromTrackingTable
  @dummy integer
AS
  DECLARE @r_errorCode integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
set @r_ErrorCode = 0
DECLARE @defaultCCId INT = 2
-- DO not run if dataaging is running - as dataaging will do this also for ALL media.
DECLARE @l_EnableDACSLevelMediaRetentionRecompute INT = 1
SELECT	@l_EnableDACSLevelMediaRetentionRecompute = value
FROM	MMConfigs WITH(NOLOCK)
WHERE	name = 'DA_CONFIG_ENABLE_CSLEVEL_MEDIA_RETENTION_RECOMPUTE'
IF EXISTS (SELECT JobId FROM JMAdminJobInfoTable WITH (NOLOCK)
		   where opType = 10 and commCellId = @defaultCCId) AND (@l_EnableDACSLevelMediaRetentionRecompute > 0)
BEGIN
	GOTO FINISHED
END
-- Phase one - get jobs that have been changed
DECLARE @l_TrackingId BIGINT
DECLARE @l_MinTrackingId BIGINT
SELECT @l_TrackingId = max(TrackingId), @l_MinTrackingId = min(TrackingId)
FROM JMJobDataStatsTracking WITH(NOLOCK)
IF @l_TrackingId is NULL
GOTO FINISHED
DECLARE @l_MaxEntriesToConsider INTEGER
SELECT @l_MaxEntriesToConsider = value
FROM MMConfigs WHERE name = 'DA_CONFIG_MEDIAEXTRETCALC_MAXENTRIES'
IF @l_MaxEntriesToConsider is NULL
BEGIN
	SET @l_MaxEntriesToConsider = 5000
END
IF ((@l_MaxEntriesToConsider > 0) AND
	((@l_TrackingId - @l_MinTrackingId) > @l_MaxEntriesToConsider ))
BEGIN
	SET @l_TrackingId = @l_MinTrackingId + @l_MaxEntriesToConsider
END
IF OBJECT_ID('tempdb..#CopyIds') IS NOT NULL DROP TABLE #CopyIds
CREATE TABLE #CopyIds (copyId INT primary key)
INSERT INTO #CopyIds
SELECT DISTINCT archGrpCopyId FROM JMJobDataStatsTracking WITH(NOLOCK) WHERE TrackingId <= @l_TrackingId
--Find copies that have at least one tape volume
DELETE #CopyIds WHERE copyId NOT IN
(
SELECT DISTINCT T.copyId
FROM #CopyIds T INNER JOIN archStream ACS WITH(NOLOCK) ON T.copyId = ACS.archGroupCopyId
INNER JOIN MMMediaGroup MMG WITH(NOLOCK) ON ACS.mediaGroupId = MMG.mediaGroupId AND ACS.mediaGroupId > 0
INNER JOIN MMVolume Vol WITH(NOLOCK) ON MMG.mediaGroupId = Vol.mediaGroupId AND Vol.RecordingFormatId <> 10001
)
--Do not process those entries belonging to copies that have no tape media
DELETE JMJobDataStatsTracking
WHERE archGrpCopyId > 0 AND archGrpCopyId NOT IN (SELECT copyId FROM #CopyIds) AND TrackingId <= @l_TrackingId
IF OBJECT_ID('tempdb..#CopyIds') IS NOT NULL DROP TABLE #CopyIds
--Exit if we have removed all entries. If there are more entries than @l_MaxEntriesToConsider they will be processed in next iteration
IF NOT EXISTS(SELECT 1 FROM JMJobDataStatsTracking WITH(NOLOCK) WHERE TrackingId <= @l_TrackingId)
	GOTO FINISHED
IF OBJECT_ID('tempdb..#JobIds') IS NOT NULL DROP TABLE #JobIds
CREATE TABLE #JobIds (jobId INT, commcellId INT, copyId INT, dataType INT, appId int, fullCycleNum int)
CREATE CLUSTERED INDEX tempJobIds_jobId_commcellId_copyId_dataType ON #JobIds(jobId, commCellId, copyId, dataType)
CREATE INDEX tempJobIds_appId_fullCycleNum ON #JobIds(appId, fullCycleNum)
IF OBJECT_ID('tempdb..#tmpJobsInCycle') IS NOT NULL DROP TABLE #tmpJobsInCycle
CREATE TABLE #tmpJobsInCycle (jobId INT, commcellId INT, appId int, fullCycleNum int)
CREATE CLUSTERED INDEX tmpJobsInCycle_jobId_commcellId ON #tmpJobsInCycle(jobId, commCellId)
CREATE INDEX tmpJobsInCycle_appId_fullCycleNum ON #tmpJobsInCycle(appId, fullCycleNum)
/*The tracking table can have jobids and also only copy ids with jobid - 0*/
INSERT INTO #JobIds
SELECT DISTINCT T.jobId, T.commCellId, T.archGrpCopyId, T.dataType, JBKP.appId, JBKP.fullCycleNum
FROM JMJobDataStatsTracking T WITH (NOLOCK), JMBkpStats JBKP WITH (NOLOCK)
WHERE T.TrackingId <= @l_TrackingId
AND 	T.jobId > 0
AND 	T.jobId = JBKP.jobId
AND 	T.commcellId = JBKP.commcellId
INSERT INTO #JobIds
SELECT DISTINCT T.jobId, T.commCellId, T.archGrpCopyId, T.dataType, JAD.appId, JAD.fullCycleNum
FROM JMJobDataStatsTracking T WITH (NOLOCK), JMAdminJobStatsTable JAD WITH (NOLOCK)
WHERE T.TrackingId <= @l_TrackingId
AND 	T.jobId > 0
AND 	T.jobId = JAD.jobId
AND 	T.commcellId = JAD.commcellId
/*Get other jobs of the cycle so their media retention end time is recalculated for cycle dependency*/
INSERT INTO #tmpJobsInCycle
SELECT DISTINCT JBKP.jobId, JBKP.commCellId, JBKP.appId, JBKP.fullCycleNum
FROM #JobIds T, JMBkpStats JBKP WITH (NOLOCK)
WHERE T.appId = JBKP.appId
AND 	T.fullCycleNum = JBKP.fullCycleNum
AND		T.dataType != 4
INSERT INTO #tmpJobsInCycle
SELECT DISTINCT JAD.jobId, JAD.commCellId, JAD.appId, JAD.fullCycleNum
FROM #JobIds T, JMAdminJobStatsTable JAD WITH (NOLOCK)
WHERE T.appId = JAD.appId
AND 	T.fullCycleNum = JAD.fullCycleNum
AND		T.dataType != 4
INSERT INTO #JobIds
SELECT DISTINCT JDS.jobId, JDS.commCellId, JDS.archGrpCopyId, JDS.dataType, TMP.appId, TMP.fullCycleNum
FROM #JobIds T, #tmpJobsInCycle TMP, JMJobDataStats JDS WITH (NOLOCK)
WHERE T.appId = TMP.appId
AND 	T.fullCycleNum = TMP.fullCycleNum
AND		TMP.jobId = JDS.jobId
AND 	TMP.commcellId = JDS.commcellId
AND 	T.copyId = JDS.archGrpCopyId
AND 	T.dataType = JDS.dataType
AND		T.dataType != 4
DECLARE @computeVSAJobRetention int = 0
SELECT @computeVSAJobRetention = ISNULL(value, 0)
FROM MMConfigs WITH(NOLOCK)
WHERE name = 'MMCONFIG_COMPUTE_VSA_JOB_RETENTION_BASED_ON_VM_JOBS'
IF @computeVSAJobRetention = 1
BEGIN
	--Populate VSA parent jobs, so their media retention can be recomputed
	INSERT INTO #JobIds
	SELECT DISTINCT JDS.jobId, JDS.commcellId, JDS.archGrpCopyId, JDS.dataType, 0, 0
	FROM #JobIds T1 INNER JOIN JMJobDataLink JDL WITH(NOLOCK) ON T1.jobId = JDL.childJobId AND T1.commcellId = JDL.commcellId
	INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JDL.parentJobId = JDS.jobId AND JDL.commcellId = JDS.commcellId AND T1.copyId = JDS.archGrpCopyId
	LEFT OUTER JOIN #JobIds T2 ON JDS.jobId = T2.jobId AND JDS.commcellId = T2.commcellid AND JDS.archGrpCopyId = T2.copyId
WHERE JDL.linkType IN (7, 8)
	AND JDS.disabled & 256 = 0 AND JDS.status IN (100, 102, 103) AND T2.jobId IS NULL
END
-- Phase 2 get the affected volumes and media (excluding magnetic)
IF OBJECT_ID('tempdb..#ChunkIds') IS NOT NULL DROP TABLE #ChunkIds
CREATE TABLE #ChunkIds (archChunkId BIGINT, commCellId INT, PRIMARY KEY (archChunkId, commCellId))
IF OBJECT_ID('tempdb..#VolumeIds') IS NOT NULL DROP TABLE #VolumeIds
CREATE TABLE #VolumeIds (VolumeId INT, PRIMARY KEY (VolumeId))
IF OBJECT_ID('tempdb..#MediaToSetRetention') IS NOT NULL DROP TABLE #MediaToSetRetention
CREATE TABLE #MediaToSetRetention (mediaId INTEGER, retentionFlags INTEGER, retentionEndTime BIGINT, minRetentionTime BIGINT, PRIMARY KEY(MediaId))
IF OBJECT_ID('tempdb..#AllMediaToSetRetention') IS NOT NULL DROP TABLE #AllMediaToSetRetention
CREATE TABLE #AllMediaToSetRetention (MediaId INTEGER, PRIMARY KEY(MediaId) WITH (ignore_dup_key = ON))
INSERT	INTO #ChunkIds
SELECT	DISTINCT ACM.ArchChunkId, ACM.CommcellId
FROM	#JobIds J
		INNER JOIN ArchFile AF WITH (NOLOCK)
			ON AF.jobId = J.jobId AND AF.CommcellId = J.commcellId AND AF.fileType = J.dataType AND AF.isValid = 1
		INNER JOIN ArchChunkMapping ACM WITH (NOLOCK)
			ON ACM.archFileId = AF.id AND ACM.commcellId = AF.commcellId AND ACM.archCopyId = J.copyId-- AND (ACM.flags & 256) = 0
INSERT	INTO #VolumeIds
SELECT	DISTINCT AC.VolumeId
FROM	#ChunkIds C
		INNER JOIN archChunk AC WITH (NOLOCK)
			ON AC.id = C.archChunkId AND AC.commCellId = C.commCellId-- AND (AC.flags & 256) = 0
DECLARE	@NumOfMediaToLoop	INTEGER
SET		@NumOfMediaToLoop = 25000
SELECT	@NumOfMediaToLoop = value
FROM	MMConfigs
WHERE	name = 'DA_CONFIG_NUMBER_OF_MEDIAID_TO_LOOP'
INSERT	INTO #AllMediaToSetRetention
SELECT	DISTINCT V.MediaId
FROM	#VolumeIds T, MMVolume V WITH (NOLOCK), App_CommCell C WITH (NOLOCK)
WHERE	V.VolumeId = T.volumeId AND V.RecordingFormatId <> 10001 AND V.VolumeFlags NOT IN (0, 5, 6)
AND	(CASE WHEN V.OrigCCCommCellId > 0 THEN V.OrigCCCommCellId ELSE 2 END) = C.id
AND	C.type = 1
IF OBJECT_ID('tempdb..#JobIds') IS NOT NULL
	DROP TABLE #JobIds
IF OBJECT_ID('tempdb..#tmpJobsInCycle') IS NOT NULL
	DROP TABLE #tmpJobsInCycle
IF OBJECT_ID('tempdb..#ChunkIds') IS NOT NULL
	DROP TABLE #ChunkIds
IF OBJECT_ID('tempdb..#VolumeIds') IS NOT NULL
	DROP TABLE #VolumeIds
/*Pick media of those copies whose data aging rule was modified*/
INSERT	INTO #AllMediaToSetRetention
SELECT	DISTINCT MediaId
FROM	MMVolume V WITH (NOLOCK), App_CommCell C WITH (NOLOCK)
WHERE	V.RecordingFormatId <> 10001 AND V.VolumeFlags NOT IN (0, 5, 6)
AND	(CASE WHEN V.OrigCCCommCellId > 0 THEN V.OrigCCCommCellId ELSE 2 END) = C.id
AND	C.type = 1 AND V.MediaGroupId in (
					SELECT MediaGroupId FROM archStream WITH(NOLOCK) where archGroupCopyId IN
					(
						SELECT archGrpCopyId FROM JMJobDataStatsTracking WITH(NOLOCK) WHERE jobId = 0 AND archGrpCopyId > 0 AND trackingId <= @l_TrackingId
					)
				)
-- Phase 3 - do it!
DECLARE	@l_numOfMedia INTEGER
SET @l_numOfMedia = (SELECT COUNT(*) FROM #AllMediaToSetRetention)
WHILE @l_numOfMedia > 0
BEGIN
	INSERT INTO #MediaToSetRetention
	SELECT TOP (@NumOfMediaToLoop) MediaId, 0, 0, 0
	FROM #AllMediaToSetRetention ORDER BY MediaId
	EXEC MMS2UpdateMediaExtRetFlagForVolumes 0
	SET @r_ErrorCode = @@ERROR
	IF	@r_ErrorCode <> 0
		BREAK
	DELETE	#AllMediaToSetRetention
	FROM	#MediaToSetRetention
	WHERE	#AllMediaToSetRetention.mediaId = #MediaToSetRetention.mediaId
	TRUNCATE TABLE #MediaToSetRetention
	SET @l_numOfMedia = (SELECT COUNT(*) FROM #AllMediaToSetRetention)
END
-- Phase 4 - update table
IF	@r_ErrorCode = 0
	DELETE FROM JMJobDataStatsTracking
	WHERE TrackingId <= @l_TrackingId
FINISHED:
SELECT @r_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2UpdateMediaExtRetFlagFromTrackingTable')
	delete from GxQscripts where name = 'MMS2UpdateMediaExtRetFlagFromTrackingTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2UpdateMediaExtRetFlagFromTrackingTable')
	delete from GXDBVersions where aliasname = 'MMS2UpdateMediaExtRetFlagFromTrackingTable'
GO

insert into GXDBVersions values(2, 'MMS2UpdateMediaExtRetFlagFromTrackingTable',  '00010007004600100000', 'MMS2UpdateMediaExtRetFlagFromTrackingTable', '00010007004600100000')
GO

