

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2UpdateMediaExtRetFlagForVolumes.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2UpdateMediaExtRetFlagForVolumes.sp,v $ $Id: MMS2UpdateMediaExtRetFlagForVolumes.sp,v 1.21.2.8 2019/12/12 19:18:26 pkrishnan Exp $";
-- Expects a temp table of definition
-- CREATE TABLE #VolumesForWhichToUpdateMediaExtRetData (VolumeId INTEGER)
-- to exist - has to be created by caller
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "MMS2UpdateMediaExtRetFlag"													|
--	|																																				|
--	|   This procedure will update the retentionFlags column  |
--	|   in the MMMedia table.																							|
--  |																																				|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2UpdateMediaExtRetFlagForVolumes')
BEGIN
	print '>>> Drop Stored Procedure: MMS2UpdateMediaExtRetFlagForVolumes <<<'
	drop procedure MMS2UpdateMediaExtRetFlagForVolumes
END
IF EXISTS (select * from GxQscripts where name='MMS2UpdateMediaExtRetFlagForVolumes')
	delete from GxQscripts where name = 'MMS2UpdateMediaExtRetFlagForVolumes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2UpdateMediaExtRetFlagForVolumes')
	delete from GXDBVersions where aliasname = 'MMS2UpdateMediaExtRetFlagForVolumes'
GO
print '... Creating Procedure: MMS2UpdateMediaExtRetFlagForVolumes'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2UpdateMediaExtRetFlagForVolumes
  @dummy integer
AS
  DECLARE @r_errorCode integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @MAXINT	BIGINT
--SET		@MAXINT	= 2147483647
SET @MAXINT = 9223372036854775807
DECLARE @EXTRETFLAGS	INT
SET		@EXTRETFLAGS	= (2|4|8|16|32|64|256|512|1024|2048|4096|262144|524288|4194304|8388608)
IF OBJECT_ID('tempdb..#JobMedia') IS NOT NULL
		DROP TABLE #JobMedia
CREATE	TABLE #JobMedia (
		jobId INT, commCellId INT, dataType INT, copyId INT, mediaId INT, appId int, fullCycleNum int, isDependentJob int, appType int, jobStartTime int, jobStatus int,
		retentionFlags INT, pinEndTime BIGINT, retentionDays BIGINT, retentionEndTime BIGINT, isVSAParentJob INT)
IF OBJECT_ID('tempdb..#JobsInCycle') IS NOT NULL
		DROP TABLE #JobsInCycle
CREATE TABLE #JobsInCycle(
		appId int, jobId int, commCellid int, fullCycleNum int, jobStartTime int, appType int, jobStatus int)
IF OBJECT_ID('tempdb..#lastJobInCycle') IS NOT NULL
		DROP TABLE #lastJobInCycle
CREATE TABLE #lastJobInCycle(
		appId int, jobId int, commCellid int, copyId int, fullCycleNum int,
		jobStartTime int, appType int, jobStatus int, retentionFlags INT, pinEndTime BIGINT)
IF OBJECT_ID('tempdb..#appCycle') IS NOT NULL
		DROP TABLE #appCycle
CREATE TABLE #appCycle(appId int, fullCycleNum int, copyId int, primary key(appId, fullCycleNum, copyId))
--Create index as part of MR : 138757
--==========================================================================================================
CREATE CLUSTERED INDEX tempJobMedia_jobId_CCId_copyId_MediaId ON #JobMedia(jobId, commcellId, copyId, MediaId)
CREATE INDEX tempJobMedia_appId_fullCycleNum_copyId ON #JobMedia(appId, fullCycleNum, copyId)
CREATE CLUSTERED INDEX tempJobsInCycle_jobId_CCId ON #JobsInCycle(jobId, commcellId)
CREATE INDEX tempJobsInCycle_appId_fullCycleNum ON #JobsInCycle(appId, fullCycleNum)
CREATE CLUSTERED INDEX templastLobInCycle_appId ON #lastJobInCycle(appId)
--==========================================================================================================
-- Phase 1 - get all the (jobid, copyid, datatype) on the affected media
INSERT	INTO #JobMedia
SELECT	AF.jobId, AF.commCellId, AF.fileType, ACM.archCopyId, T.mediaId, AF.appId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
FROM	#MediaToSetRetention T
		INNER JOIN MMVolume V WITH (NOLOCK)
			ON V.MediaId = T.mediaId
		INNER JOIN archChunk AC WITH (NOLOCK)
			ON AC.volumeId = V.VolumeId AND (AC.flags & 256) = 0
		INNER JOIN archChunkMapping ACM WITH (NOLOCK)
			ON ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId AND (ACM.flags & 256) = 0
		INNER JOIN archFile AF WITH (NOLOCK)
			ON AF.id = ACM.archFileId AND AF.commCellId = ACM.commCellId AND AF.isValid = 1
GROUP BY AF.jobId, AF.commCellId, AF.fileType, ACM.archCopyId, T.mediaId, AF.appId
DECLARE @computeVSAJobRetention int = 0
SELECT @computeVSAJobRetention = ISNULL(value, 0)
FROM MMConfigs WITH(NOLOCK)
WHERE name = 'MMCONFIG_COMPUTE_VSA_JOB_RETENTION_BASED_ON_VM_JOBS'
IF @computeVSAJobRetention = 1
BEGIN
	UPDATE T
	SET isVSAParentJob = 1
	FROM #JobMedia T INNER JOIN JMJobDataLink JDL WITH(NOLOCK) ON T.jobId = JDL.parentJobId AND T.commcellId = JDL.commcellId
WHERE JDL.linkType IN (7, 8)
	--Populate child VM jobs for parent VSA job. Rest of the code will take care of computing job retention for VM jobs and set max retention on media
	INSERT INTO #JobMedia
	SELECT JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, T1.mediaId, JDS.appId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	FROM #JobMedia T1 INNER JOIN JMJobDataLink JDL WITH(NOLOCK) ON T1.jobId = JDL.parentJobId AND T1.commcellId = JDL.commcellId
	INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JDL.childJobId = JDS.jobId AND JDL.commcellId = JDS.commcellId AND T1.copyId = JDS.archGrpCopyId
	LEFT OUTER JOIN #JobMedia T2 ON JDS.jobId = T2.jobId AND JDS.commcellId = T2.commcellid AND JDS.archGrpCopyId = T2.copyId AND JDS.dataType = T2.dataType AND T1.mediaId = T2.mediaId
WHERE (JDS.disabled & 256) = 0 AND JDS.status IN (100, 102, 103) AND JDL.linkType IN (7, 8) AND T2.jobId IS NULL
END
UPDATE #JobMedia SET fullCycleNum = JBKP.fullCycleNum,
						appType = JBKP.appType, jobStartTime = JBKP.servStartDate, jobStatus = JBKP.status,
						retentionFlags = JDS.retentionFlags, pinEndTime = JDS.manualRetentionEndTime
FROM #JobMedia J
INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON J.jobId = JBKP.jobId AND J.commcellId = JBKP.commcellId
INNER JOIN JMJobDataStats JDS WITH (NOLOCK) ON JBKP.jobId = JDS.jobId AND JBKP.commcellId = JDS.commcellId AND JDS.archGrpCopyId = J.copyId AND JDS.dataType = J.dataType
UPDATE #JobMedia SET fullCycleNum = AJ.fullCycleNum,
						appType = 1000, jobStartTime = AJ.ServStart, jobStatus = AJ.status,
						retentionFlags = JDS.retentionFlags, pinEndTime = JDS.manualRetentionEndTime
FROM #JobMedia J
INNER JOIN JMAdminJobStatsTable AJ WITH(NOLOCK) ON J.jobId = AJ.jobId AND J.commcellId = AJ.commcellId
INNER JOIN JMJobDataStats JDS WITH (NOLOCK) ON AJ.jobId = JDS.jobId AND AJ.commcellId = JDS.commcellId AND JDS.archGrpCopyId = J.copyId AND JDS.dataType = J.dataType
IF @computeVSAJobRetention = 1
BEGIN
	--To find jobs in cycle we don't need copyId
	INSERT INTO #appCycle
	SELECT distinct appId, fullCycleNum, 0
	FROM #JobMedia WHERE isVSAParentJob = 0
END
ELSE
BEGIN
	--To find jobs in cycle we don't need copyId
	INSERT INTO #appCycle
	SELECT distinct appId, fullCycleNum, 0
	FROM #JobMedia
END
INSERT INTO #JobsInCycle
SELECT JBKP.appId, JBKP.jobId, JBKP.commcellId, JBKP.fullCycleNum, JBKP.servStartDate, JBKP.appType, JBKP.status
FROM #appCycle J INNER JOIN JMBkpStats JBKP WITH (NOLOCK)
ON 	J.appId = JBKP.appId
AND J.fullCycleNum = JBKP.fullCycleNum
AND JBKP.status IN (1, 3, 14)
INSERT INTO #JobsInCycle
SELECT AJ.appId, AJ.jobId, AJ.commcellId, AJ.fullCycleNum, AJ.servStart, 1000, AJ.status
FROM #appCycle J INNER JOIN JMAdminJobStatsTable AJ WITH (NOLOCK)
ON 	J.appId = AJ.appId
AND J.fullCycleNum = AJ.fullCycleNum
AND AJ.status IN (1, 3, 14)
TRUNCATE TABLE #appCycle
--Repopulate with copyId to get lastJobInCycle in the particular copy
INSERT INTO #appCycle
SELECT distinct appId, fullCycleNum, copyId
FROM #JobMedia
--For data jobs use retentionendtime of last data job in cycle
INSERT INTO #lastJobInCycle
SELECT J.appId, 0, 0, J.copyId, J.fullCycleNum, MAX(T.jobStartTime), 0, 0, 0, 0
FROM #appCycle J
INNER JOIN #JobsInCycle T ON J.appId = T.appId AND J.fullCycleNum = T.fullCycleNum
INNER JOIN JMJobDataStats JDS WITH (NOLOCK) ON T.jobId = JDS.jobId AND T.commcellId = JDS.commcellId AND JDS.archGrpCopyId = J.copyId
--AND JDS.dataType = J.dataType
AND (JDS.disabled & 256) = 0 AND JDS.status IN (100, 102, 103) AND JDS.dataType != 4
GROUP BY J.appId, J.copyId, J.fullCycleNum
IF OBJECT_ID('tempdb..#appCycle') IS NOT NULL
		DROP TABLE #appCycle
UPDATE 	#lastJobInCycle
SET jobId = T.jobId, commcellId = T.commcellId, appType = T.appType, jobStatus = T.jobStatus,
	retentionFlags = JDS.retentionFlags, pinEndTime = JDS.manualRetentionEndTime
FROM #lastJobInCycle J
INNER JOIN #JobsInCycle T ON J.appId = T.appId AND J.jobStartTime = T.jobStartTime
INNER JOIN JMJobDataStats JDS WITH (NOLOCK) ON T.jobId = JDS.jobId AND T.commcellId = JDS.commcellId AND JDS.archGrpCopyId = J.copyId
IF OBJECT_ID('tempdb..#JobsInCycle') IS NOT NULL
		DROP TABLE #JobsInCycle
INSERT INTO #JobMedia
SELECT DISTINCT J.jobId, J.commcellId, JDS.dataType, J.copyId, JMed.mediaId, JMed.appId, J.fullCycleNum, 1, J.appType, J.jobStartTime, J.jobStatus,
				J.retentionFlags, 0, 0, 0, 0
FROM #lastJobInCycle J INNER JOIN JMJobDataStats JDS WITH(NOLOCK)
ON J.jobId = JDS.jobId AND J.commcellId = JDS.commcellId AND JDS.archGrpCopyId = J.copyId
AND (JDS.disabled & 256) = 0 AND JDS.status IN(100, 102, 103) AND JDS.dataType != 4
INNER JOIN #JobMedia JMed
ON JMed.appId = J.appId AND JMed.fullCycleNum = J.fullCycleNum AND JMed.copyId = J.copyId
LEFT OUTER JOIN #JobMedia JMed2 ON J.jobId = JMed2.jobid AND J.commcellId = JMed2.commcellId AND J.copyId = JMed2.copyId AND JMed.mediaId = JMed2.MediaId
WHERE JMed2.jobId IS NULL
IF OBJECT_ID('tempdb..#lastJobInCycle') IS NOT NULL
		DROP TABLE #lastJobInCycle
--Remove all failled\killed jobs
DELETE #JobMedia
WHERE jobStatus NOT IN (1, 3, 14)
-- Phase 2 - get retention details (basic and extended)
UPDATE	#JobMedia
SET		retentionDays = AR.retentionDays
FROM	#JobMedia T INNER JOIN archAgingRule AR WITH (NOLOCK)
ON		AR.copyId = T.copyId
WHERE	pinEndTime != -1
UPDATE	#JobMedia
SET		retentionDays = AR.archiverRetDays
FROM	#JobMedia T INNER JOIN archAgingRule AR WITH (NOLOCK)
ON		AR.copyId = T.copyId
INNER JOIN APP_IDATypeHandlingInfo HI WITH (NOLOCK)
ON		HI.appTypeId = T.appType
WHERE	HI.isDMAppType != 0
AND		pinEndTime != -1
IF @computeVSAJobRetention = 1
BEGIN
	--We do not process regular copy based retention criteria for VSA parent jobs
	UPDATE #JobMedia
	SET retentionFlags = 0, retentionDays = 0
	WHERE isVSAParentJob = 1
END
UPDATE	#JobMedia
SET	retentionFlags = 0, retentionEndTime = @MAXINT
WHERE	retentionDays = -1
UPDATE	#JobMedia
SET	retentionFlags = 0, pinEndTime = @MAXINT, retentionEndTime = @MAXINT
WHERE	pinEndTime = -1
UPDATE	#JobMedia
SET		retentionFlags = B.retentionRule, retentionDays = B.retentionDays
FROM	#JobMedia A,
		(SELECT JR.jobId, JR.commCellId, JR.dataType, JR.copyId, JR.mediaId,
				SUM(ARE.retentionRule) AS retentionRule,
				MAX(CASE WHEN ARE.retentionDays < 0 THEN @MAXINT ELSE ARE.retentionDays END) AS retentionDays
		FROM	#JobMedia JR, ArchAgingRuleExtended ARE WITH (NOLOCK)
		WHERE	ARE.copyId = JR.copyId AND (ARE.retentionRule &  (CASE
																		WHEN	(JR.retentionFlags & 4096) = 4096/*EXTENDED_GRACE_YEAR*/ 						THEN 	64/*EXTENDED_YEAR*/
																		WHEN	(JR.retentionFlags & 2048) = 2048/*EXTENDED_GRACE_HALFYEAR*/ 					THEN 	32/*EXTENDED_HALFYEAR*/
																		WHEN	(JR.retentionFlags & 1024) = 1024/*EXTENDED_GRACE_QUARTER*/ 					THEN 	16/*EXTENDED_QUARTER*/
																		WHEN	(JR.retentionFlags & 512) = 512/*EXTENDED_GRACE_MONTH*/ 						THEN 	8/*EXTENDED_MONTH*/
																		WHEN	(JR.retentionFlags & 256) = 256/*EXTENDED_GRACE_WEEK*/ 							THEN 	4/*EXTENDED_WEEK*/
																		WHEN	(JR.retentionFlags & 8388608) = 8388608/*EXTENDED_GRACE_DAY*/ 					THEN  	524288/*EXTENDED_DAY*/
																		WHEN	(JR.retentionFlags & 4194304)  = 4194304/*EXTENDED_GRACE_HOUR*/ 				THEN 	262144/*EXTENDED_HOUR*/
																		ELSE	JR.retentionFlags
																		END ) & @EXTRETFLAGS) <> 0
		AND JR.retentionEndTime != @MAXINT AND JR.retentionFlags != 0
		GROUP BY JR.jobId, JR.commCellId, JR.dataType, JR.copyId, JR.mediaId) B
WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId AND A.dataType = B.dataType AND A.copyId = B.copyId AND A.mediaId = B.mediaId
AND		B.retentionDays > A.retentionDays
UPDATE	#JobMedia
SET		retentionEndTime = (CASE WHEN retentionDays = @MAXINT THEN @MAXINT ELSE (jobStartTime + retentionDays*24*3600) END)
WHERE	retentionEndTime != @MAXINT
AND retentionEndTime < (CASE WHEN retentionDays = @MAXINT THEN @MAXINT ELSE (jobStartTime + retentionDays*24*3600) END)
--Update retention flags and retention end time if the manual ret end time is greater than the retentionendtime by basic/ext retention
UPDATE	#JobMedia
SET		retentionFlags = (retentionFlags | 128), retentionEndTime = pinEndTime
WHERE	pinEndTime > retentionEndTime OR pinEndTime = @MAXINT
-- Phase 3 - get retention details per mediaid
UPDATE	#MediaToSetRetention
SET		retentionEndTime = T.retentionEndTime, minRetentionTime = T.minRetentionTime
FROM	#MediaToSetRetention  MR, (SELECT JM.mediaId, MAX(JM.retentionEndTime) AS retentionEndTime, MIN(JM.retentionEndTime) AS minRetentionTime
									FROM	#JobMedia JM
									GROUP BY JM.mediaId) T
WHERE	MR.mediaId = T.mediaId
UPDATE	#MediaToSetRetention
SET		retentionFlags = T.retentionFlags
FROM	#MediaToSetRetention M, ( SELECT JM.mediaId, MAX(JM.retentionFlags) AS retentionFlags
																FROM	#MediaToSetRetention MR, #JobMedia JM
																WHERE	JM.mediaId = MR.mediaId
																AND 	JM.retentionEndTime = MR.retentionEndTime
																AND 	JM.isDependentJob = 0 --Dependent last job in cycle is added to the job list only for calculating estimated retention end time
																GROUP BY JM.mediaId
															) T
WHERE	M.mediaId = T.mediaId
IF OBJECT_ID('tempdb..#JobMedia') IS NOT NULL
	DROP TABLE #JobMedia
UPDATE	#MediaToSetRetention
SET		retentionEndTime = -1
WHERE	retentionEndTime = @MAXINT
UPDATE	#MediaToSetRetention
SET		minRetentionTime = -1
WHERE	minRetentionTime = @MAXINT
--phase 4 - update media
UPDATE	MMMedia
SET		retentionExpireTime = T.retentionEndTime, retentionFlags = T.retentionFlags, minRetentionTime = T.minRetentionTime
FROM	MMMedia M, #MediaToSetRetention T
WHERE	M.MediaId = T.mediaId
AND		(M.retentionExpireTime != T.retentionEndTime OR M.retentionFlags != T.retentionFlags OR M.minRetentionTime != T.minRetentionTime)
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2UpdateMediaExtRetFlagForVolumes')
	delete from GxQscripts where name = 'MMS2UpdateMediaExtRetFlagForVolumes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2UpdateMediaExtRetFlagForVolumes')
	delete from GXDBVersions where aliasname = 'MMS2UpdateMediaExtRetFlagForVolumes'
GO

insert into GXDBVersions values(2, 'MMS2UpdateMediaExtRetFlagForVolumes',  '00010021000200080000', 'MMS2UpdateMediaExtRetFlagForVolumes', '00010021000200080000')
GO

