

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2UpdateMediaExtRetFlag.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2UpdateMediaExtRetFlag.sp,v $ $Id: MMS2UpdateMediaExtRetFlag.sp,v 1.22.34.5 2018/11/29 00:03:48 pkrishnan Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "MMS2UpdateMediaExtRetFlag"													|
--	|																																				|
--	|   This procedure will update the retentionFlags column  |
--	|   in the MMMedia table.																							|
--	|   This SP should be run after data aging															|
--  |																																				|
--  |    This query takes 40 seconds to run on Macy	when nothing is cached	|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2UpdateMediaExtRetFlag')
BEGIN
	print '>>> Drop Stored Procedure: MMS2UpdateMediaExtRetFlag <<<'
	drop procedure MMS2UpdateMediaExtRetFlag
END
IF EXISTS (select * from GxQscripts where name='MMS2UpdateMediaExtRetFlag')
	delete from GxQscripts where name = 'MMS2UpdateMediaExtRetFlag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2UpdateMediaExtRetFlag')
	delete from GXDBVersions where aliasname = 'MMS2UpdateMediaExtRetFlag'
GO
print '... Creating Procedure: MMS2UpdateMediaExtRetFlag'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2UpdateMediaExtRetFlag
  @dummy integer
AS
  DECLARE @r_errorCode integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
set @r_ErrorCode = 0
DECLARE	@NumOfMediaToLoop	INTEGER
SET		@NumOfMediaToLoop = 25000
SELECT	@NumOfMediaToLoop = value
FROM	MMConfigs
WHERE	name = 'DA_CONFIG_NUMBER_OF_MEDIAID_TO_LOOP'
DECLARE @l_TrackingId BIGINT
SELECT @l_TrackingId = max(TrackingId)
FROM JMJobDataStatsTracking WITH(NOLOCK)
-- do not go to finished if table is empty
CREATE TABLE #AllMediaToSetRetention (MediaId INTEGER)
CREATE TABLE #MediaToSetRetention (mediaId INTEGER, retentionFlags INTEGER, retentionEndTime BIGINT, minRetentionTime BIGINT)
-- insert all magnetic volumes
-- Do not process foreign media (EDC media)
INSERT	INTO #AllMediaToSetRetention
SELECT	DISTINCT MediaId
FROM	MMVolume V WITH (NOLOCK), App_CommCell C WITH (NOLOCK)
WHERE	V.RecordingFormatId <> 10001 AND V.VolumeFlags NOT IN (0, 5, 6)
AND	(CASE WHEN V.OrigCCCommCellId > 0 THEN V.OrigCCCommCellId ELSE 2 END) = C.id
AND	C.type = 1
-- Phase 3 - do it!
DECLARE	@l_numOfMedia INTEGER
SET @l_numOfMedia = (SELECT COUNT(*) FROM #AllMediaToSetRetention)
WHILE @l_numOfMedia > 0
BEGIN
	INSERT INTO #MediaToSetRetention
	SELECT TOP (@NumOfMediaToLoop) MediaId, 0, 0, 0
	FROM #AllMediaToSetRetention ORDER BY MediaId
	EXEC MMS2UpdateMediaExtRetFlagForVolumes 0
	SET @r_ErrorCode = @@ERROR
	IF	@r_ErrorCode <> 0
		BREAK
	DELETE	#AllMediaToSetRetention
	FROM	#MediaToSetRetention
	WHERE	#AllMediaToSetRetention.mediaId = #MediaToSetRetention.mediaId
	TRUNCATE TABLE #MediaToSetRetention
	SET @l_numOfMedia = (SELECT COUNT(*) FROM #AllMediaToSetRetention)
END
-- Phase 4 - update table
IF	@r_ErrorCode = 0
	DELETE FROM JMJobDataStatsTracking
	WHERE TrackingId <= @l_TrackingId
select @r_errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2UpdateMediaExtRetFlag')
	delete from GxQscripts where name = 'MMS2UpdateMediaExtRetFlag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2UpdateMediaExtRetFlag')
	delete from GXDBVersions where aliasname = 'MMS2UpdateMediaExtRetFlag'
GO

insert into GXDBVersions values(2, 'MMS2UpdateMediaExtRetFlag',  '00010022003400050000', 'MMS2UpdateMediaExtRetFlag', '00010022003400050000')
GO

