

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2UpdateLibraryStateHistoryForAllControllers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2UpdateLibraryStateHistoryForAllControllers.sp,v $ $Id: MMS2UpdateLibraryStateHistoryForAllControllers.sp,v 1.1.304.1 2018/03/20 19:50:51 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2UpdateLibraryStateHistoryForAllControllers <<<'

IF EXISTS (select * from sysobjects where name='MMS2UpdateLibraryStateHistoryForAllControllers')
	drop procedure MMS2UpdateLibraryStateHistoryForAllControllers
IF EXISTS (select * from GxQscripts where name='MMS2UpdateLibraryStateHistoryForAllControllers')
	delete from GxQscripts where name = 'MMS2UpdateLibraryStateHistoryForAllControllers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2UpdateLibraryStateHistoryForAllControllers')
	delete from GXDBVersions where aliasname = 'MMS2UpdateLibraryStateHistoryForAllControllers'
GO
print '... Creating Procedure: MMS2UpdateLibraryStateHistoryForAllControllers'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2UpdateLibraryStateHistoryForAllControllers
  @i_LibraryId integer,
  @i_State integer,
  @i_Reason integer
-- Following are the "columns" returned, in the order in which they are returned
AS
  DECLARE @rowCount integer
	IF object_id('tempdb.dbo.#tmpControllers') is not null DROP TABLE #tmpControllers
	IF object_id('tempdb.dbo.#tmpTopEntries') is not null DROP TABLE #tmpTopEntries
	create table #tmpControllers(LibraryControllerId	integer,
					ClientId	integer,
					isPresent	integer)
	create table #tmpTopEntries(	LibraryId		integer,
					ClientId	integer,
					State		integer,
					stateChangeTime	dateTime)
	insert into #tmpControllers
	select MLC.LibraryControllerId, MLC.ClientId, 0
	from MMLibraryController as MLC
	where MLC.LibraryId = @i_LibraryId
	insert into #tmpTopEntries
	select top 1 MLH.LibraryId, MLH.ClientId, MLH.State, MLH.StateChangeTime
	from MMLibraryStateHistory as MLH, #tmpControllers tt
	where MLH.LibraryId = @i_LibraryId and MLH.ClientId = tt.ClientId and MLH.State = @i_State
	order by StateChangeTime DESC
	update #tmpControllers
	set isPresent = 1
	from #tmpControllers as tt1, #tmpTopEntries as tt2
	where tt1.ClientId = tt2.ClientId
	delete from #tmpControllers
	where isPresent = 1
	insert into MMLibraryStateHistory
	select @i_LibraryId, tt.ClientId, @i_State, getUtcDate(), @i_reason
	from #tmpControllers as tt
	select @@ROWCOUNT
	drop table #tmpControllers
	drop table #tmpTopEntries
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2UpdateLibraryStateHistoryForAllControllers')
	delete from GxQscripts where name = 'MMS2UpdateLibraryStateHistoryForAllControllers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2UpdateLibraryStateHistoryForAllControllers')
	delete from GXDBVersions where aliasname = 'MMS2UpdateLibraryStateHistoryForAllControllers'
GO

insert into GXDBVersions values(2, 'MMS2UpdateLibraryStateHistoryForAllControllers',  '00010001030400010000', 'MMS2UpdateLibraryStateHistoryForAllControllers', '00010001030400010000')
GO

