

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2UpdateIndexCacheForInstall.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2UpdateIndexCacheForInstall.sp,v $ $Id: MMS2UpdateIndexCacheForInstall.sp,v 1.27.2.6 2020/08/07 14:45:55 rsivadas Exp $";
--
--  +========================================================================+
--  |      Cursor:  MMS2UpdateIndexCacheForInstall()
--  |
--  | Description:  Sets the index cache directory during Windows Installations/Upgrades
--  |
--  |       Input:  ClientID, Path, Username, Password
--  |
--  |      Output:  always returns 0
--  |
--  |      Notes:	None at this time
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        mklose 	Initial release
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2UpdateIndexCacheForInstall')
BEGIN
	print '>>> Drop Stored Procedure: MMS2UpdateIndexCacheForInstall <<<'
	drop procedure MMS2UpdateIndexCacheForInstall
END
IF EXISTS (select * from GxQscripts where name='MMS2UpdateIndexCacheForInstall')
	delete from GxQscripts where name = 'MMS2UpdateIndexCacheForInstall'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2UpdateIndexCacheForInstall')
	delete from GXDBVersions where aliasname = 'MMS2UpdateIndexCacheForInstall'
GO
print '... Creating Procedure: MMS2UpdateIndexCacheForInstall'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMS2UpdateIndexCacheForInstall
  @clientId integer,
  @PathToIndex varchar(255),
  @userName varchar(255),
  @password varchar(255)
AS
  DECLARE @dummy integer
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- .. :PARAM input lines
	DECLARE @i_ClientId	integer
	DECLARE @i_Location	varchar(256)
	DECLARE @i_UserName	varchar(256)
	DECLARE @i_Password	varchar(256)
	set @i_ClientId = @clientId
	set @i_Location = @PathToIndex
	set @i_Username = @userName
	set @i_Password = @password
	DECLARE @l_idxAPId integer
	DECLARE @l_idxCacheId integer
	DECLARE @l_poolId integer
	DECLARE @l_updateMode integer
	DECLARE @l_clientVersionId integer
	DECLARE @l_alreadyUpdated int
	DECLARE @const_minFreeSpace int
	DECLARE @const_minFreeSpaceWarning int
	DECLARE @largeMinFreeSpace varchar(20) = '10240'
	DECLARE @largeWarningFreeSpace varchar(20) = '51200'
	if EXISTS (select TOP 1 * from GxGlobalParam where name='IndexCache_UseBigFreeSpaceDefaults' and value='1')
	begin
		set @const_minFreeSpace=5000
		set @const_minFreeSpaceWarning=10000
	end else
	begin
		set @const_minFreeSpace=0
		set @const_minFreeSpaceWarning=1024
	end
	SET @l_alreadyUpdated=0
	if (@clientId=0)
	BEGIN
		SET @l_clientVersionId = 16
		SET @l_idxAPId=0
	END ELSE
	BEGIN
	-- does access path Id exist, and if so, what is the Id?
		SET @l_idxAPId =
			isnull
			(
				(
					SELECT 	IAP.idxAccessPathId
					FROM 	IdxAccessPath AS IAP, IdxCache AS IC
					WHERE	IAP.ClientId = @i_ClientId
					AND		IAP.IdxCacheId = IC.IdxCacheId
					-- Check that it's regular index cache since we can have multiple SIDB idx accesspaths
					-- for same host.
					AND		IC.IdxCacheType = 1
				), 0
			)
		-- get client version
		set @l_clientVersionId = (select releaseId from app_client where id=@i_ClientId)
		-- get update mode - 0 if 5.9, 1 if 6.1 or above (by default - this changes according to circumstances)
		SET @l_updateMode = 0
		-- default to overwrite
		IF (@l_clientVersionId > 10)
		BEGIN
			SET @l_updateMode = 2
		END
	END
	IF (@l_clientVersionId > 15)
	BEGIN
		DECLARE @l_currentTime int = dbo.GetUnixTime(GETUTCDATE())
		DECLARE @t_configGuid varchar(256)
		DECLARE @l_attrName varchar(256)
		DECLARE @l_attrType int
		set @l_updateMode=3
		IF (@clientId = 0)
		BEGIN
			-- convert all MAs caches into new format
			CREATE TABLE #tempClientIds (
				clientId int
			)
			insert into #tempClientIds
				select id from app_client c, IdxAccessPath iap, IdxCache ic
				where c.id=iap.ClientId and iap.IdxCacheId=ic.IdxCacheId and ic.IdxCacheType=1
						and not exists(select 1 from APP_ClientProp cp where cp.componentNameId=c.id and cp.attrName='Idx: configuration GUID')
						and c.releaseId>15
						and not exists(select 1 from app_clientprop where componentNameId=iap.ClientId and attrName='Idx: cache path')
			IF (EXISTS (select 1 from #tempClientIds))
			BEGIN
				SET @l_attrName='Idx: configuration GUID'
				SET @l_attrType=1
				insert into APP_ClientProp select c.id, @l_attrName, @l_attrType, c.GUID, @l_currentTime, 0, 0 from app_client c where c.id in (select clientId from #tempClientIds)
				-- CacheEnabled
				SET @l_attrName='Idx: cache enabled'
				SET @l_attrType=1
				insert into APP_ClientProp select c.id, @l_attrName, @l_attrType, '1', @l_currentTime, 0, 0 from app_client c where c.id in (select clientId from #tempClientIds)
				-- MinFreeSpace
				SET @l_attrName='Idx: min space'
				SET @l_attrType=1
				insert into APP_ClientProp select iap.ClientId, @l_attrName, @l_attrType, CAST(CASE WHEN ic.DiskFreeThresholdMB>@const_minFreeSpace THEN ic.DiskFreeThresholdMB ELSE @const_minFreeSpace END as varchar(256)), @l_currentTime, 0, 0
					from IdxAccessPath iap, IdxCache ic where iap.ClientId in (select clientId from #tempClientIds) and iap.IdxCacheId=ic.IdxCacheId and ic.IdxCacheType=1
				-- alert free
				SET @l_attrName='Idx: alert space'
				SET @l_attrType=1
				insert into APP_ClientProp select iap.ClientId, @l_attrName, @l_attrType, CAST(CASE WHEN ic.DiskFreeWarningThreshholdMB>@const_minFreeSpaceWarning THEN ic.DiskFreeWarningThreshholdMB ELSE @const_minFreeSpaceWarning END as varchar(256)), @l_currentTime, 0, 0
					from IdxAccessPath iap, IdxCache ic where iap.ClientId in (select clientId from #tempClientIds) and iap.IdxCacheId=ic.IdxCacheId and ic.IdxCacheType=1
				-- idx path
				SET @l_attrName='Idx: cache path'
				SET @l_attrType=1
				insert into APP_ClientProp select iap.ClientId, @l_attrName, @l_attrType, iap.Path, @l_currentTime, 0, 0
					from IdxAccessPath iap, IdxCache ic where iap.ClientId in (select clientId from #tempClientIds) and iap.IdxCacheId=ic.IdxCacheId and ic.IdxCacheType=1
				-- age days
				SET @l_attrName='Idx: age days'
				SET @l_attrType=1
				insert into APP_ClientProp select iap.ClientId, @l_attrName, @l_attrType, cast(ip.AgeingNoOfDays as varchar(256)), @l_currentTime, 0, 0
					from IdxAccessPath iap, IdxCache ic, IdxPool ip where iap.ClientId in (select clientId from #tempClientIds) and iap.IdxCacheId=ic.IdxCacheId and ic.IdxCacheType=1 and ic.IdxPoolId=ip.IdxPoolId
				-- cleanup percent
				SET @l_attrName='Idx: cleanup percent'
				SET @l_attrType=1
				insert into APP_ClientProp select iap.ClientId, @l_attrName, @l_attrType, CAST(ic.AgeingPercentDiskspace as varchar(256)), @l_currentTime, 0, 0
					from IdxAccessPath iap, IdxCache ic where iap.ClientId in (select clientId from #tempClientIds) and iap.IdxCacheId=ic.IdxCacheId and ic.IdxCacheType=1
				IF object_id('tempdb.dbo.#tempClientIds') IS NOT null DROP TABLE #tempClientIds
			END
			SET @l_alreadyUpdated=1
		END	ELSE
		BEGIN
			DECLARE @l_isShared int=0
			DECLARE @l_isUNC int=0
			DECLARE @l_icsId int=0
			DECLARE @l_uname varchar(256)
			DECLARE @l_configGuid varchar(256)
			DECLARE @l_freshInstall int = 0
      DECLARE @l_cacheID int = 0
			SELECT @l_configGuid=attrVal from APP_ClientProp where id=@clientId and attrName='Idx: configuration GUID'
			IF (@l_configGuid='' or @l_configGuid is NULL)
			BEGIN
				SELECT @l_isShared=ip.IsShared, @l_uname=aip.Username, @l_icsId=ic.CatalogServerClientId, @l_cacheID = ic.IdxCacheId
				from IdxAccessPath aip, IdxCache ic, IdxPool ip
				where aip.IdxCacheId=ic.IdxCacheId and ic.IdxPoolId=ip.IdxPoolId
						and aip.IdxAccessPathId=@l_idxAPId and aip.ClientId=@clientId and ic.IdxCacheType = 1
				IF (@l_uname <> '' and @l_uname is not null)
					SET @l_isUNC=1
				IF (@l_icsId>0)
					SET @l_isShared=1
        IF (@l_cacheID = 0 or @l_cacheID is NULL)
          SET @l_freshInstall = 1
			END
			--if not shared then save in new format
			IF (@l_isShared=0 and @l_isUNC=0)
			BEGIN
				-- for all non-shared non-UNC paths
				-- set/update
				-- config GUID
				IF (@l_configGuid='' or @l_configGuid is NULL)
				BEGIN
					SELECT @l_configGuid=GUID from app_client where id=@clientId
				END
				DECLARE @l_attrVal varchar(256)
				DECLARE @l_curVal varchar(256) = NULL
				SET @l_attrName='Idx: configuration GUID'
				SET @l_attrVal=@l_configGuid
				SET @l_attrType=1
				IF (not exists (select 1 from APP_ClientProp where componentNameId=@clientId and attrName=@l_attrName))
					insert into APP_ClientProp VALUES (@clientId, @l_attrName, @l_attrType, @l_attrVal, @l_currentTime, 0, 0)
				-- CacheEnabled
				SET @l_attrName='Idx: cache enabled'
				SET @l_attrVal='1'
				SET @l_attrType=1
				SET @l_curVal = NULL
				select @l_curVal = attrVal
				from APP_ClientProp(NOLOCK)
				where componentNameId = @clientId
				and attrName = @l_attrName
				and modified = 0
				IF @l_curVal IS NULL
					insert into APP_ClientProp VALUES (@clientId, @l_attrName, @l_attrType, @l_attrVal, @l_currentTime, 0, 0)
				ELSE
					IF @l_curVal <> @l_attrVal
						UPDATE APP_ClientProp SET attrVal=@l_attrVal where componentNameId=@clientId and attrName=@l_attrName and modified = 0
				-- MinFreeSpace
				SET @l_attrName='Idx: min space'
				if (exists (SELECT 1 from IdxAccessPath iap, IdxCache ic where IdxAccessPathId=@l_idxAPId and iap.IdxCacheId=ic.IdxCacheId and ic.IdxCacheType=1))
					SELECT @l_attrVal=CAST(CASE WHEN ic.DiskFreeThresholdMB>@const_minFreeSpace THEN ic.DiskFreeThresholdMB ELSE @const_minFreeSpace END as varchar(256)) from IdxAccessPath iap, IdxCache ic where IdxAccessPathId=@l_idxAPId and iap.IdxCacheId=ic.IdxCacheId and ic.IdxCacheType=1
				else
				begin
					if @l_freshInstall > 0
						SET @l_attrVal= @largeMinFreeSpace
					else
						SET @l_attrVal=CAST(@const_minFreeSpace as varchar(256))
				end
				SET @l_attrType=1
				SET @l_curVal = NULL
				select @l_curVal = attrVal
				from APP_ClientProp(NOLOCK)
				where componentNameId = @clientId
				and attrName = @l_attrName
				and modified = 0
				IF @l_curVal IS NULL
					insert into APP_ClientProp VALUES (@clientId, @l_attrName, @l_attrType, @l_attrVal, @l_currentTime, 0, 0)
				ELSE
					IF @l_curVal <> @l_attrVal
						UPDATE APP_ClientProp SET attrVal=@l_attrVal where componentNameId=@clientId and attrName=@l_attrName and modified = 0
				-- alert free
				SET @l_attrName='Idx: alert space'
				IF (exists (SELECT 1 from IdxAccessPath iap, IdxCache ic where IdxAccessPathId=@l_idxAPId and iap.IdxCacheId = ic.IdxCacheId and ic.IdxCacheType=1))
					SELECT @l_attrVal=CAST(CASE WHEN ic.DiskFreeWarningThreshholdMB>@const_minFreeSpaceWarning THEN ic.DiskFreeWarningThreshholdMB ELSE @const_minFreeSpaceWarning END as varchar(256)) from IdxAccessPath iap, IdxCache ic where IdxAccessPathId=@l_idxAPId and iap.IdxCacheId = ic.IdxCacheId and ic.IdxCacheType=1
				else
				begin
					if @l_freshInstall > 0
						set @l_attrVal = @largeWarningFreeSpace
					else
						SET @l_attrVal=CAST(@const_minFreeSpaceWarning as varchar(256))
				end
				SET @l_attrType=1
				SET @l_curVal = NULL
				select @l_curVal = attrVal
				from APP_ClientProp(NOLOCK)
				where componentNameId = @clientId
				and attrName = @l_attrName
				and modified = 0
				IF @l_curVal IS NULL
					insert into APP_ClientProp VALUES (@clientId, @l_attrName, @l_attrType, @l_attrVal, @l_currentTime, 0, 0)
				ELSE
					IF @l_curVal <> @l_attrVal
						UPDATE APP_ClientProp SET attrVal=@l_attrVal where componentNameId=@clientId and attrName=@l_attrName and modified = 0
				-- idx path
				SET @l_attrName='Idx: cache path'
				SET @l_attrVal=@PathToIndex
				SET @l_attrType=1
				SET @l_curVal = NULL
				select @l_curVal = attrVal
				from APP_ClientProp(NOLOCK)
				where componentNameId = @clientId
				and attrName = @l_attrName
				and modified = 0
				IF @l_curVal IS NULL
					insert into APP_ClientProp VALUES (@clientId, @l_attrName, @l_attrType, @l_attrVal, @l_currentTime, 0, 0)
				ELSE
					IF @l_curVal <> @l_attrVal
						UPDATE APP_ClientProp SET attrVal=@l_attrVal where componentNameId=@clientId and attrName=@l_attrName and modified = 0
				-- age days
				SET @l_attrName='Idx: age days'
				SET @l_attrVal = '15'
				if (@l_freshInstall = 0)
				BEGIN
					SELECT @l_attrVal=CAST(ip.AgeingNoOfDays as varchar(256))  from IdxAccessPath iap, IdxCache ic, IdxPool ip where IdxAccessPathId=@l_idxAPId and iap.IdxCacheId = ic.IdxCacheId and ic.IdxPoolId=ip.IdxPoolId  and ic.IdxCacheType=1
				END
				SET @l_attrType=1
				SET @l_curVal = NULL
				select @l_curVal = attrVal
				from APP_ClientProp(NOLOCK)
				where componentNameId = @clientId
				and attrName = @l_attrName
				and modified = 0
				IF @l_curVal IS NULL
					insert into APP_ClientProp VALUES (@clientId, @l_attrName, @l_attrType, @l_attrVal, @l_currentTime, 0, 0)
				ELSE
					IF @l_curVal <> @l_attrVal
						UPDATE APP_ClientProp SET attrVal=@l_attrVal where componentNameId=@clientId and attrName=@l_attrName and modified = 0
				-- cleanup percent
				SET @l_attrName='Idx: cleanup percent'
				SET @l_attrVal = '90'
				if (@l_freshInstall = 0)
				BEGIN
					SELECT @l_attrVal=CAST(ic.AgeingPercentDiskspace as varchar(256))  from IdxAccessPath iap, IdxCache ic where IdxAccessPathId=@l_idxAPId and iap.IdxCacheId = ic.IdxCacheId  and ic.IdxCacheType=1
				END
				SET @l_attrType=1
				IF (not exists (select 1 from APP_ClientProp where componentNameId=@clientId and attrName=@l_attrName))
					insert into APP_ClientProp VALUES (@clientId, @l_attrName, @l_attrType, @l_attrVal, @l_currentTime, 0, 0)
				ELSE
					UPDATE APP_ClientProp SET attrVal=@l_attrVal where componentNameId=@clientId and attrName=@l_attrName
----------------- To be removed after making RM and ArchManager changes ----------------------------
------------------------------------inserting IDX config old style during new MA install------------
				IF (@l_idxAPId = 0)
				BEGIN
					INSERT INTO   IdxPool(Description, Enabled, IsShared, AgeingNoOfDays)
						VALUES		( 'tmpPool#', 1, 0, 15);
						SET @l_poolId = (SELECT SCOPE_IDENTITY())
						-- update index pool name
						UPDATE IdxPool
						SET Description = 'INDEXPOOL_' + convert (varchar, @l_poolId)
						WHERE IdxPoolId = @l_poolId
						-- on 6.1 set update mode to 2 - if recognized exactly, use it, if not, then overwrite what we have
					IF (@l_updateMode = 1)
					BEGIN
						SET @l_updateMode = 2
					END
					INSERT INTO   IdxCache(	IdxPoolId, Enabled, Softstate, OfflineReason,
									FreeDiskSpaceMB, FillUpOrder,
									Creationtime,  Description,
									AgeingPercentDiskspace,
									LastUpdateTime, LastUpdateAPId, DiskUsageMB, DiskUsageLastChecked,
									DiskFreeThresholdMB, DiskFreeWarningThreshholdMB, IdxCacheType, DiskReadSpeed, DiskWriteSpeed, CatalogServerClientId, flags, TotalCapacityMB)
					VALUES
							(
								@l_poolId,  1, 1, 0,
								-1, 0,
								dbo.GetUnixTime(GETUTCDATE()), 'VeryTempName#',
								90,
								@l_updateMode, -1,-1,0,
								cast (@largeMinFreeSpace as INT), cast (@largeWarningFreeSpace as INT), 1, 0, 0, 0, 0, 0
							)
						-- above: Updatemode was forced to overwrite
					SET @l_idxCacheId = (SELECT SCOPE_IDENTITY())
					-- update index cache name
					UPDATE IdxCache
					SET Description = 'INDEXCACHE_' + convert (varchar, @l_idxCacheId)
					WHERE IdxCacheId = @l_idxCacheId
					INSERT INTO   IdxAccessPath
						(
							IdxCacheId, ClientId,
							Path, Username, Password, Enabled,
							SoftState, OfflineReason, Priority, LocalIndexTimeStamp, ActualDaysIndexRetain, Flags,
							AgeingNoOfDays, AgeingPercentDiskspace, DiskFreeThresholdMB, DiskFreeWarningThreshholdMB, TotalCapacityMB, StagingCachePath, VolumeGUID
						) VALUES
						(
							@l_idxCacheId, @i_ClientId,
							@i_Location, @i_Username, @i_Password, 1,
							1, 11, 0, 0, 0, 0,
							0, 0, cast (@largeMinFreeSpace as INT), cast (@largeWarningFreeSpace as INT), 0, '', ''
						)
				END
-----------------
				SET @l_alreadyUpdated=1
			END
		END
	END
	IF (@l_alreadyUpdated=0)
	BEGIN
		-- update mode 0: overwrite ICL without a second thought.
		-- update mode 1: do an autodetect. If an index cache is found and is valid, use it, else fail writing the ICL
		-- update mode 2: do an autodetect. If another index cache is found, use it, else overwrite the ICL no matter what it says
		-- check if we need toi create a whole structure or update something existing
		IF (@l_idxAPId > 0)
		BEGIN
			SET @l_idxCacheId = ( SELECT idxCacheId FROM idxAccessPath WHERE idxAccessPathId = @l_idxAPId )
			BEGIN
				-- always update the idxcache table, no matter whether there are one or more access paths for a given cacheId
				UPDATE IdxCache
				SET LastUpdateTime = @l_updateMode, LastUpdateAPId = @l_idxAPId
				WHERE idxCacheId = @l_idxCacheId
				UPDATE IdxAccessPath
				SET 	Path = @i_Location, Username = @i_Username, Password = @i_Password,
					SoftState = 0, OfflineReason = 11
				WHERE idxAccessPathId = @l_idxAPId
			END
		END ELSE
		BEGIN
			INSERT INTO   IdxPool(Description, Enabled, IsShared, AgeingNoOfDays)
			VALUES		( 'tmpPool#', 1, 0, 15);
			SET @l_poolId = (SELECT SCOPE_IDENTITY())
			-- update index pool name
			UPDATE IdxPool
			SET Description = 'INDEXPOOL_' + convert (varchar, @l_poolId)
			WHERE IdxPoolId = @l_poolId
			-- on 6.1 set update mode to 2 - if recognized exactly, use it, if not, then overwrite what we have
			IF (@l_updateMode = 1)
			BEGIN
				SET @l_updateMode = 2
			END
			INSERT INTO   IdxCache(	IdxPoolId, Enabled, Softstate, OfflineReason,
							FreeDiskSpaceMB, FillUpOrder,
							Creationtime,  Description,
							AgeingPercentDiskspace,
							LastUpdateTime, LastUpdateAPId, DiskUsageMB, DiskUsageLastChecked,
							DiskFreeThresholdMB, DiskFreeWarningThreshholdMB, IdxCacheType, DiskReadSpeed, DiskWriteSpeed, CatalogServerClientId, flags, TotalCapacityMB)
			VALUES
					(
						@l_poolId,  1, 1, 0,
						-1, 0,
						dbo.GetUnixTime(GETUTCDATE()), 'VeryTempName#',
						90,
						@l_updateMode, -1,-1,0,
						cast (@largeMinFreeSpace as INT), cast (@largeWarningFreeSpace as INT), 1, 0, 0, 0, 0, 0
					)
				-- above: Updatemode was forced to overwrite
			SET @l_idxCacheId = (SELECT SCOPE_IDENTITY())
			-- update index cache name
			UPDATE IdxCache
			SET Description = 'INDEXCACHE_' + convert (varchar, @l_idxCacheId)
			WHERE IdxCacheId = @l_idxCacheId
			INSERT INTO   IdxAccessPath
			(
				IdxCacheId, ClientId,
				Path, Username, Password, Enabled,
				SoftState, OfflineReason, Priority, LocalIndexTimeStamp, ActualDaysIndexRetain, Flags,
				AgeingNoOfDays, AgeingPercentDiskspace, DiskFreeThresholdMB, DiskFreeWarningThreshholdMB, TotalCapacityMB, StagingCachePath, VolumeGUID
			) VALUES
			(
				@l_idxCacheId, @i_ClientId,
				@i_Location, @i_Username, @i_Password, 1,
				0, 11, 0, 0, 0, 0,
				0, 0, cast (@largeMinFreeSpace as INT), cast (@largeWarningFreeSpace as INT), 0, '', ''
			)
		END
	END
	SELECT 0
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2UpdateIndexCacheForInstall')
	delete from GxQscripts where name = 'MMS2UpdateIndexCacheForInstall'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2UpdateIndexCacheForInstall')
	delete from GXDBVersions where aliasname = 'MMS2UpdateIndexCacheForInstall'
GO

insert into GXDBVersions values(2, 'MMS2UpdateIndexCacheForInstall',  '00010027000200060000', 'MMS2UpdateIndexCacheForInstall', '00010027000200060000')
GO

