

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2UpdateDriveStateHistoryForAllControllers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2UpdateDriveStateHistoryForAllControllers.sp,v $ $Id: MMS2UpdateDriveStateHistoryForAllControllers.sp,v 1.1.304.1 2018/03/20 20:03:08 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2UpdateDriveStateHistoryForAllControllers <<<'

IF EXISTS (select * from sysobjects where name='MMS2UpdateDriveStateHistoryForAllControllers')
	drop procedure MMS2UpdateDriveStateHistoryForAllControllers
IF EXISTS (select * from GxQscripts where name='MMS2UpdateDriveStateHistoryForAllControllers')
	delete from GxQscripts where name = 'MMS2UpdateDriveStateHistoryForAllControllers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2UpdateDriveStateHistoryForAllControllers')
	delete from GXDBVersions where aliasname = 'MMS2UpdateDriveStateHistoryForAllControllers'
GO
print '... Creating Procedure: MMS2UpdateDriveStateHistoryForAllControllers'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2UpdateDriveStateHistoryForAllControllers
  @i_DriveId integer,
  @i_State integer,
  @i_Reason integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @rowCount integer
	IF object_id('tempdb.dbo.#tmpControllers') is not null DROP TABLE #tmpControllers
	IF object_id('tempdb.dbo.#tmpTopEntries') is not null DROP TABLE #tmpTopEntries
	create table #tmpControllers(DriveControllerId	integer,
					ClientId	integer,
					isPresent	integer)
	create table #tmpTopEntries(	DriveId		integer,
					ClientId	integer,
					State		integer,
					stateChangeTime	dateTime)
	insert into #tmpControllers
	select MDC.DriveControllerId, MDC.ClientId, 0
	from MMDriveController as MDC
	where MDC.DriveId = @i_driveId and MDC.DriveControllerId = MDC.DriveControllerId
	insert into #tmpTopEntries
	select top 1 MDH.DriveId, MDH.ClientId, MDH.State, MDH.StateChangeTime
	from MMDriveStateHistory as MDH, #tmpControllers tt
	where MDH.DriveId = @i_driveId and MDH.ClientId = tt.ClientId and MDH.State = @i_State
	order by StateChangeTime DESC
	update #tmpControllers
	set isPresent = 1
	from #tmpControllers as tt1, #tmpTopEntries as tt2
	where tt1.ClientId = tt2.ClientId
	delete from #tmpControllers
	where isPresent = 1
	insert into MMDriveStateHistory
	select @i_driveId, tt.ClientId, @i_State, getUtcDate(), @i_reason
	from #tmpControllers as tt
	select @@ROWCOUNT
	drop table #tmpControllers
	drop table #tmpTopEntries
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2UpdateDriveStateHistoryForAllControllers')
	delete from GxQscripts where name = 'MMS2UpdateDriveStateHistoryForAllControllers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2UpdateDriveStateHistoryForAllControllers')
	delete from GXDBVersions where aliasname = 'MMS2UpdateDriveStateHistoryForAllControllers'
GO

insert into GXDBVersions values(2, 'MMS2UpdateDriveStateHistoryForAllControllers',  '00010001030400010000', 'MMS2UpdateDriveStateHistoryForAllControllers', '00010001030400010000')
GO

