

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2UpdateDriveConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2UpdateDriveConfig.sp,v $ $Id: MMS2UpdateDriveConfig.sp,v 1.17.300.2 2018/03/20 20:00:30 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "MMS2UpdateDriveConfig"								|
--	|																		|
--	|THIS PROCEDURE WILL TEST TO SEE IF THE STRING "NEWSTRING" IS ALREADY A	|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS	                                                |
--  | Tinku:CCM:Archive File Id's are no longer unique						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2UpdateDriveConfig <<<'

IF EXISTS (select * from sysobjects where name='MMS2UpdateDriveConfig')
	drop procedure MMS2UpdateDriveConfig
IF EXISTS (select * from GxQscripts where name='MMS2UpdateDriveConfig')
	delete from GxQscripts where name = 'MMS2UpdateDriveConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2UpdateDriveConfig')
	delete from GXDBVersions where aliasname = 'MMS2UpdateDriveConfig'
GO
print '... Creating Procedure: MMS2UpdateDriveConfig'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2UpdateDriveConfig
  @libraryId integer,
  @isBlind integer
AS
  DECLARE @errorCode integer
  DECLARE @errorString char(255)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	set @errorCode = 0
	set @errorString = ''
	--When the library or the drives are just configured, the first config update
	--that comes in has empty drive values, which prevents the insertion into the
	--temp table, hence we check for that condition here and bail out.
	IF object_id('CommServ.dbo.MMTmpDriveConfig') IS null goto error_exit
	IF not exists (select top 1 * from MMTmpDriveConfig)
	BEGIN
		goto error_exit
	END
	create table #tmpDrive(DriveId	integer,
					isOccupied	integer,
					mediaId		integer,
					MountStatus	integer,
					VolumeId	integer)
	insert into #tmpDrive
	select MD.DriveId, MD.DriveOccupied, MD.MediaId, MD.MountStatus, MD.VolumeId
	from MMDrive as MD WITH (READUNCOMMITTED), MMMasterPool as MS WITH (READUNCOMMITTED)
	where MD.DriveId <> 0 and MD.DriveTypeId <> 10001 and
	MD.MasterPoolId = MS.MasterPoolId AND MS.LibraryId = @libraryId
	--1) Set the LibraryId in Media table
	--2) Declare Media known.
	update MMMedia
	set LibraryId = tt.LibraryId, MediaLocation = 2
	from MMTmpDriveConfig as tt
	where tt.IsOccupied = 1 and tt.CartridgePCL <> '' and BarCode = tt.CartridgePCL
	set @errorCode = @@ERROR
	if(@errorCode <> 0)
	begin
		set @errorString = 'Failed to update the libraryId in MMMedia table'
		goto error_exit
	end
	-- Declare media in the drive as known.
	update MMMedia
	set LibraryId = tt.LibraryId, MediaLocation = 2
	from MMTmpDriveConfig as tt, #tmpDrive as D, MMMedia as MM
	where  tt.DriveId = D.DriveId  and tt.IsOccupied = 1
	and MM.MediaId = D.MediaId and MM.MediaId > 0
	set @errorCode = @@ERROR
	if(@errorCode <> 0)
	begin
		set @errorString = 'Failed to declare media in drives known.'
		goto error_exit
	end
	-- If the drive was occupied and we know the media id
	-- then if the drive is not occupied now then mark the media as not stuck
	update MMMedia
	set MediaLocation = 1, LibraryId = tt.LibraryId, containerId = 0
	from #tmpDrive as MD, MMTmpDriveConfig as tt, MMMedia as MM
	where tt.DriveId = MD.DriveId and MD.MediaId <> 0 and MD.Mediaid = MM.MediaId
	and MD.isOccupied = 1 and tt.IsOccupied = 0 and @isBlind = 1
	and exists(select SlotId from MMSlot WITH (READUNCOMMITTED) where MediaId = MD.MediaId)
	set @errorCode = @@ERROR
	if(@errorCode <> 0)
	begin
		set @errorString = 'Failed to update media table'
		goto error_exit
	end
	update MMDrive
	set DriveOccupied = tt.IsOccupied
	from MMTmpDriveConfig as tt
	where tt.DriveId = MMDrive.DriveId
	update MMDrive
	set SCSIDeviceIdentifier = tt.SCSIDeviceIdentifier
	from MMTmpDriveConfig as tt
	where tt.DriveId = MMDrive.DriveId
	set @errorCode = @@ERROR
	if(@errorCode <> 0)
	begin
		set @errorString = 'Failed to update the DriveOccupied field in MMDrive table'
		goto error_exit
	end
	--First update the drives that are occupied and have unusable volume in them
	update MMDrive
	set MountStatus = 4, CurrentFileMarker = -1,
	FileMarkerCacheType = 0
	from MMTmpDriveConfig as tt, #tmpDrive as D
	where MMDrive.DriveId = D.DriveId AND D.DriveId = tt.DriveId
	and tt.isOccupied = 1 and D.VolumeId < 0
	set @errorCode = @@ERROR
	if(@errorCode <> 0)
	begin
		set @errorString = 'Failed to update the Drive Table'
		goto error_exit
	end
	--ElementAddress has been removed in 7.0
	--Bheemesh 05/31/2006
	--update the drives that are occupied and have usable volume in them
	--update MMDrive
	--set ElementAddress = tt.ElementAddress
	--from MMTmpDriveConfig as tt, #tmpDrive as D, MMDrive as MD
	--where MD.DriveId = D.DriveId and D.DriveId = tt.DriveId and D.VolumeId >= 0
	--and tt.isOccupied = 1
	set @errorCode = @@ERROR
	if(@errorCode <> 0)
	begin
		set @errorString = 'Failed to update the Drive Table'
		goto error_exit
	end
	--update the drives that are not occupied and
	--whose MountStatus is mounting.
	update MMDrive
	set MediaId = 0, DriveSoftState = 1,
	VolumeId = 0, MountStatus = D.MountStatus, SlotName = 'N/A', CurrentFileMarker = -1,
	FileMarkerCacheType = 0, SlotElementAddress = -1
	from MMTmpDriveConfig as tt, #tmpDrive as D
	where MMDrive.DriveId = D.DriveId AND D.DriveId = tt.DriveId
	and D.MountStatus = 2 and tt.isOccupied = 0
	set @errorCode = @@ERROR
	if(@errorCode <> 0)
	begin
		set @errorString = 'Failed to update the Drive Table'
		goto error_exit
	end
	--update the drives that are not occupied and
	--whose MountStatus is not mounting.
	update MMDrive
	set MediaId = 0, DriveSoftState = 1,
	VolumeId = 0, MountStatus = 0, SlotName = 'N/A', CurrentFileMarker = -1,
	FileMarkerCacheType = 0, SlotElementAddress = -1
	from MMTmpDriveConfig as tt, #tmpDrive as D
	where MMDrive.DriveId = D.DriveId AND D.DriveId = tt.DriveId
	and D.MountStatus <> 2 and tt.isOccupied = 0
	set @errorCode = @@ERROR
	if(@errorCode <> 0)
	begin
		set @errorString = 'Failed to update the Drive Table'
		goto error_exit
	end
	--Now do the UpdateMediaInfo
	--1) Set the LibraryId in Media table
	--2) Declare Media known.
	update MMDrive
	set MediaId = MM.MediaId
	from MMMedia as MM WITH (READUNCOMMITTED), MMTmpDriveConfig as tt, #tmpDrive as D
	where MMDrive.DriveId = D.DriveId AND D.DriveId = tt.DriveId
	AND tt.CartridgePCL <> '' and tt.CartridgePCL = MM.BarCode
	set @errorCode = @@ERROR
	if(@errorCode <> 0)
	begin
		set @errorString = 'Failed to update the drive t able'
		goto error_exit
	end
	--Update the soft state and reset the Request Id for all the unoccupied drives.
	update MMDrive
	set DriveSoftState = 1, RequestId = 0
	from MMTmpDriveConfig as tt
	where MMDrive.DriveId = tt.DriveId and tt.isOccupied = 0
	set @errorCode = @@ERROR
	if(@errorCode <> 0)
	begin
		set @errorString = 'Failed to update the soft state for the drives'
		goto error_exit
	end
	--Update the softstate for all the drive controllers if the drive is now not occupied.
	update MMDriveController
	set DriveControllerSoftState = 1
	from MMTmpDriveConfig as tt
	where MMDriveController.DriveId = tt.Driveid
	AND tt.isOccupied = 0
	set @errorCode = @@ERROR
	if(@errorCode <> 0)
	begin
		set @errorString = 'Failed to update the Drive Controller soft state'
		goto error_exit
	end
	update MMVolume
	set VolumeState = 0
	from #tmpDrive as MD, MMTmpDriveConfig as tt, MMVolume as MV
	where tt.DriveId = MD.DriveId and MD.MediaId <> 0 and MD.VolumeId = MV.VolumeId
	and MD.isOccupied = 1 and tt.IsOccupied = 0
	set @errorCode = @@ERROR
	if(@errorCode <> 0)
	begin
		set @errorString = 'Failed to update Volume table'
		goto error_exit
	end
	error_exit:
		--Delete the rows or drop the table only if the table exists. Other wise just pass through.
		IF object_id('CommServ.dbo.MMTmpDriveConfig') IS not null delete from MMTmpDriveConfig
		IF object_id('CommServ.dbo.#tmpDrive') IS not null drop table #tmpDrive
		select @errorCode, @errorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2UpdateDriveConfig')
	delete from GxQscripts where name = 'MMS2UpdateDriveConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2UpdateDriveConfig')
	delete from GXDBVersions where aliasname = 'MMS2UpdateDriveConfig'
GO

insert into GXDBVersions values(2, 'MMS2UpdateDriveConfig',  '00010017030000020000', 'MMS2UpdateDriveConfig', '00010017030000020000')
GO

