

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2TempSaveDriveConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2TempSaveDriveConfig.sp,v $ $Id: MMS2TempSaveDriveConfig.sp,v 1.8.208.1 2018/03/20 19:47:28 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2TempSaveDriveConfig <<<'

IF EXISTS (select * from sysobjects where name='MMS2TempSaveDriveConfig')
	drop procedure MMS2TempSaveDriveConfig
IF EXISTS (select * from GxQscripts where name='MMS2TempSaveDriveConfig')
	delete from GxQscripts where name = 'MMS2TempSaveDriveConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2TempSaveDriveConfig')
	delete from GXDBVersions where aliasname = 'MMS2TempSaveDriveConfig'
GO
print '... Creating Procedure: MMS2TempSaveDriveConfig'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2TempSaveDriveConfig
  @i_bayName varchar(256),
  @i_cartridgePCL varchar(256),
  @i_elementAddress integer,
  @i_isOccupied integer,
  @i_isAccessible integer,
  @i_libraryId integer,
  @i_sSCSIDeviceIdentifier varchar(256)
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @rowCount integer
	DECLARE	@l_RowCount		integer
	DECLARE @l_DriveId		integer
	DECLARE @l_libBaseAddr	integer
	DECLARE	@l_DriveNumber	integer
	set @i_LibraryId = @i_libraryId
	set @l_libBaseAddr = 0
	set @l_libBaseAddr = ISNULL((select BaseAddress from MMLibrary where LibraryId = @i_libraryId), 0)
	set @l_DriveId = ISNULL((Select DriveId from MMDrive AS MD, MMMasterPool as MMP
	where @i_elementAddress = (MD.DriveNumber + @l_libBaseAddr - 1)
	And MD.MasterPoolId = MMP.MasterPoolId
	AND MMP.LibraryId = @i_LibraryId), 0)
	set @l_RowCount		= 0
	--If this drive is not found in the DB, then don't do anything on this.
	if(@l_DriveId <= 0)
	begin
		select 0
	end
	else
	begin
		Set @l_DriveNumber = @i_elementAddress - @l_libBaseAddr + 1
		IF object_id('CommServ.dbo.MMTmpDriveConfig') is null
		BEGIN
		create table MMTmpDriveConfig(DriveId		integer,
						BayName		VARCHAR(256),
						CartridgePCL	VARCHAR(256),
						DriveNumber	integer,
						isOccupied	integer,
						isAccessible	integer,
						libraryId	integer,
						SCSIDeviceIdentifier	VARCHAR(256))
		END
		if exists(select * from MMTmpDriveConfig where DriveId = @l_DriveId)
		begin
			update  MMTmpDriveConfig set CartridgePCL=@i_CartridgePCL, isOccupied=@i_isOccupied, isAccessible=@i_isAccessible,
					libraryId=@i_LibraryId, SCSIDeviceIdentifier=@i_sSCSIDeviceIdentifier, BayName=@i_BayName, DriveNumber=@l_DriveNumber
					where DriveId = @l_DriveId
		end
		else
		begin
			insert into MMTmpDriveConfig
				select @l_DriveId, @i_BayName, @i_CartridgePCL, @l_DriveNumber,
					@i_isOccupied, @i_isAccessible, @i_LibraryId, @i_sSCSIDeviceIdentifier
		end
		set @l_RowCount = @@ROWCOUNT
		if(@@ERROR <> 0)
		begin
			select 0
		end
		else
		begin
			select @l_RowCount
		end
	end
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2TempSaveDriveConfig')
	delete from GxQscripts where name = 'MMS2TempSaveDriveConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2TempSaveDriveConfig')
	delete from GXDBVersions where aliasname = 'MMS2TempSaveDriveConfig'
GO

insert into GXDBVersions values(2, 'MMS2TempSaveDriveConfig',  '00010008020800010000', 'MMS2TempSaveDriveConfig', '00010008020800010000')
GO

