

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2SyncDDBConfigValues.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2SyncDDBConfigValues.sp,v $ $Id: MMS2SyncDDBConfigValues.sp,v 1.5.66.5 2020/11/06 16:44:08 abilbrey Exp $";
--  +========================================================================+
--  | Stored Proc:  MMS2SyncDDBConfigValues()
--  |
--  | Description:  syncs the encrypted and decrypted values of DDB limit params.
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMS2SyncDDBConfigValues')
BEGIN
	print '>>> Drop Stored Procedure: MMS2SyncDDBConfigValues <<<'
	drop procedure MMS2SyncDDBConfigValues
END
IF EXISTS (select * from GxQscripts where name='MMS2SyncDDBConfigValues')
	delete from GxQscripts where name = 'MMS2SyncDDBConfigValues'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2SyncDDBConfigValues')
	delete from GXDBVersions where aliasname = 'MMS2SyncDDBConfigValues'
GO
print '... Creating Procedure: MMS2SyncDDBConfigValues'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMS2SyncDDBConfigValues
AS
  DECLARE @o_retVal INTEGER = 0
SET NOCOUNT ON
	DECLARE @lt_ConfigPropTbl  TABLE (configName varchar(1024), propName varchar(1024), defaultVal int)
	--DECLARE @lt_PropTbl  TABLE (propName varchar(1024), defaultVal int) Moving entityProp values to archGroup, archGroupCopy Tables
	DECLARE	@encryptedString varchar(max)
	DECLARE	@decryptedString varchar(max)
	DECLARE @decryptedValue  int
	DECLARE @paramValue		int
	DECLARE @DDBSubclientExtensionValue	 int
	DECLARE @DDBSubclientExtensionEncrypted varchar(max)
	DECLARE @configName	varchar(1024)
	DECLARE @propName	varchar(1024)
	DECLARE @defaultVal int
	DECLARE @SPId	int
	DECLARE @DecryptedEntityId int
	-- Temp table to sync the prop whose encrypted value stored in MMEntityProp and decrypted value stored in MMConfigs
	INSERT INTO @lt_ConfigPropTbl
VALUES('MMCONFIG_MAX_PRIMARYRECS_IN_SIDB_MIL', 'MaxPrimaryRecsInSIDB', 1000),
('MMCONFIG_STORE_LIMIT_PERC', 'StoreLimitForNewSubclientPerc', 80),
('MMCONFIG_MAX_AVGQITIME_FOR_SIDB','MaxAvgQITime', 2000),
('MMCONFIG_STORE_AVG_QI_TIME_LIMIT_DAYS_TO_CONSIDER', 'DaysToConsiderStoreAvgQITimeLimits', 14)
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
	/* Not required since we are directly querying archGroup, archGroupcopy Tables
	-- Temp table to sync the prop whose encrypted and decrypted values stored in MMEntityProp
	INSERT INTO @lt_PropTbl
VALUES ('NoOfDDBLimitExtensionRetries', 0),
('DDBLimitExtensionTimeStamp', 0),
('DDBSubclientLimitExtensionTimeStamp', 0)
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
	*/
	DECLARE Sync_Config_Prop_Cursor CURSOR LOCAL FORWARD_ONLY FOR
	SELECT	configName, propName, defaultVal
	FROM	@lt_ConfigPropTbl
	OPEN Sync_Config_Prop_Cursor
	FETCH NEXT FROM Sync_Config_Prop_Cursor INTO @configName, @propName, @defaultVal
	WHILE (@@FETCH_STATUS = 0)
	BEGIN
		SET @encryptedString = ''
		SET @decryptedString = ''
		SET @decryptedValue = 0
		SET @paramValue  	 = 0
		SELECT 	TOP 1 @encryptedString = value
		FROM	GxGlobalParam WITH (READUNCOMMITTED)
		WHERE	name = @propName
		SELECT	@o_retVal = @@ERROR
		IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
		IF ISNULL(@encryptedString, '') = ''
			SET @decryptedValue = @defaultVal
		ELSE
		BEGIN
			EXEC miscProc2 @encryptedString, @decryptedString OUTPUT
			SELECT	@o_retVal = @@ERROR
			IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
			IF ISNULL(@decryptedString, '') = ''
				SET @decryptedValue = @defaultVal
			ELSE
				SET @decryptedValue = CAST(@decryptedString as int)
		END
		SELECT	@paramValue = value
		FROM	MMConfigs WITH (READUNCOMMITTED)
		WHERE	name = @configName
		SELECT	@o_retVal = @@ERROR
		IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
		IF @paramValue <> @decryptedValue
		BEGIN
			UPDATE	MMConfigs
			SET		value = @decryptedValue
			WHERE	name = @configName
			SELECT	@o_retVal = @@ERROR
			IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
		END
		FETCH NEXT FROM Sync_Config_Prop_Cursor INTO @configName, @propName, @defaultVal
	END
	CLOSE Sync_Config_Prop_Cursor
	DEALLOCATE Sync_Config_Prop_Cursor
	SET @DDBSubclientExtensionEncrypted = ''
	SET @DDBSubclientExtensionValue = 0
	DECLARE Sync_Prop_Cursor CURSOR LOCAL FORWARD_ONLY FOR
	SELECT	AG.id, SubclientExtensionTimeStamp, SubclientExtensionTimeStampEncrypted
	FROM	archGroup AG WITH (READUNCOMMITTED)
	JOIN archGroupCopy AGC WITH (READUNCOMMITTED)
		ON AGC.id = AG.defaultCopy
WHERE ((AGC.dedupeFlags & 262144) > 0)
	OPEN Sync_Prop_Cursor
	FETCH NEXT FROM Sync_Prop_Cursor INTO @SPId, @DDBSubclientExtensionValue, @DDBSubclientExtensionEncrypted
	WHILE (@@FETCH_STATUS = 0)
	BEGIN
		SET @decryptedString = ''
		SET @decryptedValue = 0
		SET @DecryptedEntityId = 0
		IF ISNULL(@DDBSubclientExtensionEncrypted, '') = ''
			SET @decryptedValue = 0
		ELSE
		BEGIN
			EXEC miscProc2 @DDBSubclientExtensionEncrypted, @decryptedString OUTPUT
			SELECT	@o_retVal = @@ERROR
			IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
			IF (ISNULL(@decryptedString, '') = '' OR CHARINDEX('_', @decryptedString) <= 0)
				SET @decryptedValue = 0
			ELSE
			BEGIN
				SET @DecryptedEntityId = CAST(SUBSTRING(@decryptedString, 1, CHARINDEX('_', @DecryptedString)-1) as int)
				IF @DecryptedEntityId <> @SPId
					SET @decryptedValue = 0
				ELSE
					SET @decryptedValue = CAST(SUBSTRING(@decryptedString, CHARINDEX('_', @DecryptedString)+1, 100) as int)
			END
		END
		IF @DDBSubclientExtensionValue <> @decryptedValue
		BEGIN
			UPDATE	archGroup
			SET		SubclientExtensionTimeStamp = @decryptedValue
			WHERE	id = @SPId
				AND	SubclientExtensionTimeStamp <> @decryptedValue
			SELECT	@o_retVal = @@ERROR
			IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
		END
		SET @DDBSubclientExtensionEncrypted = ''
		SET @DDBSubclientExtensionValue  	 = 0
		FETCH NEXT FROM Sync_Prop_Cursor INTO @SPId, @DDBSubclientExtensionValue, @DDBSubclientExtensionEncrypted
	END
	CLOSE Sync_Prop_Cursor
	DEALLOCATE Sync_Prop_Cursor
CX_EXIT:
CX_ERROR_EXIT:
	SELECT   @o_retVal
	RETURN  @o_retVal
-- END of stored procedure
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2SyncDDBConfigValues')
	delete from GxQscripts where name = 'MMS2SyncDDBConfigValues'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2SyncDDBConfigValues')
	delete from GXDBVersions where aliasname = 'MMS2SyncDDBConfigValues'
GO

insert into GXDBVersions values(2, 'MMS2SyncDDBConfigValues',  '00010005006600050000', 'MMS2SyncDDBConfigValues', '00010005006600050000')
GO

