

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2SetVolumeFull.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2SetVolumeFull.sp,v $ $Id: MMS2SetVolumeFull.sp,v 1.17.80.3 2018/09/25 05:46:46 pnara Exp $";
--
--  +========================================================================+
--  | Stored Precedure: MMS2SetVolumeFull()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2SetVolumeFull <<<'

IF EXISTS (select * from sysobjects where name='MMS2SetVolumeFull')
	drop procedure MMS2SetVolumeFull
IF EXISTS (select * from GxQscripts where name='MMS2SetVolumeFull')
	delete from GxQscripts where name = 'MMS2SetVolumeFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2SetVolumeFull')
	delete from GXDBVersions where aliasname = 'MMS2SetVolumeFull'
GO
print '... Creating Procedure: MMS2SetVolumeFull'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2SetVolumeFull
  @i_VolumeID integer,
  @i_LogEvent integer output,
  @i_VolumeFullReason integer,
  @i_JobID_l integer,
  @i_JobID_h integer,
  @i_doSelect integer
AS
  DECLARE @i_RetCode integer;
  DECLARE @o_LogEvent integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
declare @JobID bigint
set @JobID = convert(bigint, @i_JobID_h)*2147483648 + convert(bigint, @i_JobID_l)
declare @VOL_INVALID integer
declare @VOL_ACTIVE integer
declare @VOL_FULL integer
declare @VOL_READONLY integer
declare @VOL_BAD integer
declare @VOL_IDLE integer
declare @VOL_RECYCLE integer
declare @VOL_ACTIVE_APPEND integer
set @VOL_INVALID = 0
set @VOL_ACTIVE = 1
set @VOL_FULL = 2
set @VOL_READONLY = 3
set @VOL_BAD = 4
set @VOL_IDLE = 5
set @VOL_RECYCLE = 6
set @VOL_ACTIVE_APPEND  = 7
declare @10001 integer
set @10001 = 10001
declare @1 integer
set @1 = 1
declare @3 integer
set @3 = 3
declare @262144 integer
set @262144 = 262144
declare @NewVolumeflag integer
declare @MediaGroupID integer
declare @MediaID integer
declare @VolumeFlags integer
declare @RecordingFormatId integer
declare @LibraryID integer
declare @LibraryTypeID integer
declare @LibraryAttribute integer
declare @ExtendedAttributes integer
set @NewVolumeflag = @VOL_FULL
select @MediaGroupID = MediaGroupId, @MediaID = MediaId, @VolumeFlags = VolumeFlags, @RecordingFormatId = RecordingFormatId
from MMVolume WITH (READUNCOMMITTED)
where VolumeId = @i_VolumeID
if @MediaID is null
or @MediaID <= 0
begin
	set @i_RetCode = 1
	goto ERROR_EXIT
end
select @LibraryID = LibraryId
from MMMedia WITH (READUNCOMMITTED)
where MediaId = @MediaID
-- Rajiv added this to fix
--   MR Created		Yes	08/26/2005	6.1.0	3: Moderate	72031	Build 36	bbaral	Exported Full media: Full media remains the same even after marking appendable	rajiv
if @LibraryID is null
or @LibraryID <= 0
begin
	select @LibraryID = LastWriteLibraryId
	from MMMedia WITH (READUNCOMMITTED)
	where MediaId = @MediaID
end
if @LibraryID is null
or @LibraryID <= 0
begin
--	set @i_RetCode = 2
--	goto ERROR_EXIT
    goto NO_LIBID
end
select @LibraryTypeID = LibraryTypeId, @LibraryAttribute = LibraryAttribute, @ExtendedAttributes = ExtendedAttributes
from MMLibrary WITH (READUNCOMMITTED)
where LibraryId = @LibraryID
if @VolumeFlags = @VOL_READONLY
begin
	-- we don't mark read only volume to another status
	set @i_RetCode = 0
	goto ERROR_EXIT
end
set @i_LogEvent = 1
if @VolumeFlags = @VOL_ACTIVE
or @VolumeFlags = @VOL_ACTIVE_APPEND
or @VolumeFlags = @VOL_IDLE
or @VolumeFlags = @VOL_FULL
or @VolumeFlags = @VOL_BAD
begin
 	set @i_LogEvent = 1
end
if @RecordingFormatId != @10001
begin
if @i_VolumeFullReason = 42003
or @i_VolumeFullReason = 42018
or @i_VolumeFullReason = 42004
or @i_VolumeFullReason = 42005
or @i_VolumeFullReason = 42007
or @i_VolumeFullReason = 42011
or @i_VolumeFullReason = 42014
or @i_VolumeFullReason = 42015
or @i_VolumeFullReason = 42016
or @i_VolumeFullReason = 42017
or @i_VolumeFullReason = 42025
or @i_VolumeFullReason = 42026
or @i_VolumeFullReason = 42027
or @i_VolumeFullReason = 42028
	begin
if @LibraryTypeID = @3
and (@ExtendedAttributes & @1) > 0
		begin
			set @NewVolumeflag = @VOL_ACTIVE_APPEND
		end
		else
		begin
			set @NewVolumeflag = @VOL_FULL
if (@LibraryAttribute & @262144) > 0
			--or @i_VolumeFullReason = E_MM_VOL_FULL_NEW_SCHEDULE_RUN_INSTANCE
			begin
				set @NewVolumeflag = @VOL_ACTIVE_APPEND
			end
		end
		set @i_LogEvent = 0
	end
end
else
begin
if @i_VolumeFullReason = 42025
	begin
		set @NewVolumeflag = @VOL_FULL
if (@ExtendedAttributes & @1) > 0
		begin
			set @NewVolumeflag = @VOL_ACTIVE_APPEND
		end
	end
	-- For the reason of data path or DDB change, do not mark the active volume full.
else if @i_VolumeFullReason IN (42026, 42047)
	begin
		set @NewVolumeflag = @VOL_ACTIVE_APPEND
	end
end
NO_LIBID:
if @i_VolumeFullReason != 0
and @i_VolumeFullReason != 42005
begin
	update MMVolume
	set VolumeFlags = @NewVolumeflag, VolumeFullReason = @i_VolumeFullReason, VolumeFullTime = dbo.GetUnixTime(getutcdate()), VolumeFullJobId = @JobID
	where VolumeId = @i_VolumeID
	and VolumeFlags != @VOL_RECYCLE
	-- Only when volume flag and volume full reason are different, do the update. This will also change the VulumeFullTime.
	-- Otherwise, don't touch the volume.
	and (VolumeFlags != @NewVolumeflag or VolumeFullReason != @i_VolumeFullReason)
	select @i_RetCode = @@error
	if @i_RetCode != 0
		goto ERROR_EXIT
end
else
begin
	update MMVolume
	set VolumeFlags = @NewVolumeflag, VolumeFullTime = dbo.GetUnixTime(getutcdate()), VolumeFullJobId = @JobID
	where VolumeId = @i_VolumeID
	and VolumeFlags != @VOL_RECYCLE
	select @i_RetCode = @@error
	if @i_RetCode != 0
		goto ERROR_EXIT
end
	set @i_RetCode = 0
ERROR_EXIT:
    set @o_LogEvent = @i_LogEvent
    if @i_doSelect > 0
		select @i_RetCode, @o_LogEvent
	RETURN	@i_RetCode;
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2SetVolumeFull')
	delete from GxQscripts where name = 'MMS2SetVolumeFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2SetVolumeFull')
	delete from GXDBVersions where aliasname = 'MMS2SetVolumeFull'
GO

insert into GXDBVersions values(2, 'MMS2SetVolumeFull',  '00010017008000030000', 'MMS2SetVolumeFull', '00010017008000030000')
GO

