

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2SetAllMountTimedOutOccupiedDrivesAsStuck.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2SetAllMountTimedOutOccupiedDrivesAsStuck.sp,v $ $Id: MMS2SetAllMountTimedOutOccupiedDrivesAsStuck.sp,v 1.2.294.1 2018/03/20 19:53:26 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2SetAllMountTimedOutOccupiedDrivesAsStuck <<<'

IF EXISTS (select * from sysobjects where name='MMS2SetAllMountTimedOutOccupiedDrivesAsStuck')
	drop procedure MMS2SetAllMountTimedOutOccupiedDrivesAsStuck
IF EXISTS (select * from GxQscripts where name='MMS2SetAllMountTimedOutOccupiedDrivesAsStuck')
	delete from GxQscripts where name = 'MMS2SetAllMountTimedOutOccupiedDrivesAsStuck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2SetAllMountTimedOutOccupiedDrivesAsStuck')
	delete from GXDBVersions where aliasname = 'MMS2SetAllMountTimedOutOccupiedDrivesAsStuck'
GO
print '... Creating Procedure: MMS2SetAllMountTimedOutOccupiedDrivesAsStuck'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2SetAllMountTimedOutOccupiedDrivesAsStuck
  @commCellId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @DriveId integer	
	if object_id('tempdb.dbo.#tmpDriveNLib') is not null DROP TABLE #tmpDriveNLib
	create table #tmpDriveNLib(	driveId			integer,
					masterPoolId		integer,
					lastUseTime		integer,
					libraryId		integer,
					LibMountTimeOutSec	integer,
					LibUnMountTimeoutSec	integer,
					MountStatus		integer,
					libraryTypeId		integer)
	insert into #tmpDriveNLib
	select distinct MD.driveId, MasterPoolId, lastUseTime, 0, 0, 0, MD.MountStatus, 0
	from MMDrive as MD
	where MD.DriveId <> 0 and
	(MountStatus = 2 OR MountStatus = 3) and DriveOccupied = 1
	update #tmpDriveNLib
	set libraryId = MMP.LibraryId
	from MMMasterPool as MMP, #tmpDriveNLib as tt
	where MMP.MasterPoolId = tt.masterPoolId
	update #tmpDriveNLib
	set LibMountTimeOutSec = ML.MountTimeOutSec, LibUnMountTimeOutSec = ML.UnmountTimeoutSec,
	libraryTypeId = ML.libraryTypeId
	from MMLibrary as ML, #tmpDriveNLib as tt
	where ML.LibraryId = tt.LibraryId
	delete from #tmpDriveNLib
	where libraryTypeId in(4, 5)
	delete from #tmpDriveNLib
	where ( MountStatus = 2 and LastUseTime >= ((datediff(second,'01/01/1970', getutcdate()) - LibMountTimeOutSec)))
	OR
	(MountStatus = 3 and LastUseTime >= ((datediff(second,'01/01/1970', getutcdate()) - LibUnMountTimeOutSec)))
	update MMDrive
	set VolumeId = 0, MountStatus = 4
	where MMDrive.DriveId in(select #tmpDriveNLib.DriveId from #tmpDriveNLib)
	select #tmpDriveNLib.DriveId
	from #tmpDriveNLib
	where #tmpDriveNLib.DriveId > 0
	select @@ROWCOUNT
	drop table #tmpDriveNLib
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2SetAllMountTimedOutOccupiedDrivesAsStuck')
	delete from GxQscripts where name = 'MMS2SetAllMountTimedOutOccupiedDrivesAsStuck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2SetAllMountTimedOutOccupiedDrivesAsStuck')
	delete from GXDBVersions where aliasname = 'MMS2SetAllMountTimedOutOccupiedDrivesAsStuck'
GO

insert into GXDBVersions values(2, 'MMS2SetAllMountTimedOutOccupiedDrivesAsStuck',  '00010002029400010000', 'MMS2SetAllMountTimedOutOccupiedDrivesAsStuck', '00010002029400010000')
GO

