

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2SaveRetrieveScaleOutMetaDataBLOB.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2SaveRetrieveScaleOutMetaDataBLOB.sp,v $ $Id: MMS2SaveRetrieveScaleOutMetaDataBLOB.sp,v 1.1.2.6 2020/07/06 22:15:26 mnatarajan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2SaveRetrieveScaleOutMetaDataBLOB')
BEGIN
	print '>>> Drop Stored Procedure: MMS2SaveRetrieveScaleOutMetaDataBLOB <<<'
	drop procedure MMS2SaveRetrieveScaleOutMetaDataBLOB
END
IF EXISTS (select * from GxQscripts where name='MMS2SaveRetrieveScaleOutMetaDataBLOB')
	delete from GxQscripts where name = 'MMS2SaveRetrieveScaleOutMetaDataBLOB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2SaveRetrieveScaleOutMetaDataBLOB')
	delete from GXDBVersions where aliasname = 'MMS2SaveRetrieveScaleOutMetaDataBLOB'
GO
print '... Creating Procedure: MMS2SaveRetrieveScaleOutMetaDataBLOB'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2SaveRetrieveScaleOutMetaDataBLOB
  @i_optype integer,
  @i_mediaAgentId integer,
  @i_networkInformation XML,
  @i_metaDataLocation varchar(1024)
AS
  DECLARE @o_networkInformation XML
set @o_networkInformation = ''
DECLARE @isOsWindows BIT = dbo.IsOSOnCSWindows()
DECLARE @errorMessage NVARCHAR(MAX) = ''
IF (@i_optype = 1) -- SAVE N/W INFO
BEGIN
	IF EXISTS(SELECT 1 from MMScaleOutMAInfo where ClientId = @i_mediaAgentId)
	BEGIN
		UPDATE MMScaleOutMAInfo
		SET NetworkInformation = @i_networkInformation
		WHERE ClientId = @i_mediaAgentId
	END
	ELSE
	BEGIN
		INSERT INTO MMScaleOutMAInfo
		VALUES (@i_mediaAgentId, @i_networkInformation, cast('' as varbinary(max)),cast('' as XML) )
	END
END
IF(@i_optype = 2)	-- RETRIEVE N/W INFO
BEGIN
	SELECT @o_networkInformation = NetworkInformation FROM MMScaleOutMAInfo where ClientId = @i_mediaAgentId
END
IF(@i_optype = 3)	-- SAVE GLUSTER METADATA
BEGIN
	create table #fileStore (metadata varbinary(max))
	declare @sql nvarchar(2048) =
	N'insert into #fileStore
	select *
	from OPENROWSET(BULK '''+@i_metaDataLocation+''', SINGLE_BLOB) GLUS_METADATA'
	EXEC SQLAdminUtilExecQuery @sql,1
	update MMScaleOutMAInfo
	set GlusterMetaData = (select metadata from #fileStore)
	where clientId = @i_mediaAgentId
	IF OBJECT_ID('tempdb.dbo.#fileStore') IS NOT NULL DROP TABLE #fileStore
END
ELSE IF (@i_optype = 4) -- RETRIEVE GLUSTER METADATA TO FILE
BEGIN
	EXECUTE AS LOGIN = 'sqladmin_cv'
	DECLARE @BIN_DATA VARBINARY(MAX),
    @LOCATION VARCHAR(MAX),
    @ObjectToken INT
	DECLARE BINDATA CURSOR FAST_FORWARD FOR
	SELECT GlusterMetaData from MMScaleOutMAInfo where clientId = @i_mediaAgentId
	OPEN BINDATA
	FETCH NEXT FROM BINDATA INTO @BIN_DATA
	WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @LOCATION = @i_metaDataLocation
			IF @isOsWindows =1
			BEGIN
				EXEC sp_OACreate 'ADODB.Stream', @ObjectToken OUTPUT
				EXEC sp_OASetProperty @ObjectToken, 'Type', 1
				EXEC sp_OAMethod @ObjectToken, 'Open'
				EXEC sp_OAMethod @ObjectToken, 'Write', NULL, @BIN_DATA
				EXEC sp_OAMethod @ObjectToken, 'SaveToFile', NULL, @LOCATION, 2
				EXEC sp_OAMethod @ObjectToken, 'Close'
				EXEC sp_OADestroy @ObjectToken
			END
			ELSE
			BEGIN
				EXEC cv_spWriteBytesToFile @LOCATION , @BIN_DATA, @errorMessage OUTPUT
			END
			FETCH NEXT FROM BINDATA INTO @BIN_DATA
		END
	CLOSE BINDATA
	DEALLOCATE BINDATA
	REVERT
END
select @o_networkInformation

IF EXISTS (select * from GxQscripts where name = 'MMS2SaveRetrieveScaleOutMetaDataBLOB')
	delete from GxQscripts where name = 'MMS2SaveRetrieveScaleOutMetaDataBLOB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2SaveRetrieveScaleOutMetaDataBLOB')
	delete from GXDBVersions where aliasname = 'MMS2SaveRetrieveScaleOutMetaDataBLOB'
GO

insert into GXDBVersions values(2, 'MMS2SaveRetrieveScaleOutMetaDataBLOB',  '00010001000200060000', 'MMS2SaveRetrieveScaleOutMetaDataBLOB', '00010001000200060000')
GO

