

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2RunBarcodePattern.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2RunBarcodePattern.sp,v $ $Id: MMS2RunBarcodePattern.sp,v 1.39.304.2 2018/03/20 19:49:19 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: MMS2RunBarcodePattern()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2RunBarcodePattern <<<'

IF EXISTS (select * from sysobjects where name='MMS2RunBarcodePattern')
	drop procedure MMS2RunBarcodePattern
IF EXISTS (select * from GxQscripts where name='MMS2RunBarcodePattern')
	delete from GxQscripts where name = 'MMS2RunBarcodePattern'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2RunBarcodePattern')
	delete from GXDBVersions where aliasname = 'MMS2RunBarcodePattern'
GO
print '... Creating Procedure: MMS2RunBarcodePattern'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2RunBarcodePattern
  @i_commcellId INTEGER,
  @i_libraryId INTEGER
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/****************************************************************************************/
/************ Initialize and declare temparary variables ********************************/
/****************************************************************************************/
	DECLARE @rowCount			INTEGER
	DECLARE @retValFlag			INTEGER
	DECLARE	@mediaId			INTEGER
	DECLARE	@libraryId			INTEGER
	DECLARE	@libraryTypeId		INTEGER
	DECLARE	@spareGroupId		INTEGER
	DECLARE	@spareGroupType		INTEGER
	DECLARE	@patternId			INTEGER
	DECLARE	@highWaterMark		INTEGER
	DECLARE	@mediaCount			INTEGER
	DECLARE	@mediaNeeded		INTEGER
	DECLARE	@defaultSpareGroupId	INTEGER
DECLARE	@barCode				varchar(256)
DECLARE	@pattern				varchar(256)
DECLARE	@patternAux				varchar(256)
	DECLARE	@patternType	INTEGER
	DECLARE @cursorflag			INTEGER
	DECLARE @cursorflag2			INTEGER
	DECLARE @numMedia	INTEGER
	DECLARE @mediaTypeId	INTEGER
	DECLARE @attributes	INTEGER
	DECLARE @haspattern	INTEGER
	DECLARE @recordingFormatId	INTEGER
	DECLARE @totalBytesMB	INTEGER
	DECLARE @flushBlockSizeKB	INTEGER
	DECLARE @driveTypeId	table (drivetypeid int)
	DECLARE @mediaSideId	INTEGER
	DECLARE @errorString	varchar(1024)
	DECLARE @V_MMS2_NEWLY_DISCOVERRED INTEGER
SET @V_MMS2_NEWLY_DISCOVERRED = 33554432
	SET @numMedia = 0
	SET @retVal = 0
	SET @retValFlag = 0
	SET @cursorflag = 0
	SET	@cursorflag2 = 0
	SET @errorString = 'Warning: '
/****************************************************************************************/
/********************** Create temparary tables *****************************************/
/****************************************************************************************/
	if not exists (select * from mmmedia
				where ( (@i_libraryId != 0 and libraryid = @i_libraryId and medialocation = 1)
				or (@i_libraryid = 0 and libraryid > 0 and medialocation = 1) )
				and IsAged  = 0 and IsInMediaGroup = 0
				and (Attributes & @V_MMS2_NEWLY_DISCOVERRED) > 0)
		GOTO CX_CONTINUE2
	IF EXISTS ( select * from sysobjects where name='#tmSpareGroupListtmp' )
 		drop table #tmSpareGroupListtmp
	IF EXISTS ( select * from sysobjects where name='#tmSpareGroupListtmp2' )
 		drop table #tmSpareGroupListtmp2
	IF EXISTS ( select * from sysobjects where name='#tmMediaListtmp' )
 		drop table #tmMediaListtmp
	IF EXISTS ( select * from sysobjects where name='patternCuror' )
	BEGIN
 		CLOSE patternCuror
 		DEALLOCATE patternCuror
	END
	IF EXISTS ( select * from sysobjects where name='patternCuror2' )
	BEGIN
 		CLOSE patternCuror2
 		DEALLOCATE patternCuror2
	END
	CREATE TABLE #tmSpareGroupListtmp (
			LibraryId INT,
			LibraryTypeId INT,
			SpareGroupId INT,
			PatternId INT,
			HighWaterMark INT,
			MediaCount INT,
			SpareGroupType INT,
			MediaTypeId INT,
			Attributes INT,
			HasPattern INT
	)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'fail to create table #tmSpareGroupListtmp'
			GOTO CX_ERROR_EXIT
	END
	CREATE TABLE #tmMediaListtmp (
			MediaId INT,
			OldFlag INT
	)
	CREATE TABLE #tmMediaListtmp2 (
			MediaId INT,
			OldFlag INT
	)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'fail to create table #tmMediaListtmp'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
/******************** Insert into temprary tables ***************************************/
/****************************************************************************************/
	--Get patterns
	IF @i_libraryId != 0
	BEGIN
		-- specified library
		INSERT	INTO #tmSpareGroupListtmp
SELECT a.LibraryId, c.LibraryTypeId, a.SpareGroupId, b.PatternId, a.HighWaterMark, 0, a.SpareGroupType, a.MediaTypeId, (a.Attributes & (7)), 0
		FROM MMSpareGroup a left outer join MMSpareGroupToPatterns b on a.sparegroupid = b.sparegroupid
		left outer join MMLibrary c on a.libraryid = c.libraryid
		WHERE a.LibraryId = @i_libraryId
AND		a.SpareGroupType in (2, 1, 8, 32, 16)
ORDER BY a.LibraryId, (a.Attributes & (7)) DESC, a.SpareGroupId
	END
	ELSE
	BEGIN
		-- library id is zero
		INSERT	INTO #tmSpareGroupListtmp
SELECT a.LibraryId, c.LibraryTypeId, a.SpareGroupId, b.PatternId, a.HighWaterMark, 0, a.SpareGroupType, a.MediaTypeId, (a.Attributes & (7)), 0
		FROM MMSpareGroup a left outer join MMSpareGroupToPatterns b on a.sparegroupid = b.sparegroupid
		left outer join MMLibrary c on a.libraryid = c.libraryid
		WHERE a.LibraryId > 0
AND		a.SpareGroupType in (2, 1, 8, 32, 16)
ORDER BY a.LibraryId, (a.Attributes & (7)) DESC, a.SpareGroupId
	END
	SELECT	@retVal = @@ERROR, @rowCount = @@ROWCOUNT
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'fail to look up the scratch pool and pattern.'
			GOTO CX_ERROR_EXIT
	END
	IF		@rowCount = 0
	BEGIN
			SET	@retValFlag = 0
			SET @errorString = @errorString + 'no pattern to check'
			GOTO CX_ERROR_EXIT
	END
	UPDATE #tmSpareGroupListtmp
	SET	MediaCount = (select COUNT(*) from MMMedia where IsAged  = 0 and IsInMediaGroup = 0 and SpareGroupId = #tmSpareGroupListtmp.SpareGroupId AND MediaLocation = 1)
	WHERE LibraryTypeId != 8
	UPDATE #tmSpareGroupListtmp
	SET	HasPattern = 1
	WHERE PatternId > 0
	AND	PatternId is not null
	-- shelf
	UPDATE #tmSpareGroupListtmp
	SET	MediaCount = (select COUNT(*) from MMMedia where IsAged  = 0 and IsInMediaGroup = 0 and SpareGroupId = #tmSpareGroupListtmp.SpareGroupId)
	WHERE LibraryTypeId = 8
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'fail to look up the scratch pool and pattern.'
			GOTO CX_ERROR_EXIT
	END
	DELETE	FROM #tmSpareGroupListtmp
	WHERE	MediaCount >= HighWaterMark
	AND		HighWaterMark > 0
	AND		SpareGroupType != 2
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'fail to look up the scratch pool and pattern.'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
/************************************ Run the pattern ***********************************/
/****************************************************************************************/
	DECLARE patternCuror CURSOR FOR
			SELECT	DISTINCT A.LibraryId, A.LibraryTypeId, A.SpareGroupId, A.SpareGroupType,
			A.MediaTypeId, A.PatternId, A.HighWaterMark, A.Attributes, A.HasPattern
			FROM	#tmSpareGroupListtmp A left outer join MMBarCodePatterns B ON A.PatternId = B.PatternId
			ORDER BY a.HasPattern DESC, a.Attributes DESC, A.SpareGroupType DESC
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'fail to declare cursor patternCuror'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
/****************************************************************************************/
	SET		@cursorflag = 1
	OPEN	patternCuror
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'fail to open cursor patternCuror'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
	FETCH	NEXT FROM patternCuror
	INTO	@libraryId, @libraryTypeId, @spareGroupId, @spareGroupType, @mediaTypeId, @patternId, @highWaterMark, @attributes, @haspattern
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'fail to fetch cursor patternCuror'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
	WHILE	@@FETCH_STATUS = 0
	BEGIN
			IF	@patternId is null
			OR	@patternId = 0
			BEGIN
IF @spareGroupType != 1
AND @spareGroupType != 2
				BEGIN
					GOTO CX_CONTINUE
				END
			END
			-- get default spare group
			SELECT @defaultSpareGroupId = SpareGroupId
			FROM MMSpareGroup
WHERE SpareGroupType = 2
			AND	  LibraryId = @libraryId
			-- get media needed count
			if @libraryTypeId != 8
			begin
				SET @mediaNeeded = (SELECT COUNT(*) FROM MMMedia WHERE IsAged  = 0 and IsInMediaGroup = 0 and SpareGroupId = @defaultSpareGroupId AND MediaLocation = 1 and (Attributes & @V_MMS2_NEWLY_DISCOVERRED) > 0)
				-- re get current media count in group
				SET @mediaCount = (SELECT COUNT(*) FROM MMMedia WHERE IsAged  = 0 and IsInMediaGroup = 0 and SpareGroupId = @spareGroupId AND MediaLocation = 1 and (Attributes & @V_MMS2_NEWLY_DISCOVERRED) = 0)
			end
			else
			begin
				SET @mediaNeeded = (SELECT COUNT(*) FROM MMMedia WHERE IsAged  = 0 and IsInMediaGroup = 0 and SpareGroupId = @defaultSpareGroupId and (Attributes & @V_MMS2_NEWLY_DISCOVERRED) > 0)
				-- re get current media count in group
				SET @mediaCount = (SELECT COUNT(*) FROM MMMedia WHERE IsAged  = 0 and IsInMediaGroup = 0 and SpareGroupId = @spareGroupId and (Attributes & @V_MMS2_NEWLY_DISCOVERRED) = 0)
			end
--			IF @spareGroupType != DEFAULT_SPARE_GROUP
--			BEGIN
			IF @highWaterMark > 0
			BEGIN
				SET @mediaNeeded = @highWaterMark - @mediaCount
			END
			IF @mediaNeeded > 0
			BEGIN
				if @libraryTypeId != 8
				begin
					delete from @driveTypeId
					insert into @driveTypeId
					select DriveTypeId
					from MMDrive
					where MasterPoolId in (	select MasterPoolId
											from MMMasterPool
											where LibraryId = @libraryId
											)
				end
				IF	@patternId is null
				OR	@patternId = 0
				BEGIN
					-- no pattern for this group, fill in up to high water mark
					if @libraryTypeId != 8
					begin
						INSERT INTO #tmMediaListtmp
						exec ('select top ' + @mediaNeeded + ' MediaId, 0 from MMMedia where IsAged  = 0 and IsInMediaGroup = 0 and (Attributes & ' + @V_MMS2_NEWLY_DISCOVERRED + ') > 0 and MediaId not in (select mediaid from #tmMediaListtmp) and MediaLocation = 1 and sparegroupid = ' + @defaultsparegroupid)
					end
					else
					begin
						INSERT INTO #tmMediaListtmp
						exec ('select top ' + @mediaNeeded + ' MediaId, 0 from MMMedia where IsAged  = 0 and IsInMediaGroup = 0 and (Attributes & ' + @V_MMS2_NEWLY_DISCOVERRED + ') > 0 and MediaId not in (select mediaid from #tmMediaListtmp) and sparegroupid = ' + @defaultsparegroupid)
					end
				END
				IF	@patternId > 0
				BEGIN
					declare @iteration integer
					set @iteration = 0
					DECLARE patternCuror2 CURSOR FOR
							SELECT	DISTINCT Pattern, PatternAuxParam, PatternType
							FROM	MMBarCodePatternConditions
							WHERE	PatternId = @patternId
					SET		@cursorflag2 = 1
					OPEN	patternCuror2
					FETCH	NEXT FROM patternCuror2
					INTO	@pattern, @patternAux, @patternType
					WHILE	@@FETCH_STATUS = 0
					BEGIN
						delete from #tmMediaListtmp2
IF @patternType = 1
						BEGIN
							set @iteration = @iteration + 1
							if @libraryTypeId != 8
							begin
								INSERT INTO #tmMediaListtmp2
								--exec ('select top ' + @mediaNeeded + ' MediaId, 0 from MMMedia where (Attributes & @V_MMS2_NEWLY_DISCOVERRED) > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and MediaLocation = 1 and sparegroupid = ' + @defaultsparegroupid + ' and barcode like ''' + @pattern + '%''')
								exec ('select MediaId, 0 from MMMedia where IsAged  = 0 and IsInMediaGroup = 0 and (Attributes & ' + @V_MMS2_NEWLY_DISCOVERRED + ') > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and MediaLocation = 1 and sparegroupid = ' + @defaultsparegroupid + ' and barcode like ''' + @pattern + '%''')
							end
							else
							begin
								INSERT INTO #tmMediaListtmp2
								--exec ('select top ' + @mediaNeeded + ' MediaId, 0 from MMMedia where (Attributes & @V_MMS2_NEWLY_DISCOVERRED) > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and sparegroupid = ' + @defaultsparegroupid + ' and barcode like ''' + @pattern + '%''')
								exec ('select MediaId, 0 from MMMedia where IsAged  = 0 and IsInMediaGroup = 0 and (Attributes & ' + @V_MMS2_NEWLY_DISCOVERRED + ') > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and sparegroupid = ' + @defaultsparegroupid + ' and barcode like ''' + @pattern + '%''')
							end
						END
IF @patternType = 2
						BEGIN
							set @iteration = @iteration + 1
							if @libraryTypeId != 8
							begin
								INSERT INTO #tmMediaListtmp2
								--exec ('select top ' + @mediaNeeded + ' MediaId, 0 from MMMedia where (Attributes & @V_MMS2_NEWLY_DISCOVERRED) > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and MediaLocation = 1 and sparegroupid = ' + @defaultsparegroupid + ' and barcode like ''%' + @pattern + '''')
								exec ('select MediaId, 0 from MMMedia where IsAged  = 0 and IsInMediaGroup = 0 and (Attributes & ' + @V_MMS2_NEWLY_DISCOVERRED + ') > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and MediaLocation = 1 and sparegroupid = ' + @defaultsparegroupid + ' and barcode like ''%' + @pattern + '''')
							end
							else
							begin
								INSERT INTO #tmMediaListtmp2
								--exec ('select top ' + @mediaNeeded + ' MediaId, 0 from MMMedia where (Attributes & @V_MMS2_NEWLY_DISCOVERRED) > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and sparegroupid = ' + @defaultsparegroupid + ' and barcode like ''%' + @pattern + '''')
								exec ('select MediaId, 0 from MMMedia where IsAged  = 0 and IsInMediaGroup = 0 and (Attributes & ' + @V_MMS2_NEWLY_DISCOVERRED + ') > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and sparegroupid = ' + @defaultsparegroupid + ' and barcode like ''%' + @pattern + '''')
							end
						END
IF @patternType = 4
						BEGIN
							set @iteration = @iteration + 1
							if @libraryTypeId != 8
							begin
								INSERT INTO #tmMediaListtmp2
								--exec ('select top ' + @mediaNeeded + ' MediaId, 0 from MMMedia where (Attributes & @V_MMS2_NEWLY_DISCOVERRED) > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and MediaLocation = 1 and sparegroupid = ' + @defaultsparegroupid + ' and barcode like ''%' + @pattern + '%''')
								exec ('select MediaId, 0 from MMMedia where IsAged  = 0 and IsInMediaGroup = 0 and  (Attributes & ' + @V_MMS2_NEWLY_DISCOVERRED + ') > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and MediaLocation = 1 and sparegroupid = ' + @defaultsparegroupid + ' and barcode like ''%' + @pattern + '%''')
							end
							else
							begin
								INSERT INTO #tmMediaListtmp2
								--exec ('select top ' + @mediaNeeded + ' MediaId, 0 from MMMedia where (Attributes & @V_MMS2_NEWLY_DISCOVERRED) > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and sparegroupid = ' + @defaultsparegroupid + ' and barcode like ''%' + @pattern + '%''')
								exec ('select MediaId, 0 from MMMedia where IsAged  = 0 and IsInMediaGroup = 0 and (Attributes & ' + @V_MMS2_NEWLY_DISCOVERRED + ') > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and sparegroupid = ' + @defaultsparegroupid + ' and barcode like ''%' + @pattern + '%''')
							end
						END
IF @patternType = 8
						BEGIN
							set @iteration = @iteration + 1
							if @libraryTypeId != 8
							begin
								INSERT INTO #tmMediaListtmp2
								--exec ('select top ' + @mediaNeeded + ' MediaId, 0 from MMMedia where (Attributes & @V_MMS2_NEWLY_DISCOVERRED) > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and MediaLocation = 1 and sparegroupid = ' + @defaultsparegroupid + ' and barcode not like ''%' + @pattern + '%''')
								exec ('select MediaId, 0 from MMMedia where IsAged  = 0 and IsInMediaGroup = 0 and (Attributes & ' + @V_MMS2_NEWLY_DISCOVERRED + ') > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and MediaLocation = 1 and sparegroupid = ' + @defaultsparegroupid + ' and barcode not like ''%' + @pattern + '%''')
							end
							else
							begin
								INSERT INTO #tmMediaListtmp2
								--exec ('select top ' + @mediaNeeded + ' MediaId, 0 from MMMedia where (Attributes & @V_MMS2_NEWLY_DISCOVERRED) > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and sparegroupid = ' + @defaultsparegroupid + ' and barcode not like ''%' + @pattern + '%''')
								exec ('select MediaId, 0 from MMMedia where IsAged  = 0 and IsInMediaGroup = 0 and (Attributes & ' + @V_MMS2_NEWLY_DISCOVERRED + ') > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and sparegroupid = ' + @defaultsparegroupid + ' and barcode not like ''%' + @pattern + '%''')
							end
						END
IF @patternType = 16
						BEGIN
							set @iteration = @iteration + 1
							if @libraryTypeId != 8
							begin
								INSERT INTO #tmMediaListtmp2
								--exec ('select top ' + @mediaNeeded + ' MediaId, 0 from MMMedia where (Attributes & @V_MMS2_NEWLY_DISCOVERRED) > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and MediaLocation = 1 and sparegroupid = ' + @defaultsparegroupid + ' and barcode between ''' + @pattern + ''' and ''' + @patternAux + '''')
								exec ('select MediaId, 0 from MMMedia where IsAged  = 0 and IsInMediaGroup = 0 and (Attributes & ' + @V_MMS2_NEWLY_DISCOVERRED + ') > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and MediaLocation = 1 and sparegroupid = ' + @defaultsparegroupid + ' and barcode between ''' + @pattern + ''' and ''' + @patternAux + '''')
							end
							else
							begin
								INSERT INTO #tmMediaListtmp2
								--exec ('select top ' + @mediaNeeded + ' MediaId, 0 from MMMedia where (Attributes & @V_MMS2_NEWLY_DISCOVERRED) > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and sparegroupid = ' + @defaultsparegroupid + ' and barcode between ''' + @pattern + ''' and ''' + @patternAux + '''')
								exec ('select MediaId, 0 from MMMedia where IsAged  = 0 and IsInMediaGroup = 0  and (Attributes & ' + @V_MMS2_NEWLY_DISCOVERRED + ') > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and sparegroupid = ' + @defaultsparegroupid + ' and barcode between ''' + @pattern + ''' and ''' + @patternAux + '''')
							end
						END
IF @patternType = 32
						BEGIN
							set @iteration = @iteration + 1
							if @libraryTypeId != 8
							begin
								INSERT INTO #tmMediaListtmp2
								--exec ('select top ' + @mediaNeeded + ' MediaId, 0 from MMMedia where (Attributes & @V_MMS2_NEWLY_DISCOVERRED) > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and MediaLocation = 1 and sparegroupid = ' + @defaultsparegroupid + ' and barcode not between ''' + @pattern + ''' and ''' + @patternAux + '''')
								exec ('select MediaId, 0 from MMMedia where IsAged  = 0 and IsInMediaGroup = 0  and (Attributes & ' + @V_MMS2_NEWLY_DISCOVERRED + ') > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and MediaLocation = 1 and sparegroupid = ' + @defaultsparegroupid + ' and barcode not between ''' + @pattern + ''' and ''' + @patternAux + '''')
							end
							else
							begin
								INSERT INTO #tmMediaListtmp2
								--exec ('select top ' + @mediaNeeded + ' MediaId, 0 from MMMedia where (Attributes & @V_MMS2_NEWLY_DISCOVERRED) > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and sparegroupid = ' + @defaultsparegroupid + ' and barcode not between ''' + @pattern + ''' and ''' + @patternAux + '''')
								exec ('select MediaId, 0 from MMMedia where IsAged  = 0 and IsInMediaGroup = 0 and (Attributes & ' + @V_MMS2_NEWLY_DISCOVERRED + ') > 0 and MediaId not in (select mediaid from #tmMediaListtmp where oldflag = 1) and sparegroupid = ' + @defaultsparegroupid + ' and barcode not between ''' + @pattern + ''' and ''' + @patternAux + '''')
							end
						END
						if @iteration > 1
							delete from #tmMediaListtmp where mediaid not in (select mediaid from #tmMediaListtmp2) and oldflag = 0
						else
						begin
							insert into #tmMediaListtmp
							select * from #tmMediaListtmp2
						end
						FETCH	NEXT FROM patternCuror2
						INTO	@pattern, @patternAux, @patternType
					END
					CLOSE		patternCuror2
					DEALLOCATE	patternCuror2
					SET			@cursorflag2 = 0
					if @mediaNeeded < (select count(*) from #tmMediaListtmp where oldflag = 0)
					begin
						delete from #tmMediaListtmp2
						insert into #tmMediaListtmp2
						select * from #tmMediaListtmp
						where oldflag = 0
						delete from #tmMediaListtmp
						where oldflag = 0
						insert into #tmMediaListtmp
						exec ('select top ' + @mediaNeeded + ' MediaId, 0 from #tmMediaListtmp2')
					end
				END
				UPDATE MMMedia
				SET	SpareGroupId = @spareGroupId
				WHERE MediaId IN (SELECT MediaId FROM #tmMediaListtmp WHERE OldFlag = 0)
				update MMMedia
				set Attributes = Attributes & ~@V_MMS2_NEWLY_DISCOVERRED
				WHERE MediaId IN (SELECT MediaId FROM #tmMediaListtmp WHERE OldFlag = 0)
				-- cleaning media type
IF @spareGroupType = 32
				BEGIN
					UPDATE MMVolume
SET	RecordingFormatId = 0
					WHERE MediaId IN (SELECT MediaId FROM #tmMediaListtmp WHERE OldFlag = 0)
					IF	@mediaTypeId = 0
					AND @libraryTypeId != 8
						select @mediaTypeId = (SELECT TOP 1 CleaningMediaTypeId
												FROM MMRecFmtMedTyp
												WHERE DriveTypeId in (select drivetypeid from @driveTypeId))
					UPDATE MMMedia
					SET	MediaTypeId = @mediaTypeId
					WHERE MediaId IN (SELECT MediaId FROM #tmMediaListtmp WHERE OldFlag = 0)
				END
				ELSE
				BEGIN
					IF @mediaTypeId > 0
					BEGIN
						-- need to change some stuff here
						UPDATE MMMedia
						SET	MediaTypeId = @mediaTypeId
						WHERE MediaId IN (SELECT MediaId FROM #tmMediaListtmp WHERE OldFlag = 0)
						select @totalBytesMB = (select MaxUncompressCapacityMB from MMMediaType where MediaTypeId = @mediaTypeId)
						UPDATE MMMediaSide
						SET	TotalSpaceMB = @totalBytesMB, FreeBytesMB = @totalBytesMB
						WHERE MediaId IN (SELECT MediaId FROM #tmMediaListtmp WHERE OldFlag = 0)
						if @libraryTypeId != 8
						begin
							select @recordingFormatId = (select top 1 RecordingFormatId from MMRecFmtMedTyp where DriveTypeId in (select drivetypeid from @driveTypeId) and MediaTypeId = @mediaTypeId order by RecordingFormatId desc)
							select @flushBlockSizeKB = (select top 1 FlushBlockSizeKB from MMRecordingFormats where RecordingFormatId = @recordingFormatId)
							UPDATE MMVolume
							SET	FlushBlockSizeKB = @flushBlockSizeKB, RecordingFormatId = @recordingFormatId
							WHERE MediaId IN (SELECT MediaId FROM #tmMediaListtmp WHERE OldFlag = 0)
						end
					END
				END
				UPDATE #tmMediaListtmp
				SET	OldFlag = 1
			END
--			END
--			ELSE
--			BEGIN
--				SET @mediaNeeded = @mediaCount
--				IF	@highWaterMark > 0
--				AND @highWaterMark < @mediaCount
--				BEGIN
--					SET @mediaNeeded = @highWaterMark
--				END
--
--				-- fill in default
--				INSERT INTO #tmMediaListtmp
--				exec ('select top ' + @mediaNeeded + ' MediaId, 0 from MMMedia where IsAged  = 0 and IsInMediaGroup = 0 and (Attributes & ' + @V_MMS2_NEWLY_DISCOVERRED + ') > 0 and MediaId not in (select mediaid from #tmMediaListtmp) and MediaLocation = 1 and sparegroupid = ' + @defaultsparegroupid)
--
--				UPDATE #tmMediaListtmp
--				SET	OldFlag = 1
--			END
			/****************************************************************************/
CX_CONTINUE:
			FETCH	NEXT FROM patternCuror
			INTO	@libraryId, @libraryTypeId, @spareGroupId, @spareGroupType, @mediaTypeId, @patternId, @highWaterMark, @attributes, @haspattern
			SELECT	@retVal = @@ERROR
			IF		@retVal != 0
			BEGIN
					SET @errorString = @errorString + 'fail to fetch cursor patternCuror'
					GOTO CX_ERROR_EXIT
			END
			/****************************************************************************/
	END
	-- reset newly discover flag
	update mmmedia
	set Attributes = Attributes & ~@V_MMS2_NEWLY_DISCOVERRED
	where (@i_libraryId > 0 and libraryid = @i_libraryId and medialocation = 1)
	or (@i_libraryId = 0 and libraryid > 0 and medialocation = 1)
	or IsAged != 0 or IsInMediaGroup != 0
/****************************************************************************************/
/**************** Drop temparary table **************************************************/
/****************************************************************************************/
	DROP TABLE #tmMediaListtmp
	DROP TABLE #tmMediaListtmp2
	DROP TABLE #tmSpareGroupListtmp
/****************************************************************************************/
/****************************************************************************************/
CX_CONTINUE2:
--  +----------------------------+
--  |	NORMAL, "HAPPY" EXIT:    |
--  +----------------------------+
	IF @cursorflag = 1
	BEGIN
			CLOSE		patternCuror
			DEALLOCATE	patternCuror
	END
	IF @cursorflag2 = 1
	BEGIN
			CLOSE		patternCuror2
			DEALLOCATE	patternCuror2
	END
	IF		@retVal = 0
	BEGIN
			SET @errorString = ''
	END
	SELECT	@retVal
	RETURN
--  +----------------------------+
--  |   ABNORMAL, "ERROR" EXIT:  |
--  +----------------------------+
CX_ERROR_EXIT:
	DROP TABLE #tmMediaListtmp
	DROP TABLE #tmMediaListtmp2
	DROP TABLE #tmSpareGroupListtmp
	IF @cursorflag = 1
	BEGIN
			CLOSE		patternCuror
			DEALLOCATE	patternCuror
	END
	IF @cursorflag2 = 1
	BEGIN
			CLOSE		patternCuror2
			DEALLOCATE	patternCuror2
	END
	IF		@retVal = 0
	BEGIN
			SET	@retVal = @retValFlag
	END
	SELECT	@retVal
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2RunBarcodePattern')
	delete from GxQscripts where name = 'MMS2RunBarcodePattern'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2RunBarcodePattern')
	delete from GXDBVersions where aliasname = 'MMS2RunBarcodePattern'
GO

insert into GXDBVersions values(2, 'MMS2RunBarcodePattern',  '00010039030400020000', 'MMS2RunBarcodePattern', '00010039030400020000')
GO

