

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2RenewAllottedDrivesLeasePeriod.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2RenewAllottedDrivesLeasePeriod.sp,v $ $Id: MMS2RenewAllottedDrivesLeasePeriod.sp,v 1.14.86.2 2018/03/22 03:07:41 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2RenewAllottedDrivesLeasePeriod <<<'

IF EXISTS (select * from sysobjects where name='MMS2RenewAllottedDrivesLeasePeriod')
	drop procedure MMS2RenewAllottedDrivesLeasePeriod
IF EXISTS (select * from GxQscripts where name='MMS2RenewAllottedDrivesLeasePeriod')
	delete from GxQscripts where name = 'MMS2RenewAllottedDrivesLeasePeriod'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2RenewAllottedDrivesLeasePeriod')
	delete from GXDBVersions where aliasname = 'MMS2RenewAllottedDrivesLeasePeriod'
GO
print '... Creating Procedure: MMS2RenewAllottedDrivesLeasePeriod'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2RenewAllottedDrivesLeasePeriod
  @i_Renewal_cutoff integer,
  @i_reserveInt INTEGER,
  @i_reserveStr VARCHAR(1024)
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_LibraryId integer
  DECLARE @o_DriveElementAddress integer
  DECLARE @o_ReserveInt integer
  DECLARE @o_ReserveStr varchar(1024)
	SET NOCOUNT ON
	DECLARE @CV_LIBSUBTYPE_LIBRARY_SERVER 			INTEGER
	DECLARE @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER	INTEGER
	DECLARE @DRIVE_STATUS_USED_BY_ANOTHER_CS			INTEGER
	SET @CV_LIBSUBTYPE_LIBRARY_SERVER 				= 3
	SET @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER 	= 16
	SET @DRIVE_STATUS_USED_BY_ANOTHER_CS				= 17
	CREATE TABLE #tmpLibServerDrives (
    			DriveId 			INT,
    			libraryId 			INT,
    			ElementAddress			INT,
			IsInUse				INT,
    			PRIMARY KEY (DriveId)
    		)
	--Get a list of allotted LS drives that are close to lease expiry
	INSERT INTO #tmpLibServerDrives
	SElECT	MD.DriveId, ML.LibraryId, (ML.BaseAddress+MD.DriveNumber-1), 0
	FROM 	MMDrive MD, MMMasterPool MS, MMLibrary ML
		WHERE ML.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER AND ML.LibraryId = MS.LibraryId AND MD.MasterPoolId=MS.MasterPoolId
		AND MD.RMStatusUpdateTime <= (datediff(second,'01/01/1970', getutcdate()) + (@i_Renewal_cutoff))
		AND ( (MD.DriveSoftState = 1) OR (MD.OfflineReason IN( 1,2,3,12,13,14,15)))
		--Allotted drive can be down due to some(scsi) error. Select Those too
	--Drive is in use if it is part of a resource reservation
	UPDATE #tmpLibServerDrives SET IsInUse=1
	FROM MMResource AS MR
		WHERE #tmpLibServerDrives.DriveId = MR.DriveId
	--Drive is in use if it is occupied or it is allotted and offline due to error
	--and has a valid drive controller
	UPDATE #tmpLibServerDrives SET IsInUse=1
	FROM MMDrive AS MD, MMDriveController MDC
		WHERE #tmpLibServerDrives.DriveId = MD.DriveId
AND (MD.DriveEnabled = 1)  AND (MD.Attributes & 256 <> 256)
		AND ( (MD.DriveOccupied = 1) OR ((MD.DriveSoftState = 0 AND MD.OfflineReason IN( 1,2,3,12,13,14,15))))
		AND (MD.DriveId = MDC.DriveId) AND (MDC.DriveControllerSoftState = 1 AND MDC.DriveControllerActive = 1 AND MDC.DriveAccessible = 1 AND MDC.DriveControllerEnabled = 1)
	UPDATE MMDrive SET DriveSoftState = 0, OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER, MountStatus = 0, OpPhase=0, OfflineTimeStamp = datediff(second,'01/01/1970', getutcdate())
	FROM	#tmpLibServerDrives TMP, MMDrive MD
		WHERE MD.DriveId = TMP.DriveId AND TMP.IsInUse=0 AND MD.RMStatusUpdateTime <= (datediff(second,'01/01/1970', getutcdate()) )
	UPDATE MMDrive SET DriveSoftState = 0, OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER, OfflineTimeStamp = datediff(second,'01/01/1970', getutcdate()), LSCSName = ''
		WHERE OfflineReason = @DRIVE_STATUS_USED_BY_ANOTHER_CS AND OfflineTimeStamp <= (datediff(second,'01/01/1970', getutcdate()) - 30*60)
	SElECT libraryId, ElementAddress, 0, '' FROM #tmpLibServerDrives
		WHERE IsInUse=1
	DROP TABLE #tmpLibServerDrives
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2RenewAllottedDrivesLeasePeriod')
	delete from GxQscripts where name = 'MMS2RenewAllottedDrivesLeasePeriod'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2RenewAllottedDrivesLeasePeriod')
	delete from GXDBVersions where aliasname = 'MMS2RenewAllottedDrivesLeasePeriod'
GO

insert into GXDBVersions values(2, 'MMS2RenewAllottedDrivesLeasePeriod',  '00010014008600020000', 'MMS2RenewAllottedDrivesLeasePeriod', '00010014008600020000')
GO

