

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2PreventMediaReuse.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2PreventMediaReuse.sp,v $ $Id: MMS2PreventMediaReuse.sp,v 1.1.304.2 2018/03/20 20:06:04 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2PreventMediaReuse"				|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2PreventMediaReuse <<<'

IF EXISTS (select * from sysobjects where name='MMS2PreventMediaReuse')
	drop procedure MMS2PreventMediaReuse
IF EXISTS (select * from GxQscripts where name='MMS2PreventMediaReuse')
	delete from GxQscripts where name = 'MMS2PreventMediaReuse'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2PreventMediaReuse')
	delete from GXDBVersions where aliasname = 'MMS2PreventMediaReuse'
GO
print '... Creating Procedure: MMS2PreventMediaReuse'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2PreventMediaReuse
  @mediaId Integer,
  @savedSpareGroupId Integer
AS
  DECLARE @ErrorCode Integer
  DECLARE @origSpareGroupId Integer
SET NOCOUNT ON
-- input variables
		declare @i_MediaId INTEGER
		declare @i_savedSpareGroupId INTEGER
		set @i_MediaId  = @mediaId
		set @i_savedSpareGroupId  = @savedSpareGroupId
		declare @l_ErrorCode INTEGER
		set @l_ErrorCode = 0
		DECLARE @l_savedSpareGroupType INTEGER
		DECLARE @l_SGmediaTypeId INTEGER
		DECLARE @l_newOrigSpareGroupId INTEGER
		SELECT @l_savedSpareGroupType = SpareGroupType, @l_SGmediaTypeId = MediaTypeId
		FROM MMSpareGroup
		WHERE SpareGroupId = @i_savedSpareGroupId
IF (@l_savedSpareGroupType is null OR @l_savedSpareGroupType <> 64 )
		BEGIN
				SET @l_ErrorCode = 267
				-- E_MM_DB_INVALID_SPARE_GROUP_TYPE  267
				GOTO PROC_EXIT
		END
		DECLARE @l_MediaTypeId INTEGER
		DECLARE @l_origSpareGroupId INTEGER
		DECLARE @l_curMediaSpareGroupId INTEGER
		DECLARE @l_libraryId INTEGER
		SELECT @l_MediaTypeId = MediaTypeId, @l_origSpareGroupId = origSpareGroupId, @l_curMediaSpareGroupId = SpareGroupId, @l_libraryId = libraryId
		FROM MMMedia
		WHERE MediaId = @i_MediaId
		IF (@l_MediaTypeId is null)
		BEGIN
				SET @l_ErrorCode = 252
				-- E_MM_DB_BAD_MEDIA_ROW  252
				GOTO PROC_EXIT
		END
		IF (@l_SGmediaTypeId <>  @l_MediaTypeId)
		BEGIN
				SET @l_ErrorCode = 30041
				-- E_DM_INVALID_MEDIA_TYPE						30041
				GOTO PROC_EXIT
		END
		-- reason for cursor - make origSpareGroupId a regular sparegrouptype
		IF 	(@l_curMediaSpareGroupId > 0) AND
				EXISTS ( 	SELECT SpareGroupId
									FROM MMSpareGroup
WHERE SpareGroupId = @l_curMediaSpareGroupId AND SpareGroupType IN ( 1, 2 )
								)
		BEGIN
				SET @l_newOrigSpareGroupId = @l_curMediaSpareGroupId
		END ELSE
		IF  (@l_origSpareGroupId  > 0)
		BEGIN
				SET @l_newOrigSpareGroupId = @l_origSpareGroupId
		END ELSE
		BEGIN
				SET @l_newOrigSpareGroupId =
					(
						SELECT TOP 1 SpareGroupId
						FROM MMSpareGroup
WHERE SpareGroupType = 2
						AND LibraryId = @l_LibraryId
					)
				IF (@l_newOrigSpareGroupId  is null)
				BEGIN
					SET @l_ErrorCode = 408
					-- E_MM_MEDIA_BELONGS_TO_UNDEFINEDSPARE  408
					GOTO PROC_EXIT
				END
		END
		UPDATE MMMedia
		SET SpareGroupId = @i_savedSpareGroupId, origSpareGroupId = @l_newOrigSpareGroupId
		WHERE MediaId = @i_MediaId
		PROC_EXIT:
		SELECT @l_ErrorCode, isnull(@l_newOrigSpareGroupId, 0)
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2PreventMediaReuse')
	delete from GxQscripts where name = 'MMS2PreventMediaReuse'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2PreventMediaReuse')
	delete from GXDBVersions where aliasname = 'MMS2PreventMediaReuse'
GO

insert into GXDBVersions values(2, 'MMS2PreventMediaReuse',  '00010001030400020000', 'MMS2PreventMediaReuse', '00010001030400020000')
GO

