

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2MarkAssignedMediaFull.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2MarkAssignedMediaFull.sp,v $ $Id: MMS2MarkAssignedMediaFull.sp,v 1.24.60.8 2020/06/06 03:13:01 cliu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2MarkAssignedMediaFull')
BEGIN
	print '>>> Drop Stored Procedure: MMS2MarkAssignedMediaFull <<<'
	drop procedure MMS2MarkAssignedMediaFull
END
IF EXISTS (select * from GxQscripts where name='MMS2MarkAssignedMediaFull')
	delete from GxQscripts where name = 'MMS2MarkAssignedMediaFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2MarkAssignedMediaFull')
	delete from GXDBVersions where aliasname = 'MMS2MarkAssignedMediaFull'
GO
print '... Creating Procedure: MMS2MarkAssignedMediaFull'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2MarkAssignedMediaFull
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @dummy integer
AS
  DECLARE @numVolsMarkedFull integer
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
CREATE TABLE #tmpEmptyVol(
	VolumeId		integer,
	VolumeFlags		integer,
	MediaId			integer,
	MediaSideId		integer,
	MediaGroupId	integer,
	SIDBStoreId		integer
)
CREATE TABLE #tmpVol(
	VolumeId		integer,
	MediaId			integer,
	MediaSideId		integer,
	SIDBStoreId		integer,
	MediaTypeId		integer,
	MountPathId		integer
)
CREATE TABLE #tmpPrunedMagVol(
	VolumeId		integer
)
CREATE TABLE #tmpNonEmptyMedia(
	MediaId			integer)
CREATE TABLE #tmpVolumeWithFlag (
	VolumeId	integer,
	MediaId		integer,
	MediaSideId	integer,
	SIDBStoreId	integer,
	MediaTypeId integer,
	MediaFlags	integer
)
-- Get non-magnetic volumes which have no non-empty or non-aged chunks
INSERT	INTO #tmpEmptyVol
SELECT	V.VolumeId, V.VolumeFlags, V.MediaId, V.MediaSideId, V.MediaGroupId, V.SIDBStoreId
FROM	MMVolume V WITH( NOLOCK)
WHERE	V.RecordingFormatId <> 10001
	AND NOT EXISTS(SELECT 1 FROM archChunk AC WITH(NOLOCK) WHERE AC.volumeId = V.VolumeId AND (AC.physicalSize <> 0 OR AC.logicalSize <> 0) AND AC.flags & 256 = 0)
-- Get non-magnetic assigned volumes which have no valid or non-aged chunks
INSERT	INTO #tmpVol
SELECT	V.VolumeId, V.MediaId, V.MediaSideId, V.SIDBStoreId, M.MediaTypeId, 0
FROM	#tmpEmptyVol V
	INNER JOIN MMMedia M WITH (NOLOCK)
		ON V.MediaId = M.MediaId
	LEFT OUTER JOIN	MMResource R WITH (NOLOCK)
		ON V.VolumeId = R.volumeId
WHERE	R.volumeId IS NULL
-- Jai - do not filter out volumes that are marked full, since there could be full volumes
-- with no data that we want to recycle here also.
--	AND V.VolumeFlags NOT IN (2, 6) AND V.MediaGroupId > 0 AND M.IsInMediaGroup <> 0
	AND V.VolumeFlags <> 6 AND V.MediaGroupId > 0 AND M.IsInMediaGroup <> 0 AND M.MediaFlags <> 5 /* MEDIA_FLAG_RESERVED_BY_JOB - Flag set for IBM library. If this flag is set this media is to be treated as reserved media */
-- Reset the media with flags MEDIA_FLAG_RESERVED_BY_JOB, if it doesn't contain any chunks
INSERT	INTO #tmpVolumeWithFlag
SELECT	V.VolumeId, V.MediaId, V.MediaSideId, V.SIDBStoreId, M.MediaTypeId, M.MediaFlags
FROM	#tmpEmptyVol V, MMMedia M WITH (NOLOCK)
WHERE	V.MediaId = M.MediaId
AND		M.MediaFlags = 5/* MEDIA_FLAG_RESERVED_BY_JOB - Flag set for IBM library. If this flag is set this media is to be treated as reserved media */
IF @@ROWCOUNT > 0
BEGIN
	INSERT	INTO #tmpVol
	SELECT	V.VolumeId, V.MediaId, V.MediaSideId, V.SIDBStoreId, V.MediaTypeId, 0
	FROM	#tmpVolumeWithFlag V
		LEFT OUTER JOIN	RMReservations R WITH (NOLOCK)
			ON V.MediaId = R.MediaId
		LEFT OUTER JOIN JMJobInfo J WITH (NOLOCK)
			ON R.jobId = J.jobId
	WHERE	R.volumeId IS NULL OR J.jobId IS NULL
END
-- Get multi-side media which have a non-empty side
INSERT	INTO #tmpNonEmptyMedia
SELECT	DISTINCT A.MediaId
FROM	(SELECT	V.VolumeId, V.MediaId
		FROM	#tmpVol TV, MMMediaType MT WITH (NOLOCK), MMVolume V WITH (NOLOCK)
		WHERE	MT.MediaTypeId = TV.MediaTypeId	AND MT.NumberOfSides > 1
			AND V.MediaId = TV.MediaId AND V.VolumeId <> TV.VolumeId) A
	LEFT OUTER JOIN	#tmpEmptyVol B
		ON A.VolumeId = B.VolumeId
WHERE	B.VolumeId IS NULL
DELETE	#tmpVol
FROM	#tmpVol A, #tmpNonEmptyMedia B
WHERE	A.MediaId = B.MediaId
-- Get inactive assigned magnetic volumes which have no chunk
-- This can be done by Data Aging at a much lower frequency
INSERT	INTO #tmpVol
SELECT	V.VolumeId, V.MediaId, V.MediaSideId, V.SIDBStoreId, 10001, 0
FROM	MMVolume V WITH( NOLOCK)
	LEFT OUTER JOIN	MMResource AS R WITH (NOLOCK)
		ON V.VolumeId = R.volumeId
	LEFT OUTER JOIN MMDeletedAF AS D WITH (NOLOCK)
		ON V.VolumeId = D.VolumeId
WHERE	R.volumeId IS NULL
	AND V.VolumeFlags NOT IN (1, /* 2, */6) AND V.RecordingFormatId = 10001
	AND D.VolumeId IS NULL
	AND NOT EXISTS(SELECT 1 FROM archChunk AC WITH(NOLOCK) WHERE AC.volumeId = V.VolumeId AND AC.physicalSize > 0 AND AC.flags & 256 = 0)
--DELETE	#tmpVol
--FROM	archChunk C WITH (NOLOCK)
--WHERE	#tmpVol.VolumeId = C.volumeId AND ( C.physicalSize > 0 and ((C.flags & 256) = 0) )
UPDATE	#tmpVol
SET		MountPathId = MP.MountPathId
FROM	MMMountPath MP WITH (NOLOCK)
WHERE	#tmpVol.MediaSideId = MP.MediaSideId AND #tmpVol.MediaTypeId = 10001
-- Mark VOL_FULL
UPDATE	MMVolume
SET		VolumeFlags = 2,
VolumeFullReason = 42005,
		VolumeFullTime = dbo.GetUnixTime(GETUTCDATE())
FROM	#tmpVol
WHERE	MMVolume.VolumeId = #tmpVol.VolumeId
	AND MMVolume.VolumeFlags <> 2
SELECT	@@ROWCOUNT
-- Insert into MMDeletedAF for recycle
-- Get magnetic volumes in MMDeletedAF that are already marked processed for recycling routine, so we can see if they need to be reprocessed
INSERT	INTO #tmpPrunedMagVol
SELECT	DISTINCT VolumeId
FROM	MMDeletedAF WITH (NOLOCK)
WHERE (MountPathId > 0) AND (Status & 256 > 0)
--Ignore volumes that are already marked recyclable
DELETE #tmpPrunedMagVol
from MMVolume MV
where MV.VolumeId = #tmpPrunedMagVol.VolumeId AND MV.volumeFlags = 6
--DELETE	#tmpVol
--FROM	#tmpVol A, #tmpPrunedVol B
--WHERE	A.VolumeId = B.VolumeId
--Ignore volumes that still have unaged chunks. They can't be recycled
DELETE #tmpPrunedMagVol
FROM #tmpPrunedMagVol T INNER JOIN ArchChunk AC WITH(NOLOCK) ON T.volumeId = AC.volumeId AND (AC.flags & 256 = 0)
INSERT	INTO MMDeletedAF
SELECT	0, A.VolumeId, 0, 0, 0, '', 0, 0, A.MountPathId, A.SIDBStoreId, 0, dbo.GetUnixTime(GETUTCDATE()), 0, 0, 0, 0, 0, 2
FROM	#tmpVol A
-- Update status those mag volumes that are pruned now so it can be picked up for recycle.
UPDATE	MMDeletedAF
SET		Status = (Status & ~(256))
FROM	#tmpPrunedMagVol A
WHERE	MMDeletedAF.VolumeId = A.VolumeId
AND (Status & 256 > 0)
DROP TABLE #tmpNonEmptyMedia
DROP TABLE #tmpPrunedMagVol
DROP TABLE #tmpEmptyVol
DROP TABLE #tmpVol
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2MarkAssignedMediaFull')
	delete from GxQscripts where name = 'MMS2MarkAssignedMediaFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2MarkAssignedMediaFull')
	delete from GXDBVersions where aliasname = 'MMS2MarkAssignedMediaFull'
GO

insert into GXDBVersions values(2, 'MMS2MarkAssignedMediaFull',  '00010024006000080000', 'MMS2MarkAssignedMediaFull', '00010024006000080000')
GO

