

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2IsStuckMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2IsStuckMedia.sp,v $ $Id: MMS2IsStuckMedia.sp,v 1.1.304.1 2018/03/20 20:01:12 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2IsStuckMedia"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2IsStuckMedia <<<'

IF EXISTS (select * from sysobjects where name='MMS2IsStuckMedia')
	drop procedure MMS2IsStuckMedia
IF EXISTS (select * from GxQscripts where name='MMS2IsStuckMedia')
	delete from GxQscripts where name = 'MMS2IsStuckMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2IsStuckMedia')
	delete from GXDBVersions where aliasname = 'MMS2IsStuckMedia'
GO
print '... Creating Procedure: MMS2IsStuckMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2IsStuckMedia
  @mediaId integer
AS
  DECLARE @IsStuck integer
  DECLARE @DriveId integer
  DECLARE @DriveName varchar(256)
	declare @l_isStuck		integer
	declare @l_driveId		integer
	declare @l_driveName	varchar(256)
	declare @in_mediaId		integer
	set @in_mediaId = @mediaId
	set @l_isStuck = (select count(*)
					from MMVolume mv
					where mv.MediaId = @in_mediaId and mv.volumestate = 2)
	IF(@l_isStuck > 0)
	BEGIN
		set @l_driveId = isNULL((select DriveId from MMDrive where
								MediaId = @in_mediaId), 0)
		IF(@l_driveId > 0)
		BEGIN
			set @l_driveName = (select DriveName from MMDrive where DriveId = @l_driveId)
		END
		ELSE
		BEGIN
			set @l_driveName = ''
		END
		select @l_isStuck, @l_driveId, @l_driveName
	END
	ELSE
	BEGIN
		select 0, 0, ''
	END
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2IsStuckMedia')
	delete from GxQscripts where name = 'MMS2IsStuckMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2IsStuckMedia')
	delete from GXDBVersions where aliasname = 'MMS2IsStuckMedia'
GO

insert into GXDBVersions values(2, 'MMS2IsStuckMedia',  '00010001030400010000', 'MMS2IsStuckMedia', '00010001030400010000')
GO

