

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2IdxCacheUnshareGetSPconflictListforMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2004  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Gets a list of all storage policies that prevent an index cache
--	access path from taken away from a shared index cache
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2IdxCacheUnshareGetSPconflictListforMA.sp,v $ $Id: MMS2IdxCacheUnshareGetSPconflictListforMA.sp,v 1.3.58.2 2018/03/20 20:05:25 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2IdxCacheUnshareGetSPconflictListforMA <<<'

IF EXISTS (select * from sysobjects where name='MMS2IdxCacheUnshareGetSPconflictListforMA')
	drop procedure MMS2IdxCacheUnshareGetSPconflictListforMA
IF EXISTS (select * from GxQscripts where name='MMS2IdxCacheUnshareGetSPconflictListforMA')
	delete from GxQscripts where name = 'MMS2IdxCacheUnshareGetSPconflictListforMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2IdxCacheUnshareGetSPconflictListforMA')
	delete from GXDBVersions where aliasname = 'MMS2IdxCacheUnshareGetSPconflictListforMA'
GO
print '... Creating Procedure: MMS2IdxCacheUnshareGetSPconflictListforMA'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2IdxCacheUnshareGetSPconflictListforMA
  @i_MAclientId integer
-- Following are the "columns" returned, in the order in which they are returned
AS
  DECLARE @o_archiveGroupId integer
  DECLARE @o_archiveGroupName NVARCHAR(255)
declare @l_MAIdxCacheId		integer
set @l_MAIdxCacheId =
  (  	SELECT AP.IdxCacheId
  	FROM IdxAccessPath AS AP, IdxCache as IC
WHERE AP.ClientId = @i_MAClientId and AP.IdxCacheId=IC.IdxCacheId and IC.IdxCacheType=1
  	)
-- narrow down possible copy IDs to the one the client and at least another client is involved in
CREATE TABLE #tmpCopyIds		(CopyId 	integer)
INSERT INTO #tmpCopyIds
SELECT     distinct CF1.CopyId
FROM MMDataPath AS CF1
WHERE CF1.copyid IN
   (select distinct CF2.CopyId  from MMDataPath AS CF2 where HostClientID = @i_MAClientId)
AND CF1.HostClientID <> @i_MAClientId
-- now we have a list of copy ids that are shared by at least the client in question and another MA.
-- next step: filter out all copies that do NONE of the following
--	do not failover if offline(bitflag:8),
--	do not failover when resources are busy (bitflag:16)
--	do not use round robin (bitflag 512)
-- 	=> if ((flag & (8+16+512)) == 0)) then no conflict -> throw out  [8+16+512 = 536]
DELETE FROM #tmpCopyIds
WHERE CopyId in
(	SELECT DISTINCT tmpCpy.CopyId
	FROM #tmpCopyIds AS tmpCpy, ArchGroupCopy AS agc
	WHERE (tmpCpy.CopyId = agc.Id) AND ( (agc.flags & 536) = 0 )
)
-- Now gather data about all datapaths that use the index cache in question
CREATE TABLE #tmpfailoverlibtable	(CopyId			integer,
					 LibraryId		integer,
					 IdxAccessPathId	integer
					 )
INSERT INTO #tmpfailoverlibtable
SELECT distinct CF.CopyId, MP.LibraryId, AP.IdxAccessPathId
FROM MMDataPath AS CF, MMMasterPool as MP, MMDrivePool as DP, IdxAccessPath as AP
WHERE CF.CopyId in (select * from #tmpCopyIds)
 AND  (DP.DrivePoolId = CF.DrivePoolId)
 AND  (MP.MasterPoolId = DP.MasterPoolId)
 AND  (CF.HostClientID = DP.ClientId)
 AND  (DP.ClientId = AP.ClientId) AND (AP.IdxCacheId = @l_MAIdxCacheId)
DROP TABLE #tmpCopyIds
-- we now have a table of copyId, LibID, and access path ID
-- now figure out if we have any shared libraries -
-- seen by counting the number of access paths for
-- each library for each copy
CREATE TABLE #tmpcopyliblist		(CopyId		integer,
					 LibraryId	integer)
CREATE TABLE #tmplibcount		(CopyId		integer,
					 LibraryId	integer,
					 APCount	integer)
INSERT INTO #tmpcopyliblist
SELECT DISTINCT CopyId, LibraryId
FROM #tmpfailoverlibtable
INSERT INTO #tmplibcount
SELECT T1.CopyID, T1.LibraryID, Count (T2.CopyId)
FROM #tmpcopyliblist AS T1,  #tmpfailoverlibtable AS T2
WHERE (T1.CopyId = T2.CopyID) AND (T1.LibraryId = T2.LibraryID)
GROUP BY T1.CopyID, T1. LibraryID
DROP TABLE #tmpcopyliblist
-- now we have a list of how many access paths for a library are available for each copy
-- IN THE CASE OF FAILOVER:
-- 	if we have multiple access paths for a library, then it is a shared library and it is
-- 	still perfectly OK to unshare the index cache.
DELETE #tmpfailoverlibtable
FROM #tmpfailoverlibtable AS T1, #tmplibcount AS T2, ArchGroupCopy AS AGC
WHERE 	(AGC.Id = T1.CopyId) AND ((AGC.flags & 24) <> 0) AND
		(T1.CopyID = T2.CopyID) AND (T1.LibraryId = T2.LibraryID) AND (T2.APCount <> 1)
DROP TABLE #tmplibcount
-- now get the distinct access paths each copy has left
CREATE TABLE #tmpDistinctAPperCopy 	(CopyId			integer,
					 IdxAccessPathID	integer)
INSERT INTO #tmpDistinctAPperCopy
SELECT DISTINCT CopyId, IdxAccessPathId FROM #tmpfailoverlibtable
-- get the number of distinct access paths per copy
CREATE TABLE #tmpAPCountperCopy		(CopyId			integer,
				 	 APCount		integer)
INSERT INTO #tmpAPCountperCopy
SELECT DISTINCT CopyId,  0 FROM #tmpDistinctAPperCopy
UPDATE #tmpAPCountperCopy
SET APCount =
(	SELECT count(#tmpDistinctAPperCopy.IdxAccessPathId) FROM #tmpDistinctAPperCopy
	WHERE #tmpAPCountperCopy.CopyId = #tmpDistinctAPperCopy.CopyId
)
-- delete all rows with less than 2
DELETE FROM #tmpAPCountperCopy
WHERE APCount <= 1
DROP TABLE #tmpDistinctAPperCopy
-- now return results, these are the storage policy copies (below the storage policy is gotten to be returned)
-- that prevent unsharing an index cache for the host in question.
SELECT DISTINCT AGC.ArchGroupId, AG.name
FROM MMDataPath AS CF, archGroupCopy AS AGC, archGroup AS AG
WHERE (CF.CopyId IN (SELECT DISTINCT CopyID FROM #tmpAPCountperCopy))
  AND (CF.HostClientID<>@i_MAClientId)
  AND (AGC.id = CF.CopyId) AND (AG.id = AGC.archGroupId)
DROP TABLE #tmpfailoverlibtable
DROP TABLE #tmpAPCountperCopy
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2IdxCacheUnshareGetSPconflictListforMA')
	delete from GxQscripts where name = 'MMS2IdxCacheUnshareGetSPconflictListforMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2IdxCacheUnshareGetSPconflictListforMA')
	delete from GXDBVersions where aliasname = 'MMS2IdxCacheUnshareGetSPconflictListforMA'
GO

insert into GXDBVersions values(2, 'MMS2IdxCacheUnshareGetSPconflictListforMA',  '00010003005800020000', 'MMS2IdxCacheUnshareGetSPconflictListforMA', '00010003005800020000')
GO

