

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GettmMovementHistory.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GettmMovementHistory.sp,v $ $Id: MMS2GettmMovementHistory.sp,v 1.7.294.3 2018/03/20 19:57:03 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GettmMovementHistory <<<'

IF EXISTS (select * from sysobjects where name='MMS2GettmMovementHistory')
	drop procedure MMS2GettmMovementHistory
IF EXISTS (select * from GxQscripts where name='MMS2GettmMovementHistory')
	delete from GxQscripts where name = 'MMS2GettmMovementHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GettmMovementHistory')
	delete from GXDBVersions where aliasname = 'MMS2GettmMovementHistory'
GO
print '... Creating Procedure: MMS2GettmMovementHistory'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GettmMovementHistory
  @i_fromTime integer,
  @i_toTime integer,
  @i_keepAroundMins integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_HistoryId integer
  DECLARE @o_ActionId integer
  DECLARE @o_ActionType integer
  DECLARE @o_PolicyId integer
  DECLARE @o_PolicyName NVARCHAR(255)
  DECLARE @o_ActionJobId bigint
  DECLARE @o_PolicyJobType integer
  DECLARE @o_State integer
  DECLARE @o_StartTime integer
  DECLARE @o_EndTime integer
  DECLARE @o_SourceId integer
  DECLARE @o_SrcLocType integer
  DECLARE @o_SrcLocId integer
  DECLARE @o_DestinationId integer
  DECLARE @o_DestLocType integer
  DECLARE @o_DestLocId integer
  DECLARE @o_UserId integer
  DECLARE @o_UserName varchar(255)
  DECLARE @o_IntransitId integer
  DECLARE @o_IntransitName NVARCHAR(255)
	if object_id('tempdb.dbo.#bSrc') is not null DROP TABLE #bSrc
	if object_id('tempdb.dbo.#bDest') is not null DROP TABLE #bDest
	if object_id('tempdb.dbo.#maxHistory') is not null DROP TABLE #maxHistory
	create table #bSrc(		LocationId	integer,
					LocationValue	integer,
					LocationType	integer)
	create table #bDest(		LocationId	integer,
					LocationValue	integer,
					LocationType	integer)
	create table #maxHistory(ActionId integer, HistoryId integer, starttime datetime, endtime datetime, [state] integer)
	insert into #maxHistory
	select ActionId, max(HistoryId), min(startTime), max(endTime), max(state)
	from VTHistory
	group by ActionId
	insert into #bSrc
	select distinct TML.LocationId, TML.Value, TML.type
	from VTLocation as TML, VTHistory as TMH
	where TML.LocationId = TMH.SourceId
	insert into #bDest
	select distinct TML.LocationId, TML.Value, TML.type
	from VTLocation as TML, VTHistory as TMH
	where TML.LocationId = TMH.DestinationId
	if(@i_toTime > 0)
	begin
		select distinct HistoryId = MH.historyId,
		TMH.ActionId, TMH.ActionType, TMH.PolicyId, TMH.PolicyName,
		JobId = convert(bigint,TMH.JobId_h)*2147483648+convert(bigint,TMH.JobId_l),
		TMH.JobType,
		State = MH.State,
		dbo.getUnixTime(MH.StartTime),
		dbo.getUnixTime(MH.EndTime),
		TMH.SourceId,
		SrcLocType = isNull((select LocationType from #bSrc where TMH.SourceId = LocationId), 0),
		SrcLocId = isNull((select LocationValue from #bSrc where TMH.SourceId = LocationId), 0),
		TMH.DestinationId,
		DestLocType = isNull((select LocationType from #bDest where TMH.DestinationId = LocationId), 0),
		DestLocId = isNull((select LocationValue from #bDest where TMH.DestinationId = LocationId), 0),
		TMH.UserId, TMH.UserName, TMH.InTransitId, TMH.InTransitLocation
		from VTHistory as TMH, #maxHistory MH
		where TMH.ActionId not in(select ActionId from VTAction)
		and TMH.actionId = MH.actionId
		and (@i_fromTime > 0 and ((datediff(second, DATEADD(second, @i_fromTime -
		datediff(second, GETUTCDATE(), getutcdate()), '01/01/1970'), TMH.StartTime) >= 0)) OR
		(@i_fromTime = 0 and ((datediff(second, DATEADD(second, (@i_toTime - (@i_keepAroundMins * 60)) -
		datediff(second, GETUTCDATE(), getutcdate()), '01/01/1970'), TMH.EndTime) >= 0))))
		and   (datediff(second, DATEADD(second, @i_toTime -
		datediff(second, GETUTCDATE(), getutcdate()), '01/01/1970'), TMH.EndTime) <= 0)
		order by TMH.ActionId ASC
	end
	else
	begin
		select distinct HistoryId = MH.historyId,
		TMH.ActionId, TMH.ActionType, TMH.PolicyId, TMH.PolicyName,
		JobId = convert(bigint,TMH.JobId_h)*2147483648+convert(bigint,TMH.JobId_l),
		TMH.JobType,
		State = MH.State,
		dbo.getUnixTime(MH.StartTime),
		dbo.getUnixTime(MH.EndTime),
		TMH.SourceId,
		SrcLocType = isNull((select LocationType from #bSrc where TMH.SourceId = LocationId), 0),
		SrcLocId = isNull((select LocationValue from #bSrc where TMH.SourceId = LocationId), 0),
		TMH.DestinationId,
		DestLocType = isNull((select LocationType from #bDest where TMH.DestinationId = LocationId), 0),
		DestLocId = isNull((select LocationValue from #bDest where TMH.DestinationId = LocationId), 0),
		TMH.UserId, TMH.UserName, TMH.InTransitId, TMH.InTransitLocation
		from VTHistory as TMH, #maxHistory MH
		where TMH.ActionId not in(select ActionId from VTAction)
		and TMH.actionId = MH.actionId
		order by TMH.ActionId ASC
	end
	if object_id('tempdb.dbo.#bSrc') is not null DROP TABLE #bSrc
	if object_id('tempdb.dbo.#bDest') is not null DROP TABLE #bDest
	if object_id('tempdb.dbo.#maxHistory') is not null DROP TABLE #maxHistory
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GettmMovementHistory')
	delete from GxQscripts where name = 'MMS2GettmMovementHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GettmMovementHistory')
	delete from GXDBVersions where aliasname = 'MMS2GettmMovementHistory'
GO

insert into GXDBVersions values(2, 'MMS2GettmMovementHistory',  '00010007029400030000', 'MMS2GettmMovementHistory', '00010007029400030000')
GO

