

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GettmActions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GettmActions.sp,v $ $Id: MMS2GettmActions.sp,v 1.12.290.3 2018/03/20 19:44:16 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GettmActions <<<'

IF EXISTS (select * from sysobjects where name='MMS2GettmActions')
	drop procedure MMS2GettmActions
IF EXISTS (select * from GxQscripts where name='MMS2GettmActions')
	delete from GxQscripts where name = 'MMS2GettmActions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GettmActions')
	delete from GXDBVersions where aliasname = 'MMS2GettmActions'
GO
print '... Creating Procedure: MMS2GettmActions'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GettmActions
  @dummyInput integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_ActionId integer
  DECLARE @o_PolicyId integer
  DECLARE @o_PolicyJobType integer
  DECLARE @o_ActionFlag integer
  DECLARE @o_InTransitId integer
  DECLARE @o_inTransitName NVARCHAR(255)
  DECLARE @o_StartTIme integer
  DECLARE @o_ActionJobId bigint
  DECLARE @o_PolicyName NVARCHAR(255)
  DECLARE @o_PolicyFlag integer
  DECLARE @o_PolicyDescript NVARCHAR(255)
  DECLARE @o_SourceId integer
  DECLARE @o_SrcLocType integer
  DECLARE @o_SrcExportLocType integer
  DECLARE @o_SrcLocId integer
  DECLARE @o_SrcLocName NVARCHAR(255)
  DECLARE @o_DestinationId integer
  DECLARE @o_DestLocType integer
  DECLARE @o_DestExportLocType integer
  DECLARE @o_DestLocId integer
  DECLARE @o_DestLocName NVARCHAR(255)
  DECLARE @o_UserId integer
  DECLARE @o_UserName char(255)
  DECLARE @o_curMediaContainerId integer
  DECLARE @o_curMediaContainerName NVARCHAR(255)
  DECLARE @o_ActionState integer
  DECLARE @o_ActionType integer
  DECLARE @o_RecallExpireTime integer
  DECLARE @o_RecallReason NVARCHAR(255)
	if object_id('tempdb.dbo.#tmpDestLoc') is not null DROP TABLE #tmpDestLoc
	if object_id('tempdb.dbo.#tmpSource') is not null DROP TABLE #tmpSource
	create table #tmpDestLoc(
					LocationId		integer,
					LocationValue	integer,
					LocationType	integer,
					LocationName	nvarchar(255),
					ExportLocationType	integer)
	create table #tmpSource(
					LocationId		integer,
					LocationValue	integer,
					LocationType	integer,
					LocationName	nvarchar(255),
					ExportLocationType	integer)
	insert into #tmpDestLoc
	select distinct TML.LocationId, TML.Value, TML.type,
	LocationName =   CASE TML.Type
         WHEN 1 then (	CASE TML.Value
		WHEN 0 then 'Inside Library'
		ELSE (SELECT AliasName FROM MMLibrary WHERE LibraryId = TML.Value)
		END
		)
         WHEN 2 then (	CASE TML.Value
		WHEN 0 then 'Outside'
		ELSE (SELECT ExportLocation FROM MMExportLocation WHERE ExportLocationId = TML.Value)
		END
		)
         WHEN 4 then (	CASE TML.Value
		WHEN 0 then 'At virtual mailslots'
		ELSE (SELECT AliasName + ' virtual mailslots' FROM MMLibrary WHERE LibraryId = TML.Value)
		END
		)
         ELSE 'Not Available'
      END,
	ExportLocationType =  CASE TML.Type
         WHEN 2 then (	CASE TML.Value
							WHEN 0 then 0
							ELSE (SELECT Type FROM MMExportLocation WHERE ExportLocationId = TML.Value)
						END
					)
         ELSE TML.Type
      END
	from VTLocation as TML, VTAction as TMA
	where TML.LocationId = TMA.DestinationId
	insert into #tmpSource
	select distinct TML.LocationId, TML.Value, TML.type,
	LocationName =   CASE TML.Type
         WHEN 1 then (	CASE TML.Value
		WHEN 0 then 'Inside Library'
		ELSE (SELECT AliasName FROM MMLibrary WHERE LibraryId = TML.Value)
		END
		)
         WHEN 2 then (	CASE TML.Value
		WHEN 0 then 'Outside'
		ELSE (SELECT ExportLocation FROM MMExportLocation WHERE ExportLocationId = TML.Value)
		END
		)
         WHEN 4 then (	CASE TML.Value
		WHEN 0 then 'At virtual mailslots'
		ELSE (SELECT AliasName + ' virtual mailslots' FROM MMLibrary WHERE LibraryId = TML.Value)
		END
		)
         ELSE 'Not Available'
      END,
	ExportLocationType =  CASE TML.Type
         WHEN 2 then (	CASE TML.Value
							WHEN 0 then 0
							ELSE (SELECT Type FROM MMExportLocation WHERE ExportLocationId = TML.Value)
						END
					)
         ELSE TML.Type
      END
	from VTLocation as TML, VTAction as TMA
	where TML.LocationId = TMA.SourceId
	select distinct TMA.ActionId, TMA.PolicyId, TMA.JobType, TMA.Flag,
	mel.ExportLocationId, mel.ExportLocation,
	dbo.getUnixTime(TMA.StartTime),
	JobId = convert(bigint,TMA.JobId_h)*2147483648+convert(bigint,TMA.JobId_l),
	isnull((SELECT PolicyName from VTPolicy WHERE PolicyId = TMA.PolicyId), ''),
	isnull((SELECT Flag from VTPolicy WHERE PolicyId = TMA.PolicyId), 0),
	isnull((SELECT Descript from VTPolicy WHERE PolicyId = TMA.PolicyId), ''),
	ttSrc.LocationValue, ttSrc.LocationType, ttSrc.ExportLocationType, ttSrc.LocationId, ttSrc.LocationName,
	ttDst.LocationValue, ttDst.LocationType, ttDst.ExportLocationType, ttDst.LocationId, ttDst.LocationName,
	TMA.UserID, isnull((select login from UMUsers where id = TMA.UserID), ''),
	TMA.ContainerId,
	isnull((select ContainerName from MMContainer WHERE ContainerId>0 AND ContainerID = TMA.ContainerId), ''),
	TMA.ActionState, TMA.ActionType, TMA.RecallExpireTime, TMA.RecallReason
	from VTAction as TMA, #tmpSource as ttSrc, #tmpDestLoc as ttDst, MMExportLocation as mel,
	VTLocation as tml
	where TMA.SourceId = ttSrc.LocationId and TMA.DestinationId = ttDst.LocationId
	and TMA.InTransitId = TML.LocationId and TML.Value = mel.ExportLocationId
	if object_id('tempdb.dbo.#tmpDestLoc') is not null DROP TABLE #tmpDestLoc
	if object_id('tempdb.dbo.#tmpSource') is not null DROP TABLE #tmpSource
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GettmActions')
	delete from GxQscripts where name = 'MMS2GettmActions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GettmActions')
	delete from GXDBVersions where aliasname = 'MMS2GettmActions'
GO

insert into GXDBVersions values(2, 'MMS2GettmActions',  '00010012029000030000', 'MMS2GettmActions', '00010012029000030000')
GO

